/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.FilterConditionBuilder;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ChoiceSetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;

public final class DataSetFiltersPage
extends AbstractDescriptionPropertyPage
implements ITableLabelProvider {
    private transient PropertyHandleTableViewer viewer = null;
    private transient DataSetViewData[] columns = null;
    private transient String[] columnExpressions = null;
    private transient PropertyHandle filters = null;
    private static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.title.expression"), Messages.getString((String)"dataset.editor.title.operator"), Messages.getString((String)"dataset.editor.title.value1"), Messages.getString((String)"dataset.editor.title.value2")};
    private static String[] cellProperties = new String[]{"expr", "operator", "value1", "value2"};
    private static String[] operators;
    private static String[] operatorDisplayNames;

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("FilterCondition", "operator");
        IChoice[] chs = chset.getChoices();
        operators = new String[chs.length];
        operatorDisplayNames = new String[chs.length];
        int i = 0;
        while (i < chs.length) {
            DataSetFiltersPage.operators[i] = chs[i].getName();
            DataSetFiltersPage.operatorDisplayNames[i] = chs[i].getDisplayName();
            ++i;
        }
    }

    public Control createContents(Composite parent) {
        this.initColumnNames();
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[0]);
        column.setWidth(150);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[1]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[2]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[3]);
        column.setWidth(100);
        this.initializeFilters();
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList filterList = new ArrayList(10);
                Iterator iter = DataSetFiltersPage.this.filters.iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        filterList.add(iter.next());
                    }
                }
                return filterList.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)this);
        this.viewer.getViewer().setInput((Object)this.filters);
        this.addListeners();
        this.setToolTips();
        return this.viewer.getControl();
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.doNew();
            }
        });
        this.viewer.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DataSetFiltersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetFiltersPage.this.setPageProperties();
                }
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    private void doNew() {
        this.doEdit(new FilterCondition());
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        FilterConditionHandle handle = (FilterConditionHandle)this.viewer.getViewer().getTable().getItem(index).getData();
        this.doEdit(handle);
    }

    private void doEdit(Object structureOrHandle) {
        FilterConditionBuilder dlg = new FilterConditionBuilder(structureOrHandle);
        dlg.setTitle(this.getTitle(structureOrHandle));
        dlg.setDataSetColumns(this.columnExpressions);
        dlg.setExpressionProvider((DesignElementHandle)this.getContainer().getModel());
        dlg.setBindingParams(((DataSetHandle)this.getContainer().getModel()).paramBindingsIterator());
        if (dlg.open() == 0) {
            this.update(structureOrHandle);
        }
    }

    private String getTitle(Object structureOrHandle) {
        if (structureOrHandle instanceof FilterCondition) {
            return Messages.getString((String)"FilterConditionBuilder.DialogTitle.New");
        }
        return Messages.getString((String)"FilterConditionBuilder.DialogTitle.Edit");
    }

    private void update(Object structureOrHandle) {
        if (structureOrHandle instanceof FilterCondition) {
            try {
                this.filters.addItem((IStructure)((FilterCondition)structureOrHandle));
                this.viewer.getViewer().refresh();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        } else {
            this.viewer.getViewer().update(structureOrHandle, null);
        }
    }

    private FilterCondition getStructure(Object structureOrHandle) {
        FilterCondition structure = null;
        structure = structureOrHandle instanceof FilterCondition ? (FilterCondition)structureOrHandle : (FilterCondition)((FilterConditionHandle)structureOrHandle).getStructure();
        return structure;
    }

    private String getOperatorName(String displayName) {
        int i = 0;
        while (i < operatorDisplayNames.length) {
            if (operatorDisplayNames[i].equals(displayName)) {
                return operators[i];
            }
            ++i;
        }
        return operators[0];
    }

    private String getOperatorDisplayName(String name) {
        int i = 0;
        while (i < operators.length) {
            if (operators[i].equals(name)) {
                return operatorDisplayNames[i];
            }
            ++i;
        }
        return operatorDisplayNames[0];
    }

    private void setToolTips() {
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.New"));
        this.viewer.getEditButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Edit"));
        this.viewer.getDownButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Down"));
        this.viewer.getUpButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Up"));
        this.viewer.getRemoveButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Remove"));
    }

    private void initColumnNames() {
        this.columns = ((DataSetEditor)this.getContainer()).getCurrentItemModel(true, true);
        if (this.columns != null) {
            this.columnExpressions = new String[this.columns.length];
            int n = 0;
            while (n < this.columns.length) {
                this.columnExpressions[n] = this.columns[n].getName();
                ++n;
            }
        }
    }

    private boolean isColumnName(String name) {
        int n = 0;
        while (n < this.columnExpressions.length) {
            if (this.columnExpressions[n].equals(name)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isComputedColumn(String name) {
        if (name == null) {
            return false;
        }
        int i = 0;
        while (i < this.columns.length) {
            if (name.equals(this.columns[i].getName()) || name.equals(this.columns[i].getAlias())) {
                return this.columns[i].isComputedColumn();
            }
            ++i;
        }
        return false;
    }

    private String getQualifiedExpression(String expression) {
        return ExpressionUtil.createJSRowExpression((String)expression);
    }

    private void initializeFilters() {
        this.filters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("filter");
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.filters"), 0);
        this.initColumnNames();
        this.setPageProperties();
        this.viewer.getViewer().getTable().select(0);
    }

    private void setPageProperties() {
        boolean filterConditionExists = false;
        filterConditionExists = this.filters != null && this.filters.getListValue() != null && this.filters.getListValue().size() > 0;
        this.viewer.getEditButton().setEnabled(filterConditionExists);
        this.viewer.getDownButton().setVisible(false);
        this.viewer.getUpButton().setVisible(false);
        this.viewer.getRemoveButton().setEnabled(filterConditionExists);
        this.viewer.getRemoveMenuItem().setEnabled(filterConditionExists);
        this.viewer.getRemoveAllMenuItem().setEnabled(filterConditionExists);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        FilterCondition filterCondition = this.getStructure(element);
        try {
            switch (columnIndex) {
                case 0: {
                    value = filterCondition.getExpr();
                    break;
                }
                case 1: {
                    value = this.getOperatorDisplayName(filterCondition.getOperator());
                    break;
                }
                case 2: {
                    value = this.getValue1String(filterCondition);
                    break;
                }
                case 3: {
                    value = filterCondition.getValue2();
                }
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle(ex);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private String getValue1String(FilterCondition filterCondition) {
        if ("in".equals(filterCondition.getOperator()) || "not-in".equals(filterCondition.getOperator())) {
            List value1List = filterCondition.getValue1List();
            StringBuffer buf = new StringBuffer();
            for (String value : value1List) {
                buf.append(String.valueOf(value) + "; ");
            }
            if (buf.length() > 1) {
                buf.delete(buf.length() - 2, buf.length());
            }
            return buf.toString();
        }
        return filterCondition.getValue1();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getPageDescription() {
        return Messages.getString((String)"DataSetFiltersPage.description");
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetFiltersPage.Filter.Tooltip");
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetFiltersPage.this.setPageProperties();
        }
    }
}

