/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.Iterator;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataSetSettingsPage
extends AbstractDescriptionPropertyPage {
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.settings");
    private transient Button fetchAllDataCheckBox = null;
    private transient Button selectResultSetCheckBox = null;
    private transient Button resultSetName = null;
    private transient Button resultSetNumber = null;
    private String numberText = null;
    private String nameText = null;
    boolean changed = false;
    private static String STORED_PROCEDURE_EXTENSION_ID = "org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet";

    public Control createContents(Composite parent) {
        String extensionID;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.addDataFetchSettingGroup(composite);
        DataSetHandle handle = ((DataSetEditor)this.getContainer()).getHandle();
        if (handle instanceof OdaDataSetHandle && (extensionID = ((OdaDataSetHandle)handle).getExtensionID()) != null && extensionID.equalsIgnoreCase(STORED_PROCEDURE_EXTENSION_ID)) {
            this.addResultSetGroup(composite);
        }
        return composite;
    }

    private void addDataFetchSettingGroup(Composite composite) {
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 5;
        GridData groupGridData = new GridData(768);
        Group dataFetchSettingGroup = new Group(composite, 0);
        dataFetchSettingGroup.setLayoutData((Object)groupGridData);
        dataFetchSettingGroup.setLayout((Layout)groupGridLayout);
        dataFetchSettingGroup.setText(Messages.getString((String)"dataset.editor.settings.dataFetchSetting"));
        this.fetchAllDataCheckBox = new Button((Composite)dataFetchSettingGroup, 32);
        GridData data = new GridData();
        data.horizontalSpan = 5;
        this.fetchAllDataCheckBox.setLayoutData((Object)data);
        this.fetchAllDataCheckBox.setText(Messages.getString((String)"dataset.editor.settings.dataFetchSetting.fetchAll"));
        final Label dataFetchLabel = new Label((Composite)dataFetchSettingGroup, 0);
        dataFetchLabel.setText(Messages.getString((String)"SettingsPage.dataFetchSetting.label"));
        final Text rowFetchLimitText = new Text((Composite)dataFetchSettingGroup, 2048);
        GridData gData = new GridData(768);
        rowFetchLimitText.setLayoutData((Object)gData);
        if (this.getDataSetRowFetchLimit() > 0) {
            this.fetchAllDataCheckBox.setSelection(false);
            rowFetchLimitText.setEnabled(true);
            dataFetchLabel.setEnabled(true);
            rowFetchLimitText.setText(Integer.toString(this.getDataSetRowFetchLimit()));
        } else {
            this.fetchAllDataCheckBox.setSelection(true);
            rowFetchLimitText.setEnabled(false);
            dataFetchLabel.setEnabled(false);
            rowFetchLimitText.setText("");
        }
        this.fetchAllDataCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelection = DataSetSettingsPage.this.fetchAllDataCheckBox.getSelection();
                dataFetchLabel.setEnabled(!isSelection);
                rowFetchLimitText.setEnabled(!isSelection);
                if (isSelection) {
                    rowFetchLimitText.setText("");
                }
            }
        });
        rowFetchLimitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int rowFetchLimit = 0;
                try {
                    if (DataSetSettingsPage.this.isNumber(rowFetchLimitText.getText())) {
                        String rowLimitText = rowFetchLimitText.getText();
                        if (rowLimitText.trim().length() == 0) {
                            rowLimitText = "0";
                        }
                        rowFetchLimit = (rowFetchLimit = new Double(rowLimitText).intValue()) < 0 ? 0 : rowFetchLimit;
                        DataSetSettingsPage.this.setDataSetRowFetchLimit(rowFetchLimit);
                        DataSetSettingsPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                    } else {
                        DataSetSettingsPage.this.getContainer().setMessage(Messages.getString((String)"dataset.editor.settings.dataFetchSetting.errorNumberFormat"), 3);
                    }
                }
                catch (SemanticException semanticException) {
                    DataSetSettingsPage.this.getContainer().setMessage(Messages.getString((String)"dataset.editor.settings.dataFetchSetting.errorNumberFormat"), 3);
                }
            }
        });
    }

    private void addResultSetGroup(Composite composite) {
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 5;
        GridData groupGridData = new GridData(768);
        Group resultSetNumberGroup = new Group(composite, 0);
        resultSetNumberGroup.setLayoutData((Object)groupGridData);
        resultSetNumberGroup.setLayout((Layout)groupGridLayout);
        resultSetNumberGroup.setText(Messages.getString((String)"dataset.editor.settings.resultsetselection.resultSetSelection"));
        this.selectResultSetCheckBox = new Button((Composite)resultSetNumberGroup, 32);
        GridData data = new GridData();
        data.horizontalSpan = 5;
        this.selectResultSetCheckBox.setLayoutData((Object)data);
        this.selectResultSetCheckBox.setText(Messages.getString((String)"dataset.editor.settings.resultsetselection.enableResultSetSelection"));
        this.resultSetName = new Button((Composite)resultSetNumberGroup, 16);
        data = new GridData();
        data.horizontalSpan = 3;
        this.resultSetName.setLayoutData((Object)data);
        this.resultSetName.setText(Messages.getString((String)"dataset.editor.settings.resultsetselection.selectResultSetByName"));
        final Text nameText = new Text((Composite)resultSetNumberGroup, 2048);
        GridData gData = new GridData(768);
        nameText.setLayoutData((Object)gData);
        this.resultSetNumber = new Button((Composite)resultSetNumberGroup, 16);
        data = new GridData();
        data.horizontalSpan = 3;
        this.resultSetNumber.setLayoutData((Object)data);
        this.resultSetNumber.setText(Messages.getString((String)"dataset.editor.settings.resultsetselection.selectResultSetByNumber"));
        final Text numberText = new Text((Composite)resultSetNumberGroup, 2048);
        gData = new GridData(768);
        numberText.setLayoutData((Object)gData);
        this.selectResultSetCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = DataSetSettingsPage.this.selectResultSetCheckBox.getSelection();
                DataSetSettingsPage.this.resultSetName.setEnabled(selected);
                DataSetSettingsPage.this.resultSetNumber.setEnabled(selected);
                if (selected) {
                    if (DataSetSettingsPage.this.resultSetName.getSelection()) {
                        numberText.setEnabled(false);
                        nameText.setEnabled(true);
                    } else if (DataSetSettingsPage.this.resultSetNumber.getSelection()) {
                        nameText.setEnabled(false);
                        numberText.setEnabled(true);
                    } else {
                        nameText.setEnabled(selected);
                        numberText.setEnabled(selected);
                    }
                } else {
                    nameText.setEnabled(selected);
                    numberText.setEnabled(selected);
                }
                DataSetSettingsPage.this.changed = true;
            }
        });
        this.resultSetName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                nameText.setEnabled(true);
                numberText.setEnabled(false);
                DataSetSettingsPage.this.changed = true;
            }
        });
        this.resultSetNumber.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                nameText.setEnabled(false);
                numberText.setEnabled(true);
                DataSetSettingsPage.this.changed = true;
            }
        });
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataSetSettingsPage.this.nameText = nameText.getText();
                DataSetSettingsPage.this.changed = true;
            }
        });
        numberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int rsNumber = 0;
                if (DataSetSettingsPage.this.isNumber(numberText.getText())) {
                    String number = numberText.getText();
                    if (number.trim().length() == 0) {
                        number = "0";
                    }
                    rsNumber = (rsNumber = new Double(number).intValue()) < 0 ? 0 : rsNumber;
                    DataSetSettingsPage.this.numberText = numberText.getText();
                    DataSetSettingsPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                    DataSetSettingsPage.this.changed = true;
                } else {
                    DataSetSettingsPage.this.getContainer().setMessage(Messages.getString((String)"dataset.editor.settings.dataFetchSetting.errorNumberFormatForResultSet"), 3);
                }
            }
        });
        if (((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).getResultSetName() != null) {
            this.resultSetName.setSelection(true);
            nameText.setText(((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).getResultSetName());
            numberText.setEnabled(false);
            this.selectResultSetCheckBox.setSelection(true);
        } else if (((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).getPropertyHandle("resultSetNumber").isSet()) {
            this.resultSetNumber.setSelection(true);
            numberText.setText(String.valueOf(((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).getResultSetNumber()));
            nameText.setEnabled(false);
            this.selectResultSetCheckBox.setSelection(true);
        } else {
            this.selectResultSetCheckBox.setSelection(false);
            this.resultSetName.setSelection(true);
            this.resultSetName.setEnabled(false);
            this.resultSetNumber.setEnabled(false);
            nameText.setEnabled(false);
            numberText.setEnabled(false);
        }
    }

    private boolean isNumber(String text) {
        if (text == null) {
            return false;
        }
        if (text.trim().length() == 0) {
            return true;
        }
        return text.matches("^[0-9]*[1-9][0-9]*$");
    }

    private void setDataSetRowFetchLimit(int count) throws SemanticException {
        ((DataSetEditor)this.getContainer()).getHandle().setRowFetchLimit(count);
    }

    private int getDataSetRowFetchLimit() {
        return ((DataSetEditor)this.getContainer()).getHandle().getRowFetchLimit();
    }

    public void pageActivated() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean canLeave() {
        block10: {
            ((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).setProperty("resultSetNumber", null);
            ((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).setResultSetName(null);
            if (this.selectResultSetCheckBox != null) break block10;
            return true;
        }
        try {
            if (this.selectResultSetCheckBox.getSelection()) {
                if (this.resultSetNumber.getSelection()) {
                    ((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).setResultSetNumber(new Integer(this.numberText).intValue());
                } else if (this.resultSetName.getSelection()) {
                    ((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).setResultSetName(this.nameText);
                }
            }
            if (this.changed) {
                Iterator it = ((DataSetEditor)this.getContainer()).getHandle().resultSetIterator();
                while (it.hasNext()) {
                    it.remove();
                }
            }
            this.changed = false;
            if (this.canFinish()) {
                return super.performOk();
            }
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performOk() {
        if (this.canLeave()) {
            return super.performOk();
        }
        return false;
    }

    public String getToolTip() {
        return Messages.getString((String)"SettingsPage.CachePreference.Filter.Tooltip");
    }
}

