/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPageContainer;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.JoinConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.JoinCondition;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JointDataSetPage
extends WizardPage
implements ISelectionChangedListener,
IPropertyPage {
    private static final transient String seperator = "::";
    private transient ComboViewer leftDataSetChooser = null;
    private transient ComboViewer rightDataSetChooser = null;
    private transient ListViewer leftColumnList = null;
    private transient ListViewer rightColumnList = null;
    private transient DataSetHandle leftHandle = null;
    private transient DataSetHandle rightHandle = null;
    private transient Group leftGroup;
    private transient Group centerGroup;
    private transient Group rightGroup;
    private transient Button innerJoinButton;
    private transient Button leftOuterJoinButton;
    private transient Button rightOuterJoinButton;
    private transient Button fullOuterJoinButton;
    private transient Composite topComposite;
    private transient Composite bottomComposite;
    private transient List dataSetList;
    private boolean leftSelected = true;
    private String leftColumnSelection;
    private String rightColumnSelection;
    private String leftDataSetName;
    private String rightDataSetName;
    private IPropertyPageContainer propertyPageContainer;
    private Text nameEditor;
    private Label nameLabel;
    private static final String EMPTY_NAME = Messages.getString((String)"error.DataSet.emptyName");
    private static final String DUPLICATE_NAME = Messages.getString((String)"error.duplicateName");
    private static final String CREATE_PROMPT = Messages.getString((String)"dataset.message.create");
    private static final String TEXT_JOINTYYPE = Messages.getString((String)"JointDataSetPage.joinType");
    private static final String TEXT_INNORJOIN = Messages.getString((String)"JointDataSetPage.button.innerJoin");
    private static final String TEXT_LEFTJOIN = Messages.getString((String)"JointDataSetPage.button.leftJoin");
    private static final String TEXT_RIGHTJOIN = Messages.getString((String)"JointDataSetPage.button.rightJoin");
    private static final String TEXT_FULLJOIN = Messages.getString((String)"JointDataSetPage.button.fullJoin");
    private static String DEFAULT_MESSAGE = Messages.getString((String)"JointDataSetPage.page.detail");
    private String joinType;
    private static final int LEFT_DATASET = 0;
    private static final int RIGHT_DATASET = -1;
    private PropertyHandle propertyHandle;
    private static Logger logger = Logger.getLogger(JointDataSetPage.class.getName());

    public JointDataSetPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setPageMessage(Messages.getString((String)"JointDataSetPage.page.detail"), 0);
    }

    public void createControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.setPageComplete(false);
    }

    public Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.dataSetList = this.getDataSets();
        if (this.getPageDescription() != null) {
            Label pageDescription = new Label(composite, 0);
            pageDescription.setLayoutData((Object)new GridData(768));
            pageDescription.setText(this.getPageDescription());
            pageDescription.setToolTipText(this.getPageDescription());
        }
        this.topComposite = new Composite(composite, 0);
        this.createTopComposite(this.topComposite);
        this.bottomComposite = new Composite(composite, 0);
        this.createBottomComposite(this.bottomComposite);
        this.joinType = "inner";
        Utility.setSystemHelp((Control)composite, "org.eclipse.birt.cshelp.Wizard_JointDataSet_ID");
        return composite;
    }

    private void createTopComposite(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        this.createLeftGroup(parent);
        this.createCenterGroup(parent);
        this.createRightGroup(parent);
    }

    private void createLeftGroup(Composite composite) {
        this.leftGroup = new Group(composite, 0);
        this.leftGroup.setLayout((Layout)new FormLayout());
        this.leftGroup.setLayoutData((Object)new GridData(1808));
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(10, -5);
        this.leftDataSetChooser = new ComboViewer((Composite)this.leftGroup, 12);
        this.leftDataSetChooser.getCombo().setLayoutData((Object)data);
        DataSetComboProvider provider = new DataSetComboProvider();
        this.leftDataSetChooser.setContentProvider((IContentProvider)provider);
        this.leftDataSetChooser.setLabelProvider((IBaseLabelProvider)provider);
        this.leftDataSetChooser.setInput((Object)this.dataSetList);
        this.leftDataSetChooser.addSelectionChangedListener((ISelectionChangedListener)this);
        data = new FormData();
        data.top = new FormAttachment((Control)this.leftDataSetChooser.getCombo(), 10);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        this.leftColumnList = new ListViewer((Composite)this.leftGroup, 2816);
        this.leftColumnList.getControl().setLayoutData((Object)data);
        ColumnProvider colProvider = new ColumnProvider();
        this.leftColumnList.setContentProvider((IContentProvider)colProvider);
        this.leftColumnList.setLabelProvider((IBaseLabelProvider)colProvider);
        this.leftColumnList.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createCenterGroup(Composite composite) {
        this.centerGroup = new Group(composite, 0);
        this.centerGroup.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1040);
        data.verticalAlignment = 0x1000000;
        this.centerGroup.setLayoutData((Object)data);
        this.centerGroup.setText(TEXT_JOINTYYPE);
        this.createRadioButtonList((Composite)this.centerGroup);
    }

    private void createRightGroup(Composite composite) {
        this.rightGroup = new Group(composite, 0);
        this.rightGroup.setLayout((Layout)new FormLayout());
        this.rightGroup.setLayoutData((Object)new GridData(1808));
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(10, -5);
        this.rightDataSetChooser = new ComboViewer((Composite)this.rightGroup, 12);
        this.rightDataSetChooser.getControl().setLayoutData((Object)data);
        DataSetComboProvider provider = new DataSetComboProvider();
        this.rightDataSetChooser.setContentProvider((IContentProvider)provider);
        this.rightDataSetChooser.setLabelProvider((IBaseLabelProvider)provider);
        this.rightDataSetChooser.setInput((Object)this.dataSetList);
        this.rightDataSetChooser.addSelectionChangedListener((ISelectionChangedListener)this);
        data = new FormData();
        data.top = new FormAttachment(this.rightDataSetChooser.getControl(), 10);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        this.rightColumnList = new ListViewer((Composite)this.rightGroup, 2816);
        this.rightColumnList.getControl().setLayoutData((Object)data);
        ColumnProvider colProvider = new ColumnProvider();
        this.rightColumnList.setContentProvider((IContentProvider)colProvider);
        this.rightColumnList.setLabelProvider((IBaseLabelProvider)colProvider);
        this.rightColumnList.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createBottomComposite(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this.nameLabel = new Label(parent, 131072);
        this.nameLabel.setText(Messages.getString((String)"dataset.wizard.label.datasetName"));
        this.nameEditor = new Text(parent, 2048);
        String name = ReportPlugin.getDefault().getCustomName("DataSet");
        if (name != null) {
            this.nameEditor.setText(Utility.getUniqueDataSetName(name));
        } else {
            this.nameEditor.setText(Utility.getUniqueDataSetName(Messages.getString((String)"dataset.new.defaultName")));
        }
        this.nameEditor.setLayoutData((Object)new GridData(768));
        this.nameEditor.setToolTipText(Messages.getString((String)"DataSetBasePage.tooltip"));
        this.nameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringUtil.isBlank((String)JointDataSetPage.this.nameEditor.getText().trim())) {
                    JointDataSetPage.this.setPageMessage(EMPTY_NAME, 3);
                    JointDataSetPage.this.setPageComplete(false);
                } else if (JointDataSetPage.this.isDuplicateName()) {
                    JointDataSetPage.this.setPageMessage(DUPLICATE_NAME, 3);
                    JointDataSetPage.this.setPageComplete(false);
                } else if (JointDataSetPage.this.containInvalidCharactor(JointDataSetPage.this.nameEditor.getText())) {
                    String msg = Messages.getFormattedString((String)"error.invalidName", (Object[])new Object[]{JointDataSetPage.this.nameEditor.getText()});
                    JointDataSetPage.this.setMessage(msg, 3);
                    JointDataSetPage.this.setPageComplete(false);
                } else {
                    JointDataSetPage.this.setPageComplete(JointDataSetPage.this.canPageComplete());
                    JointDataSetPage.this.setPageMessage(CREATE_PROMPT, 0);
                }
            }
        });
    }

    private void createRadioButtonList(Composite composite) {
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        this.innerJoinButton = new Button(composite, 80);
        this.innerJoinButton.setText(TEXT_INNORJOIN);
        this.innerJoinButton.setLayoutData((Object)data);
        this.innerJoinButton.setSelection(true);
        data = new GridData();
        this.leftOuterJoinButton = new Button(composite, 80);
        this.leftOuterJoinButton.setText(TEXT_LEFTJOIN);
        this.leftOuterJoinButton.setLayoutData((Object)data);
        data = new GridData();
        this.rightOuterJoinButton = new Button(composite, 80);
        this.rightOuterJoinButton.setText(TEXT_RIGHTJOIN);
        this.rightOuterJoinButton.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        this.fullOuterJoinButton = new Button(composite, 80);
        this.fullOuterJoinButton.setText(TEXT_FULLJOIN);
        this.fullOuterJoinButton.setLayoutData((Object)data);
        RadioSelectionLister listener = new RadioSelectionLister();
        this.innerJoinButton.addSelectionListener((SelectionListener)listener);
        this.leftOuterJoinButton.addSelectionListener((SelectionListener)listener);
        this.rightOuterJoinButton.addSelectionListener((SelectionListener)listener);
        this.fullOuterJoinButton.addSelectionListener((SelectionListener)listener);
    }

    private boolean isDuplicateName() {
        String name = this.nameEditor.getText().trim();
        return Utility.checkDataSetName(name);
    }

    private boolean containInvalidCharactor(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(".") > -1 || name.indexOf("\\") > -1 || name.indexOf("/") > -1 || name.indexOf("!") > -1 || name.indexOf(";") > -1 || name.indexOf(",") > -1;
    }

    private List getDataSets() {
        List dataSets = Utility.getVisibleDataSets();
        ArrayList<DataSetHandle> relative = new ArrayList<DataSetHandle>();
        for (Object handleObj : dataSets) {
            if (!(handleObj instanceof JointDataSetHandle)) continue;
            List nameList = ((JointDataSetHandle)handleObj).getDataSetNames();
            int j = 0;
            while (j < nameList.size()) {
                DataSetHandle dataSet = Utility.findDataSet(nameList.get(j).toString());
                if (dataSet != null && dataSet.getModuleHandle() instanceof LibraryHandle) {
                    relative.add(dataSet);
                }
                ++j;
            }
        }
        int i = 0;
        while (i < relative.size()) {
            if (!dataSets.contains(relative.get(i))) {
                dataSets.add(relative.get(i));
            }
            ++i;
        }
        return dataSets;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() instanceof ComboViewer) {
            this.setPageMessage(Messages.getString((String)"JointDataSetPage.page.detail"), 0);
            this.leftSelected = !((ComboViewer)event.getSource()).equals(this.rightDataSetChooser);
            DataSetHandle handle = (DataSetHandle)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (this.leftSelected) {
                this.leftDataSetName = handle.getQualifiedName();
                this.leftHandle = handle;
            } else {
                this.rightDataSetName = handle.getQualifiedName();
                this.rightHandle = handle;
            }
            DataSetViewData[] columsItems = null;
            try {
                DataSessionContext context = new DataSessionContext(3, handle.getModuleHandle());
                DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
                columsItems = DataSetProvider.getCurrentInstance().populateAllCachedMetaData(handle, session);
                this.populateColumns(columsItems);
                session.shutdown();
            }
            catch (BirtException e) {
                ExceptionHandler.handle(e);
            }
        } else if (event.getSource() instanceof ListViewer) {
            this.leftSelected = !((ListViewer)event.getSource()).equals(this.rightColumnList);
            DataSetViewData itemModel = (DataSetViewData)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (this.leftSelected) {
                this.leftColumnSelection = itemModel.getName();
            } else {
                this.rightColumnSelection = itemModel.getName();
            }
        }
        if (!this.nameEditor.isDisposed()) {
            this.setPageComplete(this.canPageComplete());
        }
    }

    private void populateColumns(DataSetViewData[] columsItems) {
        if (this.leftSelected) {
            this.leftColumnList.setInput((Object)columsItems);
            if (columsItems != null && this.leftColumnList.getElementAt(0) != null) {
                this.leftColumnList.setSelection((ISelection)new StructuredSelection(this.leftColumnList.getElementAt(0)));
                this.leftColumnSelection = ((DataSetViewData)this.leftColumnList.getElementAt(0)).getName();
            }
        } else {
            this.rightColumnList.setInput((Object)columsItems);
            if (columsItems != null && this.rightColumnList.getElementAt(0) != null) {
                this.rightColumnList.setSelection((ISelection)new StructuredSelection(this.rightColumnList.getElementAt(0)));
                this.rightColumnSelection = ((DataSetViewData)this.rightColumnList.getElementAt(0)).getName();
            }
        }
    }

    public DataSetHandle createSelectedDataSet() {
        try {
            DataSetHandle dataSetHandle = this.createJointDataSet();
            ModuleHandle parentHandle = Utility.getReportModuleHandle();
            SlotHandle slotHandle = parentHandle.getDataSets();
            parentHandle.addElement((DesignElementHandle)dataSetHandle, slotHandle.getSlotID());
            return dataSetHandle;
        }
        catch (SemanticException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    private DataSetHandle createJointDataSet() throws SemanticException {
        String dataSetName = "";
        if (this.nameEditor != null) {
            dataSetName = this.nameEditor.getText();
        }
        JointDataSetHandle dsHandle = Utility.newJointDataSet(dataSetName);
        if (this.leftDataSetName.equals(this.rightDataSetName)) {
            dsHandle.addDataSet(this.leftDataSetName);
        } else {
            dsHandle.addDataSet(this.leftDataSetName);
            dsHandle.addDataSet(this.rightDataSetName);
        }
        this.setParameters(dsHandle);
        this.propertyHandle = dsHandle.getPropertyHandle("joinConditions");
        this.propertyHandle.addItem((IStructure)this.createJoinCondition());
        return dsHandle;
    }

    private void setParameters(JointDataSetHandle dsHandle) throws SemanticException {
        int num = 0;
        dsHandle.getPropertyHandle("parameters").clearValue();
        if (this.leftDataSetName.equals(this.rightDataSetName)) {
            num = this.addParameters(dsHandle, String.valueOf(this.leftDataSetName) + "1", this.leftHandle.getPropertyHandle("parameters"), 0);
            this.addParameters(dsHandle, String.valueOf(this.rightDataSetName) + "2", this.rightHandle.getPropertyHandle("parameters"), num);
        } else {
            num = this.addParameters(dsHandle, this.leftDataSetName, this.leftHandle.getPropertyHandle("parameters"), 0);
            this.addParameters(dsHandle, this.rightDataSetName, this.rightHandle.getPropertyHandle("parameters"), num);
        }
    }

    private int addParameters(JointDataSetHandle dsHandle, String dataSetName, PropertyHandle parameterHandle, int startPosition) throws SemanticException {
        int returnValue = 0;
        PropertyHandle dsParameterHandle = dsHandle.getPropertyHandle("parameters");
        for (DataSetParameterHandle paramter : parameterHandle) {
            DataSetParameter dataSetParameter = null;
            dataSetParameter = this.toDataSetParameter((DataSetParameter)paramter.getStructure(), dataSetName, new Integer(startPosition + returnValue));
            dsParameterHandle.addItem((IStructure)dataSetParameter);
            ++returnValue;
        }
        return returnValue;
    }

    private DataSetParameter toDataSetParameter(DataSetParameter parameter, String dataSetName, Integer position) {
        DataSetParameter dataSetParameter = new DataSetParameter();
        dataSetParameter.setDataType(parameter.getDataType());
        dataSetParameter.setAllowNull(parameter.allowNull());
        dataSetParameter.setDefaultValue(parameter.getDefaultValue());
        dataSetParameter.setIsInput(parameter.isInput());
        dataSetParameter.setIsOutput(parameter.isOutput());
        dataSetParameter.setName(JointDataSetPage.getParameterName(dataSetName, parameter.getName()));
        dataSetParameter.setIsOptional(parameter.isOptional());
        dataSetParameter.setPosition(position);
        return dataSetParameter;
    }

    public static String getParameterName(String dataSetName, String sourceParameterName) {
        return String.valueOf(dataSetName) + seperator + sourceParameterName;
    }

    private JoinCondition createJoinCondition() {
        JoinCondition joinCondition = new JoinCondition();
        joinCondition.setJoinType(this.joinType);
        joinCondition.setOperator("eq");
        joinCondition.setLeftDataSet(this.leftDataSetName);
        joinCondition.setRightDataSet(this.rightDataSetName);
        joinCondition.setLeftExpression(ExpressionUtil.createJSDataSetRowExpression((String)this.leftColumnSelection));
        joinCondition.setRightExpression(ExpressionUtil.createJSDataSetRowExpression((String)this.rightColumnSelection));
        return joinCondition;
    }

    private boolean canPageComplete() {
        return this.leftDataSetName != null && this.rightDataSetName != null && this.leftColumnSelection != null && this.rightColumnSelection != null && !this.nameEditor.isDisposed() && !StringUtil.isBlank((String)this.nameEditor.getText().trim()) && !this.isDuplicateName();
    }

    public void setContainer(IPropertyPageContainer parentContainer) {
        this.propertyPageContainer = parentContainer;
    }

    public boolean canLeave() {
        try {
            return this.modifyJointCondition();
        }
        catch (SemanticException semanticException) {
            return false;
        }
    }

    private boolean modifyJointCondition() throws SemanticException {
        JointDataSetHandle handle = null;
        if (this.leftDataSetName == null || this.rightDataSetName == null) {
            return false;
        }
        if (this.propertyPageContainer instanceof DataSetEditor) {
            handle = (JointDataSetHandle)((DataSetEditor)this.propertyPageContainer).getModel();
            List datasetName = handle.getDataSetNames();
            int i = 0;
            while (i < datasetName.size()) {
                try {
                    handle.removeDataSet((String)datasetName.get(i));
                }
                catch (SemanticException semanticException) {}
                ++i;
            }
            if (this.leftDataSetName.equals(this.rightDataSetName)) {
                handle.addDataSet(this.leftDataSetName);
            } else {
                handle.addDataSet(this.leftDataSetName);
                handle.addDataSet(this.rightDataSetName);
            }
            this.setParameters(handle);
        }
        if (this.propertyHandle != null) {
            JoinCondition condition = this.createJoinCondition();
            this.propertyHandle.removeItem(0);
            this.propertyHandle.addItem((IStructure)condition);
            return true;
        }
        return false;
    }

    private String getPageDescription() {
        return Messages.getString((String)"JointDataSetPage.pageDescription");
    }

    public boolean performOk() {
        block3: {
            try {
                if (this.propertyHandle != null) break block3;
                return true;
            }
            catch (SemanticException semanticException) {
                return false;
            }
        }
        return this.modifyJointCondition();
    }

    public boolean performCancel() {
        return true;
    }

    public void pageActivated() {
        if (this.propertyPageContainer != null) {
            DEFAULT_MESSAGE = Messages.getString((String)"JointDataSetPage.pageName");
            this.setPageMessage(DEFAULT_MESSAGE, 0);
            JointDataSetHandle handle = (JointDataSetHandle)this.propertyPageContainer.getModel();
            if (!this.nameEditor.isDisposed()) {
                this.nameEditor.dispose();
            }
            if (!this.nameLabel.isDisposed()) {
                this.nameLabel.dispose();
            }
            if (this.dataSetList != null) {
                int i = 0;
                while (i < this.dataSetList.size()) {
                    if (this.dataSetList.get(i) instanceof JointDataSetHandle && ((JointDataSetHandle)this.dataSetList.get(i)).getDataSetNames().equals(handle.getDataSetNames())) {
                        this.dataSetList.remove(i);
                    }
                    ++i;
                }
            }
            this.leftDataSetChooser.setInput((Object)this.dataSetList);
            this.rightDataSetChooser.setInput((Object)this.dataSetList);
            this.propertyHandle = handle.getPropertyHandle("joinConditions");
            Iterator conditionIter = handle.joinConditionsIterator();
            while (conditionIter.hasNext()) {
                JoinConditionHandle condition = (JoinConditionHandle)conditionIter.next();
                this.populateDataSet(condition.getLeftDataSet(), condition.getLeftExpression(), 0);
                this.populateDataSet(condition.getRightDataSet(), condition.getRightExpression(), -1);
                this.populateJoinType(condition.getJoinType());
            }
        }
    }

    private void populateJoinType(String joinType) {
        this.joinType = joinType;
        if (joinType.equals("inner")) {
            this.innerJoinButton.setSelection(true);
            this.leftOuterJoinButton.setSelection(false);
            this.rightOuterJoinButton.setSelection(false);
            this.fullOuterJoinButton.setSelection(false);
        } else if (joinType.equals("left-out")) {
            this.innerJoinButton.setSelection(false);
            this.leftOuterJoinButton.setSelection(true);
            this.rightOuterJoinButton.setSelection(false);
            this.fullOuterJoinButton.setSelection(false);
        } else if (joinType.equals("right-out")) {
            this.innerJoinButton.setSelection(false);
            this.leftOuterJoinButton.setSelection(false);
            this.rightOuterJoinButton.setSelection(true);
            this.fullOuterJoinButton.setSelection(false);
        } else if (joinType.equals("full-out")) {
            this.innerJoinButton.setSelection(false);
            this.leftOuterJoinButton.setSelection(false);
            this.rightOuterJoinButton.setSelection(false);
            this.fullOuterJoinButton.setSelection(true);
        }
    }

    private void populateDataSet(String name, String expression, int type) {
        String rowExpr;
        int i;
        int selectionIndex = -1;
        int i2 = 0;
        while (i2 < this.dataSetList.size()) {
            DataSetHandle dataHandle = (DataSetHandle)this.dataSetList.get(i2);
            if (dataHandle.getQualifiedName().equals(name)) {
                selectionIndex = i2;
                break;
            }
            ++i2;
        }
        if (type == 0) {
            if (selectionIndex >= 0) {
                this.leftDataSetChooser.setSelection((ISelection)new StructuredSelection(this.dataSetList.get(selectionIndex)));
                if (this.leftColumnList.getInput() != null && this.leftColumnList.getInput() instanceof DataSetViewData[]) {
                    DataSetViewData[] dataSetItems = (DataSetViewData[])this.leftColumnList.getInput();
                    i = 0;
                    while (i < dataSetItems.length) {
                        rowExpr = ExpressionUtil.createJSDataSetRowExpression((String)dataSetItems[i].getName());
                        if (rowExpr.equals(expression)) {
                            selectionIndex = i;
                            break;
                        }
                        ++i;
                    }
                    this.leftColumnList.setSelection((ISelection)new StructuredSelection((Object)dataSetItems[selectionIndex]));
                }
            } else {
                this.setPageMessage(Messages.getString((String)"JointDataSetPage.error.nodataset.left"), 3);
            }
        }
        if (type == -1) {
            if (selectionIndex >= 0) {
                this.rightDataSetChooser.setSelection((ISelection)new StructuredSelection(this.dataSetList.get(selectionIndex)));
                if (this.rightColumnList.getInput() != null && this.rightColumnList.getInput() instanceof DataSetViewData[]) {
                    DataSetViewData[] dataSetItems = (DataSetViewData[])this.rightColumnList.getInput();
                    i = 0;
                    while (i < dataSetItems.length) {
                        rowExpr = ExpressionUtil.createJSDataSetRowExpression((String)dataSetItems[i].getName());
                        if (rowExpr.equals(expression)) {
                            selectionIndex = i;
                            break;
                        }
                        ++i;
                    }
                    this.rightColumnList.setSelection((ISelection)new StructuredSelection((Object)dataSetItems[selectionIndex]));
                }
            } else {
                this.setPageMessage(Messages.getString((String)"JointDataSetPage.error.nodataset.right"), 3);
            }
        }
    }

    private void setPageMessage(String newMessage, int type) {
        if (this.propertyPageContainer != null) {
            this.propertyPageContainer.setMessage(newMessage, type);
        } else {
            this.setMessage(newMessage, type);
        }
    }

    public String getToolTip() {
        return Messages.getString((String)"JointDataSetPage.pageName");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    class ColumnProvider
    implements IStructuredContentProvider,
    ILabelProvider {
        ColumnProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof DataSetViewData) {
                return ((DataSetViewData)element).getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class DataSetComboProvider
    implements IStructuredContentProvider,
    ILabelProvider {
        DataSetComboProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof DataSetHandle) {
                return ((DataSetHandle)element).getQualifiedName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class RadioSelectionLister
    implements SelectionListener {
        RadioSelectionLister() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() instanceof Button) {
                if (((Button)e.getSource()).equals(JointDataSetPage.this.innerJoinButton)) {
                    JointDataSetPage.this.joinType = "inner";
                } else if (((Button)e.getSource()).equals(JointDataSetPage.this.leftOuterJoinButton)) {
                    JointDataSetPage.this.joinType = "left-out";
                } else if (((Button)e.getSource()).equals(JointDataSetPage.this.rightOuterJoinButton)) {
                    JointDataSetPage.this.joinType = "right-out";
                } else if (((Button)e.getSource()).equals(JointDataSetPage.this.fullOuterJoinButton)) {
                    JointDataSetPage.this.joinType = "full-out";
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

