/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputColumnsContentProvider;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputColumnsLabelProvider;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public final class OutputColumnsPage
extends AbstractDescriptionPropertyPage
implements Listener {
    private transient PropertyHandleTableViewer viewer = null;
    private transient boolean modelChanged = true;
    private String originalAlias = "";
    private String originalDisplayName = "";
    private String originalDisplayNameKey = "";
    private static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.title.name"), Messages.getString((String)"dataset.editor.title.type"), Messages.getString((String)"dataset.editor.title.alias"), Messages.getString((String)"dataset.editor.title.displayName"), Messages.getString((String)"dataset.editor.title.displayNameKey")};
    private static String[] dialogLabels = new String[]{Messages.getString((String)"dataset.editor.inputDialog.name"), Messages.getString((String)"dataset.editor.inputDialog.type"), Messages.getString((String)"dataset.editor.inputDialog.alias"), Messages.getString((String)"dataset.editor.inputDialog.displayName"), Messages.getString((String)"dataset.editor.inputDialog.displayNameKey")};
    private static String[] cellProperties = new String[]{"name", "dataTypeName", "alias", "realDisplayName", "displayNameKey"};

    public Control createContents(Composite parent) {
        this.viewer = new PropertyHandleTableViewer(parent, false, true, false);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[0]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[1]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[2]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[3]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[4]);
        column.setWidth(150);
        this.viewer.getViewer().setContentProvider((IContentProvider)new OutputColumnsContentProvider());
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new OutputColumnsLabelProvider());
        this.addListeners();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return this.viewer.getControl();
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputColumnsPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                OutputColumnsPage.this.doEdit();
            }
        });
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        DataSetViewData data = (DataSetViewData)this.viewer.getViewer().getTable().getItem(index).getData();
        this.originalAlias = data.getAlias();
        this.originalDisplayName = data.getRealDisplayName();
        this.originalDisplayNameKey = data.getDisplayNameKey();
        this.doEdit(data);
    }

    private void doEdit(DataSetViewData data) {
        OutputColumnInputDialog dlg = new OutputColumnInputDialog(data);
        if (dlg.open() == 0) {
            this.viewer.getViewer().update((Object)data, null);
            this.updateMessage();
        }
    }

    public void pageActivated() {
        if (this.modelChanged) {
            this.updateOutputColumns();
            this.modelChanged = false;
        }
        this.setPageProperties();
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputColumns"), 0);
        this.viewer.getViewer().getTable().select(0);
    }

    private void setPageProperties() {
        this.viewer.getNewButton().setEnabled(this.viewer.getViewer().getInput() != null && ((DataSetViewData[])this.viewer.getViewer().getInput()).length != 0);
        this.viewer.getNewButton().setText(Messages.getString((String)"PropertyHandleTableViewer.Button.Edit"));
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"OutputColumnPage.toolTipText.Edit"));
        this.viewer.getEditButton().setVisible(false);
        this.viewer.getRemoveButton().setVisible(false);
        this.viewer.getUpButton().setVisible(false);
        this.viewer.getDownButton().setVisible(false);
    }

    public boolean canLeave() {
        if (this.isValid()) {
            this.saveOutputColumns();
            if (this.modelChanged) {
                ((DataSetEditor)this.getContainer()).updateDataSetDesign(this);
                this.modelChanged = false;
            }
            return super.canLeave();
        }
        return false;
    }

    public boolean performOk() {
        if (this.isValid()) {
            this.saveOutputColumns();
            ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
            if (this.modelChanged) {
                ((DataSetEditor)this.getContainer()).updateDataSetDesign(this);
                this.modelChanged = false;
            }
            return super.performOk();
        }
        return false;
    }

    public String getPageDescription() {
        return Messages.getString((String)"OutputColumnsPage.description");
    }

    public String getToolTip() {
        return Messages.getString((String)"OutputColumnPage.OutputColumns.Tooltip");
    }

    protected final void updateOutputColumns() {
        this.clearOutputColumns();
        try {
            this.populateOutputColums();
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void populateOutputColums() throws BirtException {
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = oldContextLoader;
        if (parentLoader == null) {
            parentLoader = this.getClass().getClassLoader();
        }
        ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader(parentLoader, ((DataSetEditor)this.getContainer()).getHandle().getModuleHandle());
        ModuleHandle handle = ((DataSetEditor)this.getContainer()).getHandle().getModuleHandle();
        if (handle instanceof ReportDesignHandle) {
            HashMap dataSetMap = new HashMap();
            HashMap dataSourceMap = new HashMap();
            try {
                EngineConfig ec = new EngineConfig();
                ec.getAppContext().put("PARENT_CLASSLOADER", newContextLoader);
                ReportEngine engine = (ReportEngine)new ReportEngineFactory().createReportEngine(ec);
                DataSetUIUtil.clearPropertyBindingMap(((DataSetEditor)this.getContainer()).getHandle(), dataSetMap, dataSourceMap);
                DummyEngineTask engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign((ReportDesignHandle)handle), handle);
                DataRequestSession session = engineTask.getDataSession();
                engineTask.run();
                DataSetViewData[] viewDatas = DataSetProvider.getCurrentInstance().populateAllOutputColumns(((DataSetEditor)this.getContainer()).getHandle(), session);
                if (viewDatas == null) {
                    viewDatas = ((DataSetEditor)this.getContainer()).getCurrentItemModel(false, false);
                }
                this.viewer.getViewer().setInput((Object)viewDatas);
                engineTask.close();
                engine.destroy();
            }
            finally {
                DataSetUIUtil.resetPropertyBinding(((DataSetEditor)this.getContainer()).getHandle(), dataSetMap, dataSourceMap);
            }
        } else {
            DataSessionContext context = new DataSessionContext(3, ((DataSetEditor)this.getContainer()).getHandle().getModuleHandle());
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
            DataSetViewData[] viewDatas = DataSetProvider.getCurrentInstance().populateAllOutputColumns(((DataSetEditor)this.getContainer()).getHandle(), session);
            if (viewDatas == null) {
                viewDatas = ((DataSetEditor)this.getContainer()).getCurrentItemModel(false, false);
            }
            this.viewer.getViewer().setInput((Object)viewDatas);
            session.shutdown();
        }
        Thread.currentThread().setContextClassLoader(oldContextLoader);
    }

    protected final void clearOutputColumns() {
        this.viewer.getViewer().getTable().removeAll();
    }

    private void saveOutputColumns() {
        PropertyHandle handle = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        if (this.viewer != null && this.viewer.getViewer() != null && this.viewer.getViewer().getInput() != null) {
            DataSetViewData[] items = (DataSetViewData[])this.viewer.getViewer().getInput();
            String columnName = null;
            boolean found = false;
            int n = 0;
            while (n < items.length) {
                ColumnHintHandle hint;
                columnName = items[n].getName();
                found = false;
                Iterator iter = handle.iterator();
                if (iter != null) {
                    while (iter.hasNext() && !found) {
                        hint = (ColumnHintHandle)iter.next();
                        if (!hint.getColumnName().equals(columnName)) continue;
                        found = true;
                        if (items[n].getRealDisplayName() == null || items[n].getRealDisplayName().trim().length() == 0) {
                            hint.setDisplayName(null);
                        } else {
                            hint.setDisplayName(items[n].getRealDisplayName());
                        }
                        if (items[n].getDisplayNameKey() == null || items[n].getDisplayNameKey().trim().length() == 0) {
                            hint.setDisplayNameKey(null);
                        } else {
                            hint.setDisplayNameKey(items[n].getDisplayNameKey());
                        }
                        if (items[n].getAlias() == null || items[n].getAlias().trim().length() == 0) {
                            hint.setAlias(null);
                        } else {
                            hint.setAlias(items[n].getAlias());
                        }
                        if (items[n].getHelpText() == null || items[n].getHelpText().trim().length() == 0) {
                            hint.setHelpText(null);
                            continue;
                        }
                        hint.setHelpText(items[n].getHelpText());
                    }
                }
                if (!found && this.isColumnHintRequired(items[n])) {
                    hint = new ColumnHint();
                    hint.setProperty("columnName", (Object)columnName);
                    if (items[n].getRealDisplayName() != null && items[n].getRealDisplayName().trim().length() > 0) {
                        hint.setProperty("displayName", (Object)items[n].getRealDisplayName());
                    }
                    if (items[n].getDisplayNameKey() != null && items[n].getDisplayNameKey().trim().length() > 0) {
                        hint.setProperty("displayNameID", (Object)items[n].getDisplayNameKey());
                    }
                    if (items[n].getAlias() != null && items[n].getAlias().trim().length() > 0) {
                        hint.setProperty("alias", (Object)items[n].getAlias());
                    }
                    if (items[n].getHelpText() != null && items[n].getHelpText().trim().length() > 0) {
                        hint.setProperty("helpText", (Object)items[n].getHelpText());
                    }
                    try {
                        handle.addItem((IStructure)hint);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
                ++n;
            }
        }
    }

    private boolean isUnique(String newValue) {
        DataSetViewData[] items = null;
        items = this.viewer == null || this.viewer.getViewer() == null ? DataSetProvider.getCurrentInstance().getColumns(((DataSetEditor)this.getContainer()).getHandle(), false, true, true) : (DataSetViewData[])this.viewer.getViewer().getInput();
        int i = 0;
        while (i < items.length) {
            if (items[i].getAlias() != null && items[i].getAlias().equals(newValue) || items[i].getName() != null && items[i].getName().equals(newValue)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValid() {
        boolean validate = true;
        DataSetViewData[] items = null;
        items = this.viewer == null || this.viewer.getViewer() == null ? DataSetProvider.getCurrentInstance().getColumns(((DataSetEditor)this.getContainer()).getHandle(), false, true, true) : (DataSetViewData[])this.viewer.getViewer().getInput();
        int i = 0;
        while (items != null && i < items.length && validate) {
            String newColumnNameOrAlias = items[i].getAlias();
            if (newColumnNameOrAlias != null && newColumnNameOrAlias.length() > 0) {
                int n = 0;
                while (n < items.length) {
                    if (i != n && (items[n].getName() != null && items[n].getName().equals(newColumnNameOrAlias) || items[n].getAlias() != null && items[n].getAlias().equals(newColumnNameOrAlias))) {
                        validate = false;
                        this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.columnOrAliasNameAlreadyUsed", (Object[])new Object[]{newColumnNameOrAlias, new Integer(n + 1)}), 3);
                        break;
                    }
                    ++n;
                }
            }
            ++i;
        }
        return validate;
    }

    private void updateMessage() {
        if (this.isValid()) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputColumns"), 0);
        }
    }

    private boolean isColumnHintRequired(DataSetViewData model) {
        return model.getRealDisplayName() != null && model.getRealDisplayName().trim().length() != 0 || model.getDisplayNameKey() != null && model.getDisplayNameKey().trim().length() != 0 || model.getAlias() != null && model.getAlias().trim().length() != 0 || model.getHelpText() != null && model.getHelpText().trim().length() != 0;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (focus.equals(this.getContainer().getModel())) {
            this.modelChanged = true;
        }
    }

    public boolean performCancel() {
        if (this.viewer != null && this.viewer.getViewer() != null && this.viewer.getViewer().getInput() != null) {
            DataSetProvider manager = DataSetProvider.getCurrentInstance();
            manager.updateModel(((DataSetEditor)this.getContainer()).getHandle(), (DataSetViewData[])this.viewer.getViewer().getInput());
        }
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    private class OutputColumnInputDialog
    extends PropertyHandleInputDialog {
        DataSetViewData data;

        protected OutputColumnInputDialog(Object structureOrHandle) {
            super(structureOrHandle);
            this.data = null;
            this.data = (DataSetViewData)structureOrHandle;
        }

        protected void createCustomControls(Composite parent) {
            try {
                this.createCells(parent);
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
        }

        private void createCells(Composite parent) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
            int i = 0;
            while (i < cellProperties.length) {
                ControlProvider.createLabel(parent, dialogLabels[i]);
                if (i == 4) {
                    this.createResourceCell(parent, i);
                } else {
                    this.createTextCell(parent, i);
                }
                ++i;
            }
        }

        private void createTextCell(Composite parent, final int index) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
            final Text tx = ControlProvider.createText(parent, (String)Utility.getProperty(this.data, cellProperties[index]));
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            if (index < 2) {
                tx.setEditable(false);
            } else {
                tx.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        try {
                            if (index == 2) {
                                boolean isUniqueName = OutputColumnsPage.this.isUnique(tx.getText());
                                if (!isUniqueName) {
                                    OutputColumnInputDialog.this.updateStatus((IStatus)OutputColumnInputDialog.this.getMiscStatus(4, Messages.getString((String)"OutputColumnPage.OutputColumns.DuplicatedName")));
                                } else {
                                    OutputColumnInputDialog.this.updateStatus((IStatus)OutputColumnInputDialog.this.getOKStatus());
                                }
                            }
                            String txText = tx.getText();
                            if (tx.getText().trim().length() == 0) {
                                txText = null;
                            }
                            Utility.setProperty(OutputColumnInputDialog.this.data, cellProperties[index], txText);
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle(e1);
                        }
                    }
                });
            }
            if (index == 2) {
                tx.setFocus();
            }
        }

        private void createResourceCell(Composite parent, final int index) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
            final Text tx = ControlProvider.createText(parent, (String)Utility.getProperty(this.data, cellProperties[index]));
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            tx.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        Utility.setProperty(OutputColumnInputDialog.this.data, cellProperties[index], tx.getText());
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle(e1);
                    }
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ResourceEditDialog dlg = new ResourceEditDialog(OutputColumnInputDialog.this.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
                    dlg.setResourceURL(OutputColumnInputDialog.this.getResourceURL());
                    if (dlg.open() == 0) {
                        tx.setText((String)dlg.getResult());
                    }
                }
            };
            Button bt = new Button(parent, 8);
            bt.setText("...");
            bt.addSelectionListener((SelectionListener)listener);
            if (this.getBaseName() == null) {
                bt.setEnabled(false);
            }
        }

        private URL getResourceURL() {
            return SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(this.getBaseName(), 5);
        }

        private String getBaseName() {
            return SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResource();
        }

        protected void rollback() {
            this.data.setAlias(OutputColumnsPage.this.originalAlias);
            this.data.setRealDisplayName(OutputColumnsPage.this.originalDisplayName);
            this.data.setDisplayNameKey(OutputColumnsPage.this.originalDisplayNameKey);
        }

        protected IStatus validateSemantics(Object structureOrHandle) {
            return null;
        }

        protected IStatus validateSyntax(Object structureOrHandle) {
            return null;
        }

        protected String getTitle() {
            if (this.data instanceof Structure) {
                return Messages.getString((String)"OutputColumnPage.title.OutputColumnInputDialog.NewOutputColumn");
            }
            return Messages.getString((String)"OutputColumnPage.title.OutputColumnInputDialog.EditOutputColumn");
        }
    }
}

