/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.datasource.DataSourceEditor;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.dialogs.properties.AbstractPropertyPage;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionResponse;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSetDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSourceDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetEditorPage;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

public class PropertyPageWrapper
extends AbstractPropertyPage {
    private PropertyPage propertyPage = null;
    private DataSetDesignSession dataSetSession = null;
    private DataSourceDesignSession dataSourceSession = null;

    public PropertyPageWrapper(PropertyPage propertyPage, DataSetDesignSession m_designSession) {
        this.propertyPage = propertyPage;
        this.dataSetSession = m_designSession;
    }

    public PropertyPageWrapper(PropertyPage propertyPage, DataSourceDesignSession m_designSession) {
        this.propertyPage = propertyPage;
        this.dataSourceSession = m_designSession;
    }

    public Control createPageControl(Composite parent) {
        this.propertyPage.setContainer((IPreferencePageContainer)this.getContainer());
        this.propertyPage.createControl(parent);
        return this.propertyPage.getControl();
    }

    public void pageActivated() {
        if (this.propertyPage instanceof DataSetEditorPage) {
            ((DataSetEditorPage)this.propertyPage).refresh();
        } else if (this.propertyPage instanceof DataSourceEditorPage) {
            ((DataSourceEditorPage)this.propertyPage).refresh();
        }
        this.getContainer().setMessage(this.propertyPage.getMessage(), this.propertyPage.getMessageType());
    }

    public PropertyPage getPropertyPage() {
        return this.propertyPage;
    }

    public String getToolTip() {
        return this.propertyPage.getTitle();
    }

    public boolean performOk() {
        return this.canLeave();
    }

    public boolean canLeave() {
        if (this.propertyPage instanceof DataSetEditorPage) {
            boolean okToLeave = ((DataSetEditorPage)this.propertyPage).okToLeave();
            if (okToLeave) {
                try {
                    DataSetDesign requestDesign = null;
                    DesignSessionResponse response = null;
                    if (this.dataSetSession != null) {
                        requestDesign = this.dataSetSession.getRequest().getDataSetDesign();
                        response = this.dataSetSession.flush().getResponse();
                    } else {
                        response = ((DataSetEditorPage)this.propertyPage).collectPageResponse();
                    }
                    DTPUtil.getInstance().updateDataSetHandle(response, requestDesign, (OdaDataSetHandle)((DataSetEditor)this.getContainer()).getModel(), false);
                }
                catch (OdaException e) {
                    ExceptionHandler.handle(e);
                }
            }
            return okToLeave;
        }
        if (this.propertyPage instanceof DataSourceEditorPage) {
            if (this.propertyPage.okToLeave()) {
                try {
                    DataSourceDesign requestDesign = null;
                    if (this.dataSourceSession != null) {
                        requestDesign = this.dataSourceSession.getRequest().getDataSourceDesign();
                    }
                    DTPUtil.getInstance().updateDataSourceHandle(((DataSourceEditorPage)this.propertyPage).getEditSessionResponse().getResponse(), requestDesign, (OdaDataSourceHandle)this.getContainer().getModel());
                    ((DataSourceEditor)this.getContainer()).updateDesignSession();
                }
                catch (OdaException e) {
                    ExceptionHandler.handle(e);
                }
            }
            return this.propertyPage.okToLeave();
        }
        return super.canLeave();
    }
}

