/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;

public class ApplyStyleHandler
extends SelectionHandler {
    private static final String STACK_MSG_APPLY_STYLE = Messages.getString((String)"ApplyStyleAction.stackMsg.applyStyle");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Apply style rule action >> Run ...");
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(STACK_MSG_APPLY_STYLE);
        boolean isChecked = true;
        SharedStyleHandle handle = null;
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        Object obj = context.getVariable("ApplyStyleAction.StyleHandleName");
        if (obj != null && obj instanceof SharedStyleHandle) {
            handle = (SharedStyleHandle)obj;
        }
        if ((obj = context.getVariable("ApplyStyleAction.StyleChecked")) != null && obj instanceof Boolean) {
            isChecked = (Boolean)obj;
        }
        try {
            List handles = this.getElementHandles();
            int i = 0;
            while (i < handles.size()) {
                ((DesignElementHandle)handles.get(i)).setStyle((SharedStyleHandle)(isChecked ? handle : null));
                ++i;
            }
            stack.commit();
        }
        catch (StyleException e) {
            stack.rollbackAll();
            ExceptionHandler.handle(e);
        }
        return new Boolean(true);
    }
}

