/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IDisposable;

public class CommandUtils {
    public static Parameterization createParameter(Command command, String parameterId, Object value) throws NotDefinedException, ExecutionException, ParameterValueConversionException {
        ParameterType parameterType = command.getParameterType(parameterId);
        if (parameterType == null) {
            throw new ExecutionException("Command does not have a parameter type for the given parameter");
        }
        IParameter param = command.getParameter(parameterId);
        AbstractParameterValueConverter valueConverter = parameterType.getValueConverter();
        if (valueConverter == null) {
            throw new ExecutionException("Command does not have a value converter");
        }
        String valueString = valueConverter.convertToString(value);
        Parameterization parm = new Parameterization(param, valueString);
        return parm;
    }

    public static void disposeParameter(String parameterId, Command command) throws NotDefinedException {
        ParameterType parameterType = command.getParameterType(parameterId);
        AbstractParameterValueConverter valueConverter = parameterType.getValueConverter();
        if (valueConverter instanceof IDisposable) {
            ((IDisposable)valueConverter).dispose();
        }
    }

    public static ICommandService getCommandService() {
        return (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
    }

    public static IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
    }

    public static Command getCommand(String commandId) {
        return CommandUtils.getCommandService().getCommand(commandId);
    }

    public static Object executeCommand(String commandId, Map paramMap) throws NotDefinedException, ExecutionException, ParameterValueConversionException, NotEnabledException, NotHandledException {
        Command cmd = CommandUtils.getCommand(commandId);
        ArrayList<Parameterization> paramList = new ArrayList<Parameterization>();
        if (paramMap != null) {
            for (String paramId : paramMap.keySet()) {
                Object value = paramMap.get(paramId);
                if (value == null) continue;
                paramList.add(CommandUtils.createParameter(cmd, paramId, value));
            }
        }
        if (paramList.size() > 0) {
            ParameterizedCommand paramCommand = new ParameterizedCommand(cmd, paramList.toArray(new Parameterization[paramList.size()]));
            return CommandUtils.getHandlerService().executeCommand(paramCommand, null);
        }
        return CommandUtils.getHandlerService().executeCommand(commandId, null);
    }

    public static Object executeCommand(String commandId) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        return CommandUtils.getHandlerService().executeCommand(commandId, null);
    }

    public static void setVariable(String name, Object value) {
        CommandUtils.getHandlerService().getCurrentState().addVariable(name, value);
    }

    public static void removeVariable(String name) {
        CommandUtils.getHandlerService().getCurrentState().removeVariable(name);
    }
}

