/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.commands.DeleteCommand;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DeleteWarningDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteHandler
extends SelectionHandler {
    public static final String CONFIRM_PARAM_DELETE_TITLE = Messages.getString((String)"DefaultNodeProvider.ParameterGroup.ConfirmTitle");
    public static final String CONFIRM_PARAM_DELETE_MESSAGE = Messages.getString((String)"DefaultNodeProvider.ParameterGroup.ConfirmMessage");
    public static final String DLG_CONFIRM_MSG = Messages.getString((String)"DefaultNodeProvider.Dlg.Confirm");
    public static final String DLG_HAS_FOLLOWING_CLIENTS_MSG = Messages.getString((String)"DefaultNodeProvider.Tree.Clients");
    public static final String DLG_REFERENCE_FOUND_TITLE = Messages.getString((String)"DefaultNodeProvider.Tree.Reference");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        boolean hasExecuted = this.isOKPressed(this.getElementHandles());
        if (hasExecuted) {
            this.createDeleteCommand(this.getElementHandles().toArray()).execute();
        }
        return new Boolean(hasExecuted);
    }

    protected Command createDeleteCommand(Object objects) {
        return new DeleteCommand(objects);
    }

    protected boolean isOKPressed(Object model) {
        if (model instanceof IStructuredSelection) {
            for (Object obj : (IStructuredSelection)model) {
                if (this.isOKPressed(obj)) continue;
                return false;
            }
            return true;
        }
        if (model instanceof List) {
            for (Object obj : (List)model) {
                if (this.isOKPressed(obj)) continue;
                return false;
            }
            return true;
        }
        if (model instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)model;
            if (handle instanceof ParameterGroupHandle && ((ParameterGroupHandle)handle).getParameters().getCount() > 0) {
                if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)CONFIRM_PARAM_DELETE_TITLE, (String)CONFIRM_PARAM_DELETE_MESSAGE)) {
                    return false;
                }
                for (Object obj : ((ParameterGroupHandle)handle).getParameters()) {
                    if (!(obj instanceof ParameterHandle)) continue;
                    ParameterHandle parameter = (ParameterHandle)obj;
                    ConfigVariable cv = parameter.getModuleHandle().findConfigVariable(parameter.getName());
                    try {
                        if (cv == null) continue;
                        parameter.getModuleHandle().getPropertyHandle("configVars").removeItem((Object)cv);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
            }
            ArrayList referenceList = new ArrayList();
            Iterator itor = handle.clientsIterator();
            while (itor.hasNext()) {
                referenceList.add(itor.next());
            }
            if (!referenceList.isEmpty()) {
                DeleteWarningDialog dialog = new DeleteWarningDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), DLG_REFERENCE_FOUND_TITLE, referenceList);
                dialog.setPreString(String.valueOf(DEUtil.getDisplayLabel((Object)handle)) + DLG_HAS_FOLLOWING_CLIENTS_MSG);
                dialog.setSufString(DLG_CONFIRM_MSG);
                return dialog.open() != 1;
            }
            return true;
        }
        return true;
    }
}

