/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CssErrDialog
extends TitleAreaDialog {
    private List errorList;
    private int level;
    public static final int FATAL_ERROR = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;

    public CssErrDialog(Shell parentShell) {
        super(parentShell);
    }

    public CssErrDialog(Shell parentShell, List list, int level) {
        this(parentShell);
        this.errorList = list;
        this.level = level;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setMessage(Messages.getString((String)"CssErrDialog.AreaMessage"));
        this.setTitle(Messages.getString((String)"CssErrDialog.AreaTitle"));
        this.getShell().setText(Messages.getString((String)"CssErrDialog.shellTitle.ImportCssStyleMssageTitle"));
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createComposite(composite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.CssErrDialog_ID");
        return composite;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        composite.setData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText(Messages.getString((String)"CssErrDialog.Severity"));
        Label messageLine = new Label(composite, 0);
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText(Messages.getString((String)"CssErrDialog.Message"));
        messageLabel.setLayoutData((Object)new GridData(2));
        Text messageText = new Text(composite, 2882);
        gd = new GridData();
        gd.heightHint = 200;
        gd.widthHint = 340;
        messageText.setLayoutData((Object)gd);
        messageText.setEditable(false);
        switch (this.level) {
            case 1: {
                messageLine.setText(Messages.getString((String)"CssErrDialog.FatalError"));
                break;
            }
            case 2: {
                messageLine.setText(Messages.getString((String)"CssErrDialog.Error"));
                break;
            }
            case 3: {
                messageLine.setText(Messages.getString((String)"CssErrDialog.Warning"));
            }
        }
        Iterator errorIter = this.errorList.listIterator();
        while (errorIter.hasNext()) {
            messageText.append(errorIter.next().toString());
            messageText.append("\n");
        }
        return parent;
    }
}

