/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IBindingDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataColumnBindingDialog
extends BaseDialog {
    protected static final String DEFAULT_ITEM_NAME = "data column";
    protected static final String NEW_DATAITEM_TITLE = Messages.getString((String)"DataColumBindingDialog.title.CreateNewDataBinding");
    protected static final String EDIT_DATAITEM_TITLE = Messages.getString((String)"DataColumBindingDialog.title.EditDataBinding");
    protected static final String AGG_BUILDER_TITLE = Messages.getString((String)"DataColumBindingDialog.title.AggBuilder");
    IBindingDialogHelper dialogHelper;
    private ReportItemHandle bindingObject;
    private ComputedColumnHandle bindingColumn;
    private ExpressionProvider expressionProvider;
    private boolean isAggregate;
    private boolean bindSelf = false;

    public DataColumnBindingDialog(boolean isCreateNew) {
        super(isCreateNew ? NEW_DATAITEM_TITLE : EDIT_DATAITEM_TITLE);
    }

    public DataColumnBindingDialog(boolean isCreateNew, boolean bindSelf) {
        super(isCreateNew ? NEW_DATAITEM_TITLE : EDIT_DATAITEM_TITLE);
        this.bindSelf = bindSelf;
    }

    public void setInput(ReportItemHandle input) {
        this.setInput(input, null);
    }

    public DesignElementHandle getBindingObject() {
        return this.bindingObject;
    }

    public ComputedColumnHandle getBindingColumn() {
        return this.bindingColumn;
    }

    public void setInput(ReportItemHandle bindingObject, ComputedColumnHandle bindingColumn, Object container) {
        this.bindingObject = bindingObject;
        this.bindingColumn = bindingColumn;
        this.dialogHelper = (IBindingDialogHelper)ElementAdapterManager.getAdapter(DEUtil.getBindingHolder((DesignElementHandle)bindingObject), IBindingDialogHelper.class);
        if (!this.bindSelf) {
            this.dialogHelper.setBindingHolder(DEUtil.getBindingHolder((DesignElementHandle)bindingObject));
        } else {
            this.dialogHelper.setBindingHolder(bindingObject);
        }
        this.dialogHelper.setBinding(bindingColumn);
        this.dialogHelper.setContainer(container);
        this.dialogHelper.setDialog(this);
        if (this.isAggregate) {
            this.dialogHelper.setAggregate(this.isAggregate);
        }
        if (this.isAggregate || bindingColumn != null && bindingColumn.getAggregateFunction() != null && !bindingColumn.getAggregateFunction().equals("")) {
            this.setTitle(AGG_BUILDER_TITLE);
        }
    }

    public void setInput(ReportItemHandle bindingObject, ComputedColumnHandle bindingColumn) {
        this.setInput(bindingObject, bindingColumn, null);
    }

    public void setAggreate(boolean isAggregate) {
        this.isAggregate = isAggregate;
        if (isAggregate) {
            this.setTitle(AGG_BUILDER_TITLE);
        }
        if (this.dialogHelper != null) {
            this.dialogHelper.setAggregate(isAggregate);
        }
    }

    public void setExpressionProvider(ExpressionProvider expressionProvider) {
        this.expressionProvider = expressionProvider;
    }

    protected boolean isForceBinding() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.dialogHelper.setExpressionProvider(this.expressionProvider);
        this.dialogHelper.createContent(composite);
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.DataColumnBindingDialog_ID");
        return composite;
    }

    protected void okPressed() {
        try {
            if (this.bindingColumn != null) {
                if (this.dialogHelper.differs(this.bindingColumn)) {
                    if (this.isBindingMultipleReferenced()) {
                        MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"DataColumnBindingDialog.NewBindingDialogTitle"), null, Messages.getString((String)"DataColumnBindingDialog.NewBindingDialogMessage"), 3, new String[]{Messages.getString((String)"DataColumnBindingDialog.NewBindingDialogButtonYes"), Messages.getString((String)"DataColumnBindingDialog.NewBindingDialogButtonNo"), Messages.getString((String)"DataColumnBindingDialog.NewBindingDialogButtonCancel")}, 0);
                        int dialogClick = dialog.open();
                        if (dialogClick == 0) {
                            InputDialog inputDialog = new InputDialog(UIUtil.getDefaultShell(), Messages.getString((String)"DataColumnBindingDialog.NewBindingDialogInputNewNameTitle"), Messages.getString((String)"DataColumnBindingDialog.NewBindingDialogInputNewNameMessage"), "", new IInputValidator(){

                                public String isValid(String newText) {
                                    for (ComputedColumnHandle computedColumn : DEUtil.getBindingHolder((DesignElementHandle)DataColumnBindingDialog.this.bindingObject).getColumnBindings()) {
                                        if (!computedColumn.getName().equals(newText)) continue;
                                        return Messages.getFormattedString((String)"BindingDialogHelper.error.nameduplicate", (Object[])new Object[]{newText});
                                    }
                                    return null;
                                }
                            });
                            if (inputDialog.open() == 0) {
                                this.bindingColumn = this.dialogHelper.newBinding(DEUtil.getBindingHolder((DesignElementHandle)this.bindingObject), inputDialog.getValue());
                                super.okPressed();
                                return;
                            }
                            return;
                        }
                        if (dialogClick == 2) {
                            return;
                        }
                    }
                    if (!this.dialogHelper.canProcessWithWarning()) {
                        return;
                    }
                    this.bindingColumn = this.dialogHelper.editBinding(this.bindingColumn);
                }
            } else {
                if (!this.dialogHelper.canProcessWithWarning()) {
                    return;
                }
                this.bindingColumn = this.bindSelf ? this.dialogHelper.newBinding(this.bindingObject, null) : this.dialogHelper.newBinding(DEUtil.getBindingHolder((DesignElementHandle)this.bindingObject), null);
            }
            super.okPressed();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    private boolean isBindingMultipleReferenced() {
        ArrayList<ComputedColumnHandle> bindings = new ArrayList<ComputedColumnHandle>();
        ReportItemHandle holder = DEUtil.getBindingHolder((DesignElementHandle)this.bindingObject);
        for (ComputedColumnHandle computedColumn : holder.getColumnBindings()) {
            bindings.add(computedColumn);
        }
        Set referencedBindings = DataUtil.getReferencedBindings(this.bindingColumn, bindings);
        referencedBindings.add(this.bindingColumn);
        return this.isBindingUsed(holder, referencedBindings, this.bindingObject);
    }

    private boolean isBindingUsed(Object obj, Set bindings, ReportItemHandle excepted) {
        if (obj instanceof DataItemHandle && !obj.equals(excepted)) {
            for (ComputedColumnHandle binding : bindings) {
                if (!binding.getName().equals(((DataItemHandle)obj).getResultSetColumn())) continue;
                return true;
            }
        }
        Object[] children = ProviderFactory.createProvider(obj).getChildren(obj);
        int i = 0;
        while (i < children.length) {
            if ((!(children[i] instanceof ReportItemHandle) || ((ReportItemHandle)children[i]).getDataSet() == null && ((ReportItemHandle)children[i]).getDataBindingReference() == null) && this.isBindingUsed(children[i], bindings, excepted)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.dialogHelper.validate();
    }

    protected boolean initDialog() {
        this.dialogHelper.initDialog();
        return super.initDialog();
    }

    public void setCanFinish(boolean canFinish) {
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(canFinish);
        }
    }
}

