/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionArgument;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.impl.FunctionProvider;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.aggregation.AggregationUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ExpressionFilter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.IIndexInfo;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.IContextExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.ILocalizableInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ExpressionTreeSupport
implements ISelectionChangedListener {
    private static final Image IMAGE_FOLDER = ReportPlatformUIImages.getImage("IMG_OBJ_FOLDER");
    private static final Image IMAGE_OPERATOR = ExpressionTreeSupport.getIconImage("Operator");
    private static final Image IMAGE_COLUMN = ExpressionTreeSupport.getIconImage("DataColumn");
    private static final Image IMAGE_GOLBAL = ExpressionTreeSupport.getIconImage("Global");
    private static final Image IMAGE_METHOD = ExpressionTreeSupport.getIconImage("Method");
    private static final Image IMAGE_STATIC_METHOD = ExpressionTreeSupport.getIconImage("Static Method");
    private static final Image IMAGE_CONSTRUCTOR = ExpressionTreeSupport.getIconImage("Constructor");
    private static final Image IMAGE_MEMBER = ExpressionTreeSupport.getIconImage("Member");
    private static final Image IMAGE_STATIC_MEMBER = ExpressionTreeSupport.getIconImage("Static Member");
    private static final String[][] OPERATORS_ASSIGNMENT = new String[][]{{"=", Messages.getString((String)"ExpressionProvider.Operator.Assign")}, {"+=", Messages.getString((String)"ExpressionProvider.Operator.AddTo")}, {"-=", Messages.getString((String)"ExpressionProvider.Operator.SubFrom")}, {"*=", Messages.getString((String)"ExpressionProvider.Operator.MultTo")}, {"/=", Messages.getString((String)"ExpressionProvider.Operator.DividingFrom")}};
    private static final String[][] OPERATORS_COMPARISON = new String[][]{{"==", Messages.getString((String)"ExpressionProvider.Operator.Equals")}, {"<", Messages.getString((String)"ExpressionProvider.Operator.Less")}, {"<=", Messages.getString((String)"ExpressionProvider.Operator.LessEqual")}, {"!=", Messages.getString((String)"ExpressionProvider.Operator.NotEqual")}, {">", Messages.getString((String)"ExpressionProvider.Operator.Greater")}, {">=", Messages.getString((String)"ExpressionProvider.Operator.GreaterEquals")}};
    private static final String[][] OPERATORS_COMPUTATIONAL = new String[][]{{"+", Messages.getString((String)"ExpressionProvider.Operator.Add")}, {"-", Messages.getString((String)"ExpressionProvider.Operator.Sub")}, {"*", Messages.getString((String)"ExpressionProvider.Operator.Mult")}, {"/", Messages.getString((String)"ExpressionProvider.Operator.Divides")}, {"++X ", Messages.getString((String)"ExpressionProvider.Operator.Inc")}, {"X++ ", Messages.getString((String)"ExpressionProvider.Operator.ReturnInc")}, {"--X ", Messages.getString((String)"ExpressionProvider.Operator.Dec")}, {"X-- ", Messages.getString((String)"ExpressionProvider.Operator.ReturnDec")}};
    private static final String[][] OPERATORS_LOGICAL = new String[][]{{"&&", Messages.getString((String)"ExpressionProvider.Operator.And")}, {"||", Messages.getString((String)"ExpressionProvider.Operator.Or")}};
    private static final String TREE_ITEM_CONTEXT = Messages.getString((String)"ExpressionProvider.Category.Context");
    private static final String TREE_ITEM_OPERATORS = Messages.getString((String)"ExpressionProvider.Category.Operators");
    private static final String TREE_ITEM_BIRT_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.BirtObjects");
    private static final String TREE_ITEM_DATASETS = Messages.getString((String)"ExpressionProvider.Category.DataSets");
    private static final String TREE_ITEM_PARAMETERS = Messages.getString((String)"ExpressionProvider.Category.Parameters");
    private static final String TREE_ITEM_NATIVE_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.NativeObjects");
    private static final String TREE_ITEM_LOGICAL = Messages.getString((String)"ExpressionProvider.Operators.Logical");
    private static final String TREE_ITEM_COMPUTATIONAL = Messages.getString((String)"ExpressionProvider.Operators.Computational");
    private static final String TREE_ITEM_COMPARISON = Messages.getString((String)"ExpressionProvider.Operators.Comparison");
    private static final String TREE_ITEM_ASSIGNMENT = Messages.getString((String)"ExpressionProvider.Operators.Assignment");
    protected static final String ITEM_DATA_KEY_TOOLTIP = "TOOL_TIP";
    protected static final String ITEM_DATA_KEY_TEXT = "TEXT";
    protected static final String ITEM_DATA_KEY_ENABLED = "ENABLED";
    private static final String OBJECTS_TYPE_NATIVE = "native";
    private static final String OBJECTS_TYPE_BIRT = "birt";
    private static final String CLIENT_CONTEXT = "client";
    public static final String TREE_NAME_OPERATORS = "Operators";
    public static final String TREE_NAME_NATIVE_OBJECTS = "Native Objects";
    public static final String TREE_NAME_BIRT_OBJECTS = "Birt Objects";
    public static final String TREE_NAME_DATASETS = "DataSets";
    public static final String TREE_NAME_PARAMETERS = "Parameters";
    public static final String TREE_NAME_CONTEXT = "Context";
    private SourceViewer expressionViewer;
    private Tree tree;
    private DropTarget dropTarget;
    private DropTargetAdapter dropTargetAdapter;
    private Object currentEditObject;
    private String currentMethodName;
    private String currentContextName;
    private TreeItem contextItem;
    private TreeItem dataSetsItem;
    private TreeItem parametersItem;
    private TreeItem nativeObejctsItem;
    private TreeItem birtObjectsItem;
    private List<TreeItem> dynamicItems;

    public void createDefaultExpressionTree(List dataSetList) {
        this.createFilteredExpressionTree(dataSetList, null);
    }

    public void createFilteredExpressionTree(List dataSetList, List filterList) {
        if (this.filter(TREE_NAME_CONTEXT, filterList)) {
            this.createContextCatagory();
        }
        if (this.filter(TREE_NAME_PARAMETERS, filterList)) {
            this.createParamtersCategory();
        }
        if (this.filter(TREE_NAME_NATIVE_OBJECTS, filterList)) {
            this.createNativeObjectsCategory();
        }
        if (this.filter(TREE_NAME_BIRT_OBJECTS, filterList)) {
            this.createBirtObjectsCategory();
        }
        if (this.filter(TREE_NAME_OPERATORS, filterList)) {
            this.createOperatorsCategory();
        }
        if (this.currentMethodName != null) {
            this.switchContext();
        }
    }

    private boolean filter(String treeName, List filters) {
        if (filters == null) {
            return true;
        }
        for (Object obj : filters) {
            if (!(obj instanceof ExpressionFilter) || ((ExpressionFilter)obj).select(this, treeName)) continue;
            return false;
        }
        return true;
    }

    protected void createOperatorsCategory() {
        assert (this.tree != null);
        TreeItem topItem = this.createTopTreeItem(this.tree, TREE_ITEM_OPERATORS);
        TreeItem subItem = this.createSubFolderItem(topItem, TREE_ITEM_ASSIGNMENT);
        this.createSubTreeItems(subItem, OPERATORS_ASSIGNMENT, IMAGE_OPERATOR);
        subItem = this.createSubFolderItem(topItem, TREE_ITEM_COMPARISON);
        this.createSubTreeItems(subItem, OPERATORS_COMPARISON, IMAGE_OPERATOR);
        subItem = this.createSubFolderItem(topItem, TREE_ITEM_COMPUTATIONAL);
        this.createSubTreeItems(subItem, OPERATORS_COMPUTATIONAL, IMAGE_OPERATOR);
        subItem = this.createSubFolderItem(topItem, TREE_ITEM_LOGICAL);
        this.createSubTreeItems(subItem, OPERATORS_LOGICAL, IMAGE_OPERATOR);
    }

    protected void createNativeObjectsCategory() {
        assert (this.tree != null);
        this.nativeObejctsItem = this.createTopTreeItem(this.tree, TREE_ITEM_NATIVE_OBJECTS);
        this.createObjects(this.nativeObejctsItem, OBJECTS_TYPE_NATIVE);
    }

    protected void createParamtersCategory() {
        assert (this.tree != null);
        this.parametersItem = this.createTopTreeItem(this.tree, TREE_ITEM_PARAMETERS);
        this.buildParameterTree();
    }

    private void buildParameterTree() {
        for (ReportElementHandle handle : SessionHandleAdapter.getInstance().getReportDesignHandle().getParameters()) {
            if (handle instanceof ParameterHandle) {
                this.createSubTreeItem(this.parametersItem, DEUtil.getDisplayLabel((Object)handle, (boolean)false), ReportPlatformUIImages.getImage(handle), DEUtil.getExpression((Object)handle), ((ParameterHandle)handle).getHelpText(), true);
                continue;
            }
            if (!(handle instanceof ParameterGroupHandle)) continue;
            TreeItem groupItem = this.createSubTreeItem(this.parametersItem, DEUtil.getDisplayLabel((Object)handle, (boolean)false), ReportPlatformUIImages.getImage(handle), true);
            for (ParameterHandle parameter : ((ParameterGroupHandle)handle).getParameters()) {
                this.createSubTreeItem(groupItem, parameter.getDisplayLabel(), ReportPlatformUIImages.getImage(handle), DEUtil.getExpression((Object)parameter), parameter.getDisplayLabel(), true);
            }
        }
    }

    protected void createDataSetsCategory(List dataSetList) {
        assert (this.tree != null);
        this.dataSetsItem = this.createTopTreeItem(this.tree, TREE_ITEM_DATASETS);
        this.buildDataSetsTree(dataSetList);
    }

    private void buildDataSetsTree(List dataSetList) {
        this.clearTreeItem(this.dataSetsItem);
        for (DataSetHandle handle : dataSetList) {
            TreeItem dataSetItem = this.createSubTreeItem(this.dataSetsItem, DEUtil.getDisplayLabel((Object)handle, (boolean)false), ReportPlatformUIImages.getImage(handle), true);
            try {
                CachedMetaDataHandle cachedMetadata = DataSetUIUtil.getCachedMetaDataHandle(handle);
                for (ResultSetColumnHandle element : cachedMetadata.getResultSet()) {
                    this.createSubTreeItem(dataSetItem, element.getColumnName(), IMAGE_COLUMN, DEUtil.getExpression((Object)element), element.getColumnName(), true);
                }
            }
            catch (SemanticException semanticException) {}
        }
    }

    protected void createBirtObjectsCategory() {
        assert (this.tree != null);
        this.birtObjectsItem = this.createTopTreeItem(this.tree, TREE_ITEM_BIRT_OBJECTS);
        this.createObjects(this.birtObjectsItem, OBJECTS_TYPE_BIRT);
    }

    private TreeItem createTopTreeItem(Tree parent, String text) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(text);
        item.setImage(IMAGE_FOLDER);
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)"");
        return item;
    }

    private TreeItem createTopTreeItem(Tree parent, String text, int index) {
        TreeItem item = new TreeItem(parent, 0, index);
        item.setText(text);
        item.setImage(IMAGE_FOLDER);
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)"");
        return item;
    }

    private TreeItem createSubTreeItem(TreeItem parent, String text, Image image, boolean isEnabled) {
        return this.createSubTreeItem(parent, text, image, null, text, isEnabled);
    }

    private TreeItem createSubTreeItem(TreeItem parent, String text, Image image, String textData, String toolTip, boolean isEnabled) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(text);
        if (image != null) {
            item.setImage(image);
        }
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)toolTip);
        item.setData(ITEM_DATA_KEY_TEXT, (Object)textData);
        item.setData(ITEM_DATA_KEY_ENABLED, (Object)isEnabled);
        return item;
    }

    private TreeItem createSubFolderItem(TreeItem parent, String text) {
        return this.createSubTreeItem(parent, text, IMAGE_FOLDER, true);
    }

    private TreeItem createSubFolderItem(TreeItem parent, IClassInfo classInfo) {
        return this.createSubTreeItem(parent, classInfo.getDisplayName(), IMAGE_FOLDER, null, classInfo.getToolTip(), true);
    }

    private TreeItem createSubFolderItem(TreeItem parent, IScriptFunctionCategory category) {
        String categoreName = this.getCategoryDisplayName(category);
        return this.createSubTreeItem(parent, categoreName, IMAGE_FOLDER, null, category.getDescription(), true);
    }

    private String getCategoryDisplayName(IScriptFunctionCategory category) {
        return category.getName() == null ? Messages.getString((String)"ExpressionTreeSupport.Category.Global") : category.getName();
    }

    private void createSubTreeItems(TreeItem parent, String[][] texts, Image image) {
        int i = 0;
        while (i < texts.length) {
            this.createSubTreeItem(parent, texts[i][0], image, texts[i][0], texts[i][1], true);
            ++i;
        }
    }

    public void addMouseTrackListener() {
        assert (this.tree != null);
        this.tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == ExpressionTreeSupport.this.tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = ExpressionTreeSupport.this.tree.getItem(pt);
                    if (item == null) {
                        ExpressionTreeSupport.this.tree.setToolTipText("");
                    } else {
                        String text = (String)item.getData(ExpressionTreeSupport.ITEM_DATA_KEY_TOOLTIP);
                        ExpressionTreeSupport.this.tree.setToolTipText(text);
                    }
                }
            }
        });
    }

    public void addMouseListener() {
        assert (this.tree != null);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                TreeItem[] selection = ExpressionTreeSupport.this.getTreeSelection();
                if (selection == null || selection.length <= 0) {
                    return;
                }
                TreeItem item = selection[0];
                if (item != null) {
                    Object obj = item.getData(ExpressionTreeSupport.ITEM_DATA_KEY_TEXT);
                    Boolean isEnabled = (Boolean)item.getData(ExpressionTreeSupport.ITEM_DATA_KEY_ENABLED);
                    if (obj != null && isEnabled.booleanValue()) {
                        String text = (String)obj;
                        ExpressionTreeSupport.this.insertText(text);
                    }
                }
            }
        });
    }

    protected TreeItem[] getTreeSelection() {
        return this.tree.getSelection();
    }

    public void addDragSupportToTree() {
        assert (this.tree != null);
        DragSource dragSource = new DragSource((Control)this.tree, 3);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = ExpressionTreeSupport.this.tree.getSelection();
                if (selection.length <= 0 || selection[0].getData(ExpressionTreeSupport.ITEM_DATA_KEY_TEXT) == null || !((Boolean)selection[0].getData(ExpressionTreeSupport.ITEM_DATA_KEY_ENABLED)).booleanValue()) {
                    event.doit = false;
                    return;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                TreeItem[] selection;
                if (TextTransfer.getInstance().isSupportedType(event.dataType) && (selection = ExpressionTreeSupport.this.tree.getSelection()).length > 0) {
                    event.data = selection[0].getData(ExpressionTreeSupport.ITEM_DATA_KEY_TEXT);
                }
            }
        });
    }

    protected void insertText(String text) {
        StyledText textWidget = this.expressionViewer.getTextWidget();
        if (!textWidget.isEnabled()) {
            return;
        }
        int selectionStart = textWidget.getSelection().x;
        if (text.equalsIgnoreCase("x++")) {
            text = String.valueOf(textWidget.getSelectionText()) + "++";
        } else if (text.equalsIgnoreCase("x--")) {
            text = String.valueOf(textWidget.getSelectionText()) + "--";
        } else if (text.equalsIgnoreCase("++x")) {
            text = "++" + textWidget.getSelectionText();
        } else if (text.equalsIgnoreCase("--x")) {
            text = "--" + textWidget.getSelectionText();
        }
        textWidget.insert(text);
        textWidget.setSelection(selectionStart + text.length());
        textWidget.setFocus();
        if (text.endsWith("()")) {
            textWidget.setCaretOffset(textWidget.getCaretOffset() - 1);
        }
    }

    public void addDropSupportToViewer() {
        assert (this.expressionViewer != null);
        if (this.dropTarget == null || this.dropTarget.isDisposed()) {
            final StyledText text = this.expressionViewer.getTextWidget();
            if (text.getData("DropTarget") != null) {
                return;
            }
            this.dropTarget = new DropTarget((Control)text, 17);
            this.dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            this.dropTargetAdapter = new DropTargetAdapter(){

                public void dragEnter(DropTargetEvent event) {
                    text.setFocus();
                    if (event.detail == 16) {
                        event.detail = 1;
                    }
                    if (event.detail != 1) {
                        event.detail = 0;
                    }
                }

                public void dragOver(DropTargetEvent event) {
                    event.feedback = 10;
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    this.dragEnter(event);
                }

                public void drop(DropTargetEvent event) {
                    if (event.data instanceof String) {
                        ExpressionTreeSupport.this.insertText((String)event.data);
                    }
                }
            };
            this.dropTarget.addDropListener((DropTargetListener)this.dropTargetAdapter);
        }
    }

    public void removeDropSupportToViewer() {
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            if (this.dropTargetAdapter != null) {
                this.dropTarget.removeDropListener((DropTargetListener)this.dropTargetAdapter);
                this.dropTargetAdapter = null;
            }
            this.dropTarget.dispose();
            this.dropTarget = null;
        }
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    protected Tree getTree() {
        return this.tree;
    }

    public void setExpressionViewer(SourceViewer expressionViewer) {
        this.expressionViewer = expressionViewer;
    }

    protected SourceViewer getExpressionViewer() {
        return this.expressionViewer;
    }

    private static Image getIconImage(String id) {
        return ReportPlatformUIImages.getImage(id);
    }

    private void createObjects(TreeItem topItem, String objectType) {
        TreeItem subItem;
        for (IClassInfo classInfo : DEUtil.getClasses()) {
            if (classInfo.isNative() && OBJECTS_TYPE_BIRT.equals(objectType) || !classInfo.isNative() && OBJECTS_TYPE_NATIVE.equals(objectType) || classInfo.getName().equals("Total")) continue;
            subItem = this.createSubFolderItem(topItem, classInfo);
            Image globalImage = null;
            if (this.isGlobal(classInfo.getName())) {
                globalImage = IMAGE_GOLBAL;
            }
            ArrayList<ILocalizableInfo[]> childrenList = new ArrayList<ILocalizableInfo[]>();
            IMemberInfo[] members = DEUtil.getMembers((IClassInfo)classInfo).toArray(new IMemberInfo[0]);
            int i = 0;
            while (i < members.length) {
                childrenList.add(new ILocalizableInfo[]{classInfo, members[i]});
                ++i;
            }
            ArrayList methodList = new ArrayList();
            methodList.addAll(DEUtil.getMethods((IClassInfo)classInfo, (boolean)true));
            methodList.addAll(AggregationUtil.getMethods(classInfo));
            IMethodInfo[] methods = methodList.toArray(new IMethodInfo[0]);
            int i2 = 0;
            while (i2 < methods.length) {
                IMethodInfo mi = methods[i2];
                this.processMethods(classInfo, mi, childrenList);
                ++i2;
            }
            ILocalizableInfo[][] children = (ILocalizableInfo[][])childrenList.toArray((T[])new ILocalizableInfo[0][]);
            this.sortLocalizableInfo(children);
            int i3 = 0;
            while (i3 < children.length) {
                ILocalizableInfo[] obj = children[i3];
                this.createSubTreeItem(subItem, this.getDisplayText(obj), globalImage == null ? this.getImage(obj) : globalImage, this.getInsertText(obj), this.getTooltipText(obj), true);
                ++i3;
            }
        }
        if (OBJECTS_TYPE_BIRT.equals(objectType)) {
            try {
                IScriptFunctionCategory[] categorys = FunctionProvider.getCategories();
                Arrays.sort(categorys, new Comparator<IScriptFunctionCategory>(){

                    @Override
                    public int compare(IScriptFunctionCategory o1, IScriptFunctionCategory o2) {
                        return ExpressionTreeSupport.this.getCategoryDisplayName(o1).compareTo(ExpressionTreeSupport.this.getCategoryDisplayName(o2));
                    }
                });
                if (categorys != null) {
                    int i = 0;
                    while (i < categorys.length) {
                        subItem = this.createSubFolderItem(topItem, categorys[i]);
                        IScriptFunction[] functions = categorys[i].getFunctions();
                        Arrays.sort(functions, new Comparator<IScriptFunction>(){

                            @Override
                            public int compare(IScriptFunction o1, IScriptFunction o2) {
                                return ExpressionTreeSupport.this.getFunctionDisplayText(o1).compareTo(ExpressionTreeSupport.this.getFunctionDisplayText(o2));
                            }
                        });
                        if (functions != null) {
                            int j = 0;
                            while (j < functions.length) {
                                Image image = null;
                                image = functions[j].isStatic() ? IMAGE_STATIC_METHOD : IMAGE_METHOD;
                                this.createSubTreeItem(subItem, this.getFunctionDisplayText(functions[j]), image, this.getFunctionExpression(categorys[i], functions[j]), functions[j].getDescription(), true);
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (BirtException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    public void sortLocalizableInfo(ILocalizableInfo[][] infos) {
        Arrays.sort(infos, new Comparator<ILocalizableInfo[]>(){

            private int computeWeight(ILocalizableInfo obj) {
                if (obj instanceof IMemberInfo) {
                    return ((IMemberInfo)obj).isStatic() ? 0 : 2;
                }
                if (obj instanceof IMethodInfo) {
                    if (((IMethodInfo)obj).isConstructor()) {
                        return 3;
                    }
                    return ((IMethodInfo)obj).isStatic() ? 1 : 4;
                }
                return 4;
            }

            @Override
            public int compare(ILocalizableInfo[] o1, ILocalizableInfo[] o2) {
                int w2;
                ILocalizableInfo info1 = o1[1];
                ILocalizableInfo info2 = o2[1];
                int w1 = this.computeWeight(info1);
                if (w1 != (w2 = this.computeWeight(info2))) {
                    return w1 < w2 ? -1 : 1;
                }
                return Collator.getInstance().compare(ExpressionTreeSupport.this.getDisplayText(o1), ExpressionTreeSupport.this.getDisplayText(o2));
            }
        });
    }

    public Image getImage(Object element) {
        if (element instanceof ILocalizableInfo[]) {
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            if (info instanceof IMethodInfo) {
                if (((IMethodInfo)info).isStatic()) {
                    return IMAGE_STATIC_METHOD;
                }
                if (((IMethodInfo)info).isConstructor()) {
                    return IMAGE_CONSTRUCTOR;
                }
                return IMAGE_METHOD;
            }
            if (info instanceof IMemberInfo) {
                if (((IMemberInfo)info).isStatic()) {
                    return IMAGE_STATIC_MEMBER;
                }
                return IMAGE_MEMBER;
            }
        }
        return null;
    }

    public String getInsertText(Object element) {
        if (element instanceof VariableElementHandle) {
            return ((VariableElementHandle)element).getVariableName();
        }
        if (element instanceof ILocalizableInfo[]) {
            IClassInfo classInfo = (IClassInfo)((ILocalizableInfo[])element)[0];
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            StringBuffer insertText = new StringBuffer();
            if (info instanceof IMemberInfo) {
                IMemberInfo memberInfo = (IMemberInfo)info;
                if (memberInfo.isStatic()) {
                    insertText.append(String.valueOf(classInfo.getName()) + ".");
                }
                insertText.append(memberInfo.getName());
            } else if (info instanceof IMethodInfo) {
                IMethodInfo methodInfo = (IMethodInfo)info;
                if (methodInfo.isStatic()) {
                    insertText.append(String.valueOf(classInfo.getName()) + ".");
                } else if (methodInfo.isConstructor()) {
                    insertText.append("new ");
                }
                insertText.append(methodInfo.getName());
                insertText.append("()");
            }
            return insertText.toString();
        }
        return null;
    }

    public String getTooltipText(Object element) {
        if (element instanceof ILocalizableInfo[]) {
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            String tooltip = null;
            if (info instanceof IMemberInfo) {
                tooltip = ((IMemberInfo)info).getToolTip();
            } else if (info instanceof IMethodInfo) {
                tooltip = ((IMethodInfo)info).getToolTip();
            }
            return tooltip == null ? "" : tooltip;
        }
        return null;
    }

    protected String getDisplayText(Object element) {
        if (element instanceof ILocalizableInfo[]) {
            String dataType;
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            StringBuffer displayText = new StringBuffer(info.getName());
            if (info instanceof IMethodInfo) {
                IMethodInfo method = (IMethodInfo)info;
                displayText.append("(");
                int argIndex = ((ILocalizableInfo[])element).length > 2 ? ((IIndexInfo)((ILocalizableInfo[])element)[2]).getIndex() : 0;
                int idx = -1;
                Iterator argumentListIter = method.argumentListIterator();
                while (argumentListIter.hasNext()) {
                    IArgumentInfoList arguments = (IArgumentInfoList)argumentListIter.next();
                    if (++idx < argIndex) continue;
                    boolean isFirst = true;
                    Iterator iter = arguments.argumentsIterator();
                    while (iter.hasNext()) {
                        IArgumentInfo argInfo = (IArgumentInfo)iter.next();
                        if (!isFirst) {
                            displayText.append(", ");
                        }
                        isFirst = false;
                        if (argInfo.getType() != null && argInfo.getType().length() > 0) {
                            displayText.append(String.valueOf(argInfo.getType()) + " " + argInfo.getName());
                            continue;
                        }
                        displayText.append(argInfo.getName());
                    }
                    break block0;
                }
                displayText.append(")");
                if (!method.isConstructor()) {
                    displayText.append(" : ");
                    String returnType = method.getReturnType();
                    if (returnType == null || returnType.length() == 0) {
                        returnType = "void";
                    }
                    displayText.append(returnType);
                }
            } else if (info instanceof IMemberInfo && (dataType = ((IMemberInfo)info).getDataType()) != null && dataType.length() > 0) {
                displayText.append(" : ");
                displayText.append(dataType);
            }
            return displayText.toString();
        }
        return null;
    }

    private boolean isGlobal(String name) {
        return name != null && name.startsWith("Global");
    }

    private String getFunctionDisplayText(IScriptFunction function) {
        String functionStart = function.isConstructor() ? "new " : "";
        StringBuffer displayText = new StringBuffer(functionStart);
        displayText.append(function.getName());
        IScriptFunctionArgument[] arguments = function.getArguments();
        displayText.append("(");
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                displayText.append(arguments[i].getName());
                if (i < arguments.length - 1) {
                    displayText.append(", ");
                }
                ++i;
            }
        }
        displayText.append(")");
        return displayText.toString();
    }

    private String getFunctionExpression(IScriptFunctionCategory category, IScriptFunction function) {
        String functionStart = function.isConstructor() ? "new " : "";
        StringBuffer textData = new StringBuffer(functionStart);
        if (function.isStatic() && category.getName() != null) {
            textData.append(String.valueOf(category.getName()) + ".");
        }
        textData.append(String.valueOf(function.getName()) + "()");
        return textData.toString();
    }

    protected void createContextCatagory() {
        assert (this.tree != null);
        this.contextItem = this.createTopTreeItem(this.tree, TREE_ITEM_CONTEXT);
        this.createContextObjects(this.currentMethodName);
    }

    protected void createContextObjects(String methodName) {
        if (this.contextItem != null && !this.contextItem.isDisposed() && this.currentEditObject != null && methodName != null) {
            this.clearTreeItem(this.contextItem);
            DesignElementHandle handle = (DesignElementHandle)this.currentEditObject;
            List args = DEUtil.getDesignElementMethodArgumentsInfo((DesignElementHandle)handle, (String)methodName);
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                String argName = ((IArgumentInfo)iter.next()).getName();
                this.createSubTreeItem(this.contextItem, argName, IMAGE_METHOD, argName, "", true);
            }
        }
    }

    public void setCurrentEditObject(Object obj) {
        this.currentEditObject = obj;
        this.clearTreeItem(this.contextItem);
        this.clearDynamicItems();
    }

    private void clearTreeItem(TreeItem treeItem) {
        if (treeItem == null || treeItem.isDisposed()) {
            return;
        }
        TreeItem[] items = treeItem.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && !items[i].isDisposed()) {
                items[i].dispose();
            }
            ++i;
        }
    }

    private void clearDynamicItems() {
        if (this.dynamicItems != null) {
            for (TreeItem ti : this.dynamicItems) {
                if (ti == null || ti.isDisposed()) continue;
                ti.dispose();
            }
            this.dynamicItems.clear();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] sel;
        ISelection selection = event.getSelection();
        if (selection != null && (sel = ((IStructuredSelection)selection).toArray()).length == 1 && sel[0] instanceof IPropertyDefn) {
            IPropertyDefn elePropDefn = (IPropertyDefn)sel[0];
            this.currentMethodName = elePropDefn.getName();
            this.currentContextName = elePropDefn.getContext();
            this.switchContext();
        }
    }

    protected void switchContext() {
        if (this.tree == null || this.tree.isDisposed()) {
            return;
        }
        this.createContextObjects(this.currentMethodName);
        this.updateClientContext();
        this.updateDynamicItems();
    }

    private void updateClientContext() {
        if (CLIENT_CONTEXT.equals(this.currentContextName)) {
            if (this.parametersItem != null && !this.parametersItem.isDisposed()) {
                this.parametersItem.dispose();
                this.parametersItem = null;
            }
            if (this.birtObjectsItem != null && !this.birtObjectsItem.isDisposed()) {
                this.birtObjectsItem.dispose();
                this.birtObjectsItem = null;
            }
        } else {
            int idx;
            if (this.parametersItem == null || this.parametersItem.isDisposed()) {
                idx = this.tree.indexOf(this.contextItem);
                this.parametersItem = idx == -1 ? this.createTopTreeItem(this.tree, TREE_ITEM_PARAMETERS) : this.createTopTreeItem(this.tree, TREE_ITEM_PARAMETERS, idx + 1);
                this.buildParameterTree();
            }
            if (this.birtObjectsItem == null || this.birtObjectsItem.isDisposed()) {
                idx = this.tree.indexOf(this.nativeObejctsItem);
                this.birtObjectsItem = idx == -1 ? this.createTopTreeItem(this.tree, TREE_ITEM_BIRT_OBJECTS) : this.createTopTreeItem(this.tree, TREE_ITEM_BIRT_OBJECTS, idx + 1);
                this.createObjects(this.birtObjectsItem, OBJECTS_TYPE_BIRT);
            }
        }
    }

    private void updateDynamicItems() {
        this.clearDynamicItems();
        Object[] adapters = ElementAdapterManager.getAdapters(this.currentEditObject, IContextExpressionProvider.class);
        if (adapters == null) {
            return;
        }
        Object[] objectArray = adapters;
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            IExpressionProvider exprProvider;
            Object adapt = objectArray[n2];
            IContextExpressionProvider contextProvider = (IContextExpressionProvider)adapt;
            if (contextProvider != null && (exprProvider = contextProvider.getExpressionProvider(this.currentMethodName)) != null) {
                this.createDynamicCategory(exprProvider);
            }
            ++n2;
        }
    }

    private void createDynamicCategory(IExpressionProvider provider) {
        Object[] cats = provider.getCategory();
        if (cats != null) {
            Object[] objectArray = cats;
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                Object cat = objectArray[n2];
                TreeItem ti = this.createTopTreeItem(this.tree, cat, provider);
                if (this.dynamicItems == null) {
                    this.dynamicItems = new ArrayList<TreeItem>();
                }
                this.dynamicItems.add(ti);
                if (provider.hasChildren(cat)) {
                    this.createDynamicChildern(ti, cat, provider);
                }
                ++n2;
            }
        }
    }

    private void createDynamicChildern(TreeItem parent, Object element, IExpressionProvider provider) {
        Object[] children = provider.getChildren(element);
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (provider.hasChildren(child)) {
                    TreeItem ti = this.createSubFolderItem(parent, child, provider);
                    this.createDynamicChildern(ti, child, provider);
                } else {
                    this.createSubTreeItem(parent, child, provider);
                }
                ++n2;
            }
        }
    }

    private TreeItem createTopTreeItem(Tree tree, Object element, IExpressionProvider provider) {
        TreeItem item = new TreeItem(tree, 0);
        item.setText(provider.getDisplayText(element));
        item.setImage(provider.getImage(element));
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)provider.getTooltipText(element));
        return item;
    }

    private TreeItem createSubFolderItem(TreeItem parent, Object element, IExpressionProvider provider) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(provider.getDisplayText(element));
        item.setImage(provider.getImage(element));
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)provider.getTooltipText(element));
        return item;
    }

    private TreeItem createSubTreeItem(TreeItem parent, Object element, IExpressionProvider provider) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(provider.getDisplayText(element));
        item.setImage(provider.getImage(element));
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)provider.getTooltipText(element));
        item.setData(ITEM_DATA_KEY_TEXT, (Object)provider.getInsertText(element));
        item.setData(ITEM_DATA_KEY_ENABLED, (Object)Boolean.TRUE);
        return item;
    }

    public void updateParametersTree() {
        if (this.parametersItem != null && !this.parametersItem.isDisposed()) {
            this.clearTreeItem(this.parametersItem);
            this.buildParameterTree();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processMethods(IClassInfo classInfo, IMethodInfo mi, List childrenList) {
        block1: {
            alitr = mi.argumentListIterator();
            idx = 0;
            if (alitr != null) ** GOTO lbl11
            childrenList.add(new ILocalizableInfo[]{classInfo, mi});
            break block1;
lbl-1000:
            // 1 sources

            {
                alitr.next();
                childrenList.add(new ILocalizableInfo[]{classInfo, mi, new IIndexInfo(idx++)});
lbl11:
                // 2 sources

                ** while (alitr.hasNext())
            }
        }
    }
}

