/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.Comparator;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ColorFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ComboBoxFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ComboBoxMeasureFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DecorationFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.EditableComboFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PreviewLabel;
import org.eclipse.birt.report.designer.internal.ui.dialogs.SeparatorFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.CSSUtil;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class FontPreferencePage
extends BaseStylePreferencePage {
    private Object model;
    private ColorFieldEditor color;
    private EditableComboFieldEditor name;
    private ComboBoxFieldEditor style;
    private ComboBoxFieldEditor weight;
    private ComboBoxMeasureFieldEditor size;
    private DecorationFieldEditor docoration;
    private PreviewLabel sample;

    public FontPreferencePage(Object model) {
        super(model);
        this.setTitle(Messages.getString((String)"FontPreferencePage.displayname.Title"));
        this.model = model;
    }

    protected void adjustGridLayout() {
        super.adjustGridLayout();
        ((GridData)this.name.getComboBoxControl((Composite)this.getFieldEditorParent()).getLayoutData()).widthHint = 166;
        ((GridData)this.color.getColorSelector().getLayoutData()).widthHint = 96;
        ((GridData)this.size.getComboBoxControl((Composite)this.getFieldEditorParent()).getLayoutData()).widthHint = 108;
        ((GridData)this.size.getMeasureControl((Composite)this.getFieldEditorParent()).getLayoutData()).widthHint = 50;
        ((GridData)this.style.getComboBoxControl((Composite)this.getFieldEditorParent()).getLayoutData()).widthHint = 170;
        ((GridData)this.weight.getComboBoxControl((Composite)this.getFieldEditorParent()).getLayoutData()).widthHint = 170;
    }

    public Object getModel() {
        return this.model;
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        this.name = new EditableComboFieldEditor("fontFamily", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("fontFamily").getDefn().getDisplayNameID()), this.getFontChoiceArray(), this.getFieldEditorParent()){

            protected void setPropValue(String newValue) {
                super.setPropValue(newValue);
            }

            protected void updateComboForValue(String value) {
                super.updateComboForValue(DEUtil.RemoveQuote((String)value));
            }
        };
        this.color = new ColorFieldEditor("color", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("color").getDefn().getDisplayNameID()), this.getFieldEditorParent());
        this.size = new ComboBoxMeasureFieldEditor("fontSize", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("fontSize").getDefn().getDisplayNameID()), this.getChoiceArray("fontSize"), this.getChoiceArray("units"), this.getFieldEditorParent());
        this.size.setDefaultUnit(((StyleHandle)this.model).getPropertyHandle("fontSize").getDefaultUnit());
        this.style = new ComboBoxFieldEditor("fontStyle", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("fontStyle").getDefn().getDisplayNameID()), this.getChoiceArray("fontStyle"), this.getFieldEditorParent());
        this.weight = new ComboBoxFieldEditor("fontWeight", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("fontWeight").getDefn().getDisplayNameID()), this.getChoiceArray("fontWeight"), this.getFieldEditorParent());
        this.docoration = new DecorationFieldEditor("textUnderline", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("textUnderline").getDefn().getDisplayNameID()), "textOverline", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("textOverline").getDefn().getDisplayNameID()), "textLineThrough", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("textLineThrough").getDefn().getDisplayNameID()), Messages.getString((String)"FontPreferencePage.label.fontDecoration"), this.getFieldEditorParent());
        this.addField(this.name);
        this.addField(this.color);
        this.addField(this.size);
        this.addField(this.style);
        this.addField(this.weight);
        this.addField(this.docoration);
        this.addField(new SeparatorFieldEditor(this.getFieldEditorParent(), false));
        Group group = new Group(this.getFieldEditorParent(), 8);
        group.setText(Messages.getString((String)"FontPreferencePage.text.Preview"));
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        gd.heightHint = 100;
        gd.horizontalSpan = 4;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout());
        this.sample = new PreviewLabel((Composite)group, 0);
        this.sample.setText(Messages.getString((String)"FontPreferencePage.text.PreviewContent"));
        this.sample.setLayoutData(new GridData(1808));
        UIUtil.bindHelp((Control)this.getFieldEditorParent().getParent(), "org.eclipse.birt.cshelp.StyleBuilderFont_ID");
    }

    protected Control createContents(Composite parent) {
        Control ct = super.createContents(parent);
        this.updatePreview();
        return ct;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updatePreview();
    }

    private void updatePreview() {
        if (this.sample != null) {
            String familyValue;
            String fontFamily = this.name.getValueForName(this.name.getComboBoxControl(null).getText());
            if (fontFamily == null) {
                fontFamily = "Times New Roman";
            }
            if ((familyValue = (String)DesignerConstants.familyMap.get(fontFamily)) == null) {
                familyValue = fontFamily;
            }
            String fontSize = "medium";
            int sizeValue = Integer.valueOf((String)DesignerConstants.fontMap.get(fontSize));
            if (this.size.InComboNamesList(this.size.getComboBoxControl(this.getFieldEditorParent()).getText())) {
                fontSize = this.size.getBoxValueForName(this.size.getComboBoxControl(this.getFieldEditorParent()).getText());
                if ("larger".equals(fontSize)) {
                    fontSize = "large";
                } else if ("smaller".equals(fontSize)) {
                    fontSize = "small";
                }
                sizeValue = Integer.valueOf((String)DesignerConstants.fontMap.get(fontSize));
            } else {
                String text = this.size.getComboBoxControl(this.getFieldEditorParent()).getText();
                String pre = this.size.getMeasureValueForName(this.size.getMeasureControl(this.getFieldEditorParent()).getText());
                if (DEUtil.isValidNumber((String)text)) {
                    sizeValue = (int)CSSUtil.convertToPoint((Object)new DimensionValue(Double.parseDouble(text), pre));
                }
            }
            boolean italic = false;
            String fontStyle = this.style.getValueForName(this.style.getComboBoxControl(this.getFieldEditorParent()).getText());
            if ("italic".equals(fontStyle)) {
                italic = true;
            }
            String fontWeight = this.weight.getValueForName(this.weight.getComboBoxControl(null).getText());
            boolean bold = false;
            int fw = 400;
            if (!"normal".equals(fontWeight)) {
                if ("bold".equals(fontWeight)) {
                    bold = true;
                    fw = 700;
                } else if ("bolder".equals(fontWeight)) {
                    bold = true;
                    fw = 1000;
                } else if ("lighter".equals(fontWeight)) {
                    fw = 100;
                } else {
                    try {
                        fw = Integer.parseInt(fontWeight);
                    }
                    catch (NumberFormatException numberFormatException) {
                        fw = 400;
                    }
                    if (fw > 700) {
                        bold = true;
                    }
                }
            }
            this.sample.setFontFamily(familyValue);
            this.sample.setFontSize(sizeValue);
            this.sample.setBold(bold);
            this.sample.setItalic(italic);
            this.sample.setFontWeight(fw);
            this.sample.setForeground(ColorManager.getColor((RGB)this.color.getColorSelector().getRGB()));
            this.sample.setUnderline(this.docoration.getUnderLinePropControl(null).getSelection());
            this.sample.setLinethrough(this.docoration.getLineThroughPropControl(null).getSelection());
            this.sample.setOverline(this.docoration.getOverLinePropControl(null).getSelection());
            this.sample.updateView();
        }
    }

    private String[][] getFontChoiceArray() {
        String[][] fca = this.getChoiceArray("fontFamily", (Comparator)new AlphabeticallyComparator());
        String[] sf = DEUtil.getSystemFontNames();
        String[][] rt = new String[fca.length + sf.length][2];
        int i = 0;
        while (i < rt.length) {
            if (i < fca.length) {
                rt[i][0] = fca[i][0];
                rt[i][1] = fca[i][1];
            } else {
                rt[i][0] = sf[i - fca.length];
                rt[i][1] = sf[i - fca.length];
            }
            ++i;
        }
        return rt;
    }

    private String[][] getChoiceArray(String key) {
        return this.getChoiceArray(key, null);
    }

    private String[][] getChoiceArray(String key, Comparator comparator) {
        IChoice[] choices = DEUtil.getMetaDataDictionary().getChoiceSet(key).getChoices(comparator);
        String[][] names = null;
        if (choices.length > 0) {
            names = new String[choices.length][2];
            int i = 0;
            while (i < choices.length) {
                names[i][0] = choices[i].getDisplayName();
                names[i][1] = choices[i].getName();
                ++i;
            }
        }
        return names;
    }
}

