/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSetParameterBindingInputDialog;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.IBaseTableAreaModifier;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TableArea;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ParameterBindingPage
extends Composite
implements Listener {
    private Label dataSetName;
    private Table table;
    private TableViewer tableViewer;
    private static final String[] columnNames = new String[]{Messages.getString((String)"BindingPage.TableColumn.Parameter"), Messages.getString((String)"BindingPage.TableColumn.DataType"), Messages.getString((String)"BindingPage.TableColumn.Value")};
    private static final String NONE = Messages.getString((String)"BindingPage.None");
    private transient boolean enableAutoCommit = true;
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("DataSetParam").getMember("dataType").getAllowedChoices();
    private static final String DEFAULT_VALUE_LABEL = Messages.getString((String)"label.defaultValue");
    private static final String DATA_SET_LABEL = Messages.getString((String)"Element.ReportItem.dataSet");
    protected List input = new ArrayList();

    public ParameterBindingPage(Composite parent, int style) {
        super(parent, style);
        this.buildUI();
    }

    protected void buildUI() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.setLayout((Layout)layout);
        Label title = new Label((Composite)this, 0);
        title.setText(DATA_SET_LABEL);
        this.dataSetName = new Label((Composite)this, 0);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)title, 0, 131072);
        data.top = new FormAttachment((Control)title, 0, 0x1000000);
        data.right = new FormAttachment(50);
        this.dataSetName.setLayoutData((Object)data);
        TableArea tableArea = new TableArea(this, 68356, new IBaseTableAreaModifier(){

            public boolean editItem(Object element) {
                return ParameterBindingPage.this.doEdit(element);
            }
        });
        this.table = tableArea.getTable();
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(columnNames[i]);
            column.setWidth(200);
            ++i;
        }
        data = new FormData();
        data.top = new FormAttachment((Control)title, 0, 1024);
        data.left = new FormAttachment((Control)title, 0, 16384);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        tableArea.setLayoutData(data);
        this.tableViewer = tableArea.getTableViewer();
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columnNames);
        this.tableViewer.setContentProvider((IContentProvider)new BindingContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BindingLabelProvider());
    }

    protected void refreshValues() {
        if (this.input.size() != 1 || this.isDisposed()) {
            return;
        }
        this.dataSetName.setText(((ReportItemHandle)this.input.get(0)).getDataSet().getName());
        this.tableViewer.refresh();
    }

    private ReportItemHandle getReportItemHandle() {
        return (ReportItemHandle)this.input.get(0);
    }

    private String getDataSetName() {
        if (this.getReportItemHandle().getDataSet() == null) {
            return NONE;
        }
        String dataSetName = this.getReportItemHandle().getDataSet().getQualifiedName();
        if (StringUtil.isBlank((String)dataSetName)) {
            dataSetName = NONE;
        }
        return dataSetName;
    }

    private ParamBindingHandle createBindingHandle(String name) throws SemanticException {
        PropertyHandle propertyHandle = this.getPropertyHandle();
        ParamBinding binding = StructureFactory.createParamBinding();
        binding.setParamName(name);
        propertyHandle.addItem((IStructure)binding);
        return (ParamBindingHandle)binding.getHandle((SimpleValueHandle)propertyHandle);
    }

    private PropertyHandle getPropertyHandle() {
        ReportItemHandle handle = (ReportItemHandle)this.input.get(0);
        return handle.getPropertyHandle("paramBindings");
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        ContentEvent ce;
        PropertyEvent event;
        String propertyName;
        if (ev.getEventType() == 5 && ("paramBindings".equals(propertyName = (event = (PropertyEvent)ev).getPropertyName()) || "dataSet".equals(propertyName))) {
            this.refreshValues();
        }
        if (ev.getEventType() == 0 && ev instanceof ContentEvent && (ce = (ContentEvent)ev).getContent() instanceof DataSet) {
            this.refreshValues();
        }
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private void startTrans(String name) {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().startTrans(name);
        }
    }

    private void commit() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().commit();
        }
    }

    private void rollback() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().rollback();
        }
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    private boolean canChangeDataSet(String newName) {
        String currentDataSetName = this.getDataSetName();
        if (NONE.equals(currentDataSetName)) {
            return true;
        }
        if (!currentDataSetName.equals(newName)) {
            return MessageDialog.openQuestion(null, (String)Messages.getString((String)"dataBinding.title.changeDataSet"), (String)Messages.getString((String)"dataBinding.message.changeDataSet"));
        }
        return false;
    }

    private void enableUI(boolean enabled) {
        if (this.tableViewer != null) {
            this.table.setEnabled(enabled);
        }
    }

    public void setInput(List elements) {
        this.deRegisterListeners();
        if (elements.size() != 1) {
            this.enableUI(false);
            return;
        }
        this.enableUI(true);
        this.deRegisterListeners();
        this.input = elements;
        this.refreshValues();
        this.registerListeners();
        this.tableViewer.setInput(elements.get(0));
    }

    protected void registerListeners() {
        if (this.input == null) {
            return;
        }
        int i = 0;
        while (i < this.input.size()) {
            Object obj = this.input.get(i);
            if (obj instanceof DesignElementHandle) {
                DesignElementHandle element = (DesignElementHandle)obj;
                element.addListener((Listener)this);
            }
            ++i;
        }
        SessionHandleAdapter.getInstance().getReportDesignHandle().addListener((Listener)this);
    }

    protected void deRegisterListeners() {
        if (this.input == null) {
            return;
        }
        int i = 0;
        while (i < this.input.size()) {
            Object obj = this.input.get(i);
            if (obj instanceof DesignElementHandle) {
                DesignElementHandle element = (DesignElementHandle)obj;
                element.removeListener((Listener)this);
            }
            ++i;
        }
        ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (module != null) {
            module.removeListener((Listener)this);
        }
    }

    private boolean doEdit(Object element) {
        ParamBindingHandle bindingParameter = (ParamBindingHandle)((Object[])element)[1];
        String value = null;
        if (bindingParameter != null) {
            value = bindingParameter.getExpression();
        }
        DataSetParameterBindingInputDialog dialog = new DataSetParameterBindingInputDialog((DataSetParameterHandle)((Object[])element)[0], new ExpressionProvider(this.getReportItemHandle().getContainer()));
        dialog.setValue(value);
        if (dialog.open() == 0) {
            value = (String)dialog.getResult();
            if (value.length() == 0) {
                if (bindingParameter != null) {
                    this.startTrans(Messages.getString((String)"BindingPage.MessageDlg.SaveParamBinding"));
                    try {
                        this.getPropertyHandle().removeItem((Object)bindingParameter.getStructure());
                        this.commit();
                        return true;
                    }
                    catch (PropertyValueException e) {
                        ExceptionHandler.handle(e);
                        this.rollback();
                    }
                }
            } else {
                this.startTrans(Messages.getString((String)"BindingPage.MessageDlg.SaveParamBinding"));
                if (bindingParameter == null) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)((Object[])element)[0];
                    try {
                        bindingParameter = this.createBindingHandle(parameter.getName());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                        this.rollback();
                        return false;
                    }
                }
                bindingParameter.setExpression(value);
                this.commit();
                return true;
            }
        }
        return false;
    }

    private class BindingContentProvider
    implements IStructuredContentProvider {
        private BindingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ParamBindingHandle handle;
            if (inputElement == null) {
                return new Object[0];
            }
            ReportItemHandle inputHandle = (ReportItemHandle)inputElement;
            DataSetHandle dataHandle = inputHandle.getDataSet();
            if (dataHandle == null) {
                return new Object[0];
            }
            ArrayList<ParamBindingHandle> bindingParametersList = new ArrayList<ParamBindingHandle>();
            ArrayList<String> bindingParametersNameList = new ArrayList<String>();
            ArrayList<Object[]> resultList = new ArrayList<Object[]>();
            Iterator iterator = inputHandle.paramBindingsIterator();
            while (iterator.hasNext()) {
                handle = (ParamBindingHandle)iterator.next();
                bindingParametersList.add(handle);
                bindingParametersNameList.add(handle.getParamName());
            }
            iterator = dataHandle.parametersIterator();
            while (iterator.hasNext()) {
                handle = (DataSetParameterHandle)iterator.next();
                if (!handle.isInput()) continue;
                Object[] objectArray = new Object[2];
                objectArray[0] = handle;
                Object[] result = objectArray;
                int index = bindingParametersNameList.indexOf(handle.getName());
                if (index != -1) {
                    result[1] = bindingParametersList.get(index);
                }
                resultList.add(result);
            }
            return resultList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class BindingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BindingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            DataSetParameterHandle parameter = (DataSetParameterHandle)((Object[])element)[0];
            ParamBindingHandle bindingParameter = (ParamBindingHandle)((Object[])element)[1];
            switch (columnIndex) {
                case 0: {
                    if (parameter.getName() == null) break;
                    text = parameter.getName();
                    break;
                }
                case 1: {
                    if (parameter.getParameterDataType() == null) break;
                    text = ChoiceSetFactory.getDisplayNameFromChoiceSet(parameter.getParameterDataType(), DATA_TYPE_CHOICE_SET);
                    break;
                }
                case 2: {
                    if (bindingParameter != null && bindingParameter.getExpression() != null) {
                        text = bindingParameter.getExpression();
                        break;
                    }
                    if (parameter.getDefaultValue() == null) break;
                    text = String.valueOf(parameter.getDefaultValue()) + " " + DEFAULT_VALUE_LABEL;
                }
            }
            return text;
        }
    }
}

