/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ReportPrintGraphicalViewerOperation {
    private Drawable drawable;
    private Device device;
    private Rectangle region;
    private GraphicalViewer viewer;
    private List selectedEditParts;
    private IFigure printSource;
    private Color oldBGColor;
    private GC printerGC;
    private SWTGraphics g;
    private CompositePrinterGraphics printerGraphics;

    public ReportPrintGraphicalViewerOperation(GraphicalViewer g, Drawable drawable, Device device, Rectangle region) {
        IFigure f;
        this.device = device;
        this.region = region;
        this.drawable = drawable;
        this.viewer = g;
        LayerManager lm = (LayerManager)this.viewer.getEditPartRegistry().get(LayerManager.ID);
        this.printSource = f = lm.getLayer((Object)"Printable Layers");
    }

    protected IFigure getPrintSource() {
        return this.printSource;
    }

    protected Drawable getDrawable() {
        return this.drawable;
    }

    public void run(String jobName) {
        this.preparePrintSource();
        this.printerGC = new GC(this.getDrawable(), 0x2000000);
        this.printPages();
        this.restorePrintSource();
        this.cleanup();
    }

    protected void cleanup() {
        if (this.g != null) {
            this.printerGraphics.dispose();
            this.g.dispose();
        }
        if (this.printerGC != null) {
            this.printerGC.dispose();
        }
    }

    protected void preparePrintSource() {
        this.oldBGColor = this.getPrintSource().getLocalBackgroundColor();
        this.getPrintSource().setBackgroundColor(ReportColorConstants.ReportBackground);
        this.selectedEditParts = new ArrayList(this.viewer.getSelectedEditParts());
        this.viewer.deselectAll();
    }

    protected void restorePrintSource() {
        this.getPrintSource().setBackgroundColor(this.oldBGColor);
        this.oldBGColor = null;
        this.viewer.setSelection((ISelection)new StructuredSelection(this.selectedEditParts));
    }

    /*
     * Unable to fully structure code
     */
    protected void printPages() {
        graphics = this.getFreshGraphics();
        figure = this.getPrintSource();
        this.setupPrinterGraphicsFor(graphics, figure);
        bounds = figure.getBounds();
        x = bounds.x;
        y = bounds.y;
        clipRect = new Rectangle();
        ** GOTO lbl24
        {
            graphics.pushState();
            graphics.translate(-x, -y);
            graphics.getClip(clipRect);
            clipRect.setLocation(x, y);
            graphics.clipRect(clipRect);
            figure.paint(graphics);
            graphics.popState();
            if ((x += clipRect.width) == 0) {
                return;
            }
            do {
                if (x < bounds.x + bounds.width) continue block0;
                x = bounds.x;
                y += clipRect.height;
lbl24:
                // 2 sources

            } while (y < bounds.y + bounds.height);
        }
    }

    protected Graphics getFreshGraphics() {
        if (this.printerGraphics != null) {
            this.printerGraphics.dispose();
            this.g.dispose();
            this.printerGraphics = null;
            this.g = null;
        }
        this.g = new SWTGraphics(this.printerGC);
        this.printerGraphics = new CompositePrinterGraphics(this.g, this.device);
        this.setupGraphicsForPage(this.printerGraphics);
        return this.printerGraphics;
    }

    protected void setupPrinterGraphicsFor(Graphics graphics, IFigure figure) {
        Rectangle printRegion = this.getPrintRegion();
        Rectangle bounds = figure.getBounds();
        double xScale = (double)printRegion.width / (double)bounds.width;
        double yScale = (double)printRegion.height / (double)bounds.height;
        graphics.scale(Math.min(xScale, yScale));
        graphics.setForegroundColor(figure.getForegroundColor());
        graphics.setBackgroundColor(figure.getBackgroundColor());
        graphics.setFont(figure.getFont());
    }

    protected void setupGraphicsForPage(CompositePrinterGraphics pg) {
        Rectangle printRegion = this.getPrintRegion();
        pg.setClip(printRegion);
        pg.translate(printRegion.getTopLeft());
    }

    protected Rectangle getPrintRegion() {
        return this.region;
    }

    public static class CompositePrinterGraphics
    extends ScaledGraphics {
        Map imageCache = new HashMap();
        Device printer;

        public CompositePrinterGraphics(SWTGraphics g, Device p) {
            super((Graphics)g);
            this.printer = p;
        }

        public void dispose() {
            Iterator itr = this.imageCache.values().iterator();
            while (itr.hasNext()) {
                ((Image)itr.next()).dispose();
            }
            super.dispose();
        }

        private Image printerImage(Image image) {
            Image result = (Image)this.imageCache.get(image);
            if (result != null) {
                return result;
            }
            result = new Image(this.printer, image.getImageData());
            this.imageCache.put(image, result);
            return result;
        }

        public void drawImage(Image srcImage, int x, int y) {
            super.drawImage(this.printerImage(srcImage), x, y);
        }

        public void drawImage(Image srcImage, int sx, int sy, int sw, int sh, int tx, int ty, int tw, int th) {
            super.drawImage(this.printerImage(srcImage), sx, sy, sw, sh, tx, ty, tw, th);
        }
    }
}

