/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.TabPage;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class TabDialog
extends BaseDialog {
    private ArrayList tabList = new ArrayList();
    private Object input;

    public TabDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public void addTabPage(TabPage tabPage) {
        tabPage.setContainer(this);
        this.tabList.add(tabPage);
    }

    public void addTabPages() {
    }

    public void setInput(Object input) {
        assert (input != null);
        this.input = input;
    }

    protected boolean initDialog() {
        for (TabPage page : this.tabList) {
            page.setInput(this.input);
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        TabFolder tabFolder = new TabFolder(composite, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.addTabPages();
        for (TabPage page : this.tabList) {
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setControl((Control)page.createControl((Composite)tabFolder));
            tabItem.setText(page.getName());
        }
        return composite;
    }

    protected void okPressed() {
        try {
            this.saveAll();
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return;
        }
        super.okPressed();
    }

    public void updateButtons() {
        for (TabPage page : this.tabList) {
            if (page.isPageComplete()) continue;
            this.getOkButton().setEnabled(false);
            return;
        }
        this.getOkButton().setEnabled(true);
    }

    protected void saveAll() throws SemanticException {
        this.setResult(this.input);
        for (TabPage page : this.tabList) {
            page.saveTo(this.getResult());
        }
    }
}

