/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.rulers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuideEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRuler;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerContextMenuProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerEditPartFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerRootEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.RulerDefaultRangeModel;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.DefaultRangeModel;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class EditorRulerComposite
extends Composite {
    private static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    private static final int LEFT_TOP = 2;
    private static final int LEFT_BOTTOM = 3;
    private EditDomain rulerEditDomain;
    private GraphicalViewer left;
    private GraphicalViewer top;
    private FigureCanvas editor;
    private GraphicalViewer diagramViewer;
    private Font font;
    private Listener layoutListener;
    private PropertyChangeListener propertyListener;
    private boolean layingOut = false;
    private boolean isRulerVisible = true;
    private boolean needToLayout = false;
    private ModuleHandle handle;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoomValue) {
            EditorRulerComposite.this.layout(true);
        }
    };
    private Runnable runnable = new Runnable(){

        public void run() {
            EditorRulerComposite.this.layout(false);
        }
    };
    private org.eclipse.birt.report.model.api.core.Listener designListener = new org.eclipse.birt.report.model.api.core.Listener(){

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            switch (ev.getEventType()) {
                case 5: {
                    PropertyEvent event = (PropertyEvent)ev;
                    if ("units".equals(event.getPropertyName())) {
                        EditorRulerComposite.this.setUnit(EditorRulerComposite.this.getUnitFromDesign(EditorRulerComposite.this.getReportDesignHandle().getDefaultUnits()));
                        break;
                    }
                    if ("leftMargin".equals(event.getPropertyName())) {
                        EditorRulerComposite.this.setMargin(0);
                        break;
                    }
                    if ("rightMargin".equals(event.getPropertyName())) {
                        EditorRulerComposite.this.setMargin(1);
                        break;
                    }
                    if ("topMargin".equals(event.getPropertyName())) {
                        EditorRulerComposite.this.setMargin(2);
                        break;
                    }
                    if ("bottomMargin".equals(event.getPropertyName())) {
                        EditorRulerComposite.this.setMargin(3);
                        break;
                    }
                    if ("type".equals(event.getPropertyName())) {
                        EditorRulerComposite.this.layout(true);
                        EditorRulerComposite.this.resetAllGuide();
                        break;
                    }
                    if ("width".equals(event.getPropertyName())) {
                        EditorRulerComposite.this.layout(true);
                        EditorRulerComposite.this.setMargin(0);
                        EditorRulerComposite.this.setMargin(1);
                        break;
                    }
                    if (!"height".equals(event.getPropertyName())) break;
                    EditorRulerComposite.this.layout(true);
                    EditorRulerComposite.this.setMargin(2);
                    EditorRulerComposite.this.setMargin(3);
                }
            }
        }
    };

    public EditorRulerComposite(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EditorRulerComposite.this.disposeResources();
            }
        });
    }

    private GraphicalViewer createRulerContainer(int orientation) {
        RulerViewer viewer = new RulerViewer();
        boolean isHorizontal = orientation == 1 || orientation == 4;
        viewer.setRootEditPart(new EditorRulerRootEditPart(isHorizontal));
        viewer.setEditPartFactory(new EditorRulerEditPartFactory(this.diagramViewer));
        viewer.createControl(this);
        ((GraphicalEditPart)viewer.getRootEditPart()).getFigure().setBorder((Border)new RulerBorder(isHorizontal));
        viewer.setProperty(GraphicalViewer.class.toString(), this.diagramViewer);
        FigureCanvas canvas = (FigureCanvas)viewer.getControl();
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        if (this.font == null) {
            FontData[] data = canvas.getFont().getFontData();
            int i = 0;
            while (i < data.length) {
                data[i].setHeight(data[i].getHeight() - 1);
                ++i;
            }
            this.font = new Font((Device)Display.getCurrent(), data);
        }
        canvas.setFont(this.font);
        if (isHorizontal) {
            canvas.getViewport().setHorizontalRangeModel((RangeModel)new RulerDefaultRangeModel(this.editor.getViewport().getHorizontalRangeModel()));
        } else {
            canvas.getViewport().setVerticalRangeModel((RangeModel)new RulerDefaultRangeModel(this.editor.getViewport().getVerticalRangeModel()));
        }
        if (this.rulerEditDomain == null) {
            this.rulerEditDomain = new EditDomain();
            this.rulerEditDomain.setCommandStack(this.diagramViewer.getEditDomain().getCommandStack());
        }
        this.rulerEditDomain.addViewer((EditPartViewer)viewer);
        return viewer;
    }

    private void disposeResources() {
        this.left = null;
        this.top = null;
        this.editor = null;
        if (this.diagramViewer != null) {
            this.diagramViewer.removePropertyChangeListener(this.propertyListener);
            this.diagramViewer.setProperty("horizontal ruler", null);
            this.diagramViewer.setProperty("vertical ruler", null);
        }
        this.getZoomManager().removeZoomListener(this.zoomListener);
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.getReportDesignHandle() != null) {
            this.getReportDesignHandle().removeListener(this.designListener);
        }
        if (this.getMasterPageHandle() != null) {
            this.getMasterPageHandle().removeListener(this.designListener);
        }
        this.rulerEditDomain = null;
    }

    private void disposeRulerViewer(GraphicalViewer viewer) {
        if (viewer == null) {
            return;
        }
        DefaultRangeModel rModel = new DefaultRangeModel();
        Viewport port = ((FigureCanvas)viewer.getControl()).getViewport();
        port.setHorizontalRangeModel((RangeModel)new RulerDefaultRangeModel((RangeModel)rModel));
        port.setVerticalRangeModel((RangeModel)new RulerDefaultRangeModel((RangeModel)rModel));
        this.rulerEditDomain.removeViewer((EditPartViewer)viewer);
        viewer.getControl().dispose();
    }

    private void doLayout() {
        if (this.left == null && this.top == null) {
            org.eclipse.swt.graphics.Rectangle area = this.getClientArea();
            if (!this.editor.getBounds().equals((Object)area)) {
                this.editor.setBounds(area);
            }
            return;
        }
        int leftWidth = this.left == null ? 0 : this.left.getControl().computeSize((int)-1, (int)-1).x;
        int rightWidth = 0;
        int topHeight = this.top == null ? 0 : this.top.getControl().computeSize((int)-1, (int)-1).y;
        int bottomHeight = 0;
        org.eclipse.swt.graphics.Point size = this.getSize();
        org.eclipse.swt.graphics.Point editorSize = new org.eclipse.swt.graphics.Point(size.x - (leftWidth + rightWidth), size.y - (topHeight + bottomHeight));
        if (!this.editor.getSize().equals((Object)editorSize)) {
            this.editor.setSize(editorSize);
        }
        org.eclipse.swt.graphics.Point editorLocation = new org.eclipse.swt.graphics.Point(leftWidth, topHeight);
        if (!this.editor.getLocation().equals((Object)editorLocation)) {
            this.editor.setLocation(editorLocation);
        }
        PrecisionRectangle dim = new PrecisionRectangle(this.getLayoutSize());
        dim.performScale(this.getZoom());
        if (this.left != null) {
            org.eclipse.swt.graphics.Rectangle leftBounds = new org.eclipse.swt.graphics.Rectangle(0, topHeight - 1, leftWidth, dim.height + dim.y);
            if (!this.left.getControl().getBounds().equals((Object)leftBounds)) {
                this.left.getControl().setBounds(leftBounds);
            }
        }
        if (this.top != null) {
            org.eclipse.swt.graphics.Rectangle topBounds = new org.eclipse.swt.graphics.Rectangle(leftWidth - 1, 0, dim.width + dim.x, topHeight);
            if (!this.top.getControl().getBounds().equals((Object)topBounds)) {
                this.top.getControl().setBounds(topBounds);
            }
        }
    }

    protected Rectangle getScaleValue(Rectangle value) {
        PrecisionRectangle dim = new PrecisionRectangle(value);
        dim.performScale(this.getZoom());
        return dim;
    }

    public void setUnit(int unit) {
        if (unit != -1) {
            Object obj = this.diagramViewer.getProperty("horizontal ruler");
            if (obj instanceof EditorRulerProvider) {
                ((EditorRulerProvider)((Object)obj)).setUnit(unit);
            }
            if ((obj = this.diagramViewer.getProperty("vertical ruler")) instanceof EditorRulerProvider) {
                ((EditorRulerProvider)((Object)obj)).setUnit(unit);
            }
        }
    }

    public void setMargin(int direction) {
        switch (direction) {
            case 0: {
                Object obj = ((RulerProvider)this.diagramViewer.getProperty("horizontal ruler")).getRuler();
                if (!(obj instanceof EditorRuler)) break;
                ((EditorRuler)obj).setLeftMargin(this.getLayoutSize().x + this.getLeftMargin());
                break;
            }
            case 1: {
                Object obj = ((RulerProvider)this.diagramViewer.getProperty("horizontal ruler")).getRuler();
                if (!(obj instanceof EditorRuler)) break;
                ((EditorRuler)obj).setRightMargin(this.getLayoutSize().right() - this.getRightMargin());
                break;
            }
            case 2: {
                Object obj = ((RulerProvider)this.diagramViewer.getProperty("vertical ruler")).getRuler();
                if (!(obj instanceof EditorRuler)) break;
                ((EditorRuler)obj).setLeftMargin(this.getLayoutSize().y + this.getTopMargin());
                break;
            }
            case 3: {
                Object obj = ((RulerProvider)this.diagramViewer.getProperty("vertical ruler")).getRuler();
                if (!(obj instanceof EditorRuler)) break;
                ((EditorRuler)obj).setRightMargin(this.getLayoutSize().bottom() - this.getBottomMargin());
                break;
            }
        }
    }

    private int getLeftMargin() {
        return this.getMasterPageInsets((MasterPageHandle)this.getMasterPageHandle()).left;
    }

    private int getRightMargin() {
        return this.getMasterPageInsets((MasterPageHandle)this.getMasterPageHandle()).right;
    }

    private int getBottomMargin() {
        return this.getMasterPageInsets((MasterPageHandle)this.getMasterPageHandle()).bottom;
    }

    private double getZoom() {
        return this.getZoomManager().getZoom();
    }

    public ZoomManager getZoomManager() {
        return (ZoomManager)this.diagramViewer.getProperty(ZoomManager.class.toString());
    }

    private int getTopMargin() {
        return this.getMasterPageInsets((MasterPageHandle)this.getMasterPageHandle()).top;
    }

    private GraphicalViewer getRulerContainer(int orientation) {
        GraphicalViewer result = null;
        switch (orientation) {
            case 1: {
                result = this.top;
                break;
            }
            case 8: {
                result = this.left;
            }
        }
        return result;
    }

    public void layout(boolean change) {
        if (!this.layingOut && !this.isDisposed()) {
            this.checkWidget();
            if (change || this.needToLayout) {
                this.needToLayout = false;
                this.layingOut = true;
                this.doLayout();
                this.layingOut = false;
            }
        }
    }

    public void setGraphicalViewer(ScrollingGraphicalViewer primaryViewer, ModuleHandle model) {
        assert (primaryViewer != null);
        assert (primaryViewer.getControl() != null);
        assert (this.diagramViewer == null);
        this.handle = model;
        this.diagramViewer = primaryViewer;
        this.editor = (FigureCanvas)this.diagramViewer.getControl();
        this.getZoomManager().addZoomListener(this.zoomListener);
        this.layoutListener = new Listener(){

            public void handleEvent(Event event) {
                EditorRulerComposite.this.layout(true);
            }
        };
        this.addListener(11, this.layoutListener);
        this.editor.getHorizontalBar().addListener(22, this.layoutListener);
        this.editor.getHorizontalBar().addListener(23, this.layoutListener);
        this.editor.getVerticalBar().addListener(22, this.layoutListener);
        this.editor.getVerticalBar().addListener(23, this.layoutListener);
        this.propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("Property Margin Visibility".equals(property)) {
                    Object ruler;
                    Object obj = EditorRulerComposite.this.diagramViewer.getProperty("horizontal ruler");
                    if (obj instanceof EditorRulerProvider && (ruler = ((RulerProvider)obj).getRuler()) instanceof EditorRuler) {
                        ((EditorRuler)ruler).setMarginOff((Boolean)evt.getNewValue() == false);
                        EditorRulerComposite.this.setMargin(0);
                        EditorRulerComposite.this.setMargin(1);
                    }
                    if ((obj = EditorRulerComposite.this.diagramViewer.getProperty("vertical ruler")) instanceof EditorRulerProvider && (ruler = ((RulerProvider)obj).getRuler()) instanceof EditorRuler) {
                        ((EditorRuler)ruler).setMarginOff((Boolean)evt.getNewValue() == false);
                        EditorRulerComposite.this.setMargin(2);
                        EditorRulerComposite.this.setMargin(3);
                    }
                } else if ("Ruler Size".equals(property)) {
                    EditorRulerComposite.this.processProvider();
                } else if ("horizontal ruler".equals(property)) {
                    EditorRulerComposite.this.setRuler((RulerProvider)EditorRulerComposite.this.diagramViewer.getProperty("horizontal ruler"), 1);
                } else if ("vertical ruler".equals(property)) {
                    EditorRulerComposite.this.setRuler((RulerProvider)EditorRulerComposite.this.diagramViewer.getProperty("vertical ruler"), 8);
                } else if ("ruler$visibility".equals(property)) {
                    EditorRulerComposite.this.setRulerVisibility((Boolean)EditorRulerComposite.this.diagramViewer.getProperty("ruler$visibility"));
                }
            }
        };
        this.diagramViewer.addPropertyChangeListener(this.propertyListener);
        Boolean rulerVisibility = (Boolean)this.diagramViewer.getProperty("ruler$visibility");
        if (rulerVisibility != null) {
            this.setRulerVisibility(rulerVisibility);
        }
        this.setRuler((RulerProvider)this.diagramViewer.getProperty("horizontal ruler"), 1);
        this.setRuler((RulerProvider)this.diagramViewer.getProperty("vertical ruler"), 8);
        this.resetAllGuide();
        this.addModelListeners();
    }

    private void processProvider() {
        Rectangle rect = (Rectangle)this.diagramViewer.getProperty("Ruler Size");
        if (rect == null) {
            return;
        }
        Object obj = this.diagramViewer.getProperty("horizontal ruler");
        if (obj instanceof EditorRulerProvider) {
            ((EditorRulerProvider)((Object)obj)).setLayoutSize(rect.getCopy());
            ((EditorRulerProvider)((Object)obj)).setLeftSpace(rect.getCopy());
        }
        if ((obj = this.diagramViewer.getProperty("vertical ruler")) instanceof EditorRulerProvider) {
            ((EditorRulerProvider)((Object)obj)).setLayoutSize(rect.getCopy());
            ((EditorRulerProvider)((Object)obj)).setLeftSpace(rect.getCopy());
        }
        this.layout(true);
        this.resetAllGuide();
    }

    private void resetAllGuide() {
        this.setMargin(0);
        this.setMargin(1);
        this.setMargin(2);
        this.setMargin(3);
    }

    private void setRuler(RulerProvider provider, int orientation) {
        Object ruler = null;
        if (this.isRulerVisible && provider != null) {
            ruler = provider.getRuler();
        }
        if (ruler == null) {
            this.setRulerContainer(null, orientation);
            this.layout(true);
            return;
        }
        GraphicalViewer container = this.getRulerContainer(orientation);
        if (container == null) {
            container = this.createRulerContainer(orientation);
            this.setRulerContainer(container, orientation);
        }
        if (container.getContents() != ruler) {
            container.setContents(ruler);
            this.needToLayout = true;
            Display.getCurrent().asyncExec(this.runnable);
        }
    }

    private void setRulerContainer(GraphicalViewer container, int orientation) {
        if (orientation == 1) {
            if (this.top == container) {
                return;
            }
            this.disposeRulerViewer(this.top);
            this.top = container;
        } else if (orientation == 8) {
            if (this.left == container) {
                return;
            }
            this.disposeRulerViewer(this.left);
            this.left = container;
        }
    }

    public Rectangle getLayoutSize() {
        Object obj = this.diagramViewer.getProperty("Ruler Size");
        if (obj instanceof Rectangle) {
            return ((Rectangle)obj).getCopy();
        }
        Dimension dim = EditorRulerComposite.getMasterPageSize(this.getMasterPageHandle());
        return new Rectangle(0, 0, dim.width, dim.height);
    }

    public static Dimension getMasterPageSize(MasterPageHandle masterPage) {
        int height;
        int width;
        Dimension size = null;
        if (masterPage == null || masterPage.getPageType().equalsIgnoreCase("us-letter")) {
            size = new Dimension(MetricUtility.inchToPixel((double)8.5, (double)11.0).x, MetricUtility.inchToPixel((double)8.5, (double)11.0).y);
        } else if (masterPage.getPageType().equalsIgnoreCase("us-legal")) {
            size = new Dimension(MetricUtility.inchToPixel((double)8.5, (double)14.0).x, MetricUtility.inchToPixel((double)8.5, (double)14.0).y);
        } else if (masterPage.getPageType().equalsIgnoreCase("a4")) {
            size = new Dimension(MetricUtility.inchToPixel((double)8.3, (double)11.7).x, MetricUtility.inchToPixel((double)8.3, (double)11.7).y);
        } else if (masterPage.getPageType().equalsIgnoreCase("custom")) {
            width = (int)DEUtil.convertoToPixel((Object)masterPage.getWidth());
            height = (int)DEUtil.convertoToPixel((Object)masterPage.getHeight());
            size = new Dimension(width, height);
        }
        if ("landscape".equalsIgnoreCase(masterPage.getOrientation())) {
            width = (int)DEUtil.convertoToPixel((Object)masterPage.getWidth());
            height = (int)DEUtil.convertoToPixel((Object)masterPage.getHeight());
            size = new Dimension(width, height);
        }
        return size;
    }

    private void setRulerVisibility(boolean isVisible) {
        if (this.isRulerVisible != isVisible) {
            this.isRulerVisible = isVisible;
            if (this.diagramViewer != null) {
                this.setRuler((RulerProvider)this.diagramViewer.getProperty("horizontal ruler"), 1);
                this.setRuler((RulerProvider)this.diagramViewer.getProperty("vertical ruler"), 8);
            }
        }
    }

    private Insets getMasterPageInsets(MasterPageHandle masterPage) {
        return new Insets((int)DEUtil.convertoToPixel((Object)masterPage.getTopMargin()), (int)DEUtil.convertoToPixel((Object)masterPage.getLeftMargin()), (int)DEUtil.convertoToPixel((Object)masterPage.getBottomMargin()), (int)DEUtil.convertoToPixel((Object)masterPage.getRightMargin()));
    }

    private MasterPageHandle getMasterPageHandle() {
        return SessionHandleAdapter.getInstance().getFirstMasterPageHandle(this.getReportDesignHandle());
    }

    public void resetReportDesignHandle(ModuleHandle handle) {
        this.removeModelListeners();
        this.handle = handle;
        this.addModelListeners();
    }

    private void removeModelListeners() {
        if (this.getReportDesignHandle() != null) {
            this.getReportDesignHandle().removeListener(this.designListener);
        }
        if (this.getMasterPageHandle() != null) {
            this.getMasterPageHandle().removeListener(this.designListener);
        }
    }

    private void addModelListeners() {
        this.setUnit(this.getUnitFromDesign(this.getReportDesignHandle().getDefaultUnits()));
        this.getReportDesignHandle().addListener(this.designListener);
        this.getMasterPageHandle().addListener(this.designListener);
    }

    private ModuleHandle getReportDesignHandle() {
        return this.handle;
    }

    private int getUnitFromDesign(String name) {
        if ("cm".equals(name)) {
            return 1;
        }
        if ("in".equals(name)) {
            return 0;
        }
        if ("px".equals(name)) {
            return 2;
        }
        if ("mm".equals(name)) {
            return 4;
        }
        if ("pc".equals(name)) {
            return 6;
        }
        if ("pt".equals(name)) {
            return 5;
        }
        return -1;
    }

    private static class RulerBorder
    extends AbstractBorder {
        private static final Insets H_INSETS = new Insets(0, 1, 0, 0);
        private static final Insets V_INSETS = new Insets(1, 0, 0, 0);
        private boolean horizontal;

        public RulerBorder(boolean isHorizontal) {
            this.horizontal = isHorizontal;
        }

        public Insets getInsets(IFigure figure) {
            return this.horizontal ? H_INSETS : V_INSETS;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setForegroundColor(ColorConstants.buttonDarker);
            if (this.horizontal) {
                graphics.drawLine(figure.getBounds().getTopLeft(), figure.getBounds().getBottomLeft().translate(new Point(0, -4)));
            } else {
                graphics.drawLine(figure.getBounds().getTopLeft(), figure.getBounds().getTopRight().translate(new Point(-4, 0)));
            }
        }
    }

    private static class RulerViewer
    extends ScrollingGraphicalViewer {
        public void appendSelection(EditPart editpart) {
            if (editpart instanceof RootEditPart) {
                editpart = ((RootEditPart)editpart).getContents();
            }
            this.setFocus(editpart);
            super.appendSelection(editpart);
        }

        protected void init() {
            this.setContextMenu((MenuManager)new EditorRulerContextMenuProvider((EditPartViewer)this));
            this.setKeyHandler((KeyHandler)new RulerKeyHandler((GraphicalViewer)this));
        }

        public void reveal(EditPart part) {
            if (part != this.getContents()) {
                super.reveal(part);
            }
        }

        public void setContents(EditPart editpart) {
            super.setContents(editpart);
            this.setFocus(this.getContents());
        }

        protected static class RulerKeyHandler
        extends GraphicalViewerKeyHandler {
            public RulerKeyHandler(GraphicalViewer viewer) {
                super(viewer);
            }

            public boolean keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    if (this.getFocusEditPart() instanceof EditorGuideEditPart) {
                        EditorRulerEditPart parent = (EditorRulerEditPart)this.getFocusEditPart().getParent();
                        this.getViewer().getEditDomain().getCommandStack().execute(parent.getRulerProvider().getDeleteGuideCommand(this.getFocusEditPart().getModel()));
                        event.doit = false;
                        return true;
                    }
                    return false;
                }
                if ((event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000001) {
                    EditPart parent = this.getFocusEditPart().getParent();
                    if (parent instanceof EditorRulerEditPart) {
                        this.navigateTo(this.getFocusEditPart().getParent(), event);
                    }
                    return true;
                }
                return super.keyPressed(event);
            }
        }
    }
}

