/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GraphicsViewModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.layer.TableBorderLayer;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.LayerConstants;

public abstract class AbstractTableEditPart
extends ReportElementEditPart
implements LayerConstants,
ITableLayoutOwner {
    public static final String BORDER_LAYER = "Table Border layer";
    protected FreeformLayeredPane innerLayers;
    protected LayeredPane printableLayers;

    public AbstractTableEditPart(Object model) {
        super(model);
    }

    public IFigure getLayer(Object key) {
        if (this.innerLayers == null) {
            return null;
        }
        Layer layer = this.innerLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        if (this.printableLayers == null) {
            return null;
        }
        return this.printableLayers.getLayer(key);
    }

    protected LayeredPane getPrintableLayers() {
        if (this.printableLayers == null) {
            this.printableLayers = this.createPrintableLayers();
        }
        return this.printableLayers;
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        FreeformLayer layer = new FreeformLayer();
        layer.setLayoutManager((LayoutManager)new TableLayout(this));
        layeredPane.add((IFigure)layer, (Object)"Primary Layer");
        layeredPane.add((IFigure)new TableBorderLayer(this), (Object)BORDER_LAYER);
        return layeredPane;
    }

    public IFigure getContentPane() {
        return this.getLayer("Primary Layer");
    }

    public void reLayout() {
        this.notifyModelChange();
        this.getFigure().invalidateTree();
        this.getFigure().revalidate();
    }

    public abstract AbstractCellEditPart getCell(int var1, int var2);

    protected void contentChange(Map info) {
        int intValue;
        Object action = info.get(GraphicsViewModelEventProcessor.CONTENT_EVENTTYPE);
        if (action instanceof Integer && ((intValue = ((Integer)action).intValue()) == 10 || intValue == 12 || intValue == 11)) {
            if (((ReportItemHandle)this.getModel()).getViews().size() > 0) {
                this.markDirty(true);
                EditPart part = this.getParent();
                ((ReportElementEditPart)this.getParent()).removeChild((EditPart)this);
                part.refresh();
                this.removeGuideFeedBack();
                return;
            }
            ((ReportElementEditPart)this.getParent()).contentChange(info);
            return;
        }
        super.contentChange(info);
    }
}

