/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import org.eclipse.birt.report.designer.core.model.schematic.LabelHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.LineBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.LabelDirectEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportElementNonResizablePolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.LabelCellEditorLocator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.LabelEditManager;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportItemConstraint;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;

public class LabelEditPart
extends ReportElementEditPart {
    protected static final int TRUNCATE_LENGTH = 18;
    protected static final String ELLIPSIS = "...";
    private static final String ELEMENT_DEFAULT_TEXT = Messages.getString((String)"LabelEditPart.Figure.Default");
    private DirectEditManager manager;

    public LabelEditPart(Object model) {
        super(model);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
    }

    protected IFigure createFigure() {
        LabelFigure label = new LabelFigure();
        return label;
    }

    public void performDirectEdit() {
        if (this.manager == null) {
            this.manager = new LabelEditManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator((Figure)this.getFigure()));
        }
        this.manager.show();
    }

    protected LabelHandleAdapter getLabelAdapter() {
        return (LabelHandleAdapter)this.getModelAdapter();
    }

    public void refreshFigure() {
        StyleHandle style = ((DesignElementHandle)this.getModel()).getPrivateStyle();
        ((LabelFigure)this.getFigure()).setDirection(this.getTextDirection());
        ((LabelFigure)this.getFigure()).setText(this.getText());
        ((LabelFigure)this.getFigure()).setFont(this.getFont());
        ((LabelFigure)this.getFigure()).setTextUnderline(style.getTextUnderline());
        ((LabelFigure)this.getFigure()).setTextLineThrough(style.getTextLineThrough());
        ((LabelFigure)this.getFigure()).setTextOverline(style.getTextOverline());
        ((LabelFigure)this.getFigure()).setTextAlign(style.getTextAlign());
        ((LabelFigure)this.getFigure()).setVerticalAlign(style.getVerticalAlign());
        ((LabelFigure)this.getFigure()).setDisplay(style.getDisplay());
        ((LabelFigure)this.getFigure()).setRecommendSize(this.getLabelAdapter().getSize());
        ((AbstractGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), this.getConstraint());
        ((LabelFigure)this.getFigure()).setForegroundColor(ColorManager.getColor((int)this.getForegroundColor((DesignElementHandle)((ReportItemHandle)this.getModel()))));
        this.refreshBorder((DesignElementHandle)this.getModel(), new LineBorder());
        Insets pist = this.getLabelAdapter().getPadding(this.getFigure().getInsets());
        ((LineBorder)this.getFigure().getBorder()).setPaddingInsets(pist);
        if (!this.hasText()) {
            ((LabelFigure)this.getFigure()).setForegroundColor(ReportColorConstants.ShadowLineColor);
        } else {
            ((LabelFigure)this.getFigure()).setForegroundColor(ColorManager.getColor((int)this.getForegroundColor((DesignElementHandle)((ReportItemHandle)this.getModel()))));
        }
        this.refreshBackground((DesignElementHandle)this.getModel());
        this.refreshMargin();
    }

    protected boolean hasText() {
        return !StringUtil.isBlank((String)((LabelHandle)this.getModel()).getDisplayText());
    }

    protected String getText() {
        String text = ((LabelHandle)this.getModel()).getDisplayText();
        if (text == null) {
            text = ELEMENT_DEFAULT_TEXT;
        }
        return text;
    }

    protected Object getConstraint() {
        ReportItemHandle handle = (ReportItemHandle)this.getModel();
        ReportItemConstraint constraint = new ReportItemConstraint();
        constraint.setDisplay(handle.getPrivateStyle().getDisplay());
        DimensionHandle value = handle.getWidth();
        constraint.setMeasure(value.getMeasure());
        constraint.setUnits(value.getUnits());
        return constraint;
    }

    public EditPolicy getResizePolice(EditPolicy parentPolice) {
        return new ReportElementNonResizablePolicy();
    }
}

