/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.designer.core.commands.SetConstraintCommand;
import org.eclipse.birt.report.designer.core.model.IMultipleAdapterHelper;
import org.eclipse.birt.report.designer.core.model.schematic.MultipleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GraphicsViewModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportElementResizablePolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportFlowLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.MultipleFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.MultipleGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.layout.MultipleLayout;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class MultipleEditPart
extends ReportElementEditPart
implements IMultipleAdapterHelper {
    private String guideLabel;

    public MultipleEditPart(Object model) {
        super(model);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ReportFlowLayoutEditPolicy());
    }

    public void refreshFigure() {
    }

    protected List getModelChildren() {
        return this.getModelAdapter().getChildren();
    }

    protected IFigure createFigure() {
        MultipleFigure layer = new MultipleFigure();
        return layer;
    }

    public MultipleAdapter getMultipleAdapter() {
        return (MultipleAdapter)this.getModelAdapter();
    }

    public boolean isMultiple() {
        return true;
    }

    protected AbstractGuideHandle createGuideHandle() {
        MultipleGuideHandle handle = new MultipleGuideHandle((GraphicalEditPart)this);
        handle.addChildren(this.getMultipleAdapter().getViews());
        handle.setSelected(this.getMultipleAdapter().getCurrentViewNumber());
        return handle;
    }

    public void setCurrentView(int number) {
        this.getMultipleAdapter().setCurrentView(number);
        ((MultipleGuideHandle)this.getGuideHandle()).setSelected(number);
    }

    public void removeView(int number) {
        this.getMultipleAdapter().removeView(number);
    }

    protected void propertyChange(Map info) {
        Set set = info.keySet();
        if (set.contains("multiViews") && this.getMultipleAdapter().getViews().size() > 0) {
            this.refresh();
            UIUtil.resetViewSelection(this.getViewer(), true);
            return;
        }
        super.propertyChange(info);
    }

    protected void contentChange(Map info) {
        int intValue;
        Object action = info.get(GraphicsViewModelEventProcessor.CONTENT_EVENTTYPE);
        if (action instanceof Integer && ((intValue = ((Integer)action).intValue()) == 10 || intValue == 12 || intValue == 11)) {
            this.markDirty(true);
            this.removeGuideFeedBack();
            if (this.getMultipleAdapter().getViews().size() == 0) {
                this.markDirty(true);
                EditPart part = this.getParent();
                ((ReportElementEditPart)this.getParent()).removeChild((EditPart)this);
                part.refresh();
                return;
            }
        }
        super.contentChange(info);
    }

    public EditPolicy getResizePolice(EditPolicy parentPolice) {
        MultipleResizePolicy policy = new MultipleResizePolicy();
        policy.setResizeDirections(20);
        return policy;
    }

    public boolean isinterestSelection(Object object) {
        return this.getMultipleAdapter().getViews().contains(object);
    }

    public void notifyModelChange() {
        super.notifyModelChange();
        ((MultipleLayout)this.getFigure().getLayoutManager()).markDirty();
    }

    public String getGuideLabel() {
        if (this.guideLabel == null) {
            this.guideLabel = ((ReportElementEditPart)((Object)this.getChildren().get(0))).getGuideLabel();
        }
        return this.guideLabel;
    }

    private static class MultipleResizePolicy
    extends ReportElementResizablePolicy {
        private MultipleResizePolicy() {
        }

        protected Command getResizeCommand(ChangeBoundsRequest request) {
            Command command = super.getResizeCommand(request);
            if (command instanceof SetConstraintCommand) {
                ((SetConstraintCommand)command).setModel((ReportItemHandle)this.getTrueHost().getModel());
            }
            return command;
        }

        private GraphicalEditPart getTrueHost() {
            GraphicalEditPart parent = (GraphicalEditPart)this.getHost();
            List list = parent.getChildren();
            if (list.size() == 0) {
                return parent;
            }
            return (GraphicalEditPart)list.get(0);
        }
    }
}

