/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.commands.DeleteColumnCommand;
import org.eclipse.birt.report.designer.core.commands.DeleteRowCommand;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ITableAdapterHelper;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.IRequestConvert;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.ReportFigureUtilities;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.EditGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.SectionBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GraphicsViewModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.TableResizeEditPolice;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.TableXYLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.TableFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.TableGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.layer.TableGridLayer;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.GuideLayer;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class TableEditPart
extends AbstractTableEditPart
implements ITableAdapterHelper {
    private static final String RESIZE_COLUMN_TRANS_LABEL = Messages.getString((String)"TableEditPart.Label.ResizeColumn");
    private static final String MERGE_TRANS_LABEL = Messages.getString((String)"TableEditPart.Label.Merge");
    public static final String GUIDEHANDLE_TEXT = Messages.getString((String)"TableEditPart.GUIDEHANDLE_TEXT");
    private Rectangle selectRowAndColumnRect = null;
    private int oriColumnNumber = 1;
    private int oriRowNumner = 1;

    public TableEditPart(Object obj) {
        super(obj);
    }

    protected AbstractGuideHandle createGuideHandle() {
        TableGuideHandle handle = new TableGuideHandle((GraphicalEditPart)this);
        handle.setIndicatorLabel(this.getGuideLabel());
        INodeProvider provider = ProviderFactory.createProvider(this.getModel());
        handle.setIndicatorIcon(provider.getNodeIcon(this.getModel()));
        handle.setToolTip((IFigure)ReportFigureUtilities.createToolTipFigure(provider.getNodeTooltip(this.getModel()), "ltr", "left"));
        return handle;
    }

    public String getGuideLabel() {
        return GUIDEHANDLE_TEXT;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy(){

            public boolean understandsRequest(Request request) {
                if ("direct edit".equals(request.getType()) || "open".equals(request.getType()) || "create element".equals(request.getType())) {
                    return true;
                }
                return super.understandsRequest(request);
            }
        });
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TableXYLayoutEditPolicy((XYLayout)this.getContentPane().getLayoutManager()));
    }

    protected List getModelChildren() {
        return this.getTableAdapter().getChildren();
    }

    protected void contentChange(Map info) {
        super.contentChange(info);
        Object action = info.get(GraphicsViewModelEventProcessor.CONTENT_EVENTTYPE);
        if (action instanceof Integer && (Integer)action == 2) {
            this.reselectTable();
        }
    }

    private void reselectTable() {
        if (this.isDelete()) {
            return;
        }
        ReportRequest request = new ReportRequest((Object)this);
        ArrayList<TableEditPart> list = new ArrayList<TableEditPart>();
        list.add(this);
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        request.setRequestConvert((IRequestConvert)new DeferredGraphicalViewer.EditorReportRequestConvert());
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
    }

    public void performRequest(Request request) {
        EditGroupAction action;
        int rowNum;
        RowHandle row;
        Object obj;
        if ("open".equals(request.getType()) && (obj = request.getExtendedData().get("rowNumber")) != null && (row = (RowHandle)this.getRow(rowNum = ((Integer)obj).intValue())).getContainer() instanceof TableGroupHandle && (action = new EditGroupAction(null, (GroupHandle)((TableGroupHandle)row.getContainer()))).isEnabled()) {
            action.run();
        }
    }

    public void refreshFigure() {
        this.checkHelper();
        this.refreshBorder(this.getTableAdapter().getHandle(), (BaseBorder)this.getFigure().getBorder());
        ((SectionBorder)this.getFigure().getBorder()).setPaddingInsets(this.getTableAdapter().getPadding(this.getFigure().getInsets()));
        this.refreshBackground((DesignElementHandle)this.getModel());
        this.refreshMargin();
        for (TableCellEditPart fg : this.getChildren()) {
            if (fg.isDelete()) continue;
            fg.updateBlankString();
        }
        this.layoutManagerLayout();
    }

    protected void checkHelper() {
        if (HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getModel(), (IModelAdapterHelper)this).getModelAdaptHelper() == null) {
            this.peer = this.creatDesignElementHandleAdapter();
        }
        this.getTableAdapter().reload();
    }

    public TableCellEditPart[] getMinAndMaxNumber(TableCellEditPart[] parts) {
        if (parts == null || parts.length == 0) {
            return null;
        }
        int size = parts.length;
        TableCellEditPart leftTopPart = parts[0];
        TableCellEditPart leftBottomPart = parts[0];
        TableCellEditPart rightBottomPart = parts[0];
        TableCellEditPart rightTopPart = parts[0];
        int i = 1;
        while (i < size) {
            TableCellEditPart part = parts[i];
            if (part != null) {
                if (part.getRowNumber() <= leftTopPart.getRowNumber() && part.getColumnNumber() <= leftTopPart.getColumnNumber()) {
                    leftTopPart = part;
                }
                if (part.getRowNumber() <= rightTopPart.getRowNumber() && part.getColumnNumber() + part.getColSpan() - 1 >= leftTopPart.getColumnNumber()) {
                    rightTopPart = part;
                }
                if (part.getColumnNumber() <= leftBottomPart.getColumnNumber() && part.getRowNumber() + part.getRowSpan() - 1 >= leftBottomPart.getRowNumber()) {
                    leftBottomPart = part;
                }
                if (part.getRowNumber() + part.getRowSpan() - 1 >= rightBottomPart.getRowNumber() && part.getColumnNumber() + part.getColSpan() - 1 >= rightBottomPart.getColumnNumber()) {
                    rightBottomPart = part;
                }
            }
            ++i;
        }
        return new TableCellEditPart[]{leftTopPart, rightTopPart, leftBottomPart, rightBottomPart};
    }

    protected IFigure createFigure() {
        TableFigure viewport = new TableFigure();
        viewport.setOpaque(false);
        this.innerLayers = new FreeformLayeredPane();
        this.createLayers((LayeredPane)this.innerLayers);
        viewport.setContents((IFigure)this.innerLayers);
        return viewport;
    }

    protected void createLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)this.createGridLayer(), (Object)"Grid Layer");
        layeredPane.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Handle Layer");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    protected GridLayer createGridLayer() {
        TableGridLayer grid = new TableGridLayer(this);
        grid.setOpaque(false);
        return grid;
    }

    public void resizeColumn(int start, int end, int value) {
        Object startColumn = this.getColumn(start);
        ColumnHandleAdapter startAdapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(startColumn);
        Object endColumn = this.getColumn(end);
        HandleAdapterFactory.getInstance().getColumnHandleAdapter(endColumn);
        int startWidth = 0;
        startWidth = TableUtil.caleVisualWidth(this, startColumn);
        TableUtil.caleVisualWidth(this, endColumn);
        try {
            this.getTableAdapter().transStar(RESIZE_COLUMN_TRANS_LABEL);
            startAdapt.setWidth(startWidth + value);
            this.getTableAdapter().transEnd();
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void selectColumn(int[] numbers) {
        this.selectColumn(numbers, true);
    }

    public void selectColumn(int[] numbers, boolean notofyToMedia) {
        if (numbers == null || numbers.length == 0) {
            return;
        }
        ArrayList<ReportElementEditPart> list = new ArrayList<ReportElementEditPart>();
        int size = numbers.length;
        int width = 0;
        int minColumnnumber = numbers[0];
        int i = 0;
        while (i < size) {
            if (minColumnnumber > numbers[i]) {
                minColumnnumber = numbers[i];
            }
            width += TableUtil.caleVisualWidth(this, this.getColumn(numbers[i]));
            list.add(new DummyColumnEditPart(this.getColumn(numbers[i])));
            ++i;
        }
        i = 0;
        while (i < size) {
            int rowNumber = this.getTableAdapter().getRowCount();
            int j = 0;
            while (j < rowNumber) {
                AbstractCellEditPart part = this.getCell(j + 1, numbers[i]);
                if (part != null) {
                    list.add(part);
                }
                ++j;
            }
            ++i;
        }
        int x = TableUtil.caleX(this, minColumnnumber);
        Rectangle rect = new Rectangle(x, 0, width, TableUtil.getTableContentsHeight(this));
        this.setSelectRowAndColumnRect(rect);
        if (notofyToMedia) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(list));
        } else if (this.getViewer() instanceof DeferredGraphicalViewer) {
            ((DeferredGraphicalViewer)this.getViewer()).setSelection((ISelection)new StructuredSelection(list), notofyToMedia);
        }
        this.setSelectRowAndColumnRect(null);
    }

    public void resizeRow(int start, int end, int value) {
        Object row = this.getRow(start);
        RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(row);
        int rowHeight = 0;
        rowHeight = adapt.isCustomHeight() ? adapt.getHeight() : TableUtil.caleVisualHeight(this, row);
        try {
            adapt.setHeight(rowHeight + value);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void selectRow(int[] numbers) {
        this.selectRow(numbers, true);
    }

    public void selectRow(int[] numbers, boolean notofyToMedia) {
        if (numbers == null || numbers.length == 0) {
            return;
        }
        ArrayList<ReportElementEditPart> list = new ArrayList<ReportElementEditPart>();
        int size = numbers.length;
        int height = 0;
        int minRownumber = numbers[0];
        int i = 0;
        while (i < size) {
            if (minRownumber > numbers[i]) {
                minRownumber = numbers[i];
            }
            height += TableUtil.caleVisualHeight(this, this.getRow(numbers[i]));
            list.add(new DummyRowEditPart(this.getRow(numbers[i])));
            ++i;
        }
        i = 0;
        while (i < size) {
            int columnNumber = this.getTableAdapter().getColumnCount();
            int j = 0;
            while (j < columnNumber) {
                AbstractCellEditPart part = this.getCell(numbers[i], j + 1);
                if (part != null) {
                    list.add(part);
                }
                ++j;
            }
            ++i;
        }
        int y = TableUtil.caleY(this, minRownumber);
        Rectangle rect = new Rectangle(0, y, TableUtil.getTableContentsWidth(this), height);
        this.setSelectRowAndColumnRect(rect);
        if (notofyToMedia) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(list));
        } else if (this.getViewer() instanceof DeferredGraphicalViewer) {
            ((DeferredGraphicalViewer)this.getViewer()).setSelection((ISelection)new StructuredSelection(list), notofyToMedia);
        }
        this.setSelectRowAndColumnRect(null);
    }

    public int getMinHeight(int rowNumber) {
        return Math.max(TableUtil.getMinHeight(this, rowNumber), this.getTableAdapter().getMinHeight(rowNumber));
    }

    public int getMinWidth(int columnNumber) {
        return Math.max(TableUtil.getMinWidth(this, columnNumber), this.getTableAdapter().getMinWidth(columnNumber));
    }

    public TableHandleAdapter getTableAdapter() {
        return (TableHandleAdapter)this.getModelAdapter();
    }

    public List getRows() {
        return this.getTableAdapter().getRows();
    }

    public Object getRow(int number) {
        return this.getTableAdapter().getRow(number);
    }

    public Object getColumn(int number) {
        return this.getTableAdapter().getColumn(number);
    }

    public List getColumns() {
        return this.getTableAdapter().getColumns();
    }

    public int getRowCount() {
        return this.getTableAdapter().getRowCount();
    }

    public int getColumnCount() {
        return this.getTableAdapter().getColumnCount();
    }

    public Rectangle getSelectBounds() {
        if (this.getSelectRowAndColumnRect() != null) {
            return this.getSelectRowAndColumnRect();
        }
        List list = TableUtil.getSelectionCells(this);
        int size = list.size();
        TableCellEditPart[] parts = new TableCellEditPart[size];
        list.toArray(parts);
        TableCellEditPart[] caleNumber = this.getMinAndMaxNumber(parts);
        TableCellEditPart minRow = caleNumber[0];
        TableCellEditPart maxColumn = caleNumber[3];
        Rectangle min = minRow.getBounds().getCopy();
        Rectangle max = maxColumn.getBounds().getCopy();
        return min.union(max);
    }

    public Rectangle getSelectRowAndColumnRect() {
        return this.selectRowAndColumnRect;
    }

    public void setSelectRowAndColumnRect(Rectangle selectRowAndColumnRect) {
        this.selectRowAndColumnRect = selectRowAndColumnRect;
    }

    public Object getDataSet() {
        return this.getTableAdapter().getDataSet();
    }

    public AbstractCellEditPart getCell(int rowNumber, int columnNumber) {
        Object cell = this.getTableAdapter().getCell(rowNumber, columnNumber);
        return (TableCellEditPart)this.getViewer().getEditPartRegistry().get(cell);
    }

    public void deleteRow(int[] numbers) {
        try {
            this.getTableAdapter().deleteRow(numbers);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void deleteColumn(int[] numbers) {
        try {
            this.getTableAdapter().deleteColumn(numbers);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void insertRow(int rowNumber) {
        this.insertRow(-1, rowNumber);
    }

    public void insertRow(int relativePos, int originRowNumber) {
        final RowHandleAdapter adapter = HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getRow(originRowNumber));
        try {
            this.getTableAdapter().insertRow(relativePos, originRowNumber);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                TableEditPart.this.selectRow(new int[]{adapter.getRowNumber()});
            }
        });
    }

    public void insertRows(int relativePos, int[] rowNumbers) {
        int rowCount = rowNumbers.length;
        try {
            if (relativePos < 0) {
                this.getTableAdapter().insertRows(-rowCount, rowNumbers[0]);
            } else {
                this.getTableAdapter().insertRows(rowCount, rowNumbers[rowCount - 1]);
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void insertColumn(int columnNumber) {
        this.insertColumn(-1, columnNumber);
    }

    public void insertColumn(int relativePos, int originColNumber) {
        final ColumnHandleAdapter adapter = HandleAdapterFactory.getInstance().getColumnHandleAdapter(this.getColumn(originColNumber));
        try {
            this.getTableAdapter().insertColumn(relativePos, originColNumber);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                TableEditPart.this.selectColumn(new int[]{adapter.getColumnNumber()});
            }
        });
    }

    public void insertColumns(int relativePos, int[] colNumbers) {
        int colCount = colNumbers.length;
        try {
            if (relativePos < 0) {
                this.getTableAdapter().insertColumns(-colCount, colNumbers[0]);
            } else {
                this.getTableAdapter().insertColumns(colCount, colNumbers[colCount - 1]);
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void merge() {
        List selections = TableUtil.getSelectionCells(this);
        if (selections.size() == 1) {
            return;
        }
        int size = selections.size();
        TableCellEditPart[] parts = new TableCellEditPart[size];
        selections.toArray(parts);
        TableCellEditPart[] caleNumber = this.getMinAndMaxNumber(parts);
        TableCellEditPart minRow = caleNumber[0];
        TableCellEditPart maxRow = caleNumber[2];
        TableCellEditPart maxColumn = caleNumber[3];
        TableCellEditPart cellPart = caleNumber[0];
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < size) {
            if (selections.get(i) != cellPart) {
                list.add(selections.get(i));
            }
            ++i;
        }
        int rowSpan = maxRow.getRowNumber() - minRow.getRowNumber() + maxRow.getRowSpan();
        int colSpan = maxColumn.getColumnNumber() - maxRow.getColumnNumber() + maxColumn.getColSpan();
        this.getTableAdapter().transStar(MERGE_TRANS_LABEL);
        try {
            this.MergeContent(cellPart, list);
        }
        catch (ContentException e) {
            ExceptionHandler.handle(e);
        }
        cellPart.setRowSpan(rowSpan);
        cellPart.setColumnSpan(colSpan);
        this.removeMergeList(list);
        this.getTableAdapter().reload();
        this.getTableAdapter().transEnd();
        this.getViewer().setSelection((ISelection)new StructuredSelection((Object)cellPart));
    }

    private void MergeContent(TableCellEditPart cellPart, List list) throws ContentException {
        CellHandle cellHandle = (CellHandle)cellPart.getModel();
        int size = list.size();
        int i = 0;
        while (i < size) {
            CellHandle handle = (CellHandle)((TableCellEditPart)list.get(i)).getModel();
            List chList = handle.getSlot(0).getContents();
            int j = 0;
            while (j < chList.size()) {
                DesignElementHandle contentHandle = (DesignElementHandle)chList.get(j);
                try {
                    DesignElementHandle copy = contentHandle.copy().getHandle(cellHandle.getModule());
                    handle.getSlot(0).drop(contentHandle);
                    cellHandle.getModuleHandle().rename(copy);
                    cellHandle.getSlot(0).add(copy);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
                ++j;
            }
            ++i;
        }
    }

    private void removeMergeList(ArrayList list) {
        int size = list.size();
        int i = 0;
        while (i < size) {
            this.remove((TableCellEditPart)list.get(i));
            ++i;
        }
    }

    public void remove(TableCellEditPart cellPart) {
        try {
            this.getTableAdapter().removeChild(cellPart.getModel());
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public Dimension getPreferredSize() {
        Dimension retValue = this.getFigure().getParent().getClientArea().getSize();
        Rectangle rect = this.getBounds();
        if (rect.width > 0) {
            retValue.width = rect.width;
        }
        if (rect.height > 0) {
            retValue.height = rect.height;
        }
        return retValue;
    }

    private void layoutManagerLayout() {
        ((TableLayout)this.getContentPane().getLayoutManager()).markDirty();
    }

    public int caleVisualWidth(int columnNumber) {
        assert (columnNumber > 0);
        return TableUtil.caleVisualWidth(this, this.getColumn(columnNumber));
    }

    public int caleVisualHeight(int rowNumber) {
        return TableUtil.caleVisualHeight(this, this.getRow(rowNumber));
    }

    public boolean canMerge() {
        if (!this.isActive() || this.isDelete() || this.getParent() == null) {
            return false;
        }
        List list = TableUtil.getSelectionCells(this);
        int size = list.size();
        ArrayList<Object> temp = new ArrayList<Object>();
        int i = 0;
        while (i < size) {
            ReportElementEditPart part = (ReportElementEditPart)((Object)list.get(i));
            if (part.isDelete()) {
                return false;
            }
            temp.add(part.getModel());
            ++i;
        }
        boolean rt = this.getTableAdapter().canMerge(temp);
        if (rt) {
            TableUtil.calculateNewSelection(TableUtil.getUnionBounds(list), list, this.getChildren());
            return list.size() == size;
        }
        return rt;
    }

    public void splitCell(TableCellEditPart part) {
        try {
            this.getTableAdapter().splitCell(part.getModel());
        }
        catch (ContentException e) {
            ExceptionHandler.handle(e);
        }
        catch (NameException e) {
            ExceptionHandler.handle(e);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void includeSlotHandle(boolean bool, int id) {
        try {
            if (bool) {
                this.getTableAdapter().insertRowInSlotHandle(id);
            } else {
                this.getTableAdapter().deleteRowInSlotHandle(id);
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public boolean insertGroup() {
        return UIUtil.createGroup(this.getTableAdapter().getHandle());
    }

    public boolean insertGroup(int position) {
        return UIUtil.createGroup(this.getTableAdapter().getHandle(), position);
    }

    public void removeGroup(Object group) {
        try {
            ((TableHandleAdapter)this.getModelAdapter()).removeGroup(group);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public Dimension getClientAreaSize() {
        return this.getFigure().getParent().getClientArea().getSize();
    }

    public void showTargetFeedback(Request request) {
        if (this.getSelected() == 0 && this.isActive()) {
            request.getType();
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (this.isActive()) {
            this.getViewer().setCursor(null);
        }
        super.eraseTargetFeedback(request);
    }

    protected void addChildVisual(EditPart part, int index) {
        this.getViewer().setCursor(null);
        super.addChildVisual(part, index);
    }

    public void notifyModelChange() {
        super.notifyModelChange();
        this.layoutManagerLayout();
    }

    public boolean isinterest(Object model) {
        if ((model instanceof RowHandle || model instanceof ColumnHandle || model instanceof TableGroupHandle) && this.getModelAdapter().isChildren((DesignElementHandle)model)) {
            return true;
        }
        return super.isinterest(model);
    }

    public ITableLayoutOwner.DimensionInfomation getColumnWidth(int number) {
        Object obj = this.getColumn(number);
        ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(obj);
        DimensionHandle handle = ((ColumnHandle)adapt.getHandle()).getWidth();
        return new ITableLayoutOwner.DimensionInfomation(handle.getMeasure(), handle.getUnits());
    }

    public ITableLayoutOwner.DimensionInfomation getRowHeight(int number) {
        Object obj = this.getRow(number);
        RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(obj);
        DimensionHandle handle = ((RowHandle)adapt.getHandle()).getHeight();
        return new ITableLayoutOwner.DimensionInfomation(handle.getMeasure(), handle.getUnits());
    }

    public String getDefinedWidth() {
        TableHandleAdapter tadp = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getModel());
        return tadp.getDefinedWidth();
    }

    public String getRawWidth(int columNumber) {
        Object obj = this.getColumn(columNumber);
        ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(obj);
        return adapt.getRawWidth();
    }

    public int getColumnWidthValue(int number) {
        Object obj = this.getColumn(number);
        ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(obj);
        return adapt.getWidth();
    }

    public int getRowHeightValue(int number) {
        Object obj = this.getRow(number);
        RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(obj);
        return adapt.getHeight();
    }

    public EditPolicy getResizePolice(EditPolicy parentPolice) {
        TableResizeEditPolice rpc = new TableResizeEditPolice();
        rpc.setResizeDirections(20);
        return rpc;
    }

    public int getOriColumnNumber() {
        return this.oriColumnNumber;
    }

    public void setOriColumnNumber(int oriColumnNumber) {
        this.oriColumnNumber = oriColumnNumber;
    }

    public int getOriRowNumner() {
        return this.oriRowNumner;
    }

    public void setOriRowNumner(int oriRowNumner) {
        this.oriRowNumner = oriRowNumner;
    }

    public static class DummyColumnEditPart
    extends DummyEditpart {
        public DummyColumnEditPart(Object model) {
            super(model);
            this.createEditPolicies();
        }

        protected void createEditPolicies() {
            ReportComponentEditPolicy policy = new ReportComponentEditPolicy(){

                protected Command createDeleteCommand(GroupRequest deleteRequest) {
                    DeleteColumnCommand command = new DeleteColumnCommand(DummyColumnEditPart.this.getModel());
                    return command;
                }
            };
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)policy);
        }

        public int getColumnNumber() {
            ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(this.getModel());
            if (adapt.getTableParent() == null) {
                return -1;
            }
            return adapt.getColumnNumber();
        }
    }

    public static class DummyRowEditPart
    extends DummyEditpart {
        public DummyRowEditPart(Object model) {
            super(model);
            this.createEditPolicies();
        }

        protected void createEditPolicies() {
            ReportComponentEditPolicy policy = new ReportComponentEditPolicy(){

                protected Command createDeleteCommand(GroupRequest deleteRequest) {
                    DeleteRowCommand command = new DeleteRowCommand(DummyRowEditPart.this.getModel());
                    return command;
                }
            };
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)policy);
        }

        public int getRowNumber() {
            RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getModel());
            if (adapt.getTableParent() == null) {
                return -1;
            }
            return adapt.getRowNumber();
        }
    }
}

