/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.bidi.BidiUIUtils;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.ContentBox;
import org.eclipse.draw2d.text.LineRoot;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class TextFlow
extends org.eclipse.draw2d.text.TextFlow {
    private String specialPREFIX = "";
    static int LINE_FACTOR = 24;
    static String ELLIPSIS = "...";
    static Field TRUNCATED;
    private String textUnderline = "none";
    private String textLineThrough = "none";
    private String textOverline = "none";
    private String textAlign = "left";
    private String verticalAlign = "top";
    private String direction = null;
    private static final Color TRANSPARENT_COLOR;
    static Field LINE_ROOT;

    static {
        TRANSPARENT_COLOR = ColorConstants.lightGray;
        try {
            Field ellipsis = org.eclipse.draw2d.text.TextFlow.class.getDeclaredField("ELLIPSIS");
            ellipsis.setAccessible(true);
            ELLIPSIS = (String)ellipsis.get(new org.eclipse.draw2d.text.TextFlow());
        }
        catch (SecurityException e) {
            ExceptionHandler.handle(e);
        }
        catch (NoSuchFieldException e) {
            ExceptionHandler.handle(e);
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle(e);
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.handle(e);
        }
        try {
            TRUNCATED = TextFragmentBox.class.getDeclaredField("truncated");
            TRUNCATED.setAccessible(true);
        }
        catch (SecurityException e) {
            ExceptionHandler.handle(e);
        }
        catch (NoSuchFieldException e) {
            ExceptionHandler.handle(e);
        }
        try {
            LINE_ROOT = ContentBox.class.getDeclaredField("lineRoot");
            LINE_ROOT.setAccessible(true);
        }
        catch (SecurityException e) {
            ExceptionHandler.handle(e);
        }
        catch (NoSuchFieldException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void paintTo(Graphics g, Point translationPoint) {
        this.paintTo(g, translationPoint.x, translationPoint.y);
    }

    public void paintTo(Graphics g, int xoff, int yoff) {
        List fragments = this.getFragments();
        assert (this.getFont().getFontData().length > 0);
        int lineWidth = this.getFont().getFontData()[0].getHeight() / LINE_FACTOR + 1;
        if (fragments.size() > 0) {
            int index = 0;
            boolean isMirrored = this.isMirrored();
            while ((index = this.paintLineTo(g, xoff, yoff, lineWidth, index, isMirrored)) != -1) {
            }
        }
        g.restoreState();
    }

    public void paintTo_old(Graphics g, int xoff, int yoff) {
        List fragments = this.getFragments();
        assert (this.getFont().getFontData().length > 0);
        int lineWidth = this.getFont().getFontData()[0].getHeight() / LINE_FACTOR + 1;
        int totalHeight = 0;
        int i = 0;
        while (i < fragments.size()) {
            totalHeight += ((TextFragmentBox)fragments.get(i)).getAscent() + ((TextFragmentBox)fragments.get(i)).getDescent();
            ++i;
        }
        i = 0;
        while (i < fragments.size()) {
            TextFragmentBox frag = (TextFragmentBox)fragments.get(i);
            String draw = null;
            try {
                draw = TRUNCATED != null && TRUNCATED.getBoolean(frag) ? String.valueOf(this.getText().substring(frag.offset, frag.offset + frag.length)) + ELLIPSIS : this.getText().substring(frag.offset, frag.offset + frag.length);
            }
            catch (IllegalArgumentException e) {
                ExceptionHandler.handle(e);
            }
            catch (IllegalAccessException e) {
                ExceptionHandler.handle(e);
            }
            int linew = FigureUtilities.getTextWidth(draw, (Font)g.getFont());
            frag.setWidth(linew);
            int left = this.calculateLeft(this.getSize().width, frag.getWidth());
            int top = this.calculateTop(this.getSize().height, totalHeight);
            int realX = frag.getX() + left + xoff;
            int realY = frag.getBaseline() - frag.getAscent() + top + yoff;
            if (!this.isEnabled()) {
                g.setForegroundColor(ColorConstants.buttonDarker);
                this.paintSpecial_old(g, draw, realX, realY, i == 0);
            } else {
                this.paintSpecial_old(g, draw, realX, realY, i == 0);
            }
            if (frag.getWidth() > 1) {
                g.setLineWidth(lineWidth);
                if ("underline".equals(this.textUnderline)) {
                    g.drawLine(realX, frag.getBaseline() + top + frag.getDescent() - lineWidth, realX + frag.getWidth(), frag.getBaseline() + top + frag.getDescent() - lineWidth);
                }
                if ("line-through".equals(this.textLineThrough)) {
                    g.drawLine(realX, frag.getBaseline() + top - frag.getAscent() / 2 + lineWidth, realX + frag.getWidth(), frag.getBaseline() + top - frag.getAscent() / 2 + lineWidth);
                }
                if ("overline".equals(this.textOverline)) {
                    g.drawLine(realX, realY + 1, realX + frag.getWidth(), realY + 1);
                }
            }
            g.restoreState();
            ++i;
        }
    }

    private void paintSpecial_old(Graphics g, String text, int x, int y, boolean firstBox) {
        if (firstBox && this.specialPREFIX.length() != 0 && text.indexOf(this.specialPREFIX) == 0) {
            int with = FigureUtilities.getTextWidth((String)this.specialPREFIX, (Font)g.getFont());
            Color c = g.getForegroundColor();
            g.setForegroundColor(ReportColorConstants.textFillColor);
            g.drawString(this.specialPREFIX, x, y);
            g.setForegroundColor(c);
            g.drawString(text.substring(this.specialPREFIX.length()), x + with, y);
        } else {
            g.drawString(text, x, y);
        }
    }

    private int paintLineTo(Graphics g, int xoff, int yoff, int lineWidth, int fragIndex, boolean isMirrored) {
        LineRoot prevLineRoot;
        List fragments = this.getFragments();
        if (fragments == null) {
            return -1;
        }
        int nFragments = fragments.size();
        if (nFragments < 1 || fragIndex >= nFragments) {
            return -1;
        }
        TextFragmentBox frag = (TextFragmentBox)fragments.get(fragIndex);
        int totalHeight = frag.getAscent() + frag.getDescent();
        int totalWidth = 0;
        String[] draws = new String[nFragments - fragIndex];
        LineRoot lineRoot = null;
        try {
            lineRoot = prevLineRoot = (LineRoot)LINE_ROOT.get(frag);
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle(e);
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.handle(e);
        }
        int i = fragIndex;
        do {
            String draw = null;
            try {
                draw = TRUNCATED != null && TRUNCATED.getBoolean(frag) ? String.valueOf(this.getText().substring(frag.offset, frag.offset + frag.length)) + ELLIPSIS : this.getText().substring(frag.offset, frag.offset + frag.length);
            }
            catch (IllegalArgumentException e) {
                ExceptionHandler.handle(e);
            }
            catch (IllegalAccessException e) {
                ExceptionHandler.handle(e);
            }
            int linew = FigureUtilities.getTextWidth(draw, (Font)g.getFont());
            frag.setWidth(linew);
            totalWidth += linew;
            draws[i - fragIndex] = draw;
            if (++i >= nFragments) break;
            frag = (TextFragmentBox)fragments.get(i);
            prevLineRoot = lineRoot;
            try {
                lineRoot = (LineRoot)LINE_ROOT.get(frag);
            }
            catch (IllegalArgumentException iare) {
                ExceptionHandler.handle(iare);
            }
            catch (IllegalAccessException iace) {
                ExceptionHandler.handle(iace);
            }
        } while (fragIndex < nFragments && prevLineRoot == lineRoot);
        int retIndex = i;
        int spacing = this.calculateSpacing(this.getSize().width, totalWidth, isMirrored);
        i = fragIndex;
        while (i < retIndex) {
            frag = (TextFragmentBox)fragments.get(i);
            int fragAscent = frag.getAscent();
            int top = this.calculateTop(this.getSize().height, totalHeight);
            int realX = frag.getX() + spacing + xoff;
            int realY = frag.getBaseline() - fragAscent + top + yoff;
            if (!this.isEnabled()) {
                g.setForegroundColor(ColorConstants.buttonDarker);
                this.paintSpecial(g, draws[i - fragIndex], realX, realY, i == 0, frag.isRightToLeft(), isMirrored);
            } else {
                this.paintSpecial(g, draws[i - fragIndex], realX, realY, i == 0, frag.isRightToLeft(), isMirrored);
            }
            if (frag.getWidth() > 1) {
                g.setLineWidth(lineWidth);
                if ("underline".equals(this.textUnderline)) {
                    int fragDescent = frag.getDescent();
                    g.drawLine(realX, frag.getBaseline() + top + fragDescent - lineWidth, realX + frag.getWidth(), frag.getBaseline() + top + fragDescent - lineWidth);
                }
                if ("line-through".equals(this.textLineThrough)) {
                    g.drawLine(realX, frag.getBaseline() + top - fragAscent / 2 + lineWidth, realX + frag.getWidth(), frag.getBaseline() + top - fragAscent / 2 + lineWidth);
                }
                if ("overline".equals(this.textOverline)) {
                    g.drawLine(realX, realY + 1, realX + frag.getWidth(), realY + 1);
                }
            }
            ++i;
        }
        return retIndex;
    }

    private void paintSpecial(Graphics g, String text, int x, int y, boolean firstBox, boolean rtl, boolean isMirrored) {
        Image image = null;
        GC gc = null;
        if (rtl || isMirrored) {
            TextLayout textLayout = BidiUIUtils.INSTANCE.getTextLayout(0x2000000);
            textLayout.setFont(g.getFont());
            if (firstBox && this.specialPREFIX.length() != 0 && text.indexOf(this.specialPREFIX) == 0) {
                textLayout.setText(text.substring(this.specialPREFIX.length()));
            } else {
                textLayout.setText(text);
            }
            textLayout.setStyle(new TextStyle(g.getFont(), g.getForegroundColor(), TRANSPARENT_COLOR), 0, text.length());
            PaletteData paletteData = new PaletteData(new RGB[]{TRANSPARENT_COLOR.getRGB(), g.getForegroundColor().getRGB()});
            ImageData imageData = new ImageData(textLayout.getBounds().width + 1, textLayout.getBounds().height, 4, paletteData);
            imageData.transparentPixel = paletteData.getPixel(TRANSPARENT_COLOR.getRGB());
            image = new Image((Device)Display.getCurrent(), imageData);
            gc = new GC((Drawable)image, rtl ? 0x4000000 : 0x2000000);
            textLayout.draw(gc, 0, 0);
        }
        if (firstBox && this.specialPREFIX.length() != 0 && text.indexOf(this.specialPREFIX) == 0) {
            int with = FigureUtilities.getTextWidth((String)this.specialPREFIX, (Font)g.getFont());
            Color c = g.getForegroundColor();
            g.setForegroundColor(ReportColorConstants.greyFillColor);
            g.drawString(this.specialPREFIX, x, y);
            g.setForegroundColor(c);
            if (image != null) {
                g.drawImage(image, x + with, y);
            } else {
                g.drawString(text.substring(this.specialPREFIX.length()), x + with, y);
            }
        } else if (image != null) {
            g.drawImage(image, x, y);
        } else {
            g.drawString(text, x, y);
        }
        if (gc != null) {
            gc.dispose();
        }
        if (image != null) {
            image.dispose();
        }
    }

    protected void paintFigure(Graphics g) {
        this.paintTo(g, 0, 0);
    }

    protected int calculateLeft(int compWidth, int textWidth) {
        int rlt = 0;
        if ("left".equals(this.textAlign) || "justify".equals(this.textAlign)) {
            rlt = 0;
        } else if ("center".equals(this.textAlign)) {
            rlt = (compWidth - textWidth) / 2;
        } else if ("right".equals(this.textAlign)) {
            rlt = compWidth - textWidth;
        }
        return rlt;
    }

    private int calculateSpacing(int compWidth, int textWidth, boolean isMirrored) {
        int rlt = 0;
        String align = BidiAlignmentResolver.resolveAlignmentForDesigner((String)this.textAlign, (String)this.resolveDirection(this.direction, isMirrored), (boolean)isMirrored);
        if ("left".equals(align)) {
            rlt = 0;
        } else if ("center".equals(align)) {
            rlt = (compWidth - textWidth) / 2;
        } else if ("right".equals(align)) {
            rlt = compWidth - textWidth;
        }
        return rlt;
    }

    protected int calculateTop(int compHeight, int textHeight) {
        int rlt = 0;
        if ("top".equals(this.verticalAlign) || "baseline".equals(this.verticalAlign)) {
            rlt = 0;
        } else if ("middle".equals(this.verticalAlign)) {
            rlt = (compHeight - textHeight) / 2;
        } else if ("bottom".equals(this.verticalAlign)) {
            rlt = compHeight - textHeight;
        }
        return rlt;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextOverline(String textOverline) {
        this.textOverline = textOverline;
    }

    public void setTextLineThrough(String textLineThrough) {
        this.textLineThrough = textLineThrough;
    }

    public void setTextUnderline(String textUnderline) {
        this.textUnderline = textUnderline;
    }

    public void setVerticalAlign(String verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public void setSpecialPREFIX(String specialPREFIX) {
        if (specialPREFIX == null) {
            return;
        }
        this.specialPREFIX = specialPREFIX;
        this.repaint();
    }

    public void setDirection(String direction) {
        if ((direction = this.resolveDirection(direction)) == null && this.direction != null || direction != null && !direction.equals(this.direction)) {
            this.direction = direction;
            this.revalidateBidi((IFigure)this);
        }
    }

    public String getDirection() {
        return this.resolveDirection(this.direction);
    }

    private boolean isRtl() {
        return "rtl".equals(this.getDirection());
    }

    private String resolveDirection(String direction) {
        if (direction == null) {
            return this.isMirrored() ? "rtl" : "ltr";
        }
        return direction;
    }

    private String resolveDirection(String direction, boolean isMirrored) {
        if (direction == null) {
            return isMirrored ? "rtl" : "ltr";
        }
        return direction;
    }

    protected void contributeBidi(BidiProcessor proc) {
        proc.setOrientation(this.isRtl() ? 0x4000000 : 0x2000000);
        super.contributeBidi(proc);
    }
}

