/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MultipleEditPart;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;

public class RootDragTracker
extends AbstractTool
implements DragTracker {
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private int mode;
    private Figure marqueeRectangleFigure;
    private List allChildren = new ArrayList();
    private List selectedEditParts;
    private Request targetRequest;
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");

    protected void handleFinished() {
    }

    public RootDragTracker() {
        this.setDefaultCursor(SharedCursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    private List calculateNewSelection() {
        ArrayList<EditPart> newSelections = new ArrayList<EditPart>();
        List children = this.getAllChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            if (child.isSelectable() && !this.isInTable(child)) {
                IFigure figure = ((GraphicalEditPart)child).getFigure();
                Rectangle r = figure.getBounds().getCopy();
                figure.translateToAbsolute((Translatable)r);
                if (this.getMarqueeSelectionRectangle().contains(r.getTopLeft()) && this.getMarqueeSelectionRectangle().contains(r.getBottomRight()) && figure.isShowing() && child.getTargetEditPart(MARQUEE_REQUEST) == child && this.isFigureVisible(figure)) {
                    newSelections.add(child);
                }
            }
            ++i;
        }
        return newSelections;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isInTable(EditPart child) {
        if (child instanceof AbstractCellEditPart || child instanceof ListBandEditPart) {
            return true;
        }
        part = child.getParent();
        if (!(part instanceof MultipleEditPart)) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            if (part instanceof AbstractCellEditPart) {
                return true;
            }
            part = part.getParent();
lbl9:
            // 2 sources

            ** while (part != null)
        }
lbl10:
        // 1 sources

        return false;
    }

    private Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren = new ArrayList();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        ListIterator oldEditParts = this.selectedEditParts.listIterator();
        while (oldEditParts.hasNext()) {
            EditPart editPart = (EditPart)oldEditParts.next();
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    private List getAllChildren(EditPart editPart, List allChildren) {
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            allChildren.add(child);
            this.getAllChildren((EditPart)child, allChildren);
            ++i;
        }
        return allChildren;
    }

    private List getAllChildren() {
        if (this.allChildren.isEmpty()) {
            this.allChildren = this.getAllChildren((EditPart)this.getCurrentViewer().getRootEditPart(), new ArrayList());
        }
        return this.allChildren;
    }

    protected String getCommandName() {
        return "selection";
    }

    protected String getDebugName() {
        return "Marquee Tool";
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    private Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    private int getSelectionMode() {
        return this.mode;
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isControlKeyDown()) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateNewSelection();
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        return this.getCurrentViewer().getKeyHandler() != null && this.getCurrentViewer().getKeyHandler().keyPressed(e);
    }

    private boolean isFigureVisible(IFigure fig) {
        Rectangle figBounds = fig.getBounds().getCopy();
        IFigure walker = fig.getParent();
        while (!figBounds.isEmpty() && walker != null) {
            walker.translateToParent((Translatable)figBounds);
            figBounds.intersect(walker.getBounds());
            walker = walker.getParent();
        }
        return !figBounds.isEmpty();
    }

    private boolean isGraphicalViewer() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    private void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        List newSelections = this.calculateNewSelection();
        if (this.getSelectionMode() == 2) {
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                viewer.appendSelection(editPart);
                ++i;
            }
        } else if (this.getSelectionMode() == 1) {
            ArrayList<EditPart> selected = new ArrayList<EditPart>(viewer.getSelectedEditParts());
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                if (editPart.getSelected() != 0) {
                    selected.remove(editPart);
                } else {
                    selected.add(editPart);
                }
                ++i;
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(newSelections));
        }
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(SharedCursors.CROSS);
        } else {
            this.setDefaultCursor(SharedCursors.NO);
        }
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    private void showMarqueeFeedback() {
        Rectangle rect = this.getMarqueeSelectionRectangle().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
        this.getMarqueeFeedbackFigure().setBounds(rect);
    }

    private void showTargetFeedback() {
        int i = 0;
        while (i < this.selectedEditParts.size()) {
            EditPart editPart = (EditPart)this.selectedEditParts.get(i);
            editPart.showTargetFeedback(this.getTargetRequest());
            ++i;
        }
    }

    class MarqueeRectangleFigure
    extends Figure {
        private int offset = 0;
        private boolean schedulePaint = true;
        private static final int DELAY = 110;

        MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, bounds.width - 1, 0, bounds.width - 1, bounds.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = bounds.height - 1;
            points[4] = bounds.width - 1;
            points[5] = bounds.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(){

                    public void run() {
                        MarqueeRectangleFigure marqueeRectangleFigure = MarqueeRectangleFigure.this;
                        marqueeRectangleFigure.offset = marqueeRectangleFigure.offset + 1;
                        if (MarqueeRectangleFigure.this.offset > 5) {
                            MarqueeRectangleFigure.this.offset = 0;
                        }
                        MarqueeRectangleFigure.this.schedulePaint = true;
                        MarqueeRectangleFigure.this.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }
    }
}

