/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.ReportDesignMarginBorder;
import org.eclipse.birt.report.designer.internal.ui.layout.AbstractPageFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

public class ReportDesignLayout
extends AbstractPageFlowLayout {
    private boolean isAuto = false;
    private int maxWidth = -1;
    private int maxHeight = -1;

    public ReportDesignLayout(GraphicalEditPart owner) {
        super(owner);
    }

    private void initLayout() {
        this.maxHeight = -1;
        this.maxWidth = -1;
    }

    public void layout(IFigure parent) {
        ReportDesignMarginBorder reportDesignMarginBorder;
        this.initLayout();
        super.layout(parent);
        Dimension extend = new Dimension(this.getInitInsets().getWidth(), this.getInitInsets().getHeight());
        Dimension prefSize = new Dimension(this.maxWidth, this.maxHeight).expand(extend);
        Rectangle bounds = parent.getBounds().getCopy();
        bounds.height = Math.max(prefSize.height, this.getInitSize().height);
        if (bounds.width < this.getInitSize().width) {
            bounds.width = this.getInitSize().width;
        }
        AbstractPageFlowLayout.Result result = this.getReportBounds(bounds);
        bounds = result.reportSize;
        Rectangle rect = new Rectangle(0, 0, bounds.x + bounds.width + result.rightSpace, bounds.y + bounds.height + result.bottomSpace);
        ReportDesignMarginBorder border = (ReportDesignMarginBorder)parent.getBorder();
        Insets insets = border.getInsets(parent);
        int contentWidth = this.maxWidth - this.getInitSize().width + this.getInitInsets().getWidth();
        if (insets.right < contentWidth) {
            reportDesignMarginBorder = new ReportDesignMarginBorder(new Insets(insets.top, insets.left, insets.bottom, contentWidth));
            reportDesignMarginBorder.setBackgroundColor(border.getBackgroundColor());
            parent.setBorder((Border)reportDesignMarginBorder);
            bounds.width = bounds.width + contentWidth - insets.right;
        } else if (this.getInitInsets().right > contentWidth && insets.right != this.getInitInsets().right) {
            reportDesignMarginBorder = new ReportDesignMarginBorder(new Insets(insets.top, insets.left, insets.bottom, this.getInitInsets().right));
            reportDesignMarginBorder.setBackgroundColor(border.getBackgroundColor());
            parent.setBorder((Border)reportDesignMarginBorder);
            bounds.width = this.getInitSize().width;
        } else if (insets.right > contentWidth && this.getInitInsets().right < contentWidth) {
            reportDesignMarginBorder = new ReportDesignMarginBorder(new Insets(insets.top, insets.left, insets.bottom, contentWidth));
            reportDesignMarginBorder.setBackgroundColor(border.getBackgroundColor());
            parent.setBorder((Border)reportDesignMarginBorder);
            bounds.width = bounds.width + contentWidth - insets.right;
        }
        this.setViewProperty(rect, bounds);
        Rectangle temp = bounds.getCopy();
        temp.width = this.getInitSize().width;
        this.getOwner().getViewer().setProperty("Ruler Size", (Object)new Rectangle(bounds.x, bounds.y, this.getInitSize().width, bounds.height));
        parent.setBounds(bounds);
    }

    void postLayoutRow(ReportFlowLayout.WorkingData data) {
        if (data.rowY > this.maxHeight) {
            this.maxHeight = data.rowY;
        }
        if (data.rowWidth > this.maxWidth) {
            this.maxWidth = data.rowWidth;
        }
    }

    public boolean isAuto() {
        return this.isAuto;
    }

    public void setAuto(boolean isAuto) {
        this.isAuto = isAuto;
    }
}

