/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.resourcelocator;

import java.net.URL;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.FragmentResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.PathResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.util.URIUtil;

public class ResourceLocator {
    public static ResourceEntry[] getRootEntries() {
        return ResourceLocator.getRootEntries(null);
    }

    public static ResourceEntry[] getRootEntries(String[] fileNamePattern) {
        FragmentResourceEntry systemResource = new FragmentResourceEntry(fileNamePattern);
        PathResourceEntry sharedResource = new PathResourceEntry(fileNamePattern);
        if (systemResource.hasChildren()) {
            return new ResourceEntry[]{systemResource, sharedResource};
        }
        return new ResourceEntry[]{sharedResource};
    }

    public static ResourceEntry[] getResourceFolder(String[] fileNamePattern) {
        return new ResourceEntry[]{new PathResourceEntry(fileNamePattern)};
    }

    public static String relativize(String filePath) {
        return URIUtil.getRelativePath((String)ReportPlugin.getDefault().getResourceFolder(), (String)filePath);
    }

    public static String relativize(URL url) {
        if (url.getProtocol().equals("file")) {
            return ResourceLocator.relativize(url.toString());
        }
        return url.getFile();
    }
}

