/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractElementAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.gef.Request;

public class InsertAction
extends AbstractElementAction {
    public static final String ID = "org.eclipse.birt.report.designer.ui.views.action.InsertAction";
    public static final String ABOVE = "above";
    public static final String BELOW = "below";
    public static final String CURRENT = "current";
    private static final String TEXT = Messages.getString((String)"InsertAction.text");
    private SlotHandle slotHandle;
    private String position;
    private String type = null;

    public InsertAction(Object selectedObject) {
        this(selectedObject, TEXT);
    }

    public InsertAction(Object selectedObject, String text) {
        this(selectedObject, text, null);
    }

    public InsertAction(Object selectedObject, String text, String type) {
        this(selectedObject, text, type, CURRENT);
    }

    public InsertAction(Object selectedObject, String text, String type, String pos) {
        this(selectedObject, text, null, type, pos);
    }

    public InsertAction(Object selectedObject, String text, SlotHandle slotHandle, String type, String pos) {
        super(selectedObject, text);
        this.type = type;
        this.position = pos;
        this.slotHandle = slotHandle != null ? slotHandle : this.getDefaultSlotHandle();
    }

    public boolean isEnabled() {
        if (this.getSelection() instanceof SlotHandle && ((SlotHandle)this.getSelection()).getSlotID() == 1 && ((SlotHandle)this.getSelection()).getElementHandle() instanceof ListingHandle) {
            return ((SlotHandle)this.getSelection()).canContain("TableGroup");
        }
        return super.isEnabled();
    }

    private SlotHandle getDefaultSlotHandle() {
        int slotId;
        Object obj = this.getSelection();
        if (obj instanceof SlotHandle) {
            return (SlotHandle)obj;
        }
        DesignElementHandle handle = (DesignElementHandle)obj;
        if (this.position == CURRENT && (slotId = DEUtil.getDefaultSlotID((Object)handle)) != -1) {
            return handle.getSlot(slotId);
        }
        return handle.getContainerSlotHandle();
    }

    protected boolean doAction() throws Exception {
        Request request = new Request((Object)"insert");
        HashMap<String, Object> extendsData = new HashMap<String, Object>();
        extendsData.put("insert-slot", this.slotHandle);
        if (this.type != null) {
            extendsData.put("insert-type", this.type);
        }
        extendsData.put("insert-position", this.position);
        request.setExtendedData(extendsData);
        boolean bool = ProviderFactory.createProvider(this.getSelection()).performRequest(this.getSelection(), request);
        if (bool) {
            ArrayList list = new ArrayList();
            list.add(request.getExtendedData().get("result"));
            ReportRequest r = new ReportRequest();
            r.setType((Object)"create element");
            r.setSelectionObject(list);
            SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
        }
        return bool;
    }
}

