/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.SpinnerTime;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

class SpinnerTimeText
extends Text {
    String value = "0";
    int limit;
    private String chnageName = "";
    private ArrayList listenerList = new ArrayList();

    public SpinnerTimeText(Composite parent, int style, int limit, String name) {
        super(parent, style);
        this.setTextLimit(2);
        this.limit = limit;
        this.chnageName = name;
        this.setFont(FontManager.getFont((String)"Dialog", (int)10, (int)1));
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SpinnerTimeText.this.setValue(SpinnerTimeText.this.getText());
            }

            public void focusGained(FocusEvent e) {
                SpinnerTime.defaultText = SpinnerTimeText.this;
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    SpinnerTimeText.this.setValue(SpinnerTimeText.this.getText());
                }
            }
        });
    }

    protected void checkWidget() {
    }

    protected void checkSubclass() {
    }

    public String getValue() {
        return this.value;
    }

    public void setChangeName(String name) {
        this.chnageName = name;
    }

    public String getChangeName() {
        return this.chnageName;
    }

    public void setValue(String va) {
        int intValue;
        try {
            intValue = Integer.parseInt(va);
        }
        catch (Exception exception) {
            this.setText(this.value);
            return;
        }
        if ((intValue %= this.limit) < 0) {
            intValue += this.limit;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(new Object(), this.getChangeName(), (Object)new Integer(Integer.parseInt(this.value)), (Object)new Integer(intValue));
        this.firePropertyListener(event);
        this.value = String.valueOf(intValue);
        this.setText(this.value);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove(listener);
    }

    public void firePropertyListener(PropertyChangeEvent e) {
        int size = this.listenerList.size();
        int i = 0;
        while (i < size) {
            IPropertyChangeListener listener = (IPropertyChangeListener)this.listenerList.get(i);
            listener.propertyChange(e);
            ++i;
        }
    }
}

