/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ReportGraphicsViewPainter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.ImageCanvas;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.osgi.framework.Bundle;

public class WizardTemplateChoicePage
extends WizardPage {
    protected static Logger logger = Logger.getLogger(WizardTemplateChoicePage.class.getName());
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};
    private static final String MESSAGE_DESCRIPTION = Messages.getString((String)"WizardTemplateChoicePage.label.Description");
    private static final String MESSAGE_PREVIEW = Messages.getString((String)"WizardTemplateChoicePage.label.Preview");
    private static final String MESSAGE_REPORT_TEMPLATES = Messages.getString((String)"WizardTemplateChoicePage.label.ReportTemplates");
    private static final String MESSAGE_SHOW_CHEATSHEET = Messages.getString((String)"WizardTemplateChoicePage.label.ShowCheatSheets");
    private ImageCanvas previewCanvas;
    private Button chkBox;
    private static final String MESSAGE_RTL_BIDI = Messages.getString((String)"WizardTemplateChoicePage.label.rtlBiDiOrientation");
    private static final String MESSAGE_LTR_BIDI = Messages.getString((String)"WizardTemplateChoicePage.label.ltrBiDiOrientation");
    private static final String MESSAGE_CHOOSE_BIDI_DIR = Messages.getString((String)"WizardTemplateChoicePage.label.chooseBiDiDirection");
    public final int LTR_DIRECTION_INDX = 0;
    public final int RTL_DIRECTION_INDX = 1;
    private Label directionLabel;
    private Combo directionCombo;
    boolean isLTRDirection = ReportPlugin.getDefault().getLTRReportDirection();
    private boolean isModified = false;
    private Label description;
    Image thumbnailImage;
    protected List templates = new ArrayList();
    protected int selectedIndex;
    protected Map imageMap;
    private Composite previewPane;
    private org.eclipse.swt.widgets.List templateList;
    private Listener templateListener = new Listener(){

        public void handleEvent(Event event) {
            WizardTemplateChoicePage.this.selectedIndex = WizardTemplateChoicePage.this.templateList.getSelectionIndex();
            if (WizardTemplateChoicePage.this.selectedIndex < 0) {
                return;
            }
            ReportDesignHandle handle = (ReportDesignHandle)WizardTemplateChoicePage.this.templates.get(WizardTemplateChoicePage.this.selectedIndex);
            String ReprotDescription = handle.getDescription();
            if (ReprotDescription != null && ReprotDescription.trim().length() != 0) {
                if (WizardTemplateChoicePage.this.isPredifinedTemplate(handle.getFileName())) {
                    WizardTemplateChoicePage.this.description.setText(Messages.getString((String)ReprotDescription));
                } else {
                    WizardTemplateChoicePage.this.description.setText(ReprotDescription);
                }
            } else {
                WizardTemplateChoicePage.this.description.setText("");
            }
            WizardTemplateChoicePage.this.previewPane.layout();
            String key = handle.getIconFile();
            if (key != null && key.trim().length() != 0 && !WizardTemplateChoicePage.this.checkExtensions(key)) {
                key = null;
            }
            Image img = null;
            if (handle.getThumbnail() != null && handle.getThumbnail().length != 0) {
                byte[] thumbnailData = handle.getThumbnail();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(thumbnailData);
                if (WizardTemplateChoicePage.this.thumbnailImage != null) {
                    WizardTemplateChoicePage.this.thumbnailImage.dispose();
                    WizardTemplateChoicePage.this.thumbnailImage = null;
                }
                WizardTemplateChoicePage.this.thumbnailImage = new Image(null, (InputStream)inputStream);
                WizardTemplateChoicePage.this.previewCanvas.clear();
                WizardTemplateChoicePage.this.previewCanvas.loadImage(WizardTemplateChoicePage.this.thumbnailImage);
            } else if (key != null && !"".equals(key.trim())) {
                URL url = WizardTemplateChoicePage.this.getPreviewImageURL(handle.getFileName(), key);
                if (url != null) {
                    try {
                        key = FileLocator.resolve((URL)url).getPath();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    img = (Image)WizardTemplateChoicePage.this.imageMap.get(key);
                    if (img == null) {
                        try {
                            url = new URL("file://" + key);
                            img = ImageManager.getInstance().loadImage(url);
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        if (img != null) {
                            WizardTemplateChoicePage.this.imageMap.put(key, img);
                        }
                    }
                    WizardTemplateChoicePage.this.previewCanvas.clear();
                    WizardTemplateChoicePage.this.previewCanvas.loadImage(img);
                } else {
                    key = null;
                }
            }
            if ((handle.getThumbnail() == null || handle.getThumbnail().length == 0) && key == null) {
                if (WizardTemplateChoicePage.this.thumbnailImage != null) {
                    WizardTemplateChoicePage.this.thumbnailImage.dispose();
                    WizardTemplateChoicePage.this.thumbnailImage = null;
                }
                Rectangle rect = WizardTemplateChoicePage.this.previewCanvas.getBounds();
                WizardTemplateChoicePage.this.thumbnailImage = new Image(null, rect.width, rect.height);
                ReportGraphicsViewPainter painter = new ReportGraphicsViewPainter(handle);
                painter.paint((Drawable)WizardTemplateChoicePage.this.thumbnailImage, (Device)WizardTemplateChoicePage.this.previewCanvas.getDisplay(), rect);
                painter.dispose();
                WizardTemplateChoicePage.this.previewCanvas.clear();
                WizardTemplateChoicePage.this.previewCanvas.loadImage(WizardTemplateChoicePage.this.thumbnailImage);
            }
            if (handle.getCheatSheet() != null && handle.getCheatSheet().trim().length() != 0) {
                WizardTemplateChoicePage.this.chkBox.setEnabled(!handle.getCheatSheet().equals("") && !handle.getCheatSheet().equals("org.eclipse.birt.report.designer.ui.cheatsheet.firstreport"));
                WizardTemplateChoicePage.this.chkBox.setSelection(true);
            } else {
                WizardTemplateChoicePage.this.chkBox.setSelection(false);
                WizardTemplateChoicePage.this.chkBox.setEnabled(false);
            }
        }
    };

    public void setLTRDirection(boolean isLTRDirection) {
        if (!this.isModified) {
            this.isLTRDirection = isLTRDirection;
            this.reSelectDirectionCombo();
        }
    }

    public WizardTemplateChoicePage(String pageName) {
        super(pageName);
        this.imageMap = new HashMap();
        if (UIUtil.getFragmentDirectory() == null) {
            return;
        }
        ReportDesignHandle[] predefinedTemplateArray = this.getAllTemplates(UIUtil.getFragmentDirectory(), "/templates/");
        this.SortPredefinedTemplates(predefinedTemplateArray);
        if (predefinedTemplateArray != null && predefinedTemplateArray.length > 0) {
            this.templates.addAll((Collection)Arrays.asList(predefinedTemplateArray));
        }
    }

    protected ReportDesignHandle[] getAllTemplates(String root) {
        return this.getAllTemplates(root, null);
    }

    protected ReportDesignHandle[] getAllTemplates(String root, String path) {
        if (root == null || root.trim().length() <= 0) {
            return null;
        }
        ReportDesignHandle[] templateArray = null;
        File templateDirectory = null;
        templateDirectory = path == null ? new File(root, File.separator) : new File(root, String.valueOf(path) + File.separator);
        if (templateDirectory.isDirectory()) {
            if (!templateDirectory.exists()) {
                templateDirectory.mkdirs();
            }
            File[] filesArray = templateDirectory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".rpttemplate");
                }
            });
            ArrayList<ModuleHandle> reportDesingHandleList = new ArrayList<ModuleHandle>();
            int i = 0;
            while (i < filesArray.length) {
                try {
                    ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getSessionHandle().openModule(filesArray[i].getAbsolutePath());
                    if (moduleHandle != null && moduleHandle instanceof ReportDesignHandle) {
                        reportDesingHandleList.add(moduleHandle);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            int count = reportDesingHandleList.size();
            templateArray = new ReportDesignHandle[count];
            int i2 = 0;
            while (i2 < count) {
                templateArray[i2] = (ReportDesignHandle)reportDesingHandleList.get(i2);
                ++i2;
            }
        }
        return templateArray;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.NewReportCopyWizard_ID");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Label label0 = new Label(composite, 0);
        label0.setText(MESSAGE_REPORT_TEMPLATES);
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText(MESSAGE_PREVIEW);
        GridData data = new GridData(1);
        previewLabel.setLayoutData((Object)data);
        this.templateList = new org.eclipse.swt.widgets.List(composite, 2304);
        int predefinedCount = this.templates.size();
        this.createCustomTemplateList();
        int i = 0;
        while (i < this.templates.size()) {
            if (this.templates.get(i) != null) {
                if (i <= predefinedCount) {
                    String displayName = ((ReportDesignHandle)this.templates.get(i)).getDisplayName();
                    if (displayName != null) {
                        this.templateList.add(Messages.getString((String)displayName));
                    } else {
                        this.templateList.add(Messages.getString((String)((ReportDesignHandle)this.templates.get(i)).getFileName()));
                    }
                } else {
                    this.templateList.add(((ReportDesignHandle)this.templates.get(i)).getDisplayName());
                }
            }
            ++i;
        }
        data = new GridData(1041);
        data.widthHint = 200;
        this.templateList.setLayoutData((Object)data);
        this.previewPane = new Composite(composite, 0);
        data = new GridData(1808);
        this.previewPane.setLayoutData((Object)data);
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        this.previewPane.setLayout((Layout)gridLayout);
        Composite previewComposite = new Composite(this.previewPane, 2048);
        data = new GridData(1);
        data.heightHint = 229;
        data.widthHint = 184;
        previewComposite.setLayoutData((Object)data);
        previewComposite.setLayout((Layout)new FormLayout());
        this.previewCanvas = new ImageCanvas(previewComposite);
        FormData formData = new FormData(184, 229);
        formData.left = new FormAttachment((Control)previewComposite);
        formData.top = new FormAttachment((Control)previewComposite);
        this.previewCanvas.setLayoutData(formData);
        Label descriptionTitle = new Label(this.previewPane, 0);
        descriptionTitle.setText(MESSAGE_DESCRIPTION);
        data = new GridData(768);
        descriptionTitle.setLayoutData((Object)data);
        this.description = new Label(this.previewPane, 64);
        data = new GridData(768);
        data.widthHint = 184;
        data.horizontalIndent = 20;
        this.description.setLayoutData((Object)data);
        new Label(this.previewPane, 0);
        this.chkBox = new Button(composite, 32);
        this.chkBox.setText(MESSAGE_SHOW_CHEATSHEET);
        this.chkBox.setSelection(ReportPlugin.readCheatSheetPreference());
        this.chkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReportPlugin.writeCheatSheetPreference(WizardTemplateChoicePage.this.chkBox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ReportPlugin.writeCheatSheetPreference(WizardTemplateChoicePage.this.chkBox.getSelection());
            }
        });
        this.addBidiPart(composite);
        this.hookListeners();
        if (this.templateList.getItemCount() > 0) {
            this.templateList.select(0);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
        this.templateListener.handleEvent(new Event());
        this.setControl((Control)composite);
    }

    private void addBidiPart(Composite composite) {
        new Label(composite, 0);
        Composite bidiComposite = new Composite(composite, 0);
        GridData bidiGridData = new GridData(768);
        bidiGridData.horizontalSpan = 2;
        bidiComposite.setLayoutData((Object)bidiGridData);
        GridLayout bidiGridLayout = new GridLayout();
        bidiGridLayout.numColumns = 3;
        bidiGridLayout.marginHeight = 10;
        bidiGridLayout.marginWidth = 5;
        bidiGridLayout.horizontalSpacing = 5;
        bidiGridLayout.verticalSpacing = 10;
        bidiGridLayout.makeColumnsEqualWidth = false;
        bidiComposite.setLayout((Layout)bidiGridLayout);
        bidiGridData = new GridData();
        this.directionLabel = new Label(bidiComposite, 0);
        this.directionLabel.setText(MESSAGE_CHOOSE_BIDI_DIR);
        this.directionLabel.setLayoutData((Object)bidiGridData);
        this.directionCombo = new Combo(bidiComposite, 12);
        this.directionCombo.add(MESSAGE_LTR_BIDI, 0);
        this.directionCombo.add(MESSAGE_RTL_BIDI, 1);
        bidiGridData = new GridData();
        bidiGridData.grabExcessHorizontalSpace = true;
        bidiGridData.widthHint = 200;
        bidiGridData.horizontalIndent = 20;
        this.directionCombo.setLayoutData((Object)bidiGridData);
        this.reSelectDirectionCombo();
        this.directionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WizardTemplateChoicePage.this.isLTRDirection = WizardTemplateChoicePage.this.directionCombo.getSelectionIndex() == 0;
                WizardTemplateChoicePage.this.isModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void reSelectDirectionCombo() {
        if (this.directionCombo != null) {
            this.directionCombo.select(this.isLTRDirection ? 0 : 1);
        }
    }

    private void createCustomTemplateList() {
        String templateRoot = ReportPlugin.getDefault().getTemplatePreference();
        if (templateRoot == null || templateRoot.trim().length() == 0) {
            return;
        }
        File preTemplateDirectory = new File(UIUtil.getFragmentDirectory(), "/templates/");
        File cusTemplateDirectory = new File(templateRoot.trim());
        if (preTemplateDirectory != null && cusTemplateDirectory != null && preTemplateDirectory.equals(cusTemplateDirectory)) {
            return;
        }
        ReportDesignHandle[] customTmplateArray = this.getAllTemplates(templateRoot.trim());
        if (customTmplateArray != null) {
            this.templates.addAll((Collection)Arrays.asList(customTmplateArray));
        }
    }

    private void hookListeners() {
        this.templateList.addListener(13, this.templateListener);
    }

    public ReportDesignHandle getTemplate() {
        if (this.selectedIndex < 0) {
            return null;
        }
        return (ReportDesignHandle)this.templates.get(this.selectedIndex);
    }

    public boolean getShowCheatSheet() {
        if (((ReportDesignHandle)this.templates.get(this.selectedIndex)).getCheatSheet() != null && ((ReportDesignHandle)this.templates.get(this.selectedIndex)).getCheatSheet().equals("org.eclipse.birt.report.designer.ui.cheatsheet.firstreport")) {
            return true;
        }
        return this.chkBox.getSelection();
    }

    public void dispose() {
        super.dispose();
        for (Object item : this.templates) {
            if (!(item instanceof ReportDesignHandle)) continue;
            ((ReportDesignHandle)item).close();
        }
        if (this.thumbnailImage != null) {
            this.thumbnailImage.dispose();
            this.thumbnailImage = null;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().setFocus();
        }
    }

    private boolean isPredifinedTemplate(String sourceFileName) {
        String predifinedDir = UIUtil.getFragmentDirectory();
        if (predifinedDir == null || predifinedDir.length() <= 0) {
            return false;
        }
        File predifinedFile = new File(predifinedDir);
        File sourceFile = new File(sourceFileName);
        return sourceFile.getAbsolutePath().startsWith(predifinedFile.getAbsolutePath());
    }

    private void SortPredefinedTemplates(ReportDesignHandle[] predefinedTemplateArray) {
        if (predefinedTemplateArray == null || predefinedTemplateArray.length <= 1) {
            return;
        }
        String[] predefinedTemplateFileName = new String[]{"blank_report.rpttemplate", "my_first_report.rpttemplate", "simple_listing.rpttemplate", "grouped_listing.rpttemplate", "grouped_listing_column_heading.rpttemplate", "dual_column_listing.rpttemplate", "chart_listing.rpttemplate", "dual_column_chart_listing.rpttemplate", "sidebyside_chart_listing.rpttemplate"};
        int predefinedTemplateCount = predefinedTemplateFileName.length;
        ReportDesignHandle swapHandle = null;
        String templateName = null;
        int index = 0;
        int i = 0;
        while (i < predefinedTemplateCount) {
            templateName = predefinedTemplateFileName[i];
            int j = index;
            while (j < predefinedTemplateArray.length) {
                if (predefinedTemplateArray[j].getFileName().endsWith(templateName)) {
                    if (index != j) {
                        swapHandle = predefinedTemplateArray[j];
                        predefinedTemplateArray[j] = predefinedTemplateArray[index];
                        predefinedTemplateArray[index] = swapHandle;
                    }
                    ++index;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private URL getPreviewImageURL(String reportFileName, String key) {
        String path;
        URL url = null;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.resources");
        if (bundle == null) {
            return null;
        }
        url = bundle.getResource(key);
        if (url == null && (url = this.resolveURL(new File(path = ReportPlugin.getDefault().getResourceFolder(), key))) == null) {
            url = this.resolveURL(new File(key));
        }
        return url;
    }

    private URL resolveURL(File file) {
        if (file.exists() && file.isFile()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    private boolean checkExtensions(String fileName) {
        int i = 0;
        while (i < IMAGE_TYPES.length) {
            if (fileName.toLowerCase().endsWith(IMAGE_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLTRDirection() {
        return this.isLTRDirection;
    }
}

