/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.designer.core.model.LibRootModel;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.IReportEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ImageEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.LabelEditPart;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.AbstractMultiPageEditor;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;

public abstract class BaseInsertMenuAction
extends SelectionAction {
    protected static final String STACK_MSG_INSERT_ELEMENT = Messages.getString((String)"BaseInsertMenuAction.stackMsg.insertElement");
    private String insertType;
    protected SlotHandle slotHandle;
    protected PropertyHandle propertyHandle;
    private Object model;

    public BaseInsertMenuAction(IWorkbenchPart part, String type) {
        super(part);
        this.insertType = type;
    }

    protected boolean calculateEnabled() {
        this.slotHandle = this.getDefaultSlotHandle(this.insertType);
        this.propertyHandle = this.getDefaultPropertyHandle(this.insertType);
        Object obj = this.slotHandle;
        if (obj == null) {
            obj = this.model;
        }
        return DNDUtil.handleValidateTargetCanContainType((Object)obj, (String)this.insertType) && DNDUtil.handleValidateTargetCanContainMore((Object)obj, (int)0);
    }

    private PropertyHandle getDefaultPropertyHandle(String insertType) {
        IStructuredSelection models = InsertInLayoutUtil.editPart2Model(this.getSelection());
        if (models.isEmpty()) {
            return null;
        }
        this.model = DNDUtil.unwrapToModel((Object)models.getFirstElement());
        if (this.model instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)this.model;
            String contentName = DEUtil.getDefaultContentName((Object)handle);
            if (handle.canContain(contentName, insertType)) {
                return handle.getPropertyHandle(contentName);
            }
            this.model = handle.getContainer();
            return handle.getContainerPropertyHandle();
        }
        return null;
    }

    private SlotHandle getDefaultSlotHandle(String insertType) {
        IStructuredSelection models = InsertInLayoutUtil.editPart2Model(this.getSelection());
        if (models.isEmpty()) {
            return null;
        }
        this.model = DNDUtil.unwrapToModel((Object)models.getFirstElement());
        if (this.model instanceof LibRootModel) {
            this.model = ((LibRootModel)this.model).getModel();
        }
        if (this.model instanceof SlotHandle) {
            return (SlotHandle)this.model;
        }
        if (this.model instanceof DesignElementHandle) {
            int slotId;
            DesignElementHandle handle = (DesignElementHandle)this.model;
            if (handle.getDefn().isContainer() && handle.canContain(slotId = DEUtil.getDefaultSlotID((Object)handle), insertType)) {
                return handle.getSlot(slotId);
            }
            return handle.getContainerSlotHandle();
        }
        return null;
    }

    protected Request insertElement() throws Exception {
        Request request = new Request((Object)"insert");
        HashMap<String, Object> extendsData = new HashMap<String, Object>();
        if (this.slotHandle != null) {
            extendsData.put("insert-slot", this.slotHandle);
        } else if (this.propertyHandle != null) {
            extendsData.put("insert-property", this.propertyHandle);
        }
        extendsData.put("insert-type", this.insertType);
        extendsData.put("insert-position", "below");
        request.setExtendedData(extendsData);
        Object obj = this.model;
        if (this.slotHandle != null) {
            obj = this.slotHandle.getElementHandle();
        }
        if (ProviderFactory.createProvider(obj).performRequest(this.model, request)) {
            return request;
        }
        return null;
    }

    protected void selectElement(final Object element, final boolean edit) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (element instanceof ReportItemHandle) {
                    IEditorPart activeEditor;
                    IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
                    IFormPage epart = null;
                    if (part instanceof AbstractMultiPageEditor) {
                        epart = ((AbstractMultiPageEditor)part).getActivePageInstance();
                    } else if (part instanceof IReportEditor && (activeEditor = ((IReportEditor)part).getEditorPart()) instanceof AbstractMultiPageEditor) {
                        epart = ((AbstractMultiPageEditor)activeEditor).getActivePageInstance();
                    }
                    if (epart instanceof GraphicalEditorWithFlyoutPalette) {
                        GraphicalViewer viewer = ((GraphicalEditorWithFlyoutPalette)epart).getGraphicalViewer();
                        Object cpart = viewer.getEditPartRegistry().get(element);
                        if (cpart instanceof EditPart) {
                            viewer.flush();
                            viewer.select((EditPart)cpart);
                        }
                        if (edit && cpart instanceof LabelEditPart) {
                            ((LabelEditPart)((Object)cpart)).performDirectEdit();
                        } else if (edit && cpart instanceof ImageEditPart) {
                            ((ImageEditPart)((Object)cpart)).performDirectEdit();
                        } else {
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(element);
                            ReportRequest r = new ReportRequest();
                            r.setType((Object)"create element");
                            r.setSelectionObject(list);
                            SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
                        }
                    }
                }
            }
        });
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Insert action >> Run ...");
        }
        PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getItemName().equals(this.insertType)) {
                try {
                    this.selectElement(entries[i].executeCreate(), false);
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                return;
            }
            ++i;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(STACK_MSG_INSERT_ELEMENT);
        try {
            Request req = this.insertElement();
            if (req != null) {
                stack.commit();
                this.selectElement(req.getExtendedData().get("result"), true);
                return;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        stack.rollback();
    }
}

