/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.runtime.GUIException;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceSelectionValidator;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.BirtImageLoader;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.ImageCanvas;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImageBuilder
extends BaseDialog {
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};
    private static final String[] IMAGE_FILEFILTERS = new String[]{"*.bmp;*.jpg;*.jpeg;*.jpe;*.jfif;*.gif;*.png;*.tif;*.tiff;*.ico;*.svg"};
    public static final String DLG_TITLE_NEW = Messages.getString((String)"ImageBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"ImageBuilder.DialogTitle.Edit");
    private static final String BUTTON_BROWSE_TOOLTIP = Messages.getString((String)"ImageBuilder.Button.Browser.Tooltip");
    private static final String BUTTON_IMPORT = Messages.getString((String)"ImageBuilder.Button.Import");
    private static final String BUTTON_SELECT_IMAGE_DATA = Messages.getString((String)"ImageBuilder.Button.SelectImageData");
    private static final String TYPE_URI = Messages.getString((String)"ImageBuilder.Type.URI");
    private static final String TYPE_RESOURCE_FILE = Messages.getString((String)"ImageBuilder.Type.ResourceFile");
    private static final String TYPE_EMBEDDED_IMAGE = Messages.getString((String)"ImageBuilder.Type.EmbededImage");
    private static final String TYPE_DYNAMIC_IMAGE = Messages.getString((String)"ImageBuilder.Type.DynamicImage");
    private static final String DLG_SELECT_PICTURE_LABEL = Messages.getString((String)"ImageBuilder.Label.SelectFrom");
    private static final String DLG_INSERT_BUTTON_MSG = Messages.getString((String)"ImageBuilder.Button.Insert");
    private static final String DLG_TITLE_IMPORT_FAIL = Messages.getString((String)"ImageBuilder.DialogTitle.ImportFailed");
    private static final String DLG_TITLE_LOADING_FAIL = Messages.getString((String)"ImageBuilder.DialogTitle.LoadingFailed");
    private static final String DLG_ERROR_MSG_LOADING_FAIL = Messages.getString((String)"ImageBuilder.ErrorMessage.LoadingFailed");
    private static final String DLG_ERROR_MSG_FILE_EXISTS = Messages.getString((String)"ImageBuilder.ErrorMessage.FileLoaded");
    private ImageHandle inputImage;
    private Button embedded;
    private Button uri;
    private Button dynamic;
    private Button resource;
    private Button inputButton;
    private Button importButton;
    private Button expressionButton;
    private Composite inputArea;
    private Label description;
    private ImageCanvas previewCanvas;
    private Text uriEditor;
    private org.eclipse.swt.widgets.List embeddedImageList;
    private static final int URI_TYPE = 0;
    private static final int FILE_TYPE = 1;
    private static final int EMBEDDED_TYPE = 2;
    private static final int BLOB_TYPE = 3;
    private static final Map<Integer, String> descriptionMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> uriEditorLabelMap;
    private int selectedType = -1;
    private List dataSetList = new ArrayList();
    private List inputDataSetList = new ArrayList();

    static {
        descriptionMap.put(new Integer(0), Messages.getString((String)"ImageBuilder.Description.URI"));
        descriptionMap.put(new Integer(1), Messages.getString((String)"ImageBuilder.Description.ResourceFile"));
        descriptionMap.put(new Integer(2), Messages.getString((String)"ImageBuilder.Description.Embedded"));
        descriptionMap.put(new Integer(3), Messages.getString((String)"ImageBuilder.Description.Dynamic"));
        uriEditorLabelMap = new HashMap<Integer, String>();
        uriEditorLabelMap.put(new Integer(0), Messages.getString((String)"ImageBuilder.Label.EnterURI"));
        uriEditorLabelMap.put(new Integer(1), Messages.getString((String)"ImageBuilder.Label.EnterResourceFile"));
        uriEditorLabelMap.put(new Integer(3), Messages.getString((String)"ImageBuilder.Label.EnterExpr"));
    }

    public ImageBuilder(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public ImageBuilder(Shell parentShell, String title, List dataSetList) {
        super(parentShell, title);
        this.inputDataSetList = dataSetList;
        this.dataSetList = new ArrayList(this.inputDataSetList);
    }

    private ModuleHandle getModuleHandle() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle();
    }

    protected Control createDialogArea(Composite parent) {
        if (this.inputImage == null) {
            this.inputImage = DesignElementFactory.getInstance(this.getModuleHandle()).newImage(null);
            this.setOKLabel(DLG_INSERT_BUTTON_MSG);
        }
        Composite topCompostie = (Composite)super.createDialogArea(parent);
        this.createSelectionArea(topCompostie);
        GridData topGd = new GridData(1808);
        int width = topCompostie.computeSize((int)-1, (int)-1).x;
        topGd.widthHint = width > 432 ? width : 432;
        topCompostie.setLayoutData((Object)topGd);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(topCompostie, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.description = new Label(composite, 0);
        this.description.setLayoutData((Object)new GridData(768));
        this.createInputArea(composite);
        this.createPreviewArea(composite);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ImageBuilder_ID");
        return topCompostie;
    }

    private void createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(DLG_SELECT_PICTURE_LABEL);
        label.setLayoutData((Object)new GridData(2));
        Composite selectionArea = new Composite(composite, 0);
        selectionArea.setLayout((Layout)new FillLayout(512));
        this.uri = new Button(selectionArea, 16);
        this.uri.setText(TYPE_URI);
        this.uri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(0);
            }
        });
        this.resource = new Button(selectionArea, 16);
        this.resource.setText(TYPE_RESOURCE_FILE);
        this.resource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(1);
            }
        });
        this.embedded = new Button(selectionArea, 16);
        this.embedded.setText(TYPE_EMBEDDED_IMAGE);
        this.embedded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(2);
            }
        });
        this.dynamic = new Button(selectionArea, 16);
        this.dynamic.setText(TYPE_DYNAMIC_IMAGE);
        this.dynamic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(3);
            }
        });
    }

    private void createInputArea(Composite parent) {
        this.inputArea = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 80;
        this.inputArea.setLayoutData((Object)gd);
        this.inputArea.setLayout((Layout)new GridLayout(3, false));
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData();
        gd.heightHint = 240;
        gd.widthHint = 315;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FillLayout());
        this.previewCanvas = new ImageCanvas(previewArea);
    }

    private void switchTo(int type) {
        if (type == this.selectedType) {
            return;
        }
        this.selectedType = type;
        this.clearPreview();
        this.description.setText(descriptionMap.get(new Integer(type)));
        Control[] controls = this.inputArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        this.buildInputAreaUI(type);
        this.inputArea.layout();
    }

    private void buildInputAreaUI(int type) {
        if (type == 2) {
            this.buildEmbeddedImageList();
        } else {
            this.buildURIEditor(type);
        }
        this.buildInputAreaButton(type);
    }

    private void buildURIEditor(int type) {
        Label uriEditorLabel = new Label(this.inputArea, 0);
        GridData labelGd = new GridData(768);
        labelGd.horizontalSpan = 3;
        uriEditorLabel.setLayoutData((Object)labelGd);
        uriEditorLabel.setText(uriEditorLabelMap.get(new Integer(type)));
        this.uriEditor = new Text(this.inputArea, 2052);
        GridData textGd = new GridData(768);
        this.uriEditor.setLayoutData((Object)textGd);
        this.uriEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImageBuilder.this.updateButtons();
            }
        });
        this.uriEditor.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ImageBuilder.this.preview(DEUtil.RemoveQuote((String)ImageBuilder.this.uriEditor.getText()));
            }
        });
        this.initURIEditor();
    }

    private void buildEmbeddedImageList() {
        this.embeddedImageList = new org.eclipse.swt.widgets.List(this.inputArea, 2820);
        this.embeddedImageList.setLayoutData((Object)new GridData(1808));
        this.embeddedImageList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageBuilder.this.preview();
                ImageBuilder.this.updateButtons();
            }
        });
        this.initList();
    }

    public void setOpenFileButtonImage(Button button) {
        String imageName = "Open file";
        Image image = ReportPlatformUIImages.getImage(imageName);
        GridData gd = new GridData();
        if (!Platform.getOS().equals("macosx")) {
            gd.widthHint = 20;
            gd.heightHint = 20;
        }
        button.setLayoutData((Object)gd);
        button.setImage(image);
        if (button.getImage() != null) {
            button.getImage().setBackground(button.getBackground());
        }
    }

    private void buildInputAreaButton(int type) {
        if (type == 0) {
            this.inputButton = new Button(this.inputArea, 8);
            UIUtil.setExpressionButtonImage(this.inputButton);
            this.inputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ImageBuilder.this.openExpression();
                }
            });
            new Label(this.inputArea, 0);
        } else if (type == 1) {
            this.inputButton = new Button(this.inputArea, 8);
            this.setOpenFileButtonImage(this.inputButton);
            this.inputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ImageBuilder.this.openResourceBrowser();
                }
            });
            this.inputButton.setToolTipText(BUTTON_BROWSE_TOOLTIP);
            this.expressionButton = new Button(this.inputArea, 8);
            UIUtil.setExpressionButtonImage(this.expressionButton);
            this.expressionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(ImageBuilder.this.uriEditor.getText());
                    ImageBuilder.this.unionDataSets();
                    expressionBuilder.setExpressionProvier(new ExpressionProvider((DesignElementHandle)ImageBuilder.this.inputImage));
                    if (expressionBuilder.open() == 0) {
                        String uri = expressionBuilder.getResult();
                        ImageBuilder.this.uriEditor.setText(uri);
                        ImageBuilder.this.preview(DEUtil.RemoveQuote((String)uri));
                    }
                }
            });
        } else if (type == 2) {
            this.importButton = new Button(this.inputArea, 8);
            this.importButton.setText(BUTTON_IMPORT);
            this.importButton.setLayoutData((Object)new GridData(8));
            this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileChooser = new FileDialog(ImageBuilder.this.getShell(), 4096);
                    fileChooser.setText(Messages.getString((String)"ImageBuilder.Chooser.Title"));
                    fileChooser.setFilterExtensions(IMAGE_FILEFILTERS);
                    try {
                        String fileName;
                        String fullPath = fileChooser.open();
                        if (fullPath != null && (fileName = fileChooser.getFileName()) != null) {
                            if (ImageBuilder.this.embeddedImageList.indexOf(fileName) != -1) {
                                ExceptionHandler.openMessageBox(DLG_TITLE_IMPORT_FAIL, DLG_ERROR_MSG_FILE_EXISTS, 8);
                                return;
                            }
                            if (!ImageBuilder.this.checkExtensions(fileName)) {
                                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Title"), Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Message"));
                                return;
                            }
                            ImageBuilder.this.previewCanvas.loadImage(ImageManager.getInstance().loadImage(ImageBuilder.this.inputImage.getModuleHandle(), fullPath));
                            BirtImageLoader imageLoader = new BirtImageLoader();
                            EmbeddedImage image = imageLoader.save(ImageBuilder.this.getModuleHandle(), fullPath, fileName);
                            ImageBuilder.this.embeddedImageList.add(image.getName());
                            ImageBuilder.this.embeddedImageList.select(ImageBuilder.this.embeddedImageList.indexOf(image.getName()));
                            ImageBuilder.this.updateButtons();
                        }
                    }
                    catch (Throwable e2) {
                        GUIException e2;
                        ImageBuilder.this.preview();
                        if (e2 instanceof OutOfMemoryError) {
                            e2 = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e2);
                        }
                        ExceptionHandler.handle((Throwable)e2, DLG_TITLE_LOADING_FAIL, DLG_ERROR_MSG_LOADING_FAIL);
                    }
                }
            });
            new Label(this.inputArea, 0);
        } else if (type == 3) {
            this.inputButton = new Button(this.inputArea, 8);
            this.inputButton.setText(BUTTON_SELECT_IMAGE_DATA);
            this.inputButton.setEnabled(!this.getModuleHandle().getVisibleDataSets().isEmpty());
            this.inputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ImageBuilder.this.openBidingDialog();
                }
            });
            new Label(this.inputArea, 0);
        }
    }

    protected void openResourceBrowser() {
        ResourceSelectionValidator validator = new ResourceSelectionValidator(IMAGE_TYPES);
        ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(true, true, IMAGE_FILEFILTERS);
        dialog.setTitle(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Title"));
        dialog.setMessage(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Message"));
        dialog.setValidator(validator);
        if (dialog.open() == 0) {
            this.uriEditor.setText("\"" + dialog.getPath() + "\"");
            this.preview(dialog.getPath());
        }
    }

    private void preview(String uri) {
        if (uri == null || uri.trim().length() == 0) {
            this.clearPreview();
            return;
        }
        try {
            Image image = ImageManager.getInstance().loadImage(this.inputImage.getModuleHandle(), uri);
            this.previewCanvas.loadImage(image);
        }
        catch (Exception e) {
            this.clearPreview();
            this.logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    private void preview() {
        if (this.embeddedImageList.getSelectionCount() > 0) {
            Image image = ImageManager.getInstance().getEmbeddedImage(this.inputImage.getModuleHandle(), this.embeddedImageList.getSelection()[0]);
            try {
                this.previewCanvas.loadImage(image);
                return;
            }
            catch (Exception e) {
                ExceptionHandler.handle(e, DLG_TITLE_LOADING_FAIL, DLG_ERROR_MSG_LOADING_FAIL);
            }
        }
        this.clearPreview();
    }

    private void clearPreview() {
        this.previewCanvas.clear();
    }

    protected void okPressed() {
        try {
            switch (this.selectedType) {
                case 1: {
                    this.inputImage.setFile(this.uriEditor.getText().trim());
                    break;
                }
                case 0: {
                    this.inputImage.setURL(this.uriEditor.getText().trim());
                    break;
                }
                case 2: {
                    this.inputImage.setImageName(this.embeddedImageList.getSelection()[0]);
                    break;
                }
                case 3: {
                    this.inputImage.setValueExpression(this.uriEditor.getText().trim());
                }
            }
            Image image = this.previewCanvas.getSourceImage();
            if (image != null) {
                this.inputImage.setWidth(String.valueOf(image.getBounds().width) + "px");
                this.inputImage.setHeight(String.valueOf(image.getBounds().height) + "px");
            }
            this.setResult(this.inputImage);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        super.okPressed();
    }

    public void setInput(Object input) {
        assert (input instanceof ImageHandle);
        this.inputImage = (ImageHandle)input;
        if ("none".equals(this.inputImage.getSource())) {
            this.setOKLabel(DLG_INSERT_BUTTON_MSG);
        }
    }

    protected boolean initDialog() {
        if ("embed".equals(this.inputImage.getSource())) {
            this.embedded.setSelection(true);
            this.switchTo(2);
        } else if ("expr".equals(this.inputImage.getSource())) {
            this.dynamic.setSelection(true);
            this.switchTo(3);
            this.initURIEditor();
        } else if ("file".equals(this.inputImage.getSource())) {
            this.resource.setSelection(true);
            this.switchTo(1);
            this.initURIEditor();
        } else {
            this.uri.setSelection(true);
            this.switchTo(0);
            this.initURIEditor();
        }
        return true;
    }

    private void initURIEditor() {
        String uri = "";
        if ("url".equals(this.inputImage.getSource())) {
            if (this.inputImage.getURI() != null && this.selectedType == 0) {
                uri = this.inputImage.getURI();
            }
        } else if ("file".equals(this.inputImage.getSource()) && this.inputImage.getURI() != null && this.selectedType == 1) {
            uri = this.inputImage.getURI();
        }
        if ("expr".equals(this.inputImage.getSource()) && this.selectedType == 3 && this.inputImage.getValueExpression() != null) {
            uri = this.inputImage.getValueExpression();
        }
        this.uriEditor.setText(uri);
        this.uriEditor.setFocus();
        this.clearPreview();
        if (!uri.equals("") && this.selectedType != 3) {
            this.preview(DEUtil.RemoveQuote((String)uri));
        }
    }

    private void initList() {
        String imageName;
        for (EmbeddedImageHandle handle : this.getModuleHandle().getVisibleImages()) {
            this.embeddedImageList.add(handle.getQualifiedName());
        }
        int index = -1;
        if ("embed".equals(this.inputImage.getSource()) && (imageName = this.inputImage.getImageName()) != null) {
            index = this.embeddedImageList.indexOf(imageName);
        }
        if (index != -1) {
            this.embeddedImageList.select(index);
            this.preview();
        } else {
            this.clearPreview();
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean complete = false;
        switch (this.selectedType) {
            case 3: {
                complete = !StringUtil.isBlank((String)this.uriEditor.getText());
                break;
            }
            case 0: {
                complete = !StringUtil.isBlank((String)this.uriEditor.getText());
                break;
            }
            case 2: {
                complete = this.embeddedImageList.getSelectionIndex() != -1;
                break;
            }
            case 1: {
                complete = !StringUtil.isBlank((String)this.uriEditor.getText());
            }
        }
        this.getOkButton().setEnabled(complete);
    }

    private void openExpression() {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.uriEditor.getText());
        this.unionDataSets();
        expressionBuilder.setExpressionProvier(new ExpressionProvider((DesignElementHandle)this.inputImage));
        if (expressionBuilder.open() == 0) {
            String uri = expressionBuilder.getResult();
            this.uriEditor.setText(uri);
            this.preview(DEUtil.RemoveQuote((String)uri));
        }
    }

    private void openBidingDialog() {
        ImageHandle handle = this.inputImage;
        ColumnBindingDialog dialog = new ColumnBindingDialog((ReportItemHandle)handle, PlatformUI.getWorkbench().getDisplay().getActiveShell(), true);
        if (dialog.open() == 0) {
            Object obj = DEUtil.getFirstDataSource((DesignElementHandle)handle);
            String columnExpr = obj != null && obj instanceof CubeHandle ? DEUtil.getDataExpression((String)((String)dialog.getResult())) : DEUtil.getColumnExpression((String)((String)dialog.getResult()));
            this.uriEditor.setText(columnExpr);
            try {
                this.inputImage.setValueExpression(this.uriEditor.getText().trim());
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private List unionDataSets() {
        this.dataSetList = new ArrayList(this.inputDataSetList);
        if (this.inputImage == null || this.inputImage.getDataSet() == null) {
            return this.dataSetList;
        }
        int i = this.inputDataSetList.indexOf(this.inputImage.getDataSet());
        if (i == -1) {
            this.dataSetList.add(this.inputImage.getDataSet());
        }
        return this.dataSetList;
    }

    private boolean checkExtensions(String fileName) {
        int i = 0;
        while (i < IMAGE_TYPES.length) {
            if (fileName.toLowerCase().endsWith(IMAGE_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

