/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ImportValueDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.SelectionChoiceDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.DefaultParameterDialogControlTypeHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ITableAreaModifier;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TableArea;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.NewDataSetAction;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.FormatBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectParameterDefaultValueDialog;
import org.eclipse.birt.report.designer.ui.parameters.ParameterUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ParameterDialog
extends BaseDialog {
    private static final String CHOICE_NO_DEFAULT = Messages.getString((String)"ParameterDialog.Choice.NoDefault");
    private static final String CHOICE_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Choice.DisplayText");
    private static final String CHOICE_VALUE_COLUMN = Messages.getString((String)"ParameterDialog.Choice.ValueColumn");
    private static final String CHOICE_ASCENDING = Messages.getString((String)"ParameterDialog.Choice.ASCENDING");
    private static final String CHOICE_DESCENDING = Messages.getString((String)"ParameterDialog.Choice.DESCENDING");
    private static final String CHOICE_SELECT_VALUE = Messages.getString((String)"ParameterDialog.Choice.SelectValue");
    private static final String GROUP_MORE_OPTION = Messages.getString((String)"ParameterDialog.Group.MoreOption");
    private static final String LABEL_NAME = Messages.getString((String)"ParameterDialog.Label.Name");
    private static final String LABEL_DATETIME_PROMPT = Messages.getFormattedString((String)"ParameterDialog.datetime.prompt", (Object[])new String[]{"yyyy-MM-dd HH:mm:ss.SSS"});
    private static final String LABEL_DATE_PROMPT = Messages.getFormattedString((String)"ParameterDialog.date.prompt", (Object[])new String[]{"yyyy-MM-dd"});
    private static final String LABEL_TIME_PROMPT = Messages.getFormattedString((String)"ParameterDialog.time.prompt", (Object[])new String[]{"hh:mm:ss"});
    private static final String LABEL_PROMPT_TEXT = Messages.getString((String)"ParameterDialog.Label.PromptText");
    private static final String LABEL_PARAM_DATA_TYPE = Messages.getString((String)"ParameterDialog.Label.DataType");
    private static final String LABEL_DISPALY_TYPE = Messages.getString((String)"ParameterDialog.Label.DisplayType");
    private static final String LABEL_DEFAULT_VALUE = Messages.getString((String)"ParameterDialog.Label.DefaultValue");
    private static final String LABEL_HELP_TEXT = Messages.getString((String)"ParameterDialog.Label.HelpText");
    private static final String LABEL_LIST_OF_VALUE = Messages.getString((String)"ParameterDialog.Label.ListOfValue");
    private static final String LABEL_SORT_GROUP = Messages.getString((String)"ParameterDialog.Label.SortGroup");
    private static final String LABEL_VALUES = Messages.getString((String)"ParameterDialog.Label.Value");
    private static final String LABEL_FORMAT = Messages.getString((String)"ParameterDialog.Label.Format");
    private static final String LABEL_LIST_LIMIT = Messages.getString((String)"ParameterDialog.Label.Listlimit");
    private static final String LABEL_NULL = ParameterUtil.LABEL_NULL;
    private static final String LABEL_SELECT_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Label.SelectDisplayText");
    private static final String LABEL_SELECT_VALUE_COLUMN = Messages.getString((String)"ParameterDialog.Label.SelectValueColumn");
    private static final String LABEL_SELECT_DATA_SET = Messages.getString((String)"ParameterDialog.Label.SelectDataSet");
    private static final String LABEL_PREVIEW = Messages.getString((String)"ParameterDialog.Label.Preview");
    private static final String LABEL_SORT_KEY = Messages.getString((String)"ParameterDialog.Label.SortKey");
    private static final String LABEL_SORT_DIRECTION = Messages.getString((String)"ParameterDialog.Label.SortDirection");
    private static final String CHECKBOX_ISREQUIRED = Messages.getString((String)"ParameterDialog.CheckBox.IsRequired");
    private static final String CHECKBOX_DO_NOT_ECHO = Messages.getString((String)"ParameterDialog.CheckBox.DoNotEchoInput");
    private static final String CHECKBOX_HIDDEN = Messages.getString((String)"ParameterDialog.CheckBox.Hidden");
    private static final String CHECKBOX_DISTINCT = Messages.getString((String)"ParameterDialog.CheckBox.Distinct");
    private static final String BUTTON_LABEL_CHANGE_FORMAT = Messages.getString((String)"ParameterDialog.Button.ChangeFormat");
    private static final String BUTTON_LABEL_IMPORT = Messages.getString((String)"ParameterDialog.Button.ImportValue");
    private static final String BUTTON_LABEL_SET_DEFAULT = Messages.getString((String)"ParameterDialog.Button.SetDefault");
    private static final String BUTTON_LABEL_REMOVE_DEFAULT = Messages.getString((String)"ParameterDialog.Button.RemoveDefault");
    private static final String BUTTON_CREATE_DATA_SET = Messages.getString((String)"ParameterDialog.Button.CreateDataSet");
    private static final String RADIO_DYNAMIC = Messages.getString((String)"ParameterDialog.Radio.Dynamic");
    private static final String CHECK_ALLOW_MULTI = Messages.getString((String)"ParameterDialog.Check.AllowMulti");
    private static final String RADIO_STATIC = Messages.getString((String)"ParameterDialog.Radio.Static");
    private static final String ERROR_TITLE_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorTitle.InvalidListLimit");
    private static final String ERROR_MSG_CANNOT_BE_BLANK = Messages.getString((String)"ParameterDialog.ErrorMessage.CanootBeBlank");
    private static final String ERROR_MSG_CANNOT_BE_NULL = Messages.getString((String)"ParameterDialog.ErrorMessage.CanootBeNull");
    private static final String ERROR_MSG_DUPLICATED_VALUE = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedValue");
    private static final String ERROR_MSG_DUPLICATED_LABEL = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedLabel");
    private static final String ERROR_MSG_DUPLICATED_LABELKEY = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedLabelKey");
    private static final String ERROR_MSG_MISMATCH_DATA_TYPE = Messages.getString((String)"ParameterDialog.ErrorMessage.MismatchDataType");
    private static final String ERROR_MSG_DUPLICATED_NAME = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedName");
    private static final String ERROR_MSG_NAME_IS_EMPTY = Messages.getString((String)"ParameterDialog.ErrorMessage.EmptyName");
    private static final String ERROR_MSG_NO_AVAILABLE_COLUMN = Messages.getString((String)"ParameterDialog.ErrorMessage.NoAvailableColumn");
    private static final String ERROR_MSG_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorMessage.InvalidListLimit");
    private static final String FLAG_DEFAULT = Messages.getString((String)"ParameterDialog.Flag.Default");
    private static final String COLUMN_VALUE = Messages.getString((String)"ParameterDialog.Column.Value");
    private static final String COLUMN_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Column.DisplayText");
    private static final String COLUMN_DISPLAY_TEXT_KEY = Messages.getString((String)"ParameterDialog.Column.DisplayTextKey");
    private static final String COLUMN_IS_DEFAULT = Messages.getString((String)"ParameterDialog.Column.Default");
    private static final String BOOLEAN_TRUE = Messages.getString((String)"ParameterDialog.Boolean.True");
    private static final String BOOLEAN_FALSE = Messages.getString((String)"ParameterDialog.Boolean.False");
    public static final String PARAM_CONTROL_LIST = "list-box/List";
    public static final String PARAM_CONTROL_COMBO = "list-box/Combo";
    public static final String DISPLAY_NAME_CONTROL_LIST = Messages.getString((String)"ParameterDialog.DisplayLabel.List");
    public static final String DISPLAY_NAME_CONTROL_COMBO = Messages.getString((String)"ParameterDialog.DisplayLabel.Combo");
    private static final String NONE_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Label.None");
    private static final Image DEFAULT_ICON = ReportPlatformUIImages.getImage("Default");
    private static final Image ERROR_ICON = ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
    private static final String STANDARD_DATE_TIME_PATTERN = "MM/dd/yyyy hh:mm:ss a";
    public static final String CONTROLTYPE_VALUE = "controltype";
    public static final String DATATYPE_VALUE = "datatype";
    public static final String STATIC_VALUE = "static";
    public static final String HELPER_KEY_CONTROLTYPE = "controlType";
    public static final String HELPER_KEY_STARTPOINT = "autoSuggestStartPoint";
    public static final String CONTROLTYPE_INPUTVALUE = "controltypeinput";
    public static final String STARTPOINT_INPUTVALUE = "startpointinput";
    public static final String STARTPOINT_VALUE = "startpoint";
    private boolean allowMultiValueVisible = true;
    private HashMap dirtyProperties = new HashMap(5);
    private ArrayList choiceList = new ArrayList();
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getElement("ScalarParameter").getProperty("dataType").getAllowedChoices();
    private static final IChoiceSet CONTROL_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getChoiceSet("paramControl");
    private static final double DEFAULT_PREVIEW_NUMBER = 1234.56;
    private ScalarParameterHandle inputParameter;
    private boolean loading = true;
    private Text nameEditor;
    private Text promptTextEditor;
    private Text helpTextEditor;
    private Text formatField;
    private Label promptMessageLine;
    private CLabel errorMessageLine;
    private Button isRequired;
    private Button doNotEcho;
    private Button isHidden;
    private Button distinct;
    private Button importValue;
    private Button changeDefault;
    private Button changeFormat;
    private Button createDataSet;
    private Button dynamicRadio;
    private Button staticRadio;
    private Button allowMultiChoice;
    private Combo dataTypeChooser;
    private Combo defaultValueChooser;
    private Combo dataSetChooser;
    private Combo columnChooser;
    private Combo displayTextChooser;
    private Combo sortKeyChooser;
    private Combo sortDirectionChooser;
    private Button valueColumnExprButton;
    private Label previewLabel;
    private Label sortKeyLabel;
    private Label sortDirectionLabel;
    private TableViewer valueTable;
    private String lastDataType;
    private String lastControlType;
    private String formatCategroy;
    private String formatPattern;
    private String defaultValue;
    private Composite valueArea;
    private Composite sorttingArea;
    private List columnList;
    private TableArea tableArea;
    private IDialogHelper controlTypeHelper;
    private IDialogHelper startPointTypeHelper;
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = (ArrayList)inputElement;
            ArrayList elementsList = (ArrayList)list.clone();
            return elementsList.toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            SelectionChoice choice;
            if (ParameterDialog.this.valueTable.getColumnProperties().length == 5 && columnIndex == 1 && ParameterDialog.this.isDefaultChoice(choice = (SelectionChoice)element)) {
                return DEFAULT_ICON;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SelectionChoice choice = (SelectionChoice)element;
            int valueIndex = ParameterDialog.this.valueTable.getColumnProperties().length - 3;
            String text = null;
            if (ParameterDialog.this.valueTable.getColumnProperties().length == 5 && columnIndex == 1) {
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    text = FLAG_DEFAULT;
                }
            } else if (columnIndex == valueIndex) {
                text = choice.getValue();
            } else if (columnIndex == valueIndex + 1) {
                text = choice.getLabel();
                if (text == null) {
                    text = "";
                }
            } else if (columnIndex == valueIndex + 2) {
                text = choice.getLabelResourceKey();
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private final ITableAreaModifier tableAreaModifier = new ITableAreaModifier(){

        public boolean editItem(Object element) {
            final SelectionChoice choice = (SelectionChoice)element;
            boolean isDefault = ParameterDialog.this.isDefaultChoice(choice);
            SelectionChoiceDialog dialog = new SelectionChoiceDialog(Messages.getString((String)"ParameterDialog.SelectionDialog.Edit"));
            dialog.setInput(choice);
            dialog.setValidator(new SelectionChoiceDialog.ISelectionChoiceValidator(){

                public String validate(String displayLableKey, String displayLabel, String value) {
                    return ParameterDialog.this.validateChoice(choice, displayLableKey, displayLabel, value);
                }
            });
            if (dialog.open() == 0) {
                choice.setValue(choice.getValue());
                if (isDefault) {
                    ParameterDialog.this.changeDefaultValue(choice.getValue());
                }
                return true;
            }
            return false;
        }

        public boolean newItem() {
            SelectionChoice choice = StructureFactory.createSelectionChoice();
            SelectionChoiceDialog dialog = new SelectionChoiceDialog(Messages.getString((String)"ParameterDialog.SelectionDialog.New"));
            dialog.setInput(choice);
            dialog.setValidator(new SelectionChoiceDialog.ISelectionChoiceValidator(){

                public String validate(String displayLabelKey, String displayLabel, String value) {
                    return ParameterDialog.this.validateChoice(null, displayLabelKey, displayLabel, value);
                }
            });
            if (dialog.open() == 0) {
                ParameterDialog.this.choiceList.add(choice);
                return true;
            }
            return false;
        }

        public boolean removeItem(Object[] elements) {
            int i = 0;
            while (i < elements.length) {
                if (ParameterDialog.this.isDefaultChoice((SelectionChoice)elements[i])) {
                    ParameterDialog.this.changeDefaultValue(null);
                }
                ParameterDialog.this.choiceList.remove(elements[i]);
                ++i;
            }
            return true;
        }

        public boolean removeItemAll() {
            ParameterDialog.this.choiceList.clear();
            ParameterDialog.this.changeDefaultValue(null);
            return true;
        }
    };
    private Text listLimit;

    public ParameterDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    public ParameterDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public ParameterDialog(Shell parentShell, String title, boolean allowMultiValueVisible) {
        super(parentShell, title);
        this.allowMultiValueVisible = allowMultiValueVisible;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite topComposite = new Composite(parentComposite, 0);
        topComposite.setLayoutData((Object)new GridData(768));
        topComposite.setLayout((Layout)new GridLayout(2, false));
        this.createPropertiesSection(topComposite);
        this.createDisplayOptionsSection(topComposite);
        this.createValuesDefineSection(parentComposite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ParameterDialog_ID");
        return parentComposite;
    }

    private void createPropertiesSection(Composite composite) {
        Composite propertiesSection = new Composite(composite, 0);
        propertiesSection.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.minimumWidth = 200;
        propertiesSection.setLayoutData((Object)gd);
        this.createLabel(propertiesSection, LABEL_NAME);
        this.nameEditor = new Text(propertiesSection, 2048);
        this.nameEditor.setLayoutData((Object)new GridData(768));
        this.nameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this.updateMessageLine();
            }
        });
        this.createLabel(propertiesSection, LABEL_PROMPT_TEXT);
        this.promptTextEditor = new Text(propertiesSection, 2048);
        this.promptTextEditor.setLayoutData((Object)new GridData(768));
        this.createLabel(propertiesSection, LABEL_PARAM_DATA_TYPE);
        this.dataTypeChooser = new Combo(propertiesSection, 12);
        this.dataTypeChooser.setLayoutData((Object)new GridData(768));
        this.dataTypeChooser.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(DATA_TYPE_CHOICE_SET));
        this.dataTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.changeDataType();
                ParameterDialog.this.updateCheckBoxArea();
                ParameterDialog.this.refreshColumns(true);
            }
        });
        this.createLabel(propertiesSection, LABEL_DISPALY_TYPE);
        this.createControlTypeChooser(propertiesSection);
    }

    private void createControlTypeChooser(Composite propertiesSection) {
        IDialogHelperProvider helperProvider = (IDialogHelperProvider)ElementAdapterManager.getAdapter((Object)this, IDialogHelperProvider.class);
        if (helperProvider != null) {
            this.controlTypeHelper = helperProvider.createHelper((Object)this, HELPER_KEY_CONTROLTYPE);
        }
        if (this.controlTypeHelper == null) {
            this.controlTypeHelper = new DefaultParameterDialogControlTypeHelper();
        }
        this.controlTypeHelper.setContainer((Object)this);
        this.controlTypeHelper.createContent(propertiesSection);
        this.controlTypeHelper.getControl().setLayoutData((Object)new GridData(768));
        this.controlTypeHelper.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ParameterDialog.this.controlTypeHelper.update(false);
                ParameterDialog.this.changeControlType();
            }
        });
    }

    private void createDisplayOptionsSection(Composite composite) {
        Group displayOptionSection = new Group(composite, 0);
        displayOptionSection.setText(GROUP_MORE_OPTION);
        displayOptionSection.setLayout((Layout)new GridLayout(2, false));
        displayOptionSection.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, LABEL_HELP_TEXT);
        this.helpTextEditor = new Text((Composite)displayOptionSection, 2048);
        this.helpTextEditor.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, LABEL_FORMAT);
        Composite formatSection = new Composite((Composite)displayOptionSection, 0);
        formatSection.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        formatSection.setLayoutData((Object)new GridData(768));
        this.formatField = new Text(formatSection, 2060);
        GridData fFgd = new GridData(768);
        fFgd.minimumWidth = 180;
        this.formatField.setLayoutData((Object)fFgd);
        this.changeFormat = new Button(formatSection, 8);
        this.changeFormat.setText(BUTTON_LABEL_CHANGE_FORMAT);
        this.setButtonLayoutData(this.changeFormat);
        this.changeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.popupFormatBuilder(true);
            }
        });
        this.createLabel((Composite)displayOptionSection, null);
        Group previewArea = new Group((Composite)displayOptionSection, 0);
        previewArea.setLayoutData((Object)new GridData(768));
        previewArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        previewArea.setText(LABEL_PREVIEW);
        this.previewLabel = new Label((Composite)previewArea, 0);
        this.previewLabel.setAlignment(0x1000000);
        this.previewLabel.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, LABEL_LIST_LIMIT);
        Composite limitArea = new Composite((Composite)displayOptionSection, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        limitArea.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.verticalSpan = 1;
        limitArea.setLayoutData((Object)data);
        this.listLimit = new Text(limitArea, 2048);
        data = new GridData();
        data.widthHint = 80;
        this.listLimit.setLayoutData((Object)data);
        this.listLimit.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = "0123456789\u0000\b\u007f".indexOf(e.character) != -1;
            }
        });
        Label values = new Label(limitArea, 0);
        values.setText(Messages.getString((String)"ParameterDialog.Label.values"));
        values.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, null);
        Composite checkBoxArea = new Composite((Composite)displayOptionSection, 0);
        checkBoxArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        checkBoxArea.setLayoutData((Object)new GridData(1808));
        this.isRequired = new Button(checkBoxArea, 32);
        this.isRequired.setText(CHECKBOX_ISREQUIRED);
        this.addCheckBoxListener(this.isRequired, CHECKBOX_ISREQUIRED);
        this.doNotEcho = new Button(checkBoxArea, 32);
        this.doNotEcho.setText(CHECKBOX_DO_NOT_ECHO);
        this.addCheckBoxListener(this.doNotEcho, CHECKBOX_DO_NOT_ECHO);
        this.isHidden = new Button(checkBoxArea, 32);
        this.isHidden.setText(CHECKBOX_HIDDEN);
        this.addCheckBoxListener(this.isHidden, CHECKBOX_HIDDEN);
        this.distinct = new Button(checkBoxArea, 32);
        this.distinct.setText(CHECKBOX_DISTINCT);
        this.distinct.setSelection(false);
        this.addCheckBoxListener(this.distinct, CHECKBOX_DISTINCT);
        this.createStartPointSection(displayOptionSection);
    }

    private void createStartPointSection(Group displayOptionSection) {
        IDialogHelperProvider helperProvider = (IDialogHelperProvider)ElementAdapterManager.getAdapter((Object)this, IDialogHelperProvider.class);
        if (helperProvider != null) {
            this.startPointTypeHelper = helperProvider.createHelper((Object)this, HELPER_KEY_STARTPOINT);
        }
        if (this.startPointTypeHelper != null) {
            this.startPointTypeHelper.createContent((Composite)displayOptionSection);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.startPointTypeHelper.getControl().setLayoutData((Object)data);
            this.startPointTypeHelper.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    ParameterDialog.this.startPointTypeHelper.update(false);
                }
            });
        }
    }

    private void hideStartPointSection(boolean hide) {
        if (this.startPointTypeHelper != null && this.startPointTypeHelper.getControl() != null) {
            GridData gd = (GridData)this.startPointTypeHelper.getControl().getLayoutData();
            gd.exclude = hide;
            this.startPointTypeHelper.getControl().setVisible(!hide);
            this.startPointTypeHelper.getControl().getParent().layout();
            if (!hide) {
                this.startPointTypeHelper.update(true);
            }
        }
    }

    private void createValuesDefineSection(Composite composite) {
        Group valuesDefineSection = new Group(composite, 0);
        valuesDefineSection.setText(LABEL_LIST_OF_VALUE);
        valuesDefineSection.setLayout((Layout)new GridLayout(2, false));
        valuesDefineSection.setLayoutData((Object)new GridData(768));
        Composite choiceArea = new Composite((Composite)valuesDefineSection, 0);
        choiceArea.setLayoutData((Object)new GridData(768));
        choiceArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(4, true));
        this.staticRadio = new Button(choiceArea, 16);
        this.staticRadio.setText(RADIO_STATIC);
        GridData gd = new GridData(32);
        this.staticRadio.setLayoutData((Object)gd);
        this.staticRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.switchParamterType();
            }
        });
        this.dynamicRadio = new Button(choiceArea, 16);
        this.dynamicRadio.setText(RADIO_DYNAMIC);
        this.dynamicRadio.setLayoutData((Object)gd);
        this.dynamicRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.switchParamterType();
            }
        });
        Label dummy = new Label(choiceArea, 0);
        dummy.setLayoutData((Object)new GridData(768));
        this.allowMultiChoice = new Button(choiceArea, 32);
        this.allowMultiChoice.setText(CHECK_ALLOW_MULTI);
        gd = new GridData(128);
        this.staticRadio.setLayoutData((Object)gd);
        this.valueArea = new Composite((Composite)valuesDefineSection, 0);
        this.valueArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 550;
        gd.horizontalSpan = 2;
        this.valueArea.setLayoutData((Object)gd);
        this.createLabel((Composite)valuesDefineSection, null);
        this.errorMessageLine = new CLabel((Composite)valuesDefineSection, 0);
        GridData msgLineGridData = new GridData(768);
        msgLineGridData.horizontalSpan = 2;
        this.errorMessageLine.setLayoutData((Object)msgLineGridData);
    }

    public void setInput(Object input) {
        this.inputParameter = (ScalarParameterHandle)input;
    }

    protected boolean initDialog() {
        this.nameEditor.setText(this.inputParameter.getName());
        if (!StringUtil.isBlank((String)this.inputParameter.getPromptText())) {
            this.promptTextEditor.setText(this.inputParameter.getPromptText());
        }
        this.helpTextEditor.setText(UIUtil.convertToGUIString(this.inputParameter.getHelpText()));
        for (SelectionChoiceHandle choiceHandle : this.inputParameter.getPropertyHandle("selectionList")) {
            this.choiceList.add(choiceHandle.getStructure());
        }
        if (this.inputParameter.getValueType().equals(STATIC_VALUE)) {
            this.staticRadio.setSelection(true);
        } else {
            this.dynamicRadio.setSelection(true);
        }
        this.defaultValue = this.inputParameter.getDefaultValue();
        if (PARAM_CONTROL_LIST.endsWith(this.getSelectedControlType()) && this.allowMultiValueVisible) {
            this.allowMultiChoice.setVisible(true);
            if ("multi-value".endsWith(this.inputParameter.getParamType())) {
                this.allowMultiChoice.setSelection(true);
            } else {
                this.allowMultiChoice.setSelection(false);
            }
        } else {
            this.allowMultiChoice.setVisible(false);
        }
        if (this.inputParameter.getPropertyHandle("listLimit").isSet()) {
            this.listLimit.setText(String.valueOf(this.inputParameter.getListlimit()));
        }
        this.isHidden.setSelection(this.inputParameter.isHidden());
        this.isRequired.setSelection(this.inputParameter.isRequired());
        this.doNotEcho.setSelection(this.inputParameter.isConcealValue());
        this.distinct.setSelection(!this.inputParameter.distinct());
        if (this.startPointTypeHelper != null) {
            this.startPointTypeHelper.setProperty(STARTPOINT_INPUTVALUE, this.inputParameter.getAutoSuggestThreshold());
            this.startPointTypeHelper.update(true);
        }
        this.changeDataType();
        this.dataTypeChooser.setText(DATA_TYPE_CHOICE_SET.findChoice(this.inputParameter.getDataType()).getDisplayName());
        this.switchParamterType();
        this.loading = false;
        return true;
    }

    private void initValueArea() {
        String controlType = this.getSelectedControlType();
        if ("auto-suggest".equals(controlType)) {
            this.listLimit.setEnabled(false);
        }
        if (this.isStatic()) {
            if ("check-box".equals(controlType)) {
                if (this.isValidValue(this.defaultValue) != null) {
                    this.defaultValue = null;
                    this.defaultValueChooser.select(0);
                } else if (this.defaultValue == null) {
                    this.defaultValueChooser.select(this.defaultValueChooser.indexOf(CHOICE_NO_DEFAULT));
                } else if (Boolean.valueOf(this.defaultValue).booleanValue()) {
                    this.defaultValueChooser.select(1);
                } else {
                    this.defaultValueChooser.select(2);
                }
            } else if ("text-box".equals(controlType)) {
                if (this.getSelectedDataType().equals("string")) {
                    this.defaultValueChooser.setText(DEUtil.resolveNull((String)this.defaultValue));
                } else if (this.defaultValue != null) {
                    if (this.defaultValue.equals(Boolean.toString(true)) || this.defaultValue.equals(Boolean.toString(false))) {
                        this.defaultValue = null;
                    } else {
                        this.defaultValueChooser.setText(this.defaultValue);
                    }
                }
            } else if (PARAM_CONTROL_COMBO.equals(controlType) || PARAM_CONTROL_LIST.equals(controlType) || "radio-button".endsWith(controlType)) {
                this.initSorttingArea();
                if (this.lastControlType != null && this.lastControlType.equals("text-box")) {
                    this.defaultValue = null;
                }
            }
            this.refreshValueTable();
        } else {
            this.refreshDataSets();
            if (this.inputParameter.getDataSetName() != null) {
                this.dataSetChooser.setText(this.inputParameter.getDataSetName());
            }
            this.refreshColumns(false);
            this.refresSortByItems();
            String columnName = this.getColumnName(this.inputParameter.getValueExpr());
            if (columnName != null) {
                this.columnChooser.setText(columnName);
            }
            if ((columnName = this.getColumnName(this.inputParameter.getLabelExpr())) != null) {
                this.displayTextChooser.setText(columnName);
            }
            if (this.getSelectedDataType().equals("string")) {
                this.defaultValueChooser.setText(DEUtil.resolveNull((String)this.defaultValue));
            } else if (this.defaultValue != null) {
                this.defaultValueChooser.setText(this.defaultValue);
            }
            this.initSorttingArea();
        }
        this.updateMessageLine();
    }

    private void initSorttingArea() {
        this.refresSortByItems();
        if (!this.inputParameter.isFixedOrder()) {
            this.sortKeyLabel.setEnabled(true);
            this.sortKeyChooser.setEnabled(true);
            this.sortDirectionLabel.setEnabled(true);
            this.sortDirectionChooser.setEnabled(true);
            this.distinct.setEnabled(true);
            this.distinct.setSelection(!this.inputParameter.distinct());
            boolean isStatic = STATIC_VALUE.equals(this.inputParameter.getValueType());
            boolean isDynamic = "dynamic".equals(this.inputParameter.getValueType());
            if (isStatic) {
                String sortKey = this.inputParameter.getSortBy();
                if (sortKey == null || sortKey.equals("label")) {
                    this.sortKeyChooser.setText(CHOICE_DISPLAY_TEXT);
                } else {
                    this.sortKeyChooser.setText(CHOICE_VALUE_COLUMN);
                }
            } else if (isDynamic) {
                String columnName = this.getColumnName(this.inputParameter.getSortByColumn());
                if (columnName != null && this.sortKeyChooser.indexOf(columnName) >= 0) {
                    this.sortKeyChooser.setText(columnName);
                }
            } else {
                this.sortKeyChooser.select(0);
            }
            String sortDirection = this.inputParameter.getSortDirection();
            if (sortDirection == null || sortDirection.equals("asc")) {
                this.sortDirectionChooser.setText(CHOICE_ASCENDING);
            } else {
                this.sortDirectionChooser.setText(CHOICE_DESCENDING);
            }
        } else {
            this.sortKeyLabel.setEnabled(true);
            this.sortKeyChooser.setEnabled(true);
            this.sortDirectionLabel.setEnabled(false);
            this.sortDirectionChooser.setEnabled(false);
            this.distinct.setEnabled(false);
        }
    }

    private void initFormatField() {
        String type = this.getSelectedDataType();
        if ("decimal".equals(this.lastControlType) && "float".equals(type) || "float".equals(this.lastControlType) && "decimal".equals(type)) {
            return;
        }
        IChoiceSet choiceSet = this.getFormatChoiceSet(type);
        if (choiceSet == null) {
            this.formatPattern = null;
            this.formatCategroy = null;
        } else if (!this.loading || this.inputParameter.getCategory() == null && this.inputParameter.getPattern() == null) {
            if ("string".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("dateTime".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("date".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("time".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("decimal".equals(type) || "float".equals(type) || "integer".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            }
            this.formatPattern = null;
        } else {
            this.formatCategroy = this.inputParameter.getCategory();
            if (this.formatCategroy == null) {
                this.formatCategroy = "Unformatted";
            }
            this.formatPattern = this.inputParameter.getPattern();
        }
        this.updateFormatField();
    }

    private List getColumnValueList() {
        try {
            String queryExpr = this.getExpression(this.columnChooser.getText());
            if (queryExpr == null || queryExpr.equals("")) {
                return Collections.EMPTY_LIST;
            }
            ArrayList valueList = new ArrayList();
            valueList.addAll(SelectValueFetcher.getSelectValueList(queryExpr, this.getDataSetHandle()));
            return valueList;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return Collections.EMPTY_LIST;
        }
    }

    private void refreshDataSets() {
        String selectedDataSetName = this.dataSetChooser.getText();
        String[] oldList = this.dataSetChooser.getItems();
        ArrayList<String> dataSetList = new ArrayList<String>();
        for (DataSetHandle DataSetHandle2 : this.inputParameter.getModuleHandle().getVisibleDataSets()) {
            dataSetList.add(DataSetHandle2.getQualifiedName());
        }
        if (this.inputParameter.getDataSetName() != null && !dataSetList.contains(this.inputParameter.getDataSetName())) {
            dataSetList.add(0, this.inputParameter.getDataSetName());
        }
        if (oldList.length != dataSetList.size()) {
            String newName = this.findNewDataSet(Arrays.asList(oldList), dataSetList);
            if (newName != null) {
                selectedDataSetName = newName;
            }
            this.dataSetChooser.setItems(dataSetList.toArray(new String[0]));
            if (StringUtil.isBlank((String)selectedDataSetName)) {
                this.dataSetChooser.select(0);
                this.refreshColumns(false);
            } else if (selectedDataSetName != null && this.dataSetChooser.indexOf(selectedDataSetName) != -1) {
                this.dataSetChooser.select(this.dataSetChooser.indexOf(selectedDataSetName));
                this.refreshColumns(false);
            }
            this.refresSortByItems();
        }
    }

    private String findNewDataSet(List existingDataSets, List newDataSets) {
        int i = 0;
        while (i < newDataSets.size()) {
            if (!existingDataSets.contains(newDataSets.get(i))) {
                return (String)newDataSets.get(i);
            }
            ++i;
        }
        return null;
    }

    private DataSetHandle getDataSetHandle() {
        return this.inputParameter.getModuleHandle().findDataSet(this.dataSetChooser.getText());
    }

    private void refreshColumns(boolean onlyFilter) {
        if (this.columnChooser == null || this.columnChooser.isDisposed()) {
            return;
        }
        if (!onlyFilter) {
            DataSetHandle dataSetHandle = this.getDataSetHandle();
            try {
                this.columnList = DataUtil.getColumnList(dataSetHandle);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
            this.displayTextChooser.removeAll();
            this.displayTextChooser.add(NONE_DISPLAY_TEXT);
            Iterator iter = this.columnList.iterator();
            while (iter.hasNext()) {
                this.displayTextChooser.add(((ResultSetColumnHandle)iter.next()).getColumnName());
            }
            this.displayTextChooser.setText(NONE_DISPLAY_TEXT);
        }
        String originalSelection = this.columnChooser.getText();
        this.columnChooser.removeAll();
        for (ResultSetColumnHandle cachedColumn : this.columnList) {
            if (!this.matchDataType(cachedColumn)) continue;
            this.columnChooser.add(cachedColumn.getColumnName());
        }
        if (this.columnChooser.indexOf(originalSelection) != -1) {
            this.columnChooser.setText(originalSelection);
        }
        if (this.columnChooser.getItemCount() == 0) {
            this.columnChooser.add("");
        }
        this.updateMessageLine();
    }

    private boolean matchDataType(ResultSetColumnHandle column) {
        String type = this.getSelectedDataType();
        if (type.equals("string") || "any".equals(column.getDataType())) {
            return true;
        }
        if ("date-time".equals(column.getDataType())) {
            return type.equals("dateTime");
        }
        if ("decimal".equals(column.getDataType())) {
            return type.equals("decimal");
        }
        if ("float".equals(column.getDataType())) {
            return type.equals("float");
        }
        if ("integer".equals(column.getDataType())) {
            return type.equals("integer");
        }
        if ("date".equals(column.getDataType())) {
            return type.equals("date");
        }
        if ("time".equals(column.getDataType())) {
            return type.equals("time");
        }
        if ("boolean".equals(column.getDataType())) {
            return type.equals("boolean");
        }
        return false;
    }

    private String getInputControlType() {
        String type = null;
        type = this.inputParameter.getControlType() == null ? "text-box" : ("list-box".equals(this.inputParameter.getControlType()) ? (this.inputParameter.isMustMatch() ? PARAM_CONTROL_LIST : PARAM_CONTROL_COMBO) : this.inputParameter.getControlType());
        return type;
    }

    private String getSelectedDataType() {
        String type = null;
        if (StringUtil.isBlank((String)this.dataTypeChooser.getText())) {
            type = this.inputParameter.getDataType();
        } else {
            IChoice choice = DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(this.dataTypeChooser.getText());
            type = choice.getName();
        }
        return type;
    }

    private String getSelectedControlType() {
        if (this.controlTypeHelper == null) {
            return this.getInputControlType();
        }
        this.controlTypeHelper.update(false);
        String type = (String)this.controlTypeHelper.getProperty(CONTROLTYPE_VALUE);
        if (type == null) {
            return this.getInputControlType();
        }
        return type;
    }

    private void changeDataType() {
        String type = this.getSelectedDataType();
        if (type.equals(this.lastDataType)) {
            return;
        }
        try {
            this.validateValue(this.defaultValue);
        }
        catch (BirtException birtException) {
            this.defaultValue = null;
        }
        this.buildControlTypeList(type);
        this.initFormatField();
        if (type.equals("string")) {
            this.clearDefaultValueChooser(this.isRequired.getSelection());
        } else if (!type.equals("boolean")) {
            this.clearDefaultValueText();
            this.clearDefaultValueChooserSelections();
        }
        if (this.isStatic() && !this.distinct.isEnabled() || this.distinct.isEnabled() && !this.distinct.getSelection()) {
            this.makeUniqueAndValid();
            this.refreshValueTable();
        } else {
            this.refreshColumns(true);
        }
        this.lastDataType = type;
        this.updateMessageLine();
    }

    private void buildControlTypeList(String type) {
        this.controlTypeHelper.setProperty(DATATYPE_VALUE, type);
        this.controlTypeHelper.setProperty(STATIC_VALUE, this.isStatic());
        this.controlTypeHelper.setProperty(CONTROLTYPE_INPUTVALUE, this.getInputControlType());
        this.controlTypeHelper.update(true);
    }

    private boolean makeUniqueAndValid() {
        boolean change = false;
        try {
            HashSet<Object> set = new HashSet<Object>();
            Iterator iter = this.choiceList.iterator();
            while (iter.hasNext()) {
                SelectionChoice choice = (SelectionChoice)iter.next();
                if (this.isValidValue(choice.getValue()) != null || set.contains(this.validateValue(choice.getValue()))) {
                    iter.remove();
                    change = true;
                    continue;
                }
                set.add(this.validateValue(choice.getValue()));
            }
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
        return change;
    }

    private void changeControlType() {
        String type;
        if (this.isStatic() && !(type = this.getSelectedControlType()).equals(this.lastControlType)) {
            if ("check-box".equals(type)) {
                this.clearArea(this.valueArea);
                this.switchToCheckBox();
            } else if (PARAM_CONTROL_COMBO.equals(type) || PARAM_CONTROL_LIST.equals(type) || "radio-button".equals(type)) {
                if (!(PARAM_CONTROL_COMBO.equals(this.lastControlType) || PARAM_CONTROL_LIST.equals(this.lastControlType) || "radio-button".equals(this.lastControlType))) {
                    this.clearArea(this.valueArea);
                    this.switchToList();
                }
            } else if ("text-box".equals(type)) {
                this.clearArea(this.valueArea);
                this.switchToText();
            }
            this.valueArea.layout();
            this.initValueArea();
            this.lastControlType = type;
        }
        this.updateCheckBoxArea();
        this.updateMessageLine();
        boolean radioEnable = false;
        if (PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) || PARAM_CONTROL_LIST.equals(this.getSelectedControlType())) {
            radioEnable = true;
        }
        if (radioEnable != this.staticRadio.isEnabled()) {
            this.staticRadio.setEnabled(radioEnable);
            this.dynamicRadio.setEnabled(radioEnable);
        }
        if ("auto-suggest".equals(this.getSelectedControlType())) {
            if (!this.dynamicRadio.getSelection()) {
                this.staticRadio.setSelection(false);
                this.dynamicRadio.setSelection(true);
                this.switchParamterType();
            }
            this.hideStartPointSection(false);
            this.listLimit.setEnabled(false);
        } else {
            this.hideStartPointSection(true);
            if (this.isStatic()) {
                this.listLimit.setEnabled(false);
            } else {
                this.listLimit.setEnabled(true);
            }
        }
        if (PARAM_CONTROL_LIST.equals(this.getSelectedControlType()) && this.allowMultiValueVisible) {
            this.allowMultiChoice.setVisible(true);
        } else {
            this.allowMultiChoice.setVisible(false);
        }
    }

    private void switchParamterType() {
        this.clearArea(this.valueArea);
        this.lastControlType = null;
        if (this.isStatic()) {
            this.switchToStatic();
        } else {
            this.switchToDynamic();
        }
        this.buildControlTypeList(this.getSelectedDataType());
        this.valueArea.layout();
        this.initValueArea();
        this.updateCheckBoxArea();
    }

    private void switchToCheckBox() {
        this.createLabel(this.valueArea, LABEL_DEFAULT_VALUE);
        this.defaultValueChooser = new Combo(this.valueArea, 2056);
        this.defaultValueChooser.add(CHOICE_NO_DEFAULT);
        this.defaultValueChooser.add(BOOLEAN_TRUE);
        this.defaultValueChooser.add(BOOLEAN_FALSE);
        this.defaultValueChooser.setLayoutData((Object)new GridData(768));
        this.defaultValueChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (ParameterDialog.this.defaultValueChooser.getSelectionIndex()) {
                    case 0: {
                        ParameterDialog.this.defaultValue = null;
                        break;
                    }
                    case 1: {
                        ParameterDialog.this.defaultValue = Boolean.toString(true);
                        break;
                    }
                    case 2: {
                        ParameterDialog.this.defaultValue = Boolean.toString(false);
                    }
                }
                ParameterDialog.this.updateMessageLine();
            }
        });
    }

    private void switchToList() {
        this.createLabel(this.valueArea, LABEL_VALUES);
        Composite tableAreaComposite = new Composite(this.valueArea, 0);
        tableAreaComposite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        tableAreaComposite.setLayoutData((Object)new GridData(1808));
        this.tableArea = new TableArea(tableAreaComposite, 67588, this.tableAreaModifier);
        this.tableArea.setLayoutData(new GridData(1808));
        Table table = this.tableArea.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] stringArray = new String[5];
        stringArray[1] = COLUMN_IS_DEFAULT;
        stringArray[2] = COLUMN_VALUE;
        stringArray[3] = COLUMN_DISPLAY_TEXT;
        stringArray[4] = COLUMN_DISPLAY_TEXT_KEY;
        String[] columns = stringArray;
        int[] columnWidth = new int[]{10, 70, 100, 100, 100};
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 16384);
            column.setResizable(columns[i] != null);
            if (columns[i] != null) {
                column.setText(columns[i]);
            }
            column.setWidth(columnWidth[i]);
            ++i;
        }
        this.valueTable = this.tableArea.getTableViewer();
        this.valueTable.setColumnProperties(columns);
        this.valueTable.setContentProvider((IContentProvider)this.contentProvider);
        this.valueTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableArea.setInput(this.choiceList);
        this.valueTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ParameterDialog.this.updateTableButtons();
            }
        });
        Composite buttonBar = new Composite(tableAreaComposite, 0);
        buttonBar.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(4, false));
        buttonBar.setLayoutData((Object)new GridData(768));
        this.importValue = new Button(buttonBar, 8);
        this.importValue.setText(BUTTON_LABEL_IMPORT);
        this.setButtonLayoutData(this.importValue);
        this.importValue.setEnabled(!this.inputParameter.getModuleHandle().getVisibleDataSets().isEmpty());
        this.importValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean defaultValueRemoved = true;
                String type = ParameterDialog.this.getSelectedDataType();
                ArrayList<String> choices = new ArrayList<String>();
                HashMap<String, String> labelMap = new HashMap<String, String>();
                for (SelectionChoice choice : ParameterDialog.this.choiceList) {
                    choices.add(choice.getValue());
                    if (choice.getLabel() == null) continue;
                    labelMap.put(choice.getValue(), choice.getLabel());
                }
                ImportValueDialog dialog = new ImportValueDialog(type, choices);
                if (ParameterDialog.this.distinct.isEnabled() && ParameterDialog.this.distinct.getSelection()) {
                    dialog.setDistinct(false);
                } else {
                    dialog.setDistinct(true);
                }
                dialog.setValidate(new ImportValueDialog.IAddChoiceValidator(){

                    public String validateString(String value) {
                        String errorMessage = ParameterDialog.this.isValidValue(value);
                        if (errorMessage != null) {
                            return errorMessage;
                        }
                        return null;
                    }
                });
                if (dialog.open() == 0) {
                    String[] importValues = (String[])dialog.getResult();
                    ParameterDialog.this.choiceList.clear();
                    int i = 0;
                    while (i < importValues.length) {
                        SelectionChoice choice = StructureFactory.createSelectionChoice();
                        choice.setValue(UIUtil.convertToModelString(importValues[i], false));
                        if (labelMap.get(UIUtil.convertToModelString(importValues[i], false)) != null) {
                            choice.setLabel((String)labelMap.get(importValues[i]));
                        }
                        ParameterDialog.this.choiceList.add(choice);
                        if (ParameterDialog.this.defaultValue != null && ParameterDialog.this.defaultValue.equals(UIUtil.convertToModelString(importValues[i], false))) {
                            defaultValueRemoved = false;
                        }
                        ++i;
                    }
                    ParameterDialog.this.refreshValueTable();
                    if (ParameterDialog.this.defaultValue != null && defaultValueRemoved) {
                        ParameterDialog.this.changeDefaultValue(null);
                    }
                }
            }
        });
        this.changeDefault = new Button(buttonBar, 2);
        this.changeDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionChoice choice = (SelectionChoice)((IStructuredSelection)ParameterDialog.this.valueTable.getSelection()).getFirstElement();
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    ParameterDialog.this.changeDefaultValue(null);
                } else {
                    ParameterDialog.this.changeDefaultValue(choice.getValue());
                }
                ParameterDialog.this.refreshValueTable();
                ParameterDialog.this.changeDefault.getParent().layout();
            }
        });
        int width1 = UIUtil.getStringWidth(BUTTON_LABEL_REMOVE_DEFAULT, (Control)this.changeDefault) + 10;
        int width2 = UIUtil.getStringWidth(BUTTON_LABEL_SET_DEFAULT, (Control)this.changeDefault) + 10;
        int width = width1 >= width2 ? width1 : width2;
        GridData gd = new GridData();
        gd.widthHint = width;
        this.changeDefault.setLayoutData((Object)gd);
        this.createPromptLine(tableAreaComposite);
        this.updateTableButtons();
        this.createSortingArea(this.valueArea);
    }

    private void switchToText() {
        this.createDefaultEditor();
        this.createLabel(this.valueArea, null);
        this.createPromptLine(this.valueArea);
    }

    private void switchToStatic() {
        this.changeControlType();
        this.listLimit.setEnabled(false);
    }

    private void switchToDynamic() {
        this.changeControlType();
        Composite composite = new Composite(this.valueArea, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(3, false));
        this.createLabel(composite, LABEL_SELECT_DATA_SET);
        this.dataSetChooser = new Combo(composite, 2056);
        this.dataSetChooser.setLayoutData((Object)new GridData(768));
        this.dataSetChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ParameterDialog.this.refreshColumns(false);
                ParameterDialog.this.refresSortByItems();
            }

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.refreshColumns(false);
                ParameterDialog.this.refresSortByItems();
            }
        });
        this.createDataSet = new Button(composite, 8);
        this.createDataSet.setText(BUTTON_CREATE_DATA_SET);
        this.setButtonLayoutData(this.createDataSet);
        this.createDataSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new NewDataSetAction().run();
                ParameterDialog.this.refreshDataSets();
            }
        });
        this.createLabel(composite, LABEL_SELECT_VALUE_COLUMN);
        this.columnChooser = new Combo(composite, 2052);
        this.columnChooser.setLayoutData((Object)new GridData(768));
        this.columnChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.updateButtons();
            }
        });
        this.valueColumnExprButton = new Button(composite, 8);
        UIUtil.setExpressionButtonImage(this.valueColumnExprButton);
        this.valueColumnExprButton.setToolTipText(Messages.getString((String)"ParameterDialog.toolTipText.OpenExprButton"));
        this.valueColumnExprButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(ParameterDialog.this.getExpression(ParameterDialog.this.columnChooser.getText()));
                expressionBuilder.setExpressionProvier(new ParameterExpressionProvider((DesignElementHandle)ParameterDialog.this.inputParameter, ParameterDialog.this.dataSetChooser.getText()));
                if (expressionBuilder.open() == 0) {
                    ParameterDialog.this.setExpression(ParameterDialog.this.columnChooser, expressionBuilder.getResult().trim());
                }
            }
        });
        this.createLabel(composite, LABEL_SELECT_DISPLAY_TEXT);
        this.displayTextChooser = new Combo(composite, 2052);
        this.displayTextChooser.setLayoutData((Object)new GridData(768));
        Button displayTextExprButton = new Button(composite, 8);
        UIUtil.setExpressionButtonImage(displayTextExprButton);
        displayTextExprButton.setToolTipText(Messages.getString((String)"ParameterDialog.toolTipText.OpenExprButton"));
        displayTextExprButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(ParameterDialog.this.getExpression(ParameterDialog.this.displayTextChooser.getText()));
                expressionBuilder.setExpressionProvier(new ParameterExpressionProvider((DesignElementHandle)ParameterDialog.this.inputParameter, ParameterDialog.this.dataSetChooser.getText()));
                if (expressionBuilder.open() == 0) {
                    ParameterDialog.this.setExpression(ParameterDialog.this.displayTextChooser, expressionBuilder.getResult().trim());
                }
            }
        });
        this.createDefaultEditor();
        this.createSortingArea(this.valueArea);
        this.createLabel(this.valueArea, null);
        this.createPromptLine(this.valueArea);
        this.listLimit.setEnabled(true);
    }

    private void refresSortByItems() {
        if (this.sortKeyChooser == null || this.sortKeyChooser.isDisposed()) {
            return;
        }
        this.sortKeyChooser.removeAll();
        this.sortKeyChooser.add(NONE_DISPLAY_TEXT);
        if (this.staticRadio.getSelection()) {
            this.sortKeyChooser.add(CHOICE_DISPLAY_TEXT);
            this.sortKeyChooser.add(CHOICE_VALUE_COLUMN);
        } else if (this.dynamicRadio.getSelection()) {
            Iterator iter = this.columnList.iterator();
            while (iter.hasNext()) {
                this.sortKeyChooser.add(((ResultSetColumnHandle)iter.next()).getColumnName());
            }
        }
        this.sortKeyChooser.setText(NONE_DISPLAY_TEXT);
    }

    private void createSortingArea(Composite parent) {
        this.sorttingArea = new Composite(parent, 0);
        GridData sorttingAreaGridData = new GridData(776);
        sorttingAreaGridData.horizontalSpan = 2;
        this.sorttingArea.setLayoutData((Object)sorttingAreaGridData);
        this.sorttingArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(1, false));
        Group sortGroup = new Group(this.sorttingArea, 0);
        sortGroup.setText(LABEL_SORT_GROUP);
        sortGroup.setLayout((Layout)new GridLayout(2, false));
        sortGroup.setLayoutData((Object)new GridData(768));
        Composite sortKeyArea = new Composite((Composite)sortGroup, 0);
        sortKeyArea.setLayoutData((Object)new GridData(768));
        sortKeyArea.setLayout((Layout)new GridLayout(2, false));
        this.sortKeyLabel = new Label(sortKeyArea, 0);
        this.sortKeyLabel.setText(LABEL_SORT_KEY);
        this.sortKeyChooser = new Combo(sortKeyArea, 2056);
        this.sortKeyChooser.setLayoutData((Object)new GridData(768));
        this.sortKeyChooser.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!((Combo)e.widget).getText().equals(NONE_DISPLAY_TEXT)) {
                    ParameterDialog.this.sortDirectionLabel.setEnabled(true);
                    ParameterDialog.this.sortDirectionChooser.setEnabled(true);
                } else {
                    ParameterDialog.this.sortDirectionLabel.setEnabled(false);
                    ParameterDialog.this.sortDirectionChooser.setEnabled(false);
                }
            }
        });
        Composite sortDirectionArea = new Composite((Composite)sortGroup, 0);
        sortDirectionArea.setLayoutData((Object)new GridData(768));
        sortDirectionArea.setLayout((Layout)new GridLayout(2, false));
        this.sortDirectionLabel = new Label(sortDirectionArea, 0);
        this.sortDirectionLabel.setText(LABEL_SORT_DIRECTION);
        this.sortDirectionChooser = new Combo(sortDirectionArea, 2056);
        this.sortDirectionChooser.setLayoutData((Object)new GridData(768));
        this.sortDirectionChooser.add(CHOICE_ASCENDING);
        this.sortDirectionChooser.add(CHOICE_DESCENDING);
        this.sortDirectionChooser.setText(CHOICE_ASCENDING);
    }

    private void clearDefaultValueText() {
        if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed()) {
            return;
        }
        String textValue = this.defaultValueChooser.getText();
        if (textValue != null && textValue.length() == 0) {
            this.defaultValueChooser.setText("");
        }
    }

    private void clearDefaultValueChooserSelections() {
        if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed()) {
            return;
        }
        if (this.defaultValueChooser.getItemCount() > 1) {
            this.defaultValueChooser.removeAll();
        }
    }

    private void createDefaultEditor() {
        this.createLabel(this.valueArea, LABEL_DEFAULT_VALUE);
        this.defaultValueChooser = new Combo(this.valueArea, 2048);
        this.defaultValueChooser.setLayoutData((Object)new GridData(768));
        if (!this.isStatic()) {
            this.defaultValueChooser.add(CHOICE_SELECT_VALUE);
        }
        this.defaultValueChooser.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String selection = e.text;
                if (ParameterDialog.this.defaultValueChooser.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                e.doit = !selection.equals(CHOICE_SELECT_VALUE);
            }
        });
        this.defaultValueChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParameterDialog.this.defaultValueChooser.getSelectionIndex() == -1) {
                    return;
                }
                String selection = ParameterDialog.this.defaultValueChooser.getItem(ParameterDialog.this.defaultValueChooser.getSelectionIndex());
                if (selection.equals(CHOICE_SELECT_VALUE)) {
                    List columnValueList = ParameterDialog.this.getColumnValueList();
                    if (columnValueList.isEmpty()) {
                        return;
                    }
                    SelectParameterDefaultValueDialog dialog = new SelectParameterDefaultValueDialog(Display.getCurrent().getActiveShell(), Messages.getString((String)"SelectParameterDefaultValueDialog.Title"));
                    dialog.setColumnValueList(columnValueList);
                    int status = dialog.open();
                    if (status == 0) {
                        String selectedValue = dialog.getSelectedValue();
                        ParameterDialog.this.defaultValueChooser.setText(DEUtil.resolveNull((String)selectedValue));
                    }
                } else if (ParameterDialog.this.isStatic()) {
                    ParameterDialog.this.refreshValueTable();
                }
            }
        });
        this.defaultValueChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = ParameterDialog.this.defaultValueChooser.getText();
                ParameterDialog.this.changeDefaultValue(UIUtil.convertToModelString(value, false));
                if (ParameterDialog.this.isStatic()) {
                    ParameterDialog.this.refreshValueTable();
                }
            }
        });
    }

    private void createPromptLine(Composite parent) {
        this.promptMessageLine = new Label(parent, 0);
        this.promptMessageLine.setLayoutData((Object)new GridData(768));
    }

    private Object validateValue(String value) throws BirtException {
        String tempdefaultValue = value;
        if (!"string".endsWith(this.getSelectedDataType()) && !"boolean".endsWith(this.getSelectedDataType())) {
            if ("dateTime".equals(this.getSelectedDataType())) {
                tempdefaultValue = ParameterUtil.convertToStandardFormat(DataTypeUtil.toDate((Object)tempdefaultValue));
            } else if ("date".equals(this.getSelectedDataType())) {
                tempdefaultValue = ParameterUtil.convertToStandardFormat(DataTypeUtil.toSqlDate((Object)tempdefaultValue));
            } else if ("time".equals(this.getSelectedDataType())) {
                tempdefaultValue = ParameterUtil.convertToStandardFormat(DataTypeUtil.toSqlTime((Object)tempdefaultValue));
            }
            return ParameterValidationUtil.validate((String)this.getSelectedDataType(), (String)STANDARD_DATE_TIME_PATTERN, (String)tempdefaultValue, (ULocale)ULocale.getDefault());
        }
        if ("boolean".equals(this.getSelectedDataType())) {
            if (tempdefaultValue != null && tempdefaultValue.equals(CHOICE_NO_DEFAULT)) {
                return DataTypeUtil.toBoolean(null);
            }
            return DataTypeUtil.toBoolean((Object)tempdefaultValue);
        }
        return tempdefaultValue;
    }

    protected void okPressed() {
        try {
            this.validateValue(this.defaultValue);
        }
        catch (BirtException e1) {
            ExceptionHandler.handle(e1);
            return;
        }
        try {
            this.inputParameter.setName(this.nameEditor.getText());
            this.inputParameter.setPromptText(UIUtil.convertToModelString(this.promptTextEditor.getText(), true));
            this.inputParameter.setParamType("simple");
            String newControlType = this.getSelectedControlType();
            if (PARAM_CONTROL_COMBO.equals(newControlType)) {
                newControlType = "list-box";
                this.inputParameter.setMustMatch(false);
            } else if (PARAM_CONTROL_LIST.equals(newControlType)) {
                newControlType = "list-box";
                this.inputParameter.setMustMatch(true);
                if (this.allowMultiChoice.isVisible() && this.allowMultiChoice.getSelection()) {
                    this.inputParameter.setParamType("multi-value");
                }
            } else {
                this.inputParameter.setProperty("mustMatch", null);
            }
            this.inputParameter.setControlType(newControlType);
            this.inputParameter.setDefaultValue(this.defaultValue);
            this.inputParameter.setDataType(DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(this.dataTypeChooser.getText()).getName());
            PropertyHandle selectionChioceList = this.inputParameter.getPropertyHandle("selectionList");
            selectionChioceList.setValue(null);
            if (this.isStatic()) {
                this.inputParameter.setValueType(STATIC_VALUE);
                if (!"text-box".equals(newControlType) && !"check-box".equals(newControlType)) {
                    for (SelectionChoice choice : this.choiceList) {
                        if (this.isValidValue(choice.getValue()) != null) continue;
                        selectionChioceList.addItem((IStructure)choice);
                    }
                }
                this.inputParameter.setDataSetName(null);
                this.inputParameter.setValueExpr(null);
                this.inputParameter.setLabelExpr(null);
            } else {
                this.inputParameter.setValueType("dynamic");
                this.inputParameter.setDataSetName(this.dataSetChooser.getText());
                this.inputParameter.setValueExpr(this.getExpression(this.columnChooser.getText()));
                if (this.displayTextChooser.getText().equals(LABEL_NULL)) {
                    this.inputParameter.setLabelExpr("");
                } else {
                    this.inputParameter.setLabelExpr(this.getExpression(this.displayTextChooser.getText()));
                }
                if (this.startPointTypeHelper != null && this.startPointTypeHelper.getControl() != null && this.startPointTypeHelper.getControl().isVisible()) {
                    this.startPointTypeHelper.update(false);
                    this.inputParameter.setAutoSuggestThreshold(((Integer)this.startPointTypeHelper.getProperty(STARTPOINT_VALUE)).intValue());
                }
            }
            this.inputParameter.setHelpText(UIUtil.convertToModelString(this.helpTextEditor.getText(), false));
            this.inputParameter.setCategory(this.formatCategroy);
            this.inputParameter.setPattern(this.formatPattern);
            if (this.isStatic() && (PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) || "radio-button".equals(this.getSelectedControlType())) && !this.containValue(null, this.defaultValue, COLUMN_VALUE)) {
                this.defaultValue = null;
            }
            if (this.dirtyProperties.containsKey(CHECKBOX_HIDDEN)) {
                this.inputParameter.setHidden(this.getProperty(CHECKBOX_HIDDEN));
            }
            if (this.dirtyProperties.containsKey(CHECKBOX_ISREQUIRED)) {
                this.inputParameter.setIsRequired(this.getProperty(CHECKBOX_ISREQUIRED));
            }
            if (this.doNotEcho.isEnabled()) {
                if (this.dirtyProperties.containsKey(CHECKBOX_DO_NOT_ECHO)) {
                    this.inputParameter.setConcealValue(this.getProperty(CHECKBOX_DO_NOT_ECHO));
                }
            } else {
                this.inputParameter.setProperty("concealValue", null);
            }
            if (this.distinct.isEnabled()) {
                this.inputParameter.setDistinct(!this.distinct.getSelection());
            } else {
                this.inputParameter.setDistinct(true);
            }
            if (this.sorttingArea != null && !this.sorttingArea.isDisposed() && this.sorttingArea.isVisible()) {
                if (this.sortKeyChooser.getText().equals(NONE_DISPLAY_TEXT)) {
                    this.inputParameter.setFixedOrder(true);
                    this.inputParameter.setSortBy(null);
                    this.inputParameter.setSortDirection(null);
                    this.inputParameter.setSortByColumn(null);
                } else {
                    if (this.isStatic()) {
                        this.inputParameter.setFixedOrder(false);
                        if (this.sortKeyChooser.getText().equals(CHOICE_DISPLAY_TEXT)) {
                            this.inputParameter.setSortBy("label");
                        } else if (this.sortKeyChooser.getText().equals(CHOICE_VALUE_COLUMN)) {
                            this.inputParameter.setSortBy("value");
                        }
                        this.inputParameter.setSortByColumn(null);
                    } else if (this.dynamicRadio.getSelection()) {
                        this.inputParameter.setSortBy(null);
                        this.inputParameter.setFixedOrder(false);
                        this.inputParameter.setSortByColumn(this.getExpression(this.sortKeyChooser.getText()));
                    }
                    if (this.sortDirectionChooser.getText().equals(CHOICE_ASCENDING)) {
                        this.inputParameter.setSortDirection("asc");
                    } else if (this.sortDirectionChooser.getText().equals(CHOICE_DESCENDING)) {
                        this.inputParameter.setSortDirection("desc");
                    }
                }
            } else {
                this.inputParameter.setProperty("fixedOrder", null);
            }
            if (!(this.isStatic() || StringUtil.isBlank((String)this.listLimit.getText()) || "auto-suggest".equals(this.getSelectedControlType()))) {
                try {
                    this.inputParameter.setListlimit(Integer.parseInt(this.listLimit.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    ExceptionHandler.openErrorMessageBox(ERROR_TITLE_INVALID_LIST_LIMIT, MessageFormat.format(ERROR_MSG_INVALID_LIST_LIMIT, Integer.toString(Integer.MAX_VALUE)));
                }
            } else {
                this.inputParameter.setProperty("listLimit", null);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return;
        }
        this.setResult(this.inputParameter);
        super.okPressed();
    }

    private void createLabel(Composite parent, String content) {
        Label label = new Label(parent, 0);
        if (content != null) {
            label.setText(content);
        }
        this.setLabelLayoutData(label);
    }

    private void setLabelLayoutData(Label label) {
        GridData gd = new GridData();
        if (label.getText().equals(LABEL_VALUES)) {
            gd.verticalAlignment = 1;
        }
        label.setLayoutData((Object)gd);
    }

    private void addCheckBoxListener(final Button checkBox, final String key) {
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.checkBoxChange(checkBox, key);
            }
        });
    }

    protected void checkBoxChange(Button checkBox, String key) {
        this.dirtyProperties.put(key, new Boolean(checkBox.getSelection()));
        if (CHECKBOX_ISREQUIRED.equals(key) || CHECKBOX_DISTINCT.equals(key)) {
            boolean change;
            if ((this.isStatic() && !this.distinct.isEnabled() || this.distinct.isEnabled() && !this.distinct.getSelection()) && (change = this.makeUniqueAndValid())) {
                this.refreshValueTable();
            }
            if (this.getSelectedDataType().equals("string")) {
                this.clearDefaultValueChooser(checkBox.getSelection());
            }
            this.updateMessageLine();
        }
    }

    private void clearDefaultValueChooser(boolean isChecked) {
        if (isChecked) {
            this.clearDefaultValueText();
            this.clearDefaultValueChooserSelections();
        } else if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed() || this.defaultValueChooser.getItemCount() > 1) {
            return;
        }
    }

    private void clearArea(Composite area) {
        Control[] children = area.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    private void updateTableButtons() {
        boolean isDefault;
        this.tableArea.updateButtons();
        boolean isEnable = true;
        SelectionChoice selectedChoice = null;
        if (this.valueTable.getSelection().isEmpty()) {
            isEnable = false;
        } else {
            selectedChoice = (SelectionChoice)((IStructuredSelection)this.valueTable.getSelection()).getFirstElement();
            String value = selectedChoice.getValue();
            try {
                this.validateValue(value);
            }
            catch (BirtException birtException) {
                isEnable = false;
            }
        }
        boolean bl = isDefault = isEnable && this.isDefaultChoice(selectedChoice);
        if (isDefault) {
            this.changeDefault.setText(BUTTON_LABEL_REMOVE_DEFAULT);
        } else {
            this.changeDefault.setText(BUTTON_LABEL_SET_DEFAULT);
        }
        this.changeDefault.setSelection(isDefault);
        this.changeDefault.setEnabled(isEnable);
    }

    private void updateButtons() {
        boolean canFinish;
        boolean bl = canFinish = !StringUtil.isBlank((String)this.nameEditor.getText());
        if (canFinish) {
            if (this.errorMessageLine != null && !this.errorMessageLine.isDisposed()) {
                boolean bl2 = canFinish = this.errorMessageLine.getImage() == null;
            }
            if (this.columnChooser != null && !this.columnChooser.isDisposed() && !this.isStatic()) {
                canFinish &= this.getExpression(this.columnChooser.getText()) != null;
            }
        }
        this.getOkButton().setEnabled(canFinish);
    }

    private void updateCheckBoxArea() {
        if ("text-box".equals(this.getSelectedControlType()) || "auto-suggest".equals(this.getSelectedControlType())) {
            this.doNotEcho.setEnabled(true);
            this.distinct.setEnabled(false);
        } else {
            this.doNotEcho.setEnabled(false);
            this.distinct.setEnabled(true);
        }
    }

    private void updateMessageLine() {
        String errorMessage = this.validateName();
        if (errorMessage == null && !this.isStatic() && this.columnChooser != null && !this.columnChooser.isDisposed() && this.columnChooser.getItemCount() == 0) {
            errorMessage = ERROR_MSG_NO_AVAILABLE_COLUMN;
        }
        if (errorMessage != null) {
            this.errorMessageLine.setText(errorMessage);
            this.errorMessageLine.setImage(ERROR_ICON);
        } else {
            this.errorMessageLine.setText("");
            this.errorMessageLine.setImage(null);
        }
        if (this.promptMessageLine != null && !this.promptMessageLine.isDisposed()) {
            if ("dateTime".equals(this.getSelectedDataType())) {
                this.promptMessageLine.setText(LABEL_DATETIME_PROMPT);
            } else if ("date".equals(this.getSelectedDataType())) {
                this.promptMessageLine.setText(LABEL_DATE_PROMPT);
            } else if ("time".equals(this.getSelectedDataType())) {
                this.promptMessageLine.setText(LABEL_TIME_PROMPT);
            } else {
                this.promptMessageLine.setText("");
            }
        }
        this.updateButtons();
    }

    private String validateName() {
        String name = this.nameEditor.getText().trim();
        if (name.length() == 0) {
            return ERROR_MSG_NAME_IS_EMPTY;
        }
        if (!name.equals(this.inputParameter.getName()) && this.inputParameter.getModuleHandle().findParameter(name) != null) {
            return ERROR_MSG_DUPLICATED_NAME;
        }
        if (this.defaultValueChooser != null && !this.defaultValueChooser.isDisposed() && this.defaultValueChooser.getText().length() != 0) {
            try {
                this.validateValue(this.defaultValueChooser.getText());
            }
            catch (BirtException birtException) {
                return ERROR_MSG_MISMATCH_DATA_TYPE;
            }
        }
        return null;
    }

    private void refreshValueTable() {
        if (this.valueTable != null && !this.valueTable.getTable().isDisposed()) {
            this.valueTable.refresh();
            this.updateTableButtons();
        }
    }

    private boolean getProperty(String key) {
        return (Boolean)this.dirtyProperties.get(key);
    }

    private String isValidValue(String value) {
        if (this.canBeNull()) {
            if (value == null || value.length() == 0) {
                return null;
            }
        } else if (value == null || value.length() == 0) {
            return ERROR_MSG_CANNOT_BE_NULL;
        }
        if (this.canBeBlank()) {
            if (StringUtil.isBlank((String)value)) {
                return null;
            }
        } else if (StringUtil.isBlank((String)value)) {
            return ERROR_MSG_CANNOT_BE_BLANK;
        }
        try {
            this.validateValue(value);
        }
        catch (BirtException birtException) {
            return ERROR_MSG_MISMATCH_DATA_TYPE;
        }
        return null;
    }

    private boolean isEqual(String value1, String value2) {
        Object v1 = null;
        Object v2 = null;
        if (value1 == null && value2 != null || value1 != null && value2 == null) {
            return false;
        }
        try {
            v1 = this.validateValue(value1);
            v2 = this.validateValue(value2);
        }
        catch (BirtException birtException) {
            return false;
        }
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof Double && v2 instanceof Double) {
            return ((Double)v1).compareTo((Double)v2) == 0;
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2) == 0;
        }
        if (v1 instanceof Integer && v2 instanceof Integer) {
            return ((Integer)v1).compareTo((Integer)v2) == 0;
        }
        return v1.equals(v2);
    }

    private IChoiceSet getFormatChoiceSet(String type) {
        IChoiceSet choiceSet = null;
        if ("string".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("stringFormat");
        } else if ("dateTime".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("dateTimeFormat");
        } else if ("date".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("dateFormat");
        } else if ("time".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("timeFormat");
        } else if ("decimal".equals(type) || "float".equals(type) || "integer".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("numberFormat");
        }
        return choiceSet;
    }

    private void updateFormatField() {
        String previewString;
        String displayFormat;
        String type = this.getSelectedDataType();
        IChoiceSet choiceSet = this.getFormatChoiceSet(type);
        if (choiceSet == null) {
            displayFormat = DEUtil.getMetaDataDictionary().getChoiceSet("stringFormat").findChoice("Unformatted").getDisplayName();
            previewString = "True";
        } else {
            if (this.formatCategroy == null) {
                return;
            }
            displayFormat = choiceSet.findChoice(this.formatCategroy).getDisplayName();
            if (ParameterUtil.isCustomCategory(this.formatCategroy)) {
                displayFormat = String.valueOf(displayFormat) + ": " + this.formatPattern;
            }
            previewString = type.equals("dateTime") ? new DateFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : (this.formatCategroy.equals("Unformatted") ? "DateTimeUnformatted" : this.formatCategroy), ULocale.getDefault()).format(new Date()) : (type.equals("date") ? new DateFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : (this.formatCategroy.equals("Unformatted") ? "DateUnformatted" : this.formatCategroy), ULocale.getDefault()).format(new Date()) : (type.equals("time") ? new DateFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : (this.formatCategroy.equals("Unformatted") ? "TimeUnformatted" : this.formatCategroy), ULocale.getDefault()).format(new Date()) : (type.equals("string") ? new StringFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : this.formatCategroy, ULocale.getDefault()).format(this.defaultValue == null ? Messages.getString((String)"FormatStringPage.default.preview.text") : this.defaultValue) : (type.equals("integer") || type.equals("decimal") || type.equals("float") ? new NumberFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) || this.isNumberFormat(this.formatCategroy) ? this.formatPattern : this.formatCategroy, ULocale.getDefault()).format(this.defaultValue == null ? 1234.56 : Double.parseDouble(this.defaultValue)) : new NumberFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : this.formatCategroy, ULocale.getDefault()).format(1234.56)))));
        }
        this.formatField.setText(displayFormat);
        this.previewLabel.setText(this.convertNullString(previewString));
        this.changeFormat.setEnabled(choiceSet != null);
    }

    private boolean isNumberFormat(String formatCatogory) {
        return formatCatogory.equals("Unformatted") || formatCatogory.equals("General Number") || formatCatogory.equals("Currency") || formatCatogory.equals("Fixed") || formatCatogory.equals("Percent") || formatCatogory.equals("Scientific");
    }

    private String convertNullString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private boolean containValue(SelectionChoice selectedChoice, String newValue, String property) {
        for (SelectionChoice choice : this.choiceList) {
            if (choice == selectedChoice) continue;
            String value = null;
            if (COLUMN_VALUE.equals(property) && this.isEqual(value = choice.getValue(), newValue)) {
                return true;
            }
            if (COLUMN_DISPLAY_TEXT_KEY.equals(property)) {
                value = choice.getLabelResourceKey();
                if (value == null) {
                    value = choice.getValue();
                }
                if (value == null) {
                    value = LABEL_NULL;
                }
                if (value.equals(newValue)) {
                    return true;
                }
            }
            if (!COLUMN_DISPLAY_TEXT.equals(property)) continue;
            value = choice.getLabel();
            if (value == null) {
                value = choice.getValue();
            }
            if (value == null) {
                value = LABEL_NULL;
            }
            if (!value.equals(newValue)) continue;
            return true;
        }
        return false;
    }

    private void popupFormatBuilder(boolean refresh) {
        String dataType = this.getSelectedDataType();
        if ("boolean".equals(dataType)) {
            return;
        }
        int formatType = "string".equals(dataType) ? 1 : ("dateTime".equals(dataType) ? 3 : ("date".equals(dataType) ? 4 : ("time".equals(dataType) ? 5 : 2)));
        FormatBuilder formatBuilder = new FormatBuilder(formatType);
        formatBuilder.setInputFormat(this.formatCategroy, this.formatPattern);
        formatBuilder.setPreviewText(this.defaultValue);
        if (formatBuilder.open() == 0) {
            this.formatCategroy = ((String[])formatBuilder.getResult())[0];
            this.formatPattern = ((String[])formatBuilder.getResult())[1];
            this.updateFormatField();
            if (refresh) {
                this.refreshValueTable();
            }
        }
    }

    private boolean canBeBlank() {
        boolean canBeBlank = false;
        canBeBlank = this.dirtyProperties.containsKey(CHECKBOX_ISREQUIRED) ? (Boolean)this.dirtyProperties.get(CHECKBOX_ISREQUIRED) == false : !this.inputParameter.isRequired();
        return canBeBlank;
    }

    private boolean canBeNull() {
        boolean canBeNull = true;
        canBeNull = this.dirtyProperties.containsKey(CHECKBOX_ISREQUIRED) ? (Boolean)this.dirtyProperties.get(CHECKBOX_ISREQUIRED) == false : !this.inputParameter.isRequired();
        return canBeNull;
    }

    private boolean isDefaultChoice(SelectionChoice choice) {
        String choiceValue = choice.getValue();
        if (this.canBeNull() && choiceValue == null && this.defaultValue == null) {
            return true;
        }
        return choiceValue != null && this.defaultValue != null && this.isEqual(choiceValue, this.defaultValue);
    }

    private boolean isStatic() {
        return this.staticRadio.getSelection();
    }

    private String convertToStandardFormat(String string) {
        if (string != null && "dateTime".equals(this.getSelectedDataType())) {
            try {
                string = ParameterUtil.convertToStandardFormat(DataTypeUtil.toDate((String)string, (ULocale)ULocale.US));
            }
            catch (BirtException birtException) {}
        }
        return string;
    }

    private String getExpression(String columnName) {
        if (columnName.equals(NONE_DISPLAY_TEXT)) {
            return null;
        }
        for (ResultSetColumnHandle cachedColumn : this.columnList) {
            if (!cachedColumn.getColumnName().equals(columnName)) continue;
            return DEUtil.getExpression((Object)cachedColumn);
        }
        return columnName;
    }

    private String getColumnName(String expression) {
        for (ResultSetColumnHandle cachedColumn : this.columnList) {
            if (!DEUtil.getExpression((Object)cachedColumn).equals(expression)) continue;
            return cachedColumn.getColumnName();
        }
        return expression;
    }

    private String getInputControlDisplayName() {
        String type = this.getInputControlType();
        String displayName = null;
        if (CONTROL_TYPE_CHOICE_SET.findChoice(type) != null) {
            displayName = CONTROL_TYPE_CHOICE_SET.findChoice(type).getDisplayName();
        } else if (PARAM_CONTROL_COMBO.equals(type)) {
            displayName = DISPLAY_NAME_CONTROL_COMBO;
        } else if (PARAM_CONTROL_LIST.equals(type)) {
            displayName = DISPLAY_NAME_CONTROL_LIST;
        }
        return displayName;
    }

    private String validateChoice(SelectionChoice choice, String displayLabelKey, String displayLabel, String value) {
        String errorMessage = this.isValidValue(value);
        if (errorMessage != null) {
            return errorMessage;
        }
        if (this.distinct.isEnabled() && this.distinct.getSelection()) {
            if (this.containValue(choice, displayLabelKey, COLUMN_DISPLAY_TEXT_KEY)) {
                return ERROR_MSG_DUPLICATED_LABELKEY;
            }
            return null;
        }
        if (this.containValue(choice, value, COLUMN_VALUE)) {
            return ERROR_MSG_DUPLICATED_VALUE;
        }
        if (displayLabel == null && this.containValue(choice, value, COLUMN_DISPLAY_TEXT) || this.containValue(choice, displayLabel, COLUMN_DISPLAY_TEXT)) {
            return ERROR_MSG_DUPLICATED_LABEL;
        }
        if (this.containValue(choice, displayLabelKey, COLUMN_DISPLAY_TEXT_KEY)) {
            return ERROR_MSG_DUPLICATED_LABELKEY;
        }
        return null;
    }

    private void changeDefaultValue(String value) {
        this.defaultValue = value;
        this.updateMessageLine();
        this.updateFormatField();
    }

    private void setExpression(Combo chooser, String key) {
        chooser.deselectAll();
        key = StringUtil.trimString((String)key);
        if (StringUtil.isBlank((String)key)) {
            chooser.setText("");
            return;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            if (key.equals(DEUtil.getExpression(this.columnList.get(i)))) {
                chooser.setText(((ResultSetColumnHandle)this.columnList.get(i)).getColumnName());
                return;
            }
            ++i;
        }
        chooser.setText(key);
    }
}

