/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceFilter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ResourceFilterDialog
extends BaseDialog {
    private List filters = new ArrayList();
    private Text descriptionText;
    private CheckboxTableViewer viewer;

    public ResourceFilterDialog() {
        super(Messages.getString((String)"ResourceFilterDialog.Title"));
    }

    public void setInput(List filters) {
        this.filters = filters;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayout((Layout)new GridLayout());
        this.createViewerArea(container);
        this.createHelpArea(container);
        this.initViewer();
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.ResourceFilterDialog_ID");
        return composite;
    }

    private void initViewer() {
        this.viewer.setInput((Object)this.filters);
        int i = 0;
        while (i < this.filters.size()) {
            ResourceFilter filter = (ResourceFilter)this.filters.get(i);
            this.viewer.setChecked((Object)filter, filter.isEnabled());
            ++i;
        }
    }

    private void createHelpArea(Composite parent) {
        Label descriptionLabel = new Label(parent, 0);
        descriptionLabel.setText(Messages.getString((String)"ResourceFilterDialog.Lable.Description"));
        this.descriptionText = new Text(parent, 2634);
        GridData gd = new GridData(1808);
        gd.heightHint = 40;
        this.descriptionText.setLayoutData((Object)gd);
    }

    private void createViewerArea(Composite parent) {
        Label viewerLabel = new Label(parent, 0);
        viewerLabel.setText(Messages.getString((String)"ResourceFilterDialog.Lable.Viewer"));
        Table table = new Table(parent, 2852);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        TableColumn column = new TableColumn(table, 16384);
        column.setWidth(250);
        this.viewer = new CheckboxTableViewer(table);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 200;
        this.viewer.getTable().setLayoutData((Object)gd);
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourceFilter filter;
                StructuredSelection selection = (StructuredSelection)ResourceFilterDialog.this.viewer.getSelection();
                Object obj = null;
                if (selection != null && (obj = selection.getFirstElement()) != null && (filter = (ResourceFilter)obj).getDescription() != null) {
                    ResourceFilterDialog.this.descriptionText.setText(filter.getDescription());
                }
            }

            public void widgetSelected(SelectionEvent e) {
                ResourceFilter filter;
                StructuredSelection selection = (StructuredSelection)ResourceFilterDialog.this.viewer.getSelection();
                Object obj = null;
                if (selection != null && (obj = selection.getFirstElement()) != null && (filter = (ResourceFilter)obj).getDescription() != null) {
                    ResourceFilterDialog.this.descriptionText.setText(filter.getDescription());
                }
            }
        });
        FilterProvider provider = new FilterProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ResourceFilter filter = (ResourceFilter)event.getElement();
                if (event.getChecked()) {
                    filter.setEnabled(true);
                } else {
                    filter.setEnabled(false);
                }
            }
        });
        this.viewer.setInput((Object)this.filters);
    }

    class FilterProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        FilterProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getText(Object element) {
            if (element instanceof ResourceFilter) {
                return ((ResourceFilter)element).getDisplayName();
            }
            return "";
        }

        public String getToolTip(Object element) {
            return this.getText(element);
        }
    }
}

