/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectParameterDefaultValueDialog
extends BaseDialog {
    private org.eclipse.swt.widgets.List selectValueList = null;
    private List columnValueList = new ArrayList();
    private final String NULL_VALUE_DISPLAY = Messages.getString((String)"SelectValueDialog.SelectValue.NullValue");

    public SelectParameterDefaultValueDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public void setColumnValueList(Collection valueList) {
        this.columnValueList.clear();
        this.columnValueList.addAll(valueList);
    }

    public String getSelectedValue() {
        String[] result = (String[])this.getResult();
        return result != null && result.length > 0 ? result[0] : null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString((String)"SelectParameterDefaultValueDialog.Title"));
        this.selectValueList = new org.eclipse.swt.widgets.List(composite, 772);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.selectValueList.setLayoutData((Object)data);
        this.selectValueList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SelectParameterDefaultValueDialog.this.selectValueList.getSelectionCount() > 0) {
                    SelectParameterDefaultValueDialog.this.okPressed();
                }
            }
        });
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SelectParameterDefaultValueDialog.this.populateList();
            }
        });
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.SelectParameterDefaultValueDialog_ID");
        return composite;
    }

    protected void okPressed() {
        String[] selection = this.selectValueList.getSelection();
        int index = this.selectValueList.getSelectionIndex();
        if (selection.length > 0 && this.NULL_VALUE_DISPLAY.equals(selection[0]) && this.columnValueList.get(index) == null) {
            this.setResult(null);
        } else {
            this.setResult(this.selectValueList.getSelection());
        }
        super.okPressed();
    }

    private String convertToStandardFormat(java.util.Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return new DateFormatter("yyyy-MM-dd", ULocale.US).format(date);
        }
        if (date instanceof Time) {
            return new DateFormatter("HH:mm:ss", ULocale.US).format(date);
        }
        return new DateFormatter("yyyy-MM-dd HH:mm:ss.SSS", ULocale.US).format(date);
    }

    private void populateList() {
        try {
            this.getOkButton().setEnabled(false);
            this.selectValueList.removeAll();
            this.selectValueList.deselectAll();
            if (this.columnValueList != null) {
                for (Object obj : this.columnValueList) {
                    String candiateValue = null;
                    candiateValue = obj == null ? this.NULL_VALUE_DISPLAY : (obj instanceof java.util.Date ? this.convertToStandardFormat((java.util.Date)obj) : String.valueOf(obj));
                    this.selectValueList.add(candiateValue);
                }
            }
            if (this.selectValueList.getItemCount() > 0) {
                this.selectValueList.select(0);
                this.getOkButton().setEnabled(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

