/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class TreeValueDialog
extends ElementTreeSelectionDialog {
    List<ListenerClass> listeners = new ArrayList<ListenerClass>();

    public TreeValueDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setAllowMultiple(false);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = super.createTreeViewer(parent);
        Tree tree = treeViewer.getTree();
        assert (tree != null);
        int i = 0;
        while (i < this.listeners.size()) {
            int type = this.listeners.get((int)i).type;
            Listener listener = this.listeners.get((int)i).listener;
            tree.addListener(type, listener);
            ++i;
        }
        return treeViewer;
    }

    public void addListener(int type, Listener listner) {
        this.listeners.add(new ListenerClass(type, listner));
    }

    public boolean removeListener(int index) {
        if (index >= 0 && index < this.listeners.size()) {
            this.listeners.remove(index);
            return true;
        }
        return false;
    }

    public boolean removeAllListeners() {
        this.listeners.clear();
        return true;
    }

    private class ListenerClass {
        int type;
        Listener listener;

        public ListenerClass(int type, Listener listener) {
            this.type = type;
            this.listener = listener;
        }
    }
}

