/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ElementAdapterInvocationHandler
implements InvocationHandler {
    private List adapters;

    public ElementAdapterInvocationHandler(List adapters) {
        this.adapters = adapters;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.adapters != null && this.adapters.size() > 0) {
                Class<?> returnType = method.getReturnType();
                if (returnType.isArray()) {
                    ArrayList allResult = new ArrayList();
                    Iterator iter = this.adapters.iterator();
                    while (iter.hasNext()) {
                        Object result = method.invoke(iter.next(), args);
                        if (result == null) continue;
                        allResult.addAll(Arrays.asList((Object[])result));
                    }
                    Object a = Array.newInstance(returnType.getComponentType(), allResult.size());
                    return allResult.toArray((Object[])a);
                }
                if (returnType == Collection.class) {
                    ArrayList allResult = new ArrayList();
                    Iterator iter = this.adapters.iterator();
                    while (iter.hasNext()) {
                        Object result = method.invoke(iter.next(), args);
                        allResult.addAll((Collection)result);
                    }
                    return allResult;
                }
                if (returnType == Boolean.class) {
                    boolean returnValue = false;
                    Iterator iter = this.adapters.iterator();
                    while (iter.hasNext()) {
                        Boolean result = (Boolean)method.invoke(iter.next(), args);
                        if (returnValue == result) continue;
                        returnValue ^= result.booleanValue();
                    }
                    return new Boolean(returnValue);
                }
                if (returnType == Void.TYPE) {
                    Iterator iter = this.adapters.iterator();
                    while (iter.hasNext()) {
                        method.invoke(iter.next(), args);
                    }
                } else {
                    Iterator iter = this.adapters.iterator();
                    if (iter.hasNext()) {
                        return method.invoke(iter.next(), args);
                    }
                }
            }
        }
        catch (Exception e) {
            throw e.getCause();
        }
        return null;
    }
}

