/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.action;

import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractElementAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.ui.PlatformUI;

public class EditCubeAction
extends AbstractElementAction {
    public static final String ID = "org.eclipse.birt.report.designer.ui.actions.EditCubeAction";

    public EditCubeAction(String text) {
        super((Object)text);
        this.setId(ID);
    }

    public EditCubeAction(Object selectedObject, String text) {
        super(selectedObject, text);
        this.setId(ID);
    }

    protected boolean doAction() throws Exception {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Edit cube action >> Runs ...");
        }
        TabularCubeHandle cubeHandle = null;
        if (this.getSelection() instanceof TabularCubeHandle) {
            cubeHandle = (TabularCubeHandle)this.getSelection();
        } else if (this.getSelection() instanceof PropertyHandle) {
            cubeHandle = (TabularCubeHandle)((PropertyHandle)this.getSelection()).getElementHandle();
        }
        CubeBuilder dialog = new CubeBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), cubeHandle);
        if (this.getSelection() instanceof CubeHandle) {
            dialog.showPage("org.eclipse.birt.datasource.editor.cubebuilder.datasetselectionpage");
        } else if (this.getSelection() instanceof PropertyHandle) {
            dialog.showPage("org.eclipse.birt.datasource.editor.cubebuilder.grouppage");
        }
        return dialog.open() == 0;
    }

    public boolean isEnabled() {
        if (this.getSelection() instanceof CubeHandle) {
            return ((CubeHandle)this.getSelection()).canEdit();
        }
        return this.getSelection() instanceof PropertyHandle && ((PropertyHandle)this.getSelection()).getElementHandle() instanceof CubeHandle;
    }

    protected String getTransactionLabel() {
        if (this.getSelection() instanceof CubeHandle) {
            return Messages.getFormattedString("cube.edit", new String[]{((CubeHandle)this.getSelection()).getName()});
        }
        return super.getTransactionLabel();
    }
}

