/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MeasureDialog
extends BaseDialog {
    private TabularMeasureHandle input;
    private TabularCubeHandle cube;
    private Text nameText;
    private static IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("dataType").getAllowedChoices().getChoices();
    private Object result;
    private boolean isEdit = false;
    private Combo typeCombo;
    private Text expressionText;
    private Combo functionCombo;
    private Button expressionButton;

    private String[] getDataTypeNames() {
        IChoice[] choices = dataTypes;
        if (choices == null) {
            return new String[0];
        }
        String[] names = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            names[i] = choices[i].getName();
            ++i;
        }
        return names;
    }

    private String getDataTypeDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("dataType").getAllowedChoices());
    }

    private String[] getDataTypeDisplayNames() {
        IChoice[] choices = dataTypes;
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    private String[] getFunctionDisplayNames() {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    private IAggrFunction getFunctionByDisplayName(String displayName) {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return null;
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getDisplayName().equals(displayName)) {
                return choices[i];
            }
            ++i;
        }
        return null;
    }

    private String getFunctionDisplayName(String function) {
        try {
            return DataUtil.getAggregationManager().getAggregation(function).getDisplayName();
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private IAggrFunction[] getFunctions() {
        try {
            List aggrInfoList = DataUtil.getAggregationManager().getAggregations(2);
            return aggrInfoList.toArray(new IAggrFunction[0]);
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
            return new IAggrFunction[0];
        }
    }

    public MeasureDialog(boolean newOrEdit) {
        super(Messages.getString("MeasureDialog.Title"));
        this.isEdit = !newOrEdit;
    }

    public void setInput(TabularCubeHandle cube, TabularMeasureHandle input) {
        this.input = input;
        this.cube = cube;
    }

    protected Control createDialogArea(Composite parent) {
        this.createTitleArea(parent);
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.MeasureDialog_ID");
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginWidth = 20;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(70);
        contents.setLayoutData((Object)data);
        this.createMeasureArea(contents);
        WidgetUtil.createGridPlaceholder((Composite)contents, (int)1, (boolean)true);
        this.initMeasureDialog();
        return contents;
    }

    private void initMeasureDialog() {
        this.typeCombo.setItems(this.getDataTypeDisplayNames());
        this.functionCombo.setItems(this.getFunctionDisplayNames());
        if (!this.isEdit) {
            if (this.typeCombo.getItemCount() > 0) {
                this.typeCombo.select(0);
            }
            if (this.functionCombo.getItemCount() > 0) {
                this.functionCombo.select(0);
            }
            this.handleFunctionSelectEvent();
        } else {
            try {
                this.functionCombo.setText(this.getFunctionDisplayName(DataAdapterUtil.adaptModelAggregationType((String)this.input.getFunction())) == null ? "" : this.getFunctionDisplayName(DataAdapterUtil.adaptModelAggregationType((String)this.input.getFunction())));
            }
            catch (AdapterException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.expressionText.setText(this.input.getMeasureExpression() == null ? "" : this.input.getMeasureExpression());
            this.nameText.setText(this.input.getName() == null ? "" : this.input.getName());
            this.handleFunctionSelectEvent();
            this.typeCombo.setText(this.getDataTypeDisplayName(this.input.getDataType()) == null ? "" : this.getDataTypeDisplayName(this.input.getDataType()));
        }
    }

    public Object getResult() {
        return this.result;
    }

    protected void okPressed() {
        try {
            if (!this.isEdit) {
                TabularMeasureHandle measure;
                if (this.input == null) {
                    measure = DesignElementFactory.getInstance().newTabularMeasure(this.nameText.getText());
                } else {
                    measure = this.input;
                    this.input.setName(this.nameText.getText());
                }
                measure.setFunction(this.getFunctions()[this.functionCombo.getSelectionIndex()].getName());
                measure.setDataType(this.getDataTypeNames()[this.typeCombo.getSelectionIndex()]);
                if (this.expressionText.isEnabled()) {
                    measure.setMeasureExpression(this.expressionText.getText());
                }
                this.result = measure;
            } else {
                this.input.setName(this.nameText.getText());
                this.input.setFunction(this.getFunctions()[this.functionCombo.getSelectionIndex()].getName());
                this.input.setDataType(this.getDataTypeNames()[this.typeCombo.getSelectionIndex()]);
                if (this.expressionText.isEnabled()) {
                    this.input.setMeasureExpression(this.expressionText.getText());
                } else {
                    this.input.setMeasureExpression(null);
                }
                this.result = this.input;
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle((Throwable)e);
            return;
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.checkOkButtonStatus();
    }

    private Composite createMeasureArea(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setText(Messages.getString("MeasureDialog.Label.Name"));
        this.nameText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        Label functionLabel = new Label((Composite)group, 0);
        functionLabel.setText(Messages.getString("MeasureDialog.Label.Function"));
        this.functionCombo = new Combo((Composite)group, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.functionCombo.setLayoutData((Object)gd);
        this.functionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MeasureDialog.this.handleFunctionSelectEvent();
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        Label typeLabel = new Label((Composite)group, 0);
        typeLabel.setText(Messages.getString("MeasureDialog.Label.DataType"));
        this.typeCombo = new Combo((Composite)group, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.typeCombo.setLayoutData((Object)gd);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MeasureDialog.this.handleTypeSelectEvent();
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        Label expressionLabel = new Label((Composite)group, 0);
        expressionLabel.setText(Messages.getString("MeasureDialog.Label.Expression"));
        this.expressionText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.expressionText.setLayoutData((Object)gd);
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        this.expressionButton = new Button((Composite)group, 8);
        UIUtil.setExpressionButtonImage((Button)this.expressionButton);
        this.expressionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MeasureDialog.this.openExpression();
            }
        });
        return group;
    }

    protected void handleTypeSelectEvent() {
        IAggrFunction function = this.getFunctionByDisplayName(this.functionCombo.getText());
        if (function == null) {
            return;
        }
        try {
            String recommendType = this.getDataTypeDisplayName(DataAdapterUtil.adapterToModelDataType((int)DataUtil.getAggregationManager().getAggregation(function.getName()).getDataType()));
            if (!this.typeCombo.getText().equals(recommendType) && this.typeCombo.indexOf(recommendType) != -1 && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("MeasureDialog.MessageDialog.Title"), (String)Messages.getFormattedString("MeasureDialog.MessageDialog.Message", new Object[]{recommendType}))) {
                this.typeCombo.setText(recommendType);
            }
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void handleFunctionSelectEvent() {
        IAggrFunction function = this.getFunctionByDisplayName(this.functionCombo.getText());
        if (function == null) {
            return;
        }
        try {
            this.typeCombo.setText(this.getDataTypeDisplayName(DataAdapterUtil.adapterToModelDataType((int)DataUtil.getAggregationManager().getAggregation(function.getName()).getDataType())));
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        int parameterLength = function.getParameterDefn().length;
        this.expressionText.setEnabled(parameterLength > 0);
        this.expressionButton.setEnabled(parameterLength > 0);
    }

    protected void checkOkButtonStatus() {
        IParameterDefn param;
        if ((this.nameText.getText() == null || this.nameText.getText().trim().equals("") || this.functionCombo.getSelectionIndex() == -1 || this.typeCombo.getSelectionIndex() == -1) && this.getOkButton() != null) {
            this.getOkButton().setEnabled(false);
            return;
        }
        IAggrFunction function = this.getFunctionByDisplayName(this.functionCombo.getText());
        if (!(function == null || function.getParameterDefn().length <= 0 || (param = function.getParameterDefn()[0]).isOptional() || this.expressionText.getText() != null && this.expressionText.getText().trim().length() != 0 || this.getOkButton() == null)) {
            this.getOkButton().setEnabled(false);
            return;
        }
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(true);
        }
    }

    private void openExpression() {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.expressionText.getText());
        CubeExpressionProvider provider = new CubeExpressionProvider((DesignElementHandle)this.cube);
        expressionBuilder.setExpressionProvier((IExpressionProvider)provider);
        if (expressionBuilder.open() == 0) {
            this.expressionText.setText(expressionBuilder.getResult());
        }
    }

    private Composite createTitleArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        contents.setLayoutData((Object)data);
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(contents, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(Messages.getString("MeasureDialog.Title.Property"));
        return titleArea;
    }
}

