/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.commands;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.AttributeEditPart;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.ColumnEditPart;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.DatasetNodeEditPart;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.HierarchyNodeEditPart;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.LevelEditPart;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.api.elements.structures.DimensionJoinCondition;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class AddJoinConditionCommand
extends Command {
    protected EditPart source;
    protected ColumnEditPart target;

    public AddJoinConditionCommand(EditPart source, ColumnEditPart target) {
        this.source = source;
        this.target = target;
    }

    public boolean canExecute() {
        boolean canExecute = this.target != null && this.source != null;
        return canExecute;
    }

    public void execute() {
        if (this.source == null || this.target == null) {
            return;
        }
        DimensionJoinCondition joinCondition = StructureFactory.createDimensionJoinCondition();
        joinCondition.setCubeKey(this.target.getColumnName());
        if (this.source instanceof LevelEditPart) {
            joinCondition.setHierarchyKey(((LevelEditPart)this.source).getLevelColumnName());
        } else if (this.source instanceof AttributeEditPart) {
            joinCondition.setHierarchyKey(((AttributeEditPart)this.source).getColumnName());
        }
        TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)((HierarchyNodeEditPart)this.source.getParent()).getModel();
        try {
            TabularCubeHandle cube = ((DatasetNodeEditPart)this.target.getParent()).getCube();
            DimensionJoinConditionHandle handle = this.getDimensionCondition(cube, hierarchy).addJoinCondition(joinCondition);
            if (this.source instanceof AttributeEditPart) {
                LevelAttributeHandle levelAttribute = (LevelAttributeHandle)((AttributeEditPart)this.source).getModel();
                LevelHandle level = (LevelHandle)levelAttribute.getElementHandle();
                handle.setLevel(level);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private DimensionConditionHandle getDimensionCondition(TabularCubeHandle cube, TabularHierarchyHandle hierarchy) throws Exception {
        DimensionConditionHandle conditionHandle = cube.findDimensionCondition((HierarchyHandle)hierarchy);
        if (conditionHandle != null) {
            return conditionHandle;
        }
        DimensionCondition dimensionCondition = StructureFactory.createCubeJoinCondition();
        conditionHandle = cube.addDimensionCondition(dimensionCondition);
        conditionHandle.setHierarchy((HierarchyHandle)hierarchy);
        return conditionHandle;
    }
}

