/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.DatasetNodeEditPart;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.NodeEditPartHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editpolicies.ColumnSelectionEditPolicy;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editpolicies.ConnectionCreationEditPolicy;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.ColumnFigure;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class ColumnEditPart
extends NodeEditPartHelper
implements Listener {
    protected Label label;
    private TabularCubeHandle cube;

    public ColumnEditPart(EditPart parent, ResultSetColumnHandle column) {
        this.setParent(parent);
        this.setModel(column);
        this.cube = ((DatasetNodeEditPart)this.getParent()).getCube();
    }

    public TabularCubeHandle getCube() {
        return this.cube;
    }

    protected IFigure createFigure() {
        ColumnFigure columnFigure = null;
        columnFigure = new ColumnFigure();
        FlowLayout layout = new FlowLayout();
        layout.setMinorSpacing(2);
        columnFigure.setLayoutManager((LayoutManager)layout);
        columnFigure.setOpaque(true);
        String name = this.getColumn().getColumnName();
        this.label = new Label(name);
        columnFigure.add((IFigure)this.label);
        return columnFigure;
    }

    private ResultSetColumnHandle getColumn() {
        return (ResultSetColumnHandle)this.getModel();
    }

    protected void createEditPolicies() {
        ColumnSelectionEditPolicy colEditPol = new ColumnSelectionEditPolicy();
        this.installEditPolicy("Selection Policy", (EditPolicy)colEditPol);
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ConnectionCreationEditPolicy());
    }

    public IFigure getChopFigure() {
        return ((AbstractGraphicalEditPart)this.getParent()).getFigure();
    }

    protected List getModelTargetConnections() {
        ArrayList<DimensionJoinConditionHandle> targetjoins = new ArrayList<DimensionJoinConditionHandle>();
        DatasetNodeEditPart datasetEditpart = (DatasetNodeEditPart)this.getParent();
        TabularCubeHandle cube = datasetEditpart.getCube();
        Iterator iter = cube.joinConditionsIterator();
        block0: while (iter.hasNext()) {
            DimensionConditionHandle condition = (DimensionConditionHandle)iter.next();
            block1: for (DimensionJoinConditionHandle joinCondition : condition.getJoinConditions()) {
                if (!joinCondition.getCubeKey().equals(this.getColumn().getColumnName())) continue;
                TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)condition.getHierarchy();
                if (hierarchy.getDataSet() == null) continue block0;
                if (joinCondition.getLevel() != null) {
                    LevelHandle level = joinCondition.getLevel();
                    Iterator attrIter = level.attributesIterator();
                    while (attrIter.hasNext()) {
                        LevelAttributeHandle handle = (LevelAttributeHandle)attrIter.next();
                        ResultSetColumnHandle column = OlapUtil.getDataField(hierarchy.getDataSet(), handle.getName());
                        if (column == null || !column.getColumnName().equals(joinCondition.getHierarchyKey())) continue;
                        targetjoins.add(joinCondition);
                        continue block1;
                    }
                    continue;
                }
                if (OlapUtil.getDataField(hierarchy.getDataSet(), joinCondition.getHierarchyKey()) == null) continue;
                int i = 0;
                while (i < hierarchy.getLevelCount()) {
                    TabularLevelHandle level = (TabularLevelHandle)hierarchy.getLevel(i);
                    if (level.getColumnName() != null && level.getColumnName().equals(joinCondition.getHierarchyKey())) {
                        targetjoins.add(joinCondition);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        return targetjoins;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.isActive() && !this.isDelete()) {
            this.refreshTargetConnections();
        }
    }

    public void deactivate() {
        super.deactivate();
        this.cube.removeListener((Listener)this);
    }

    public void activate() {
        super.activate();
        this.cube.addListener((Listener)this);
    }

    public String getColumnName() {
        return this.getColumn().getColumnName();
    }
}

