/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.page;

import java.util.Iterator;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.RenameInputDialog;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ListenerElementVisitor;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.DateLevelDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.GroupDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.LevelPropertyDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.MeasureDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeContentProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeLabelProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.DataContentProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.VirtualField;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.widget.TreeViewerBackup;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class CubeGroupContent
extends Composite
implements Listener {
    private TreeItem[] dragSourceItems = new TreeItem[1];
    private TreeViewer dataFieldsViewer;
    private CubeBuilder builder;
    private TabularCubeHandle input;
    private TreeViewer groupViewer;
    private DataSetHandle[] datasets = new DataSetHandle[1];
    TreeListener groupTreeListener = new TreeListener(){

        public void treeCollapsed(TreeEvent e) {
            Item item = (Item)e.item;
            if (CubeGroupContent.this.groupBackup != null) {
                CubeGroupContent.this.groupBackup.updateCollapsedStatus(CubeGroupContent.this.groupViewer, item.getData());
            }
        }

        public void treeExpanded(TreeEvent e) {
            Item item = (Item)e.item;
            if (CubeGroupContent.this.groupBackup != null) {
                CubeGroupContent.this.groupBackup.updateExpandedStatus(CubeGroupContent.this.groupViewer, item.getData());
            }
        }
    };
    TreeListener dataTreeListener = new TreeListener(){

        public void treeCollapsed(TreeEvent e) {
            Item item = (Item)e.item;
            if (CubeGroupContent.this.dataBackup != null) {
                CubeGroupContent.this.dataBackup.updateCollapsedStatus(CubeGroupContent.this.dataFieldsViewer, item.getData());
            }
        }

        public void treeExpanded(TreeEvent e) {
            Item item = (Item)e.item;
            if (CubeGroupContent.this.dataBackup != null) {
                CubeGroupContent.this.dataBackup.updateExpandedStatus(CubeGroupContent.this.dataFieldsViewer, item.getData());
            }
        }
    };
    private Button addBtn;
    private Button delBtn;
    private int operations = 7;
    private Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
    private Button editBtn;
    private ListenerElementVisitor visitor;
    private DataContentProvider dataContentProvider = new DataContentProvider();
    private CubeLabelProvider cubeLabelProvider;
    private TreeViewerBackup dataBackup;
    private TreeViewerBackup groupBackup;
    private Button addButton;
    private Button removeButton;

    public CubeGroupContent(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(4, false);
        layout.marginTop = 0;
        this.setLayout((Layout)layout);
        this.createContent();
    }

    public CubeGroupContent(CubeBuilder builder, Composite parent, int style) {
        super(parent, style);
        this.builder = builder;
        GridLayout layout = new GridLayout(4, false);
        layout.marginTop = 0;
        this.setLayout((Layout)layout);
        this.createContent();
    }

    public void dispose() {
        this.dataBackup.dispose();
        this.groupBackup.dispose();
        if (this.visitor != null) {
            if (this.input != null) {
                this.visitor.removeListener((DesignElementHandle)this.input);
            }
            this.visitor.dispose();
            this.visitor = null;
        }
        super.dispose();
    }

    public void setInput(TabularCubeHandle cube) {
        if (this.input != null) {
            this.getListenerElementVisitor().removeListener((DesignElementHandle)this.input);
        }
        this.input = cube;
    }

    public void setInput(TabularCubeHandle cube, DataSetHandle dataset) {
        this.input = cube;
        this.datasets[0] = dataset;
    }

    public void createContent() {
        this.createDataField();
        this.createMoveButtonsField();
        this.createGroupField();
        this.createOperationField();
    }

    private void createOperationField() {
        Composite operationField = new Composite((Composite)this, 0);
        operationField.setLayout((Layout)new GridLayout());
        operationField.setLayout((Layout)new GridLayout());
        String[] btnTexts = new String[]{Messages.getString("GroupsPage.Button.Add"), Messages.getString("GroupsPage.Button.Edit"), Messages.getString("GroupsPage.Button.Delete")};
        this.addBtn = new Button(operationField, 8);
        this.addBtn.setEnabled(false);
        this.addBtn.setText(btnTexts[0]);
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleAddEvent();
            }
        });
        this.editBtn = new Button(operationField, 8);
        this.editBtn.setText(btnTexts[1]);
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleEditEvent();
            }
        });
        this.delBtn = new Button(operationField, 8);
        this.delBtn.setText(btnTexts[2]);
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleDelEvent();
            }
        });
        int width = UIUtil.getMaxStringWidth((String[])btnTexts, (Control)operationField) + 10;
        if (width < 60) {
            width = 60;
        }
        this.layoutButton(this.addBtn, width);
        this.layoutButton(this.editBtn, width);
        this.layoutButton(this.delBtn, width);
        this.addBtn.setEnabled(false);
        this.editBtn.setEnabled(false);
        this.delBtn.setEnabled(false);
        GridData data = (GridData)this.addBtn.getLayoutData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 1024;
        data = (GridData)this.delBtn.getLayoutData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 128;
    }

    private void layoutButton(Button button, int width) {
        GridData gd = new GridData();
        gd.widthHint = width;
        button.setLayoutData((Object)gd);
    }

    private void createGroupField() {
        Composite groupField = new Composite((Composite)this, 0);
        groupField.setLayoutData((Object)new GridData(1808));
        groupField.setLayout((Layout)new GridLayout());
        Label groupLabel = new Label(groupField, 0);
        groupLabel.setText(Messages.getString("GroupsPage.Label.Group"));
        this.groupViewer = new TreeViewer(groupField, 2820);
        this.groupViewer.getTree().setLayoutData((Object)new GridData(1808));
        ((GridData)this.groupViewer.getTree().getLayoutData()).heightHint = 250;
        ((GridData)this.groupViewer.getTree().getLayoutData()).widthHint = 250;
        this.groupViewer.setLabelProvider((IBaseLabelProvider)new CubeLabelProvider());
        this.groupViewer.setContentProvider((IContentProvider)new CubeContentProvider());
        this.groupViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CubeGroupContent.this.updateButtons();
            }
        });
        this.groupViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    try {
                        CubeGroupContent.this.handleDelEvent();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        });
        this.groupViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (CubeGroupContent.this.editBtn.isEnabled()) {
                    CubeGroupContent.this.handleEditEvent();
                }
            }
        });
        DragSource fieldsSource = new DragSource((Control)this.groupViewer.getTree(), this.operations);
        fieldsSource.setTransfer(this.types);
        fieldsSource.addDragListener((DragSourceListener)new CustomDragListener(this.groupViewer));
        DropTarget target = new DropTarget((Control)this.groupViewer.getTree(), this.operations);
        target.setTransfer(this.types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 24;
                if (OlapUtil.isFromLibrary(CubeGroupContent.this.input)) {
                    event.detail = 0;
                    return;
                }
                if (event.item != null) {
                    TreeItem item = (TreeItem)event.item;
                    Object element = item.getData();
                    event.detail = 2;
                    Object obj = CubeGroupContent.this.dragSourceItems[0].getData();
                    ResultSetColumnHandle dataField = null;
                    DataSetHandle dataset = null;
                    if (obj == null || obj instanceof DataSetHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("other")) {
                        event.detail = 0;
                        return;
                    }
                    if (obj instanceof ResultSetColumnHandle) {
                        DataSetHandle primary;
                        dataField = (ResultSetColumnHandle)obj;
                        dataset = (DataSetHandle)dataField.getElementHandle();
                        if (element instanceof LevelHandle) {
                            DataSetHandle temp = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)((LevelHandle)element).getContainer());
                            if (temp != null && dataset != null && dataset != temp) {
                                event.detail = 0;
                                return;
                            }
                            DesignElementHandle hierarchy = ((TabularLevelHandle)element).getContainer();
                            DimensionHandle dimension = (DimensionHandle)hierarchy.getContainer();
                            if (dimension.isTimeType()) {
                                event.detail = 0;
                                return;
                            }
                        } else if (element instanceof DimensionHandle || element instanceof VirtualField && ((VirtualField)element).getType().equals("level")) {
                            DimensionHandle dimension = null;
                            dimension = element instanceof DimensionHandle ? (DimensionHandle)element : (DimensionHandle)((VirtualField)element).getModel();
                            if (dimension.isTimeType() && (dimension.getDefaultHierarchy().getLevelCount() != 0 || !CubeGroupContent.this.isDateType(dataField.getDataType()))) {
                                event.detail = 0;
                                return;
                            }
                            DataSetHandle temp = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)dimension.getDefaultHierarchy());
                            if (temp != null && dataset != null && dataset != temp) {
                                event.detail = 0;
                                return;
                            }
                        } else if ((element instanceof MeasureGroupHandle || element instanceof VirtualField && ((VirtualField)element).getType().equals("measure") || element instanceof MeasureHandle || element instanceof VirtualField && ((VirtualField)element).getType().equals("measureGroup") || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("measureGroups")) && ((primary = CubeGroupContent.this.input.getDataSet()) == null || primary != dataset)) {
                            event.detail = 0;
                            return;
                        }
                    }
                    if (obj instanceof LevelHandle && (!(element instanceof LevelHandle) || element == obj || ((LevelHandle)obj).getContainer() != ((LevelHandle)element).getContainer())) {
                        event.detail = 0;
                        return;
                    }
                    Point pt = Display.getCurrent().map(null, (Control)CubeGroupContent.this.groupViewer.getTree(), event.x, event.y);
                    Rectangle bounds = item.getBounds();
                    event.feedback = pt.y < bounds.y + bounds.height / 3 ? (event.feedback |= 2) : (pt.y > bounds.y + 2 * bounds.height / 3 ? (event.feedback |= 4) : (event.feedback |= 1));
                } else {
                    event.detail = 0;
                }
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                Object obj = CubeGroupContent.this.dragSourceItems[0].getData();
                ResultSetColumnHandle dataField = null;
                DataSetHandle dataset = null;
                if (obj == null || obj instanceof DataSetHandle) {
                    event.detail = 0;
                    return;
                }
                if (obj instanceof ResultSetColumnHandle) {
                    DimensionHandle dimension;
                    DesignElementHandle hierarchy;
                    TabularMeasureHandle measure;
                    CommandStack stack;
                    dataField = (ResultSetColumnHandle)obj;
                    dataset = (DataSetHandle)dataField.getElementHandle();
                    if (event.item == null || dataField == null) {
                        event.detail = 0;
                        return;
                    }
                    TreeItem item = (TreeItem)event.item;
                    Point pt = Display.getCurrent().map(null, (Control)CubeGroupContent.this.groupViewer.getTree(), event.x, event.y);
                    Rectangle bounds = item.getBounds();
                    Object element = item.getData();
                    if (pt.y < bounds.y + bounds.height / 3) {
                        if (element instanceof MeasureHandle) {
                            stack = SessionHandleAdapter.getInstance().getCommandStack();
                            stack.startTrans("");
                            try {
                                measure = DesignElementFactory.getInstance().newTabularMeasure(dataField.getColumnName());
                                measure.setMeasureExpression(DEUtil.getExpression((Object)dataField));
                                measure.setDataType(dataField.getDataType());
                                ((MeasureHandle)element).getContainer().add("measures", (DesignElementHandle)measure);
                                stack.commit();
                            }
                            catch (SemanticException e) {
                                stack.rollback();
                                CubeGroupContent.this.refresh();
                                ExceptionHandler.handle((Throwable)e);
                                return;
                            }
                        } else if (element instanceof LevelHandle) {
                            hierarchy = ((TabularLevelHandle)element).getContainer();
                            dimension = (DimensionHandle)hierarchy.getContainer();
                            if (dimension.isTimeType()) {
                                event.detail = 0;
                                return;
                            }
                            int index = ((LevelHandle)element).getIndex();
                            CommandStack stack2 = SessionHandleAdapter.getInstance().getCommandStack();
                            stack2.startTrans("");
                            try {
                                TabularLevelHandle level = DesignElementFactory.getInstance().newTabularLevel(dimension, dataField.getColumnName());
                                level.setColumnName(dataField.getColumnName());
                                level.setDataType(dataField.getDataType());
                                ((LevelHandle)element).getContainer().add("levels", (DesignElementHandle)level, index);
                                stack2.commit();
                            }
                            catch (SemanticException e) {
                                stack2.rollback();
                                CubeGroupContent.this.refresh();
                                ExceptionHandler.handle((Throwable)e);
                                return;
                            }
                        }
                    } else {
                        CommandStack stack3;
                        if (element instanceof MeasureHandle) {
                            if (!CubeGroupContent.this.checkColumnDataType(dataField)) {
                                return;
                            }
                            stack = SessionHandleAdapter.getInstance().getCommandStack();
                            stack.startTrans("");
                            try {
                                measure = DesignElementFactory.getInstance().newTabularMeasure(dataField.getColumnName());
                                measure.setMeasureExpression(DEUtil.getExpression((Object)dataField));
                                measure.setDataType(dataField.getDataType());
                                ((MeasureHandle)element).getContainer().add("measures", (DesignElementHandle)measure);
                                stack.commit();
                            }
                            catch (SemanticException e) {
                                stack.rollback();
                                CubeGroupContent.this.refresh();
                                ExceptionHandler.handle((Throwable)e);
                                return;
                            }
                        }
                        if (element instanceof MeasureGroupHandle || element instanceof VirtualField && ((VirtualField)element).getType().equals("measure") || element instanceof VirtualField && ((VirtualField)element).getType().equals("measureGroup") || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("measureGroups")) {
                            if (!CubeGroupContent.this.checkColumnDataType(dataField)) {
                                return;
                            }
                            MeasureGroupHandle measureGroup = null;
                            stack3 = SessionHandleAdapter.getInstance().getCommandStack();
                            stack3.startTrans("");
                            try {
                                if (element instanceof VirtualField && ((VirtualField)element).getType().equals("measureGroup") || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("measureGroups")) {
                                    measureGroup = DesignElementFactory.getInstance().newTabularMeasureGroup(null);
                                    CubeGroupContent.this.input.add("measureGroups", (DesignElementHandle)measureGroup);
                                } else {
                                    measureGroup = element instanceof MeasureGroupHandle ? (MeasureGroupHandle)element : (MeasureGroupHandle)((VirtualField)element).getModel();
                                }
                                TabularMeasureHandle measure2 = DesignElementFactory.getInstance().newTabularMeasure(dataField.getColumnName());
                                measure2.setMeasureExpression(DEUtil.getExpression((Object)dataField));
                                measure2.setDataType(dataField.getDataType());
                                measureGroup.add("measures", (DesignElementHandle)measure2);
                                stack3.commit();
                            }
                            catch (SemanticException e) {
                                stack3.rollback();
                                CubeGroupContent.this.refresh();
                                ExceptionHandler.handle((Throwable)e);
                                return;
                            }
                        }
                        if (element instanceof LevelHandle) {
                            hierarchy = (TabularHierarchyHandle)((LevelHandle)element).getContainer();
                            dimension = (DimensionHandle)hierarchy.getContainer();
                            if (dimension.isTimeType()) {
                                event.detail = 0;
                                return;
                            }
                            CommandStack stack4 = SessionHandleAdapter.getInstance().getCommandStack();
                            stack4.startTrans("");
                            try {
                                int index = ((LevelHandle)element).getIndex();
                                TabularLevelHandle level = DesignElementFactory.getInstance().newTabularLevel(dimension, dataField.getColumnName());
                                level.setColumnName(dataField.getColumnName());
                                level.setDataType(dataField.getDataType());
                                ((LevelHandle)element).getContainer().add("levels", (DesignElementHandle)level, index + 1);
                                stack4.commit();
                            }
                            catch (SemanticException e) {
                                stack4.rollback();
                                CubeGroupContent.this.refresh();
                                ExceptionHandler.handle((Throwable)e);
                                return;
                            }
                        }
                        if (element instanceof DimensionHandle || element instanceof VirtualField && ((VirtualField)element).getType().equals("level") || element instanceof VirtualField && ((VirtualField)element).getType().equals("dimension") || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("dimensions")) {
                            DimensionHandle dimension2 = null;
                            stack3 = SessionHandleAdapter.getInstance().getCommandStack();
                            stack3.startTrans("");
                            try {
                                if (element instanceof VirtualField && ((VirtualField)element).getType().equals("dimension") || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("dimensions")) {
                                    dimension2 = DesignElementFactory.getInstance().newTabularDimension(null);
                                    CubeGroupContent.this.input.add("dimensions", (DesignElementHandle)dimension2);
                                } else {
                                    dimension2 = element instanceof DimensionHandle ? (DimensionHandle)element : (DimensionHandle)((VirtualField)element).getModel();
                                }
                                if (dimension2.isTimeType() && dimension2.getDefaultHierarchy().getLevelCount() > 0) {
                                    event.detail = 0;
                                    stack3.rollback();
                                    return;
                                }
                                TabularHierarchyHandle hierarchy2 = (TabularHierarchyHandle)dimension2.getDefaultHierarchy();
                                if (hierarchy2.getDataSet() == null && hierarchy2.getLevelCount() == 0 && dataset != null && dataset != CubeGroupContent.this.input.getDataSet()) {
                                    hierarchy2.setDataSet(dataset);
                                }
                                if (CubeGroupContent.this.isDateType(dataField.getDataType()) && hierarchy2.getLevelCount() == 0) {
                                    GroupDialog dialog = new GroupDialog(true);
                                    dialog.setInput(hierarchy2, dataField.getColumnName());
                                    if (dialog.open() != 0) {
                                        stack3.rollback();
                                    } else {
                                        stack3.commit();
                                    }
                                } else {
                                    TabularLevelHandle level = DesignElementFactory.getInstance().newTabularLevel(dimension2, dataField.getColumnName());
                                    level.setColumnName(dataField.getColumnName());
                                    level.setDataType(dataField.getDataType());
                                    hierarchy2.add("levels", (DesignElementHandle)level);
                                    stack3.commit();
                                }
                            }
                            catch (SemanticException e) {
                                stack3.rollback();
                                CubeGroupContent.this.refresh();
                                ExceptionHandler.handle((Throwable)e);
                                return;
                            }
                        }
                    }
                }
                if (obj instanceof LevelHandle) {
                    int oldIndex = ((LevelHandle)obj).getIndex();
                    if (event.item == null) {
                        event.detail = 0;
                        return;
                    }
                    TreeItem item = (TreeItem)event.item;
                    Point pt = Display.getCurrent().map(null, (Control)CubeGroupContent.this.groupViewer.getTree(), event.x, event.y);
                    Rectangle bounds = item.getBounds();
                    LevelHandle element = (LevelHandle)item.getData();
                    int newIndex = element.getIndex();
                    if (newIndex < oldIndex) {
                        newIndex = pt.y < bounds.y + bounds.height / 3 ? element.getIndex() : element.getIndex() + 1;
                    } else if (newIndex > oldIndex) {
                        newIndex = pt.y < bounds.y + bounds.height / 3 ? element.getIndex() - 1 : element.getIndex();
                    }
                    CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                    stack.startTrans("");
                    try {
                        ((LevelHandle)obj).moveTo(newIndex);
                        stack.commit();
                    }
                    catch (SemanticException e) {
                        stack.rollback();
                        CubeGroupContent.this.refresh();
                        ExceptionHandler.handle((Throwable)e);
                        return;
                    }
                    CubeGroupContent.this.groupViewer.expandToLevel(obj, -1);
                    CubeGroupContent.this.groupViewer.setSelection((ISelection)new StructuredSelection(obj), true);
                }
                CubeGroupContent.this.refresh();
            }
        });
    }

    private void createMoveButtonsField() {
        Composite buttonsField = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        buttonsField.setLayout((Layout)layout);
        this.addButton = new Button(buttonsField, 8);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleAddEvent();
            }
        });
        this.removeButton = new Button(buttonsField, 8);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleDelEvent();
            }
        });
        this.addButton.setText(">");
        this.removeButton.setText("<");
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = Math.max(25, this.addButton.computeSize((int)-1, (int)-1).x);
        gd.verticalAlignment = 1024;
        this.addButton.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = Math.max(25, this.removeButton.computeSize((int)-1, (int)-1).x);
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 128;
        this.removeButton.setLayoutData((Object)gd);
    }

    private void createDataField() {
        Composite dataField = new Composite((Composite)this, 0);
        dataField.setLayoutData((Object)new GridData(1808));
        dataField.setLayout((Layout)new GridLayout());
        Label dataLabel = new Label(dataField, 0);
        dataLabel.setText(Messages.getString("GroupsPage.Label.DataField"));
        this.dataFieldsViewer = new TreeViewer(dataField, 2820);
        this.cubeLabelProvider = new CubeLabelProvider();
        this.dataFieldsViewer.setLabelProvider((IBaseLabelProvider)this.cubeLabelProvider);
        this.dataFieldsViewer.setContentProvider((IContentProvider)this.dataContentProvider);
        GridData gd = new GridData(1808);
        this.dataFieldsViewer.getTree().setLayoutData((Object)gd);
        ((GridData)this.dataFieldsViewer.getTree().getLayoutData()).heightHint = 250;
        ((GridData)this.dataFieldsViewer.getTree().getLayoutData()).widthHint = 225;
        this.dataFieldsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CubeGroupContent.this.updateButtons();
            }
        });
        DragSource fieldsSource = new DragSource((Control)this.dataFieldsViewer.getTree(), this.operations);
        fieldsSource.setTransfer(this.types);
        fieldsSource.addDragListener((DragSourceListener)new CustomDragListener(this.dataFieldsViewer));
    }

    public void load() {
        if (this.input != null) {
            this.dataFieldsViewer.getTree().removeTreeListener(this.dataTreeListener);
            if (this.datasets[0] != null) {
                this.dataFieldsViewer.setInput((Object)this.datasets);
            } else if (this.input.getDataSet() != null) {
                this.cubeLabelProvider.setInput(this.input);
                this.dataFieldsViewer.setInput((Object)this.input);
            }
            this.dataFieldsViewer.refresh();
            if (this.dataBackup != null) {
                this.dataBackup.restoreBackup(this.dataFieldsViewer);
            } else {
                this.dataBackup = new TreeViewerBackup();
                this.dataFieldsViewer.expandAll();
                this.dataBackup.updateStatus(this.dataFieldsViewer);
            }
            this.dataFieldsViewer.getTree().addTreeListener(this.dataTreeListener);
            this.groupViewer.getTree().removeTreeListener(this.groupTreeListener);
            this.groupViewer.setInput((Object)this.input);
            this.dataFieldsViewer.refresh();
            if (this.groupBackup != null) {
                this.groupBackup.restoreBackup(this.groupViewer);
            } else {
                this.groupBackup = new TreeViewerBackup();
                this.groupViewer.expandToLevel(4);
                this.groupBackup.updateStatus(this.groupViewer);
            }
            this.groupViewer.getTree().addTreeListener(this.groupTreeListener);
            this.getListenerElementVisitor().addListener((DesignElementHandle)this.input);
            this.updateButtons();
        }
    }

    private ListenerElementVisitor getListenerElementVisitor() {
        if (this.visitor == null) {
            this.visitor = new ListenerElementVisitor((Listener)this);
        }
        return this.visitor;
    }

    protected void updateButtons() {
        this.groupViewer.refresh();
        TreeSelection selections = (TreeSelection)this.groupViewer.getSelection();
        ResultSetColumnHandle dataField = null;
        if (selections.size() == 1) {
            Iterator iter = selections.iterator();
            Object obj = iter.next();
            TreeSelection dataSelection = (TreeSelection)this.dataFieldsViewer.getSelection();
            DataSetHandle dataset = null;
            if (dataSelection.size() == 1 && dataSelection.getFirstElement() != null && dataSelection.getFirstElement() instanceof ResultSetColumnHandle) {
                dataField = (ResultSetColumnHandle)dataSelection.getFirstElement();
                dataset = (DataSetHandle)dataField.getElementHandle();
            }
            if (dataField == null || dataset == null) {
                this.addBtn.setEnabled(false);
            }
            if (obj instanceof DimensionHandle || obj instanceof LevelHandle || obj instanceof MeasureHandle || obj instanceof MeasureGroupHandle || obj instanceof VirtualField) {
                DimensionHandle dimenTemp = null;
                if (obj instanceof DimensionHandle) {
                    dimenTemp = (DimensionHandle)obj;
                } else if (obj instanceof VirtualField && ((VirtualField)obj).getType().equals("level")) {
                    dimenTemp = (DimensionHandle)((VirtualField)obj).getModel();
                } else if (obj instanceof LevelHandle) {
                    DesignElementHandle hierarchy = ((LevelHandle)obj).getContainer();
                    dimenTemp = (TabularDimensionHandle)hierarchy.getContainer();
                } else {
                    this.addBtn.setEnabled(true);
                }
                if (dimenTemp != null) {
                    DataSetHandle table = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)dimenTemp.getDefaultHierarchy());
                    if (table == null && dataField != null) {
                        this.addBtn.setEnabled(true);
                    } else if (table != null && dataset != table) {
                        this.addBtn.setEnabled(false);
                    } else {
                        if (dimenTemp.isTimeType() && dataField != null) {
                            if (this.isDateType(dataField.getDataType()) && dimenTemp.getDefaultHierarchy().getLevelCount() == 0) {
                                this.addBtn.setEnabled(true);
                            } else {
                                this.addBtn.setEnabled(false);
                            }
                        }
                        if (!dimenTemp.isTimeType() && dataField != null) {
                            this.addBtn.setEnabled(true);
                        }
                    }
                }
                if (obj instanceof MeasureGroupHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measure") || obj instanceof MeasureHandle) {
                    this.addBtn.setEnabled(true);
                }
                if (obj instanceof LevelHandle) {
                    DimensionHandle dimension = (DimensionHandle)((LevelHandle)obj).getContainer().getContainer();
                    if (dimension.isTimeType()) {
                        this.delBtn.setEnabled(true);
                    } else {
                        this.delBtn.setEnabled(true);
                    }
                } else if (obj instanceof VirtualField) {
                    this.delBtn.setEnabled(false);
                } else {
                    this.delBtn.setEnabled(true);
                }
            } else {
                this.delBtn.setEnabled(false);
            }
            if (obj instanceof CubeHandle) {
                this.addBtn.setEnabled(false);
            } else if (obj instanceof PropertyHandle) {
                this.addBtn.setEnabled(true);
            }
            if (obj instanceof LevelHandle) {
                TabularLevelHandle level = (TabularLevelHandle)obj;
                if (level != null && level.attributesIterator() != null && level.attributesIterator().hasNext()) {
                    String name = String.valueOf(level.getName()) + " (";
                    Iterator attrIter = level.attributesIterator();
                    while (attrIter.hasNext()) {
                        name = String.valueOf(name) + ((LevelAttributeHandle)attrIter.next()).getName();
                        if (!attrIter.hasNext()) continue;
                        name = String.valueOf(name) + ", ";
                    }
                    name = String.valueOf(name) + ")";
                    this.groupViewer.getTree().getSelection()[0].setText(name);
                }
                this.editBtn.setEnabled(true);
            } else if (obj instanceof DimensionHandle || obj instanceof MeasureGroupHandle || obj instanceof MeasureHandle) {
                this.editBtn.setEnabled(true);
            } else {
                this.editBtn.setEnabled(false);
            }
            if (OlapUtil.isFromLibrary(this.input)) {
                this.addBtn.setEnabled(false);
                this.delBtn.setEnabled(false);
            }
        } else {
            this.addBtn.setEnabled(false);
            this.delBtn.setEnabled(false);
            this.editBtn.setEnabled(false);
        }
        this.removeButton.setEnabled(this.delBtn.isEnabled());
        this.addButton.setEnabled(this.addBtn.isEnabled());
    }

    private void handleDelEvent() {
        if (OlapUtil.isFromLibrary(this.input)) {
            return;
        }
        TreeSelection slections = (TreeSelection)this.groupViewer.getSelection();
        for (Object obj : slections) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans("");
            try {
                MeasureHandle measure;
                boolean hasExecuted;
                if (obj instanceof DimensionHandle) {
                    DimensionHandle dimension = (DimensionHandle)obj;
                    hasExecuted = OlapUtil.enableDrop(dimension);
                    if (hasExecuted) {
                        UIHelper.dropDimensionProperties(dimension);
                        dimension.dropAndClear();
                    }
                } else if (obj instanceof LevelHandle) {
                    LevelHandle level = (LevelHandle)obj;
                    TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)level.getContainer();
                    DimensionHandle dimension = (DimensionHandle)hierarchy.getContainer();
                    boolean hasExecuted2 = OlapUtil.enableDrop(level);
                    if (hasExecuted2) {
                        level.dropAndClear();
                    }
                    if (hierarchy.getContentCount("levels") == 0) {
                        dimension.setTimeType(false);
                        hierarchy.setDataSet(null);
                    }
                } else if (obj instanceof MeasureGroupHandle) {
                    MeasureGroupHandle measureGroup = (MeasureGroupHandle)obj;
                    hasExecuted = OlapUtil.enableDrop(measureGroup);
                    if (hasExecuted) {
                        measureGroup.dropAndClear();
                    }
                } else if (obj instanceof MeasureHandle && (hasExecuted = OlapUtil.enableDrop(measure = (MeasureHandle)obj))) {
                    measure.dropAndClear();
                }
                stack.commit();
            }
            catch (SemanticException e) {
                stack.rollback();
                this.refresh();
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.updateButtons();
    }

    private void handleAddEvent() {
        if (OlapUtil.isFromLibrary(this.input)) {
            return;
        }
        TreeSelection slections = (TreeSelection)this.groupViewer.getSelection();
        for (Object obj : slections) {
            RenameInputDialog inputDialog;
            CommandStack stack;
            TreeSelection dataFields = (TreeSelection)this.dataFieldsViewer.getSelection();
            Iterator iterator = dataFields.iterator();
            ResultSetColumnHandle dataField = null;
            while (iterator.hasNext()) {
                Object temp = iterator.next();
                if (!(temp instanceof ResultSetColumnHandle)) continue;
                dataField = (ResultSetColumnHandle)temp;
            }
            if (dataField != null) {
                this.handleDataAddEvent();
                continue;
            }
            if (obj instanceof MeasureGroupHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measure")) {
                MeasureGroupHandle measureGroup = null;
                measureGroup = obj instanceof MeasureGroupHandle ? (MeasureGroupHandle)obj : (MeasureGroupHandle)((VirtualField)obj).getModel();
                stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                TabularMeasureHandle measure = DesignElementFactory.getInstance().newTabularMeasure(null);
                try {
                    measureGroup.add("measures", (DesignElementHandle)measure);
                    MeasureDialog dialog = new MeasureDialog(true);
                    dialog.setInput(this.input, measure);
                    if (dialog.open() == 1) {
                        stack.rollback();
                    } else {
                        stack.commit();
                    }
                }
                catch (SemanticException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                    stack.rollback();
                }
                this.refresh();
                return;
            }
            if (obj instanceof MeasureHandle) {
                CommandStack stack2 = SessionHandleAdapter.getInstance().getCommandStack();
                stack2.startTrans("");
                TabularMeasureHandle measure = DesignElementFactory.getInstance().newTabularMeasure(null);
                try {
                    ((MeasureHandle)obj).getContainer().add("measures", (DesignElementHandle)measure);
                    MeasureDialog dialog = new MeasureDialog(true);
                    dialog.setInput(this.input, measure);
                    if (dialog.open() == 1) {
                        stack2.rollback();
                    } else {
                        stack2.commit();
                    }
                }
                catch (SemanticException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                    stack2.rollback();
                }
                this.refresh();
                return;
            }
            if (!(obj instanceof PropertyHandle) && (!(obj instanceof VirtualField) || !(((VirtualField)obj).getModel() instanceof PropertyHandle))) continue;
            PropertyHandle model = obj instanceof PropertyHandle ? (PropertyHandle)obj : (PropertyHandle)((VirtualField)obj).getModel();
            if (model.getPropertyDefn().getName().equals("dimensions")) {
                stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                TabularDimensionHandle dimension = DesignElementFactory.getInstance().newTabularDimension(null);
                try {
                    model.getElementHandle().add("dimensions", (DesignElementHandle)dimension);
                }
                catch (SemanticException e1) {
                    stack.rollback();
                    ExceptionHandler.handle((Throwable)e1);
                    this.refresh();
                    continue;
                }
                inputDialog = new RenameInputDialog(this.getShell(), Messages.getString("CubeGroupContent.Group.Add.Title"), Messages.getString("CubeGroupContent.Group.Add.Message"), dimension.getName(), null);
                inputDialog.create();
                if (inputDialog.open() == 0) {
                    try {
                        dimension.setName(inputDialog.getValue().trim());
                        stack.commit();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                        stack.rollback();
                    }
                } else {
                    stack.rollback();
                }
                this.refresh();
                continue;
            }
            if (!model.getPropertyDefn().getName().equals("measureGroups")) continue;
            stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans("");
            TabularMeasureGroupHandle measureGroup = DesignElementFactory.getInstance().newTabularMeasureGroup(null);
            try {
                model.getElementHandle().add("measureGroups", (DesignElementHandle)measureGroup);
            }
            catch (SemanticException e1) {
                stack.rollback();
                ExceptionHandler.handle((Throwable)e1);
                this.refresh();
                continue;
            }
            inputDialog = new RenameInputDialog(this.getShell(), Messages.getString("CubeGroupContent.Measure.Add.Title"), Messages.getString("CubeGroupContent.Message.Add.Message"), measureGroup.getName(), null);
            inputDialog.create();
            if (inputDialog.open() == 0) {
                try {
                    measureGroup.setName(inputDialog.getValue().trim());
                    stack.commit();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                    stack.rollback();
                }
            } else {
                stack.rollback();
            }
            this.refresh();
        }
    }

    private boolean isDateType(String dataType) {
        return dataType.equals("date-time") || dataType.equals("date") || dataType.equals("time");
    }

    protected void handleDataAddEvent() {
        if (OlapUtil.isFromLibrary(this.input)) {
            return;
        }
        TreeSelection dataFields = (TreeSelection)this.dataFieldsViewer.getSelection();
        for (Object temp : dataFields) {
            if (!(temp instanceof ResultSetColumnHandle)) continue;
            ResultSetColumnHandle dataField = (ResultSetColumnHandle)temp;
            DataSetHandle dataset = (DataSetHandle)dataField.getElementHandle();
            DataSetHandle primary = this.input.getDataSet();
            TreeSelection slections = (TreeSelection)this.groupViewer.getSelection();
            for (Object obj : slections) {
                CommandStack stack;
                TabularLevelHandle level;
                TabularDimensionHandle dimension;
                if (obj instanceof TabularLevelHandle) {
                    DataSetHandle dasetTemp;
                    TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)((TabularLevelHandle)obj).getContainer();
                    dimension = (TabularDimensionHandle)hierarchy.getContainer();
                    if (dimension.isTimeType() || (dasetTemp = OlapUtil.getHierarchyDataset(hierarchy)) != null && dataset != null && dataset != dasetTemp) continue;
                    CommandStack stack2 = SessionHandleAdapter.getInstance().getCommandStack();
                    stack2.startTrans("");
                    level = DesignElementFactory.getInstance().newTabularLevel((DimensionHandle)dimension, dataField.getColumnName());
                    try {
                        level.setColumnName(dataField.getColumnName());
                        level.setDataType(dataField.getDataType());
                        ((TabularLevelHandle)obj).getContainer().add("levels", (DesignElementHandle)level, ((TabularLevelHandle)obj).getIndex() + 1);
                    }
                    catch (SemanticException e) {
                        stack2.rollback();
                        this.refresh();
                        ExceptionHandler.handle((Throwable)e);
                        continue;
                    }
                    stack2.commit();
                    this.refresh();
                    return;
                }
                if (obj instanceof DimensionHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("level") || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("dimension") || obj instanceof PropertyHandle && ((PropertyHandle)obj).getPropertyDefn().getName().equals("dimensions")) {
                    TabularHierarchyHandle hierarchy;
                    block42: {
                        block41: {
                            stack = SessionHandleAdapter.getInstance().getCommandStack();
                            stack.startTrans("");
                            dimension = null;
                            if (obj instanceof VirtualField && ((VirtualField)obj).getType().equals("dimension") || obj instanceof PropertyHandle && ((PropertyHandle)obj).getPropertyDefn().getName().equals("dimensions")) {
                                dimension = DesignElementFactory.getInstance().newTabularDimension(null);
                                try {
                                    this.input.add("dimensions", (DesignElementHandle)dimension);
                                    break block41;
                                }
                                catch (SemanticException e) {
                                    stack.rollback();
                                    this.refresh();
                                    ExceptionHandler.handle((Throwable)e);
                                    continue;
                                }
                            }
                            dimension = obj instanceof TabularDimensionHandle ? (TabularDimensionHandle)obj : (TabularDimensionHandle)((VirtualField)obj).getModel();
                        }
                        if (dimension.isTimeType()) {
                            if (dimension.getDefaultHierarchy().getLevelCount() <= 0 && this.isDateType(dataField.getDataType())) continue;
                            stack.rollback();
                            continue;
                        }
                        hierarchy = (TabularHierarchyHandle)dimension.getContent("hierarchies", 0);
                        DataSetHandle dasetTemp = OlapUtil.getHierarchyDataset(hierarchy);
                        if (dasetTemp != null && dataset != null && dataset != dasetTemp) {
                            stack.rollback();
                            continue;
                        }
                        if (hierarchy.getDataSet() == null) {
                            try {
                                if (hierarchy.getLevelCount() != 0 || dataset == primary) break block42;
                                hierarchy.setDataSet(dataset);
                            }
                            catch (SemanticException e) {
                                stack.rollback();
                                this.refresh();
                                ExceptionHandler.handle((Throwable)e);
                                continue;
                            }
                        }
                    }
                    try {
                        if (this.isDateType(dataField.getDataType()) && hierarchy.getLevelCount() == 0) {
                            GroupDialog dialog = new GroupDialog(true);
                            dialog.setInput(hierarchy, dataField.getColumnName());
                            if (dialog.open() == 1) {
                                stack.rollback();
                            } else {
                                stack.commit();
                            }
                        } else {
                            level = DesignElementFactory.getInstance().newTabularLevel((DimensionHandle)dimension, dataField.getColumnName());
                            level.setColumnName(dataField.getColumnName());
                            level.setDataType(dataField.getDataType());
                            hierarchy.add("levels", (DesignElementHandle)level);
                            stack.commit();
                        }
                    }
                    catch (SemanticException e) {
                        stack.rollback();
                        ExceptionHandler.handle((Throwable)e);
                    }
                    this.refresh();
                    return;
                }
                if (obj instanceof MeasureGroupHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measure") || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measureGroup") || obj instanceof PropertyHandle && ((PropertyHandle)obj).getPropertyDefn().getName().equals("measureGroups")) {
                    CommandStack stack3;
                    MeasureGroupHandle measureGroup;
                    block43: {
                        if (!this.checkColumnDataType(dataField)) {
                            return;
                        }
                        measureGroup = null;
                        stack3 = SessionHandleAdapter.getInstance().getCommandStack();
                        stack3.startTrans("");
                        if (obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measureGroup") || obj instanceof PropertyHandle && ((PropertyHandle)obj).getPropertyDefn().getName().equals("measureGroups")) {
                            measureGroup = DesignElementFactory.getInstance().newTabularMeasureGroup(null);
                            try {
                                this.input.add("measureGroups", (DesignElementHandle)measureGroup);
                                break block43;
                            }
                            catch (SemanticException e) {
                                stack3.rollback();
                                this.refresh();
                                ExceptionHandler.handle((Throwable)e);
                                continue;
                            }
                        }
                        measureGroup = obj instanceof MeasureGroupHandle ? (MeasureGroupHandle)obj : (MeasureGroupHandle)((VirtualField)obj).getModel();
                    }
                    TabularMeasureHandle measure = DesignElementFactory.getInstance().newTabularMeasure(dataField.getColumnName());
                    try {
                        if (dataset != null && primary != null && dataset == primary) {
                            measure.setMeasureExpression(DEUtil.getExpression((Object)dataField));
                        }
                        measure.setDataType(dataField.getDataType());
                        measureGroup.add("measures", (DesignElementHandle)measure);
                        if (measure.getMeasureExpression() == null) {
                            MeasureDialog dialog = new MeasureDialog(false);
                            dialog.setInput(this.input, measure);
                            if (dialog.open() == 1) {
                                stack3.rollback();
                            } else {
                                stack3.commit();
                            }
                        } else {
                            stack3.commit();
                        }
                    }
                    catch (SemanticException e1) {
                        stack3.rollback();
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    this.refresh();
                    return;
                }
                if (!(obj instanceof MeasureHandle)) continue;
                if (!this.checkColumnDataType(dataField)) {
                    return;
                }
                stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                TabularMeasureHandle measure = DesignElementFactory.getInstance().newTabularMeasure(dataField.getColumnName());
                try {
                    if (dataset != null && primary != null && dataset == primary) {
                        measure.setMeasureExpression(DEUtil.getExpression((Object)dataField));
                    }
                    measure.setDataType(dataField.getDataType());
                    ((MeasureHandle)obj).getContainer().add("measures", (DesignElementHandle)measure);
                    if (measure.getMeasureExpression() == null) {
                        MeasureDialog dialog = new MeasureDialog(false);
                        dialog.setInput(this.input, measure);
                        if (dialog.open() == 1) {
                            stack.rollback();
                        } else {
                            stack.commit();
                        }
                    } else {
                        stack.commit();
                    }
                }
                catch (SemanticException e1) {
                    stack.rollback();
                    ExceptionHandler.handle((Throwable)e1);
                }
                this.refresh();
                return;
            }
        }
    }

    private boolean checkColumnDataType(ResultSetColumnHandle dataField) {
        if (dataField.getDataType().equals("any")) {
            MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString("CubeGroupContent.MeasureDataTypeErrorDialog.Title"), null, Messages.getFormattedString("CubeGroupContent.MeasureDataTypeErrorDialog.Message", new Object[]{dataField.getColumnName()}), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            return false;
        }
        return true;
    }

    public void refresh() {
        this.updateButtons();
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.groupViewer == null || this.groupViewer.getControl().isDisposed()) {
            return;
        }
        this.groupViewer.refresh();
        this.expandNodeAfterCreation(ev);
        this.groupBackup.updateStatus(this.groupViewer);
        this.getListenerElementVisitor().addListener(focus);
    }

    private void expandNodeAfterCreation(NotificationEvent ev) {
        IDesignElement element;
        if (ev instanceof ContentEvent && ev.getEventType() == 0 && ((ContentEvent)ev).getAction() == 1 && (element = ((ContentEvent)ev).getContent()) != null) {
            DesignElementHandle handle = element.getHandle(this.input.getModule());
            this.groupViewer.expandToLevel((Object)handle, -1);
            this.groupViewer.setSelection((ISelection)new StructuredSelection((Object)handle), true);
            this.updateButtons();
        }
    }

    private void handleEditEvent() {
        TreeSelection slections = (TreeSelection)this.groupViewer.getSelection();
        for (Object obj : slections) {
            Object dialog;
            TabularLevelHandle level;
            if (obj instanceof TabularLevelHandle) {
                level = (TabularLevelHandle)obj;
                if (((DimensionHandle)level.getContainer().getContainer()).isTimeType()) {
                    dialog = new DateLevelDialog();
                    ((DateLevelDialog)((Object)dialog)).setInput(level);
                    if (dialog.open() != 0) continue;
                    this.refresh();
                    continue;
                }
                CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                LevelPropertyDialog dialog2 = new LevelPropertyDialog(false);
                dialog2.setInput(level);
                if (dialog2.open() == 0) {
                    stack.commit();
                    this.refresh();
                    continue;
                }
                stack.rollback();
                continue;
            }
            if (obj instanceof TabularMeasureHandle) {
                level = (TabularMeasureHandle)obj;
                dialog = new MeasureDialog(false);
                ((MeasureDialog)((Object)dialog)).setInput(this.input, (TabularMeasureHandle)level);
                if (dialog.open() != 0) continue;
                this.refresh();
                continue;
            }
            if (obj instanceof DimensionHandle && ((DimensionHandle)obj).isTimeType() && ((DimensionHandle)obj).getDefaultHierarchy().getLevelCount() > 0) {
                GroupDialog dialog3 = new GroupDialog(false);
                dialog3.setInput((TabularHierarchyHandle)((DimensionHandle)obj).getDefaultHierarchy());
                dialog3.open();
                continue;
            }
            String title = Messages.getString("RenameInputDialog.DialogTitle");
            String message = Messages.getString("RenameInputDialog.DialogMessage");
            if (obj instanceof DimensionHandle) {
                title = Messages.getString("CubeGroupContent.Group.Edit.Title");
                message = Messages.getString("CubeGroupContent.Group.Edit.Message");
            } else if (obj instanceof MeasureGroupHandle) {
                title = Messages.getString("CubeGroupContent.Measure.Edit.Title");
                message = Messages.getString("CubeGroupContent.Measure.Edit.Message");
            }
            RenameInputDialog inputDialog = new RenameInputDialog(this.getShell(), title, message, ((DesignElementHandle)obj).getName(), null);
            inputDialog.create();
            if (inputDialog.open() != 0) continue;
            try {
                ((DesignElementHandle)obj).setName(inputDialog.getValue().trim());
            }
            catch (NameException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
        this.updateButtons();
    }

    class CustomDragListener
    implements DragSourceListener {
        private TreeViewer viewer;

        CustomDragListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void dragSetData(DragSourceEvent event) {
            event.data = CubeGroupContent.this.dragSourceItems[0].getText();
        }

        public void dragStart(DragSourceEvent event) {
            TreeItem[] selection = this.viewer.getTree().getSelection();
            if (selection.length > 0) {
                if (this.viewer == CubeGroupContent.this.dataFieldsViewer) {
                    ((CubeGroupContent)CubeGroupContent.this).dragSourceItems[0] = selection[0];
                } else if (this.viewer == CubeGroupContent.this.groupViewer && selection[0].getData() != null && selection[0].getData() instanceof LevelHandle) {
                    ((CubeGroupContent)CubeGroupContent.this).dragSourceItems[0] = selection[0];
                } else {
                    event.doit = false;
                }
            } else {
                event.doit = false;
            }
        }
    }
}

