/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.page;

import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.FilterListDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DatasetSelectionPage
extends AbstractDescriptionPropertyPage {
    private CubeHandle input;
    private Combo dataSetCombo;
    private Text nameText;
    private CubeBuilder builder;
    private Button filterButton;

    public DatasetSelectionPage(CubeBuilder builder, CubeHandle model) {
        this.input = model;
        this.builder = builder;
    }

    public Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CubeBuilderDataSetSelectionPage_ID");
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginRight = 20;
        container.setLayout((Layout)layout);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(Messages.getString("DatasetPage.Label.Name"));
        this.nameText = new Text(container, 2048);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    DatasetSelectionPage.this.input.setName(DatasetSelectionPage.this.nameText.getText());
                    DatasetSelectionPage.this.builder.setErrorMessage(null);
                    DatasetSelectionPage.this.builder.setTitleMessage(Messages.getString("DatasetPage.Title.Message"));
                }
                catch (NameException e1) {
                    DatasetSelectionPage.this.builder.setErrorMessage(e1.getMessage());
                }
            }
        });
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)data);
        Label dateSetLabel = new Label(container, 0);
        dateSetLabel.setText(Messages.getString("DatasetPage.Label.PrimaryDataset"));
        this.dataSetCombo = new Combo(container, 2056);
        this.dataSetCombo.setLayoutData((Object)new GridData(768));
        this.dataSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatasetSelectionPage.this.dataSetCombo.getItemCount() == 0) {
                    return;
                }
                String datasetName = DatasetSelectionPage.this.dataSetCombo.getItem(DatasetSelectionPage.this.dataSetCombo.getSelectionIndex());
                try {
                    ((TabularCubeHandle)DatasetSelectionPage.this.input).setDataSet(OlapUtil.getDataset(datasetName));
                }
                catch (SemanticException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                if (DatasetSelectionPage.this.dataSetCombo.getSelectionIndex() == -1) {
                    DatasetSelectionPage.this.builder.setOKEnable(false);
                    DatasetSelectionPage.this.filterButton.setEnabled(false);
                } else {
                    DatasetSelectionPage.this.builder.setOKEnable(true);
                    DatasetSelectionPage.this.filterButton.setEnabled(true);
                }
            }
        });
        this.filterButton = new Button(container, 8);
        this.filterButton.setText(Messages.getString("DatasetPage.Button.Filter"));
        data = new GridData();
        data.widthHint = Math.max(60, this.filterButton.computeSize((int)-1, (int)-1).x);
        this.filterButton.setLayoutData((Object)data);
        this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterListDialog dialog = new FilterListDialog(new FilterHandleProvider());
                dialog.setInput((ReportElementHandle)DatasetSelectionPage.this.input);
                dialog.open();
            }
        });
        this.filterButton.setEnabled(false);
        return container;
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString("DatasetPage.Container.Title.Message"), 0);
        this.builder.setTitleTitle(Messages.getString("DatasetPage.Title.Title"));
        this.builder.setErrorMessage(null);
        this.builder.setTitleMessage(Messages.getString("DatasetPage.Title.Message"));
        this.load();
    }

    private void refresh() {
        if (this.dataSetCombo != null && !this.dataSetCombo.isDisposed()) {
            this.dataSetCombo.setItems(OlapUtil.getAvailableDatasetNames());
            if (((TabularCubeHandle)this.input).getDataSet() != null) {
                String datasetName = ((TabularCubeHandle)this.input).getDataSet().getQualifiedName();
                if (this.dataSetCombo.indexOf(datasetName) == -1) {
                    this.dataSetCombo.add(datasetName, 0);
                }
                this.dataSetCombo.setText(datasetName);
            }
            if (this.dataSetCombo.getSelectionIndex() == -1) {
                this.builder.setOKEnable(false);
                this.filterButton.setEnabled(false);
            } else {
                this.builder.setOKEnable(true);
                this.filterButton.setEnabled(true);
            }
        }
    }

    private void load() {
        if (this.input != null) {
            if (this.input.getName() != null) {
                this.nameText.setText(this.input.getName());
            }
            this.refresh();
        }
    }
}

