/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.VirtualField;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CubeLabelProvider
extends LabelProvider {
    private static final Image IMG_DATASOURCE = ReportPlatformUIImages.getImage((String)"OdaDataSource");
    private static final Image IMG_DATASET = ReportPlatformUIImages.getImage((String)"OdaDataSet");
    private static final Image IMG_DATAFIELD = ReportPlatformUIImages.getImage((String)"DataColumn");
    private static final Image IMG_CUBE = UIHelper.getImage("icons/obj16/cube.gif");
    private static final Image IMG_DIMENSION = UIHelper.getImage("icons/obj16/dimension.gif");
    private static final Image IMG_DIMENSION_FOLDER = UIHelper.getImage("icons/obj16/dimensions.gif");
    private static final Image IMG_MEASUREGROUP_FOLDER = UIHelper.getImage("icons/obj16/measuregroups.gif");
    private static final Image IMG_MEASURE = ReportPlatformUIImages.getImage((String)"DataColumn");
    private static final Image IMG_MEASUREGROUP = UIHelper.getImage("icons/obj16/measure_group.gif");
    private static final Image IMG_LEVEL = UIHelper.getImage("icons/obj16/data_column.gif");
    private static final Image IMG_OTHER_DATASETS = UIHelper.getImage("icons/obj16/folder.gif");
    private TabularCubeHandle input;

    public void setInput(TabularCubeHandle input) {
        this.input = input;
    }

    public Image getImage(Object element) {
        if (element instanceof DataSourceHandle) {
            return IMG_DATASOURCE;
        }
        if (element instanceof DataSetHandle) {
            return IMG_DATASET;
        }
        if (element instanceof VirtualField && ((VirtualField)element).getType().equals("other")) {
            return IMG_OTHER_DATASETS;
        }
        if (element instanceof ResultSetColumnHandle) {
            return IMG_DATAFIELD;
        }
        if (element instanceof DimensionHandle) {
            return IMG_DIMENSION;
        }
        if (element instanceof LevelHandle) {
            return IMG_LEVEL;
        }
        if (element instanceof CubeHandle) {
            return IMG_CUBE;
        }
        if (element instanceof MeasureHandle) {
            return IMG_MEASURE;
        }
        if (element instanceof MeasureGroupHandle) {
            return IMG_MEASUREGROUP;
        }
        if (element instanceof String) {
            return IMG_DATAFIELD;
        }
        if (element instanceof PropertyHandle) {
            PropertyHandle model = (PropertyHandle)element;
            if (model.getPropertyDefn().getName().equals("dimensions")) {
                return IMG_DIMENSION_FOLDER;
            }
            if (model.getPropertyDefn().getName().equals("measureGroups")) {
                return IMG_MEASUREGROUP_FOLDER;
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof DataSetHandle) {
            if (this.input != null && this.input.getDataSet() != null && this.input.getDataSet() == element) {
                return String.valueOf(((DataSetHandle)element).getName()) + " " + Messages.getString("GroupsPage.Primary.Dataset");
            }
            return ((DataSetHandle)element).getName();
        }
        if (element instanceof VirtualField && ((VirtualField)element).getType().equals("other")) {
            return Messages.getString("Cube.Other.Datasets");
        }
        if (element instanceof ResultSetColumnHandle) {
            return ((ResultSetColumnHandle)element).getColumnName();
        }
        if (element instanceof DimensionHandle) {
            return ((DimensionHandle)element).getName();
        }
        if (element instanceof LevelHandle) {
            return ((LevelHandle)element).getName();
        }
        if (element instanceof CubeHandle) {
            return ((CubeHandle)element).getName();
        }
        if (element instanceof MeasureGroupHandle) {
            return ((MeasureGroupHandle)element).getName();
        }
        if (element instanceof MeasureHandle) {
            try {
                return String.valueOf(((MeasureHandle)element).getName()) + "(" + DataUtil.getAggregationManager().getAggregation(DataAdapterUtil.adaptModelAggregationType((String)((MeasureHandle)element).getFunction())).getDisplayName() + ")";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof PropertyHandle) {
            PropertyHandle model = (PropertyHandle)element;
            if (model.getPropertyDefn().getName().equals("dimensions")) {
                return Messages.getString("Cube.Groups");
            }
            if (model.getPropertyDefn().getName().equals("measureGroups")) {
                return Messages.getString("Cube.MeasureGroup");
            }
        }
        return super.getText(element);
    }

    public String getToolTip(Object element) {
        return this.getText(element);
    }
}

