/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshAction;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.ShowPropertyAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.action.EditCubeLevelAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TabularLevelNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        if (((LevelHandle)object).canEdit()) {
            menu.insertAfter("additions", (IAction)new EditCubeLevelAction(object, Messages.getString("CubeLevelNodeProvider.menu.text")));
        }
        menu.insertBefore("additions-refresh", (IAction)new ShowPropertyAction(object));
        menu.insertAfter("additions-refresh", (IContributionItem)new Separator());
        menu.insertAfter("additions-refresh", (IAction)new RefreshAction(sourceViewer));
    }

    public String getNodeDisplayName(Object model) {
        LevelHandle handle = (LevelHandle)model;
        return handle.getName();
    }

    public Object[] getChildren(Object object) {
        int pos;
        HierarchyHandle hierarchy = (HierarchyHandle)((LevelHandle)object).getContainer();
        if (hierarchy.getLevel((pos = ((LevelHandle)object).getIndex()) + 1) != null) {
            return new Object[]{hierarchy.getLevel(pos + 1)};
        }
        return new Object[0];
    }

    public Object getParent(Object model) {
        HierarchyHandle hierarchy = (HierarchyHandle)((LevelHandle)model).getContainer();
        LevelHandle level = (LevelHandle)model;
        if (hierarchy == null) {
            return null;
        }
        if (level.getIndex() > 0) {
            return hierarchy.getLevel(level.getIndex() - 1);
        }
        return hierarchy.getContainer();
    }

    public boolean hasChildren(Object object) {
        int pos;
        HierarchyHandle hierarchy = (HierarchyHandle)((LevelHandle)object).getContainer();
        return hierarchy.getLevel((pos = ((LevelHandle)object).getIndex()) + 1) != null;
    }

    protected boolean performEdit(ReportElementHandle handle) {
        TabularLevelHandle level = (TabularLevelHandle)handle;
        CubeBuilder dialog = new CubeBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (TabularCubeHandle)level.getContainer().getContainer().getContainer());
        dialog.showPage("org.eclipse.birt.datasource.editor.cubebuilder.grouppage");
        return dialog.open() == 0;
    }

    public Image getNodeIcon(Object model) {
        if (model instanceof DesignElementHandle && ((DesignElementHandle)model).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK");
        }
        return UIHelper.getImage("icons/obj16/data_column.gif");
    }
}

