/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChartCacheManager {
    private static Map<String, ChartCacheManager> instances = new HashMap<String, ChartCacheManager>(3);
    private static String currentInstanceId = null;
    private static final String DEFAULT_INSTANCE = "default";
    private List<Map<String, Series>> cacheSeries = new ArrayList<Map<String, Series>>(3);
    private Map<String, Object> cacheCharts = new HashMap<String, Object>();
    private Map<String, Position> cacheLabelPosition = new HashMap<String, Position>();
    private static final String PREFIX_SUBTYPE = "s_";
    private static final String PREFIX_ORIENTATION = "o_";
    private static final String PREFIX_CATEGORY = "c_";
    private static final String PREFIX_SERIESTYPE = "t_";
    private static final String PREFIX_DIMENSION = "d_";

    private ChartCacheManager() {
    }

    public static ChartCacheManager getInstance() {
        if (currentInstanceId == null) {
            ChartCacheManager.switchInstance(DEFAULT_INSTANCE);
        }
        return instances.get(currentInstanceId);
    }

    public static ChartCacheManager getInstance(String instanceId) {
        ChartCacheManager.switchInstance(instanceId);
        return ChartCacheManager.getInstance();
    }

    public static void switchInstance(String instanceId) {
        assert (instanceId != null);
        currentInstanceId = instanceId;
        if (!instances.containsKey(instanceId)) {
            instances.put(instanceId, new ChartCacheManager());
        }
    }

    /*
     * Unable to fully structure code
     */
    public Series findSeries(String seriesClass, int seriesIndex) {
        if (ChartCacheManager.$assertionsDisabled || seriesIndex >= 0) ** GOTO lbl5
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.cacheSeries.add(new HashMap<K, V>());
lbl5:
            // 2 sources

            ** while (this.cacheSeries.size() <= seriesIndex)
        }
lbl6:
        // 1 sources

        map = this.cacheSeries.get(seriesIndex);
        if (!map.containsKey(seriesClass)) {
            return null;
        }
        return (Series)EcoreUtil.copy((EObject)((EObject)map.get(seriesClass)));
    }

    public void cacheSeries(List<SeriesDefinition> seriesDefinitions) {
        int i = 0;
        while (i < seriesDefinitions.size()) {
            Series series = seriesDefinitions.get(i).getDesignTimeSeries();
            if (this.cacheSeries.size() <= i) {
                this.cacheSeries.add(new HashMap());
            }
            this.cacheSeries.get(i).put(series.getClass().getName(), (Series)EcoreUtil.copy((EObject)series));
            ++i;
        }
        this.removeSeries(seriesDefinitions.size());
    }

    /*
     * Unable to fully structure code
     */
    public void cacheSeries(int seriesIndex, Series series) {
        if (ChartCacheManager.$assertionsDisabled || seriesIndex >= 0) ** GOTO lbl5
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.cacheSeries.add(new HashMap<K, V>());
lbl5:
            // 2 sources

            ** while (this.cacheSeries.size() <= seriesIndex)
        }
lbl6:
        // 1 sources

        this.cacheSeries.get(seriesIndex).put(series.getClass().getName(), (Series)EcoreUtil.copy((EObject)series));
    }

    public void removeSeries(int seriesSize) {
        while (this.cacheSeries.size() > seriesSize) {
            this.cacheSeries.remove(seriesSize);
        }
    }

    public void dispose() {
        this.cacheSeries.clear();
        this.cacheCharts.clear();
        this.cacheLabelPosition.clear();
        instances.remove(currentInstanceId);
        currentInstanceId = null;
    }

    public void cacheSubtype(String chartType, String subtype) {
        this.cacheCharts.put(PREFIX_SUBTYPE + chartType, subtype);
    }

    public void cacheSeriesType(String seriesType) {
        this.cacheCharts.put(PREFIX_SERIESTYPE, seriesType);
    }

    public void cacheLabelPositionWithStackedCase(String stackedType, Position labelPosition) {
        this.cacheLabelPosition.put(stackedType, labelPosition);
    }

    public Position findLabelPositionWithStackedCase(String stackedType) {
        return this.cacheLabelPosition.get(stackedType);
    }

    public String findSubtype(String chartType) {
        return (String)this.cacheCharts.get(PREFIX_SUBTYPE + chartType);
    }

    public String findSeriesType() {
        return (String)this.cacheCharts.get(PREFIX_SERIESTYPE);
    }

    public void cacheOrientation(String chartType, Orientation orientation) {
        this.cacheCharts.put(PREFIX_ORIENTATION + chartType, orientation);
    }

    public Orientation findOrientation(String chartType) {
        return (Orientation)this.cacheCharts.get(PREFIX_ORIENTATION + chartType);
    }

    public void cacheCategory(String chartType, boolean bCategory) {
        this.cacheCharts.put(PREFIX_CATEGORY + chartType, new Boolean(bCategory));
    }

    public Boolean findCategory(String chartType) {
        return (Boolean)this.cacheCharts.get(PREFIX_CATEGORY + chartType);
    }

    public void cacheDimension(String chartType, String dimension) {
        this.cacheCharts.put(PREFIX_DIMENSION + chartType, dimension);
    }

    public String getDimension(String chartType) {
        return (String)this.cacheCharts.get(PREFIX_DIMENSION + chartType);
    }
}

