/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.util;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.impl.AxisOriginImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.impl.BubbleSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.GanttSeriesImpl;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartUIUtil {
    public static final String FONT_AUTO = Messages.getString("ChartUIUtil.Font.Auto");
    public static final String[] FONT_SIZES = new String[]{FONT_AUTO, "9", "10", "12", "14", "16", "18", "24", "36"};
    private static IDisplayServer swtDisplayServer = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui/swt");
    private static HashMap<String, ISeriesUIProvider> htSeriesAttributeUIProviders = new HashMap();
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_WIDTH = 20;

    static {
        try {
            swtDisplayServer = PluginSettings.instance().getDisplayServer("ds.SWT");
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
        Collection<ISeriesUIProvider> cRegisteredEntries = ChartUIExtensionsImpl.instance().getSeriesUIComponents(ChartWizardContext.class.getSimpleName());
        for (ISeriesUIProvider provider : cRegisteredEntries) {
            String sSeries = provider.getSeriesClass();
            htSeriesAttributeUIProviders.put(sSeries, provider);
        }
    }

    public static IDisplayServer getDisplayServer() {
        return swtDisplayServer;
    }

    public static void setBackgroundColor(Control control, boolean selected, Color color) {
        if (selected) {
            control.setBackground(color);
        } else {
            control.setBackground(null);
        }
    }

    public static Composite createCompositeWrapper(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cmp.setLayout((Layout)gridLayout);
        return cmp;
    }

    public static Query getDataQuery(SeriesDefinition seriesDefn, int queryIndex) {
        if (seriesDefn.getDesignTimeSeries().getDataDefinition().size() <= queryIndex) {
            Query query = QueryImpl.create((String)"");
            query.eAdapters().addAll((Collection)seriesDefn.eAdapters());
            seriesDefn.getDesignTimeSeries().getDataDefinition().add((Object)query);
            return query;
        }
        return (Query)seriesDefn.getDesignTimeSeries().getDataDefinition().get(queryIndex);
    }

    public static String getExpressionString(String colName) {
        return ExpressionUtil.createJSRowExpression((String)colName);
    }

    public static NumberFormat getDefaultNumberFormatInstance() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(100);
        return numberFormat;
    }

    public static EList<SeriesDefinition> getBaseSeriesDefinitions(Chart chart) {
        return ChartUtil.getBaseSeriesDefinitions((Chart)chart);
    }

    public static int getOrthogonalAxisNumber(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            EList axisList = ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getAssociatedAxes();
            return axisList.size();
        }
        if (chart instanceof ChartWithoutAxes) {
            return 1;
        }
        return 0;
    }

    public static EList<SeriesDefinition> getOrthogonalSeriesDefinitions(Chart chart, int axisIndex) {
        if (chart instanceof ChartWithAxes) {
            EList axisList = ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getAssociatedAxes();
            return ((Axis)axisList.get(axisIndex)).getSeriesDefinitions();
        }
        if (chart instanceof ChartWithoutAxes) {
            return ((SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0)).getSeriesDefinitions();
        }
        return null;
    }

    public static List<SeriesDefinition> getAllOrthogonalSeriesDefinitions(Chart chart) {
        return ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)chart);
    }

    public static String getStockTitle(int index) {
        switch (index) {
            case 0: {
                return Messages.getString("ChartUIUtil.StockExp.High");
            }
            case 1: {
                return Messages.getString("ChartUIUtil.StockExp.Low");
            }
            case 2: {
                return Messages.getString("ChartUIUtil.StockExp.Open");
            }
            case 3: {
                return Messages.getString("ChartUIUtil.StockExp.Close");
            }
        }
        return "";
    }

    public static String getGanttTitle(int index) {
        switch (index) {
            case 0: {
                return Messages.getString("ChartUIUtil.GanttExp.Start");
            }
            case 1: {
                return Messages.getString("ChartUIUtil.GanttExp.End");
            }
            case 2: {
                return Messages.getString("ChartUIUtil.GanttExp.Label");
            }
        }
        return "";
    }

    public static String getBubbleTitle(int index) {
        switch (index) {
            case 0: {
                return Messages.getString("ChartUIUtil.BubbleExp.Label");
            }
            case 1: {
                return Messages.getString("ChartUIUtil.BubbleExp.Size");
            }
        }
        return "";
    }

    public static String getDifferenceTitle(int index) {
        switch (index) {
            case 0: {
                return Messages.getString("ChartUIUtil.DifferenceExp.Postive");
            }
            case 1: {
                return Messages.getString("ChartUIUtil.DifferenceExp.Negative");
            }
        }
        return "";
    }

    public static Axis getAxisXForProcessing(ChartWithAxes chartWithAxis) {
        return (Axis)chartWithAxis.getAxes().get(0);
    }

    public static Axis getAxisYForProcessing(ChartWithAxes chartWithAxis, int axisIndex) {
        return (Axis)ChartUIUtil.getAxisXForProcessing(chartWithAxis).getAssociatedAxes().get(axisIndex);
    }

    public static Axis getAxisZForProcessing(ChartWithAxes chartWithAxis) {
        return (Axis)ChartUIUtil.getAxisXForProcessing(chartWithAxis).getAncillaryAxes().get(0);
    }

    public static boolean is3DType(Chart chart) {
        return chart.getDimension().getValue() == 2;
    }

    public static int getFontRotation(FontDefinition font) {
        return font.isSetRotation() ? (int)font.getRotation() : 0;
    }

    public static String getFontName(FontDefinition font) {
        return font.getName() == null ? FONT_AUTO : font.getName();
    }

    public static TextAlignment getFontTextAlignment(FontDefinition font) {
        return font.getAlignment() == null ? TextAlignmentImpl.create() : font.getAlignment();
    }

    public static boolean checkDataBinding(Chart chart) {
        EList<SeriesDefinition> sdList = ChartUIUtil.getBaseSeriesDefinitions(chart);
        if (!ChartUIUtil.checkDataDefinition(sdList)) {
            return false;
        }
        int i = 0;
        while (i < ChartUIUtil.getOrthogonalAxisNumber(chart)) {
            sdList = ChartUIUtil.getOrthogonalSeriesDefinitions(chart, i);
            if (!ChartUIUtil.checkDataDefinition(sdList)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkDataDefinition(List<SeriesDefinition> sdList) {
        int i = 0;
        while (i < sdList.size()) {
            Series series = sdList.get(i).getDesignTimeSeries();
            EList ddList = series.getDataDefinition();
            if (ddList.size() == 0) {
                return false;
            }
            int[] validIndex = ChartUIUtil.getSeriesUIProvider(series).validationIndex(series);
            int j = 0;
            while (j < validIndex.length) {
                String query;
                int vi = validIndex[j];
                if (vi >= 0 && vi < ddList.size() && ((query = ((Query)ddList.get(vi)).getDefinition()) == null || query.length() == 0)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static void syncRuntimeSeries(Chart chart) {
        block15: {
            block14: {
                if (!(chart instanceof ChartWithAxes)) break block14;
                ChartWithAxes cwa = (ChartWithAxes)chart;
                Axis[] axa = cwa.getOrthogonalAxes(cwa.getPrimaryBaseAxes()[0], true);
                int iOrthogonalSeriesDefinitionCount = 0;
                int i = 0;
                while (i < axa.length) {
                    EList elSD = axa[i].getSeriesDefinitions();
                    int j = 0;
                    while (j < elSD.size()) {
                        String sExpression;
                        SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                        Query qy = sd.getQuery();
                        if (qy != null && (sExpression = qy.getDefinition()) != null && sExpression.length() != 0) {
                            ++iOrthogonalSeriesDefinitionCount;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < axa.length) {
                    for (SeriesDefinition sdOrthogonal : axa[i].getSeriesDefinitions()) {
                        Series seDesignOrthogonal = sdOrthogonal.getDesignTimeSeries();
                        List seRuntimes = sdOrthogonal.getRunTimeSeries();
                        sdOrthogonal.getSeries().removeAll((Collection)seRuntimes);
                        int j = 0;
                        while (j < seRuntimes.size()) {
                            Series seRuntimeOrthogonal = (Series)EcoreUtil.copy((EObject)seDesignOrthogonal);
                            seRuntimeOrthogonal.setDataSet(((Series)seRuntimes.get(j)).getDataSet());
                            if (iOrthogonalSeriesDefinitionCount < 1) {
                                seRuntimeOrthogonal.setSeriesIdentifier(seDesignOrthogonal.getSeriesIdentifier());
                            } else {
                                seRuntimeOrthogonal.setSeriesIdentifier(((Series)seRuntimes.get(j)).getSeriesIdentifier());
                            }
                            sdOrthogonal.getSeries().add((Object)seRuntimeOrthogonal);
                            ++j;
                        }
                    }
                    ++i;
                }
                break block15;
            }
            if (!(chart instanceof ChartWithoutAxes)) break block15;
            ChartWithoutAxes cwoa = (ChartWithoutAxes)chart;
            SeriesDefinition sdBase = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            int iOrthogonalSeriesDefinitionCount = 0;
            EList elSD = sdBase.getSeriesDefinitions();
            int j = 0;
            while (j < elSD.size()) {
                String sExpression;
                SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                Query qy = sd.getQuery();
                if (qy != null && (sExpression = qy.getDefinition()) != null && sExpression.length() != 0) {
                    ++iOrthogonalSeriesDefinitionCount;
                }
                ++j;
            }
            for (SeriesDefinition sdOrthogonal : elSD) {
                Series seDesignOrthogonal = sdOrthogonal.getDesignTimeSeries();
                List seRuntimes = sdOrthogonal.getRunTimeSeries();
                sdOrthogonal.getSeries().removeAll((Collection)seRuntimes);
                int j2 = 0;
                while (j2 < seRuntimes.size()) {
                    Series seRuntimeOrthogonal = (Series)EcoreUtil.copy((EObject)seDesignOrthogonal);
                    seRuntimeOrthogonal.setDataSet(((Series)seRuntimes.get(j2)).getDataSet());
                    if (iOrthogonalSeriesDefinitionCount < 1) {
                        seRuntimeOrthogonal.setSeriesIdentifier(seDesignOrthogonal.getSeriesIdentifier());
                    } else {
                        seRuntimeOrthogonal.setSeriesIdentifier(((Series)seRuntimes.get(j2)).getSeriesIdentifier());
                    }
                    sdOrthogonal.getSeries().add((Object)seRuntimeOrthogonal);
                    ++j2;
                }
            }
        }
    }

    public static void doLivePreview(Chart chart, IDataServiceProvider dataProvider, IActionEvaluator iae) throws ChartException {
        boolean isSharingQuery = dataProvider.checkState(16);
        List expressions = Generator.instance().getRowExpressions(chart, iae, !isSharingQuery);
        IDataRowExpressionEvaluator evaluator = dataProvider.prepareRowExpressionEvaluator(chart, expressions, -1, false);
        RunTimeContext context = new RunTimeContext();
        context.setULocale(ULocale.getDefault());
        context.setSharingQuery(isSharingQuery);
        Generator.instance().bindData(evaluator, iae, chart, context);
        if (evaluator != null) {
            evaluator.close();
        }
    }

    public static String getConvertedSampleDataRepresentation(AxisType axisType, String sOldRepresentation, int index) {
        return ChartUtil.getNewSampleData((AxisType)axisType, (int)index);
    }

    public static void setAllGroupingQueryExceptFirst(Chart chart, String queryDefinition) {
        List<SeriesDefinition> sds = ChartUIUtil.getAllOrthogonalSeriesDefinitions(chart);
        int i = 0;
        while (i < sds.size()) {
            if (i != 0) {
                SeriesDefinition sd = sds.get(i);
                if (sd.getQuery() != null) {
                    sd.getQuery().setDefinition(queryDefinition);
                } else {
                    Query query = QueryImpl.create((String)queryDefinition);
                    query.eAdapters().addAll((Collection)sd.eAdapters());
                    sd.setQuery(query);
                }
            }
            ++i;
        }
    }

    public static void addAxis(ChartWithAxes chartModel) {
        ChartAdapter.beginIgnoreNotifications();
        Axis yAxis = (Axis)((Axis)chartModel.getAxes().get(0)).getAssociatedAxes().get(0);
        Axis overlayAxis = (Axis)EcoreUtil.copy((EObject)yAxis);
        overlayAxis.setAligned(false);
        overlayAxis.setSideBySide(false);
        overlayAxis.setPrimaryAxis(false);
        overlayAxis.setOrigin(AxisOriginImpl.create((IntersectionType)IntersectionType.MAX_LITERAL, null));
        overlayAxis.setLabelPosition(Position.RIGHT_LITERAL);
        overlayAxis.setTitlePosition(Position.RIGHT_LITERAL);
        overlayAxis.getTitle().getCaption().setValue(Messages.getString("TaskSelectType.Caption.OverlayAxis1"));
        overlayAxis.eAdapters().addAll((Collection)yAxis.eAdapters());
        if (overlayAxis.getSeriesDefinitions().size() > 1) {
            EList list = overlayAxis.getSeriesDefinitions();
            int i = list.size() - 1;
            while (i > 0) {
                list.remove(i);
                --i;
            }
        }
        SeriesDefinition sdOverlay = (SeriesDefinition)overlayAxis.getSeriesDefinitions().get(0);
        EList dds = sdOverlay.getDesignTimeSeries().getDataDefinition();
        int i = 0;
        while (i < dds.size()) {
            ((Query)dds.get(i)).setDefinition("");
            ++i;
        }
        SampleData sd = chartModel.getSampleData();
        int currentSize = sd.getOrthogonalSampleData().size();
        OrthogonalSampleData sdOrthogonal = (OrthogonalSampleData)EcoreUtil.copy((EObject)((EObject)chartModel.getSampleData().getOrthogonalSampleData().get(0)));
        sdOrthogonal.setDataSetRepresentation(ChartUtil.getNewSampleData((AxisType)overlayAxis.getType(), (int)currentSize));
        sdOrthogonal.setSeriesDefinitionIndex(currentSize);
        sdOrthogonal.eAdapters().addAll((Collection)sd.eAdapters());
        sd.getOrthogonalSampleData().add((Object)sdOrthogonal);
        ((Axis)chartModel.getAxes().get(0)).getAssociatedAxes().add((Object)overlayAxis);
        ChartAdapter.endIgnoreNotifications();
        ChartUIUtil.setSeriesName((Chart)chartModel);
    }

    public static void setSeriesName(Chart chart) {
        List<SeriesDefinition> seriesDefinitions = ChartUIUtil.getAllOrthogonalSeriesDefinitions(chart);
        String seriesText = Messages.getString("ChartUIUtil.SeriesLabel");
        int i = 0;
        while (i < seriesDefinitions.size()) {
            SeriesDefinition sd = seriesDefinitions.get(i);
            if (ChartUIUtil.needSeriesName(sd.getDesignTimeSeries().getSeriesIdentifier().toString(), seriesText)) {
                sd.getDesignTimeSeries().setSeriesIdentifier((Object)MessageFormat.format(seriesText, new Integer(i + 1)));
            }
            ++i;
        }
    }

    private static boolean needSeriesName(String name, String seriesText) {
        String pattern = MessageFormat.format(seriesText, "[0-9]+");
        return name.trim().matches(pattern) || name.trim().length() == 0;
    }

    public static void removeLastAxes(ChartWithAxes chartModel, int removedAxisNumber) {
        int i = 0;
        while (i < removedAxisNumber) {
            ChartUIUtil.removeLastAxis(chartModel);
            ++i;
        }
    }

    public static void removeLastAxis(ChartWithAxes chartModel) {
        ChartUIUtil.removeAxis((Chart)chartModel, ChartUIUtil.getOrthogonalAxisNumber((Chart)chartModel) - 1);
    }

    public static void removeAxis(Chart chartModel, int axisIndex) {
        if (chartModel instanceof ChartWithoutAxes) {
            return;
        }
        ChartAdapter.beginIgnoreNotifications();
        Axis oldPrimaryAxis = ChartUIUtil.getAxisYForProcessing((ChartWithAxes)chartModel, axisIndex);
        if (oldPrimaryAxis.isPrimaryAxis()) {
            int yAxisSize = ChartUIUtil.getOrthogonalAxisNumber(chartModel);
            Axis newPrimaryAxis = null;
            newPrimaryAxis = axisIndex + 1 < yAxisSize ? ChartUIUtil.getAxisYForProcessing((ChartWithAxes)chartModel, axisIndex + 1) : ChartUIUtil.getAxisYForProcessing((ChartWithAxes)chartModel, 0);
            newPrimaryAxis.setPrimaryAxis(true);
            newPrimaryAxis.setOrigin(oldPrimaryAxis.getOrigin());
            newPrimaryAxis.setLabelPosition(oldPrimaryAxis.getLabelPosition());
            newPrimaryAxis.setTitlePosition(oldPrimaryAxis.getTitlePosition());
        }
        ChartAdapter.endIgnoreNotifications();
        ChartUIUtil.getAxisXForProcessing((ChartWithAxes)chartModel).getAssociatedAxes().remove(axisIndex);
    }

    public static int getLastSeriesIndexWithinAxis(Chart chartModel, int axisIndex) {
        if (chartModel instanceof ChartWithoutAxes || axisIndex < 0 || axisIndex >= ChartUIUtil.getOrthogonalAxisNumber(chartModel)) {
            return -1;
        }
        int seriesIndex = -1;
        int i = 0;
        while (i <= axisIndex) {
            seriesIndex += ChartUIUtil.getOrthogonalSeriesDefinitions(chartModel, i).size();
            ++i;
        }
        return seriesIndex;
    }

    public static void reorderOrthogonalSampleDataIndex(Chart chartModel) {
        EList list = chartModel.getSampleData().getOrthogonalSampleData();
        int i = 0;
        while (i < list.size()) {
            ((OrthogonalSampleData)list.get(i)).setSeriesDefinitionIndex(i);
            ++i;
        }
    }

    public static void copyGeneralSeriesAttributes(Series oldSeries, Series newSeries) {
        newSeries.setLabel(oldSeries.getLabel());
        newSeries.setSeriesIdentifier(oldSeries.getSeriesIdentifier());
        if (oldSeries.isSetVisible()) {
            newSeries.setVisible(oldSeries.isVisible());
        }
        if (oldSeries.isSetStacked() && newSeries.canBeStacked()) {
            newSeries.setStacked(oldSeries.isStacked());
        }
        if (oldSeries.isSetTranslucent()) {
            newSeries.setTranslucent(oldSeries.isTranslucent());
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_Triggers())) {
            newSeries.getTriggers().addAll((Collection)oldSeries.getTriggers());
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataPoint())) {
            newSeries.setDataPoint(oldSeries.getDataPoint());
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_CurveFitting())) {
            newSeries.setCurveFitting(oldSeries.getCurveFitting());
        }
        if (oldSeries.getLabelPosition().equals(Position.INSIDE_LITERAL) || oldSeries.getLabelPosition().equals(Position.OUTSIDE_LITERAL)) {
            if (newSeries instanceof LineSeries || newSeries instanceof StockSeries || newSeries instanceof GanttSeries) {
                newSeries.setLabelPosition(Position.ABOVE_LITERAL);
            } else {
                newSeries.setLabelPosition(oldSeries.getLabelPosition());
            }
        } else if (newSeries instanceof LineSeries || newSeries instanceof StockSeries || newSeries instanceof GanttSeries) {
            newSeries.setLabelPosition(oldSeries.getLabelPosition());
        } else {
            newSeries.setLabelPosition(Position.OUTSIDE_LITERAL);
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataDefinition())) {
            Object query = oldSeries.getDataDefinition().get(0);
            newSeries.getDataDefinition().clear();
            if (newSeries instanceof StockSeries) {
                if (oldSeries.getDataDefinition().size() != 4) {
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                } else {
                    newSeries.getDataDefinition().addAll((Collection)oldSeries.getDataDefinition());
                }
            } else if (newSeries instanceof BubbleSeries) {
                if (oldSeries.getDataDefinition().size() != 2) {
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                } else {
                    newSeries.getDataDefinition().addAll((Collection)oldSeries.getDataDefinition());
                }
            } else if (newSeries instanceof DifferenceSeries) {
                if (oldSeries.getDataDefinition().size() != 2) {
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                } else {
                    newSeries.getDataDefinition().addAll((Collection)oldSeries.getDataDefinition());
                }
            } else if (newSeries instanceof GanttSeries) {
                if (oldSeries.getDataDefinition().size() != 3) {
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                } else {
                    newSeries.getDataDefinition().addAll((Collection)oldSeries.getDataDefinition());
                }
            } else {
                newSeries.getDataDefinition().add(query);
            }
        }
    }

    public static ChartDimension getDimensionType(String sDimension) {
        if (sDimension == null || sDimension.equals(IChartType.TWO_DIMENSION_TYPE)) {
            return ChartDimension.TWO_DIMENSIONAL_LITERAL;
        }
        if (sDimension.equals(IChartType.THREE_DIMENSION_TYPE)) {
            return ChartDimension.THREE_DIMENSIONAL_LITERAL;
        }
        return ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL;
    }

    public static String getDimensionString(ChartDimension dimension) {
        if (dimension == null || dimension == ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            return IChartType.TWO_DIMENSION_TYPE;
        }
        if (dimension == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            return IChartType.THREE_DIMENSION_TYPE;
        }
        return IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE;
    }

    public static void bindHelp(Control control, String contextId) {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getHelpSystem().setHelp((Control)control.getShell(), contextId);
        }
        catch (RuntimeException runtimeException) {}
    }

    public static boolean is3DWallFloorSet(Chart chart) {
        if (!ChartUIUtil.is3DType(chart) || chart instanceof ChartWithoutAxes) {
            return true;
        }
        ChartWithAxes chartWithAxes = (ChartWithAxes)chart;
        ColorDefinition wall = (ColorDefinition)chartWithAxes.getWallFill();
        ColorDefinition floor = (ColorDefinition)chartWithAxes.getFloorFill();
        return wall != null && wall.getTransparency() > 0 || floor != null && floor.getTransparency() > 0;
    }

    public static Anchor getFlippedAnchor(Anchor anchor, boolean isFlippedAxes) {
        if (isFlippedAxes) {
            return ChartUtil.transposeAnchor((Anchor)anchor);
        }
        return anchor;
    }

    public static TextAlignment getFlippedAlignment(TextAlignment ta, boolean isFlippedAxes) {
        if (isFlippedAxes) {
            return ChartUtil.transposeAlignment((TextAlignment)ta);
        }
        return ta;
    }

    public static Position getFlippedPosition(Position position, boolean isFlippedAxes) {
        if (isFlippedAxes) {
            switch (position.getValue()) {
                case 0: {
                    position = Position.RIGHT_LITERAL;
                    break;
                }
                case 1: {
                    position = Position.LEFT_LITERAL;
                    break;
                }
                case 2: {
                    position = Position.BELOW_LITERAL;
                    break;
                }
                case 3: {
                    position = Position.ABOVE_LITERAL;
                }
            }
        }
        return position;
    }

    public static int getPositionScopeOfSeriesLabel(Series series, ChartDimension dimension) {
        int positionScope = 15;
        if (series instanceof BarSeries) {
            positionScope = dimension == ChartDimension.THREE_DIMENSIONAL_LITERAL ? 32 : 48;
        } else if (series instanceof PieSeries) {
            positionScope = 48;
        } else if (series instanceof GanttSeriesImpl) {
            positionScope |= 0x10;
        } else if (series instanceof BubbleSeriesImpl) {
            positionScope |= 0x10;
        }
        return positionScope;
    }

    public static String[] getPositionDisplayNames(int positionScope, boolean isFlipped) {
        if ((positionScope & 0x3F) == 63) {
            return LiteralHelper.fullPositionSet.getDisplayNames();
        }
        ArrayList<String> items = new ArrayList<String>(5);
        if ((positionScope & 3) == 3) {
            if (isFlipped) {
                ChartUIUtil.addArrayToList(LiteralHelper.horizontalPositionSet.getDisplayNames(), items);
            } else {
                ChartUIUtil.addArrayToList(LiteralHelper.verticalPositionSet.getDisplayNames(), items);
            }
        }
        if ((positionScope & 0xC) == 12) {
            if (isFlipped) {
                ChartUIUtil.addArrayToList(LiteralHelper.verticalPositionSet.getDisplayNames(), items);
            } else {
                ChartUIUtil.addArrayToList(LiteralHelper.horizontalPositionSet.getDisplayNames(), items);
            }
        }
        if ((positionScope & 0x10) == 16) {
            items.add(LiteralHelper.inoutPositionSet.getDisplayNameByName(Position.INSIDE_LITERAL.getName()));
        }
        if ((positionScope & 0x20) == 32) {
            items.add(LiteralHelper.inoutPositionSet.getDisplayNameByName(Position.OUTSIDE_LITERAL.getName()));
        }
        return items.toArray(new String[items.size()]);
    }

    private static void addArrayToList(Object[] array, List list) {
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
    }

    public static void saveLabelPositionIntoCache(SeriesDefinition seriesDefinition) {
        if (seriesDefinition == null) {
            return;
        }
        EList seriesList = seriesDefinition.getSeries();
        for (Series series : seriesList) {
            if (!(series instanceof BarSeries)) continue;
            String stackedCase = "non-stacked";
            if (series.isStacked()) {
                stackedCase = "stacked";
            }
            ChartCacheManager.getInstance().cacheLabelPositionWithStackedCase(stackedCase, series.getLabelPosition());
            break;
        }
    }

    public static void restoreLabelPositionFromCache(Chart currentChart) {
        if (currentChart == null) {
            return;
        }
        SeriesDefinition[] sds = currentChart.getSeriesForLegend();
        int i = 0;
        while (i < sds.length) {
            EList seriesList = sds[i].getSeries();
            for (Series series : seriesList) {
                Position labelPosition;
                if (!(series instanceof BarSeries)) continue;
                String stackedCase = "non-stacked";
                if (series.isStacked()) {
                    stackedCase = "stacked";
                }
                if ((labelPosition = ChartCacheManager.getInstance().findLabelPositionWithStackedCase(stackedCase)) != null) {
                    series.setLabelPosition(labelPosition);
                    continue;
                }
                if (!series.isStacked()) continue;
                series.setLabelPosition(Position.INSIDE_LITERAL);
            }
            ++i;
        }
    }

    public static ISeriesUIProvider getSeriesUIProvider(Series series) {
        return htSeriesAttributeUIProviders.get(series.getClass().getName());
    }

    public static void setChartImageButtonSizeByPlatform(GridData gridData) {
        if (ChartUIUtil.isWindows()) {
            gridData.heightHint = 20;
            gridData.widthHint = 20;
        }
    }

    public static void setChartImageButtonHeightByPlatform(GridData gridData) {
        if (ChartUIUtil.isWindows()) {
            gridData.heightHint = 20;
        }
    }

    public static int getImageButtonDefaultHeightByPlatform() {
        if (ChartUIUtil.isWindows()) {
            return 20;
        }
        return 0;
    }

    private static boolean isWindows() {
        String platform = SWT.getPlatform();
        return "win32".equals(platform);
    }

    public static boolean isGroupingSupported(ChartWizardContext wizardContext) {
        return wizardContext.getPredefinedQuery("category") == null && wizardContext.getPredefinedQuery("value") == null;
    }

    private static String checkGroupTypeOnCategory(ChartWizardContext context, Chart chart) {
        String isConsistent = "";
        SeriesDefinition seriesdefinition = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions(chart).get(0);
        DataType queryDataType = context.getDataServiceProvider().getDataType(ChartUIUtil.getDataQuery(seriesdefinition, 0).getDefinition());
        if (queryDataType != null && seriesdefinition.getGrouping() != null) {
            if (!seriesdefinition.getGrouping().isEnabled()) {
                return isConsistent;
            }
            DataType groupDataType = seriesdefinition.getGrouping().getGroupType();
            if (queryDataType == DataType.NUMERIC_LITERAL && groupDataType == DataType.DATE_TIME_LITERAL) {
                return groupDataType.getName();
            }
            if (queryDataType == DataType.TEXT_LITERAL && groupDataType != DataType.TEXT_LITERAL) {
                return groupDataType.getName();
            }
        }
        return isConsistent;
    }

    private static String checkGroupTypeOnYGrouping(ChartWizardContext context, Chart chart) {
        DataType queryDataType;
        String isConsistent = "";
        SeriesDefinition seriesdefinition = (SeriesDefinition)ChartUIUtil.getOrthogonalSeriesDefinitions(chart, 0).get(0);
        if (seriesdefinition.getQuery() != null && (queryDataType = context.getDataServiceProvider().getDataType(seriesdefinition.getQuery().getDefinition())) != null && seriesdefinition.getQuery().getGrouping() != null) {
            DataType groupDataType = seriesdefinition.getGrouping().getGroupType();
            if (queryDataType == DataType.NUMERIC_LITERAL && groupDataType == DataType.DATE_TIME_LITERAL) {
                return groupDataType.getName();
            }
            if (queryDataType == DataType.TEXT_LITERAL && groupDataType != DataType.TEXT_LITERAL) {
                return groupDataType.getName();
            }
        }
        return isConsistent;
    }

    public static void checkGroupType(ChartWizardContext context, Chart chart) {
        String yGroupWarning;
        String cGroupWarning = ChartUIUtil.checkGroupTypeOnCategory(context, chart);
        if (cGroupWarning.length() != 0) {
            cGroupWarning = MessageFormat.format(Messages.getString("TaskSelectData.Warning.CategoryGroupTypeCheck"), cGroupWarning);
        }
        if ((yGroupWarning = ChartUIUtil.checkGroupTypeOnYGrouping(context, chart)).length() != 0) {
            yGroupWarning = MessageFormat.format(Messages.getString("TaskSelectData.Warning.YGroupTypeCheck"), yGroupWarning);
        }
        if (cGroupWarning.length() != 0 || yGroupWarning.length() != 0) {
            WizardBase.showException((String)(String.valueOf(cGroupWarning) + yGroupWarning));
        }
    }

    public static boolean isValidAggregation(ChartWizardContext context, SeriesGrouping grouping, boolean isCategoryGrouping) {
        if (context == null || grouping == null) {
            return true;
        }
        if (!"Gantt Chart".equals(context.getModel().getType()) || !grouping.isEnabled()) {
            return true;
        }
        String aggName = grouping.getAggregateExpression();
        if (!("First".equalsIgnoreCase(aggName) || "Last".equalsIgnoreCase(aggName) || "Min".equalsIgnoreCase(aggName) || "Max".equalsIgnoreCase(aggName))) {
            String aggPlace = "";
            aggPlace = isCategoryGrouping ? Messages.getString("ChartUIUtil.TaskSelectData.Warning.CheckAgg.DefaultAggregate") : Messages.getString("ChartUIUtil.TaskSelectData.Warning.CheckAgg.ValueSeriesAggregate");
            WizardBase.showException((String)(String.valueOf(Messages.getString("ChartUIUtil.TaskSelectData.Warning.CheckAgg.GanttChart")) + aggName + Messages.getString("ChartUIUtil.TaskSelectData.Warning.CheckAggAs") + aggPlace + Messages.getString("ChartUIUtil.TaskSelectData.Warning.CheckAgg.Aggregation")));
            return false;
        }
        return true;
    }

    public static void checkAggregateType(ChartWizardContext context) {
        SeriesDefinition baseSD;
        boolean isValidAgg = true;
        Iterator iter = ChartUIUtil.getOrthogonalSeriesDefinitions(context.getModel(), 0).iterator();
        while (iter.hasNext()) {
            if (!isValidAgg) {
                return;
            }
            SeriesDefinition orthSD = (SeriesDefinition)iter.next();
            if (orthSD.getGrouping() == null || !orthSD.getGrouping().isEnabled()) continue;
            isValidAgg = ChartUIUtil.isValidAggregation(context, orthSD.getGrouping(), false);
        }
        if (isValidAgg && (baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions(context.getModel()).get(0)).getGrouping() != null && baseSD.getGrouping().isEnabled()) {
            ChartUIUtil.isValidAggregation(context, baseSD.getGrouping(), true);
        }
    }

    public static NameSet getCompatibleAxisType(Series series) {
        ISeriesUIProvider provider = ChartUIUtil.getSeriesUIProvider(series);
        AxisType[] types = provider.getCompatibleAxisType(series);
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            names[i] = types[i].getName();
            ++i;
        }
        String prefix = "AxisType.";
        String suffix = ".displayName";
        return new NameSet(prefix, suffix, names);
    }

    public static void prepareLivePreview(Chart cm, IDataServiceProvider dataServiceProvider) {
        ChartUIUtil.prepareLivePreview(cm, dataServiceProvider, null);
    }

    public static void prepareLivePreview(Chart cm, IDataServiceProvider dataServiceProvider, IActionEvaluator iae) {
        if (dataServiceProvider.isLivePreviewEnabled() && ChartUIUtil.checkDataBinding(cm)) {
            boolean hasOtherException;
            block6: {
                ChartPreviewPainter.activateLivePreview(true);
                ChartAdapter.beginIgnoreNotifications();
                hasOtherException = false;
                try {
                    ChartUIUtil.doLivePreview(cm, dataServiceProvider, iae);
                }
                catch (Exception e) {
                    ChartPreviewPainter.activateLivePreview(false);
                    boolean isZeroDataset = false;
                    if (e instanceof ChartException && ((ChartException)((Object)e)).getType() == 16) {
                        isZeroDataset = true;
                    }
                    if (isZeroDataset) break block6;
                    hasOtherException = true;
                    ChartPreviewPainter.activateLivePreview(false);
                    WizardBase.showException((String)e.getLocalizedMessage());
                }
            }
            if (!hasOtherException) {
                WizardBase.removeException();
            }
            ChartAdapter.endIgnoreNotifications();
        } else {
            ChartPreviewPainter.activateLivePreview(false);
        }
    }

    public static String getText(Control control) {
        if (control instanceof Text) {
            return ((Text)control).getText();
        }
        if (control instanceof CCombo) {
            return ((CCombo)control).getText().trim();
        }
        if (control instanceof Combo) {
            return ((Combo)control).getText();
        }
        return "";
    }

    public static void setText(Control control, String text) {
        if (control instanceof Text) {
            ((Text)control).setText(text);
        } else if (control instanceof CCombo) {
            if (text.trim().length() > 0) {
                text = String.valueOf(text) + " ";
            }
            ((CCombo)control).setText(text);
        } else if (control instanceof Combo) {
            ((Combo)control).setText(text);
        }
    }

    public static boolean isNumericAggregate(Series series) {
        Chart cm = ChartUtil.getChartFromSeries((Series)series);
        SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions(cm).get(0);
        SeriesDefinition orthSD = null;
        orthSD = (SeriesDefinition)series.eContainer();
        String aggFunc = null;
        try {
            aggFunc = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD);
        }
        catch (ChartException chartException) {}
        return baseSD != orthSD && ChartUtil.isMagicAggregate((String)aggFunc);
    }
}

