/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.designsession;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DesignerLogger;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.DesignerUtil;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.OdaProfileUIExplorer;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionEditorPage;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionWizard;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionWizardPage;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.NewDataSourceWizard;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class DataSourceDesignSessionBase {
    private String m_odaDataSourceId;
    private OdaDesignSession m_designSession;
    private NewDataSourceWizard m_dataSourceWizard;
    private ProfileReferenceBase m_wizardProfileRef;
    private DataSourceEditorPage m_editorPage;
    private boolean m_inCreateMode = true;
    private static final boolean USE_PROFILE_PAGE_DEFAULT_SETTING = false;
    private boolean m_useProfileSelectionPage = false;
    private ProfileSelectionWizard m_profileSelectionWizard;
    private ProfileSelectionEditorPage m_profileEditorPage;
    private static final String sm_className;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.design.internal.designsession.DataSourceDesignSessionBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.design.internal.designsession.DataSourceDesignSessionBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz2.getName();
    }

    protected DataSourceDesignSessionBase(String odaDataSourceId) {
        if (!($assertionsDisabled || odaDataSourceId != null && odaDataSourceId.length() > 0)) {
            throw new AssertionError();
        }
        this.m_odaDataSourceId = odaDataSourceId;
    }

    protected DataSourceDesignSessionBase() {
        this.m_useProfileSelectionPage = true;
    }

    protected DataSourceDesignSessionBase(DesignSessionRequest sessionRequest) {
        if (sessionRequest != null) {
            String odaDataSourceId;
            DataSourceDesign requestDataSourceDesign = sessionRequest.getDataSourceDesign();
            if (requestDataSourceDesign != null && (odaDataSourceId = requestDataSourceDesign.getOdaExtensionDataSourceId()) != null && odaDataSourceId.length() > 0) {
                this.m_odaDataSourceId = odaDataSourceId;
            }
        } else {
            sessionRequest = DesignFactory.eINSTANCE.createDesignSessionRequest();
            sessionRequest.setNewDataAccessDesign(null);
        }
        this.m_designSession = DesignFactory.eINSTANCE.createOdaDesignSession();
        this.m_designSession.setRequest(sessionRequest);
        if (this.m_odaDataSourceId == null) {
            this.m_useProfileSelectionPage = true;
        }
    }

    protected void restartNewDesign(String odaDataSourceId, String newDataSourceName, ProfileReferenceBase profileRef) throws OdaException {
        this.restartNewDesign(odaDataSourceId, newDataSourceName, profileRef, null);
    }

    protected void restartNewDesign(String odaDataSourceId, String newDataSourceName, ProfileReferenceBase profileRef, DesignSessionRequest sessionRequest) throws OdaException {
        OdaConnectionProfile odaProfile;
        OdaConnectionProfile odaConnectionProfile = odaProfile = profileRef == null ? null : profileRef.getOdaProfileInstance();
        if (this.m_odaDataSourceId == null || this.m_dataSourceWizard != null && !this.m_dataSourceWizard.isValid(odaDataSourceId, odaProfile)) {
            this.m_odaDataSourceId = odaDataSourceId;
            if (this.m_dataSourceWizard != null) {
                this.m_dataSourceWizard.dispose();
            }
            this.m_dataSourceWizard = null;
        }
        this.initNewDesign(newDataSourceName, profileRef, sessionRequest);
    }

    protected void initNewDesign(String newDataSourceName, ProfileReferenceBase profileRef) throws OdaException {
        this.initNewDesign(newDataSourceName, profileRef, null);
    }

    protected void initNewDesign(String newDataSourceName, ProfileReferenceBase profileRef, DesignSessionRequest sessionRequest) throws OdaException {
        NewDataSourceWizard wizard = this.getExtendedWizard();
        Properties profileProps = null;
        String profileDesc = null;
        if (profileRef != null && !profileRef.equals(this.m_wizardProfileRef)) {
            profileProps = this.getProfileProperties(profileRef);
            profileDesc = profileRef.getDescription();
            if (newDataSourceName == null || newDataSourceName.length() == 0) {
                newDataSourceName = profileRef.getName();
            }
        }
        this.initWizard(wizard, newDataSourceName, profileDesc, profileProps, profileRef, sessionRequest);
        this.m_wizardProfileRef = profileRef;
        if (sessionRequest != null) {
            if (this.m_designSession == null) {
                this.m_designSession = DesignFactory.eINSTANCE.createOdaDesignSession();
            }
            this.m_designSession.setRequest(sessionRequest);
        }
    }

    protected void initEditDesign(DesignSessionRequest request, DataSourceEditorPage editorPage) throws OdaException {
        this.m_inCreateMode = false;
        if (editorPage == null) {
            editorPage = this.getExtendedEditorPage();
        }
        OdaDesignSession odaSession = DesignFactory.eINSTANCE.createOdaDesignSession();
        odaSession.setRequest(request);
        editorPage.initEditSession(odaSession);
        if (this.m_editorPage != editorPage) {
            this.m_editorPage = editorPage;
        }
        this.m_designSession = odaSession;
        this.getProfileSelectionEditorPage().initEditSession(this.m_designSession);
        this.m_editorPage.initProfileSelectionEditSession(this.getProfileSelectionEditorPage());
    }

    protected DesignSessionRequest getRequest() {
        if (this.m_designSession == null) {
            return null;
        }
        return this.m_designSession.getRequest();
    }

    protected boolean isInCreateMode() {
        return this.m_inCreateMode;
    }

    protected boolean isInEditMode() {
        return !this.m_inCreateMode;
    }

    protected OdaDesignSession finish() throws OdaException {
        OdaDesignSession finishedSession = this.m_inCreateMode ? this.finishNewDataSource() : this.finishEditDataSource();
        this.m_designSession = null;
        this.disposePages();
        return finishedSession;
    }

    protected OdaDesignSession cancel() {
        if (this.m_designSession == null) {
            this.m_designSession = DataSourceDesignSessionBase.createDefaultRequestDesignSession();
        }
        this.m_designSession.setResponseInCancelledState();
        OdaDesignSession cancelledSession = this.m_designSession;
        this.m_designSession = null;
        this.disposePages();
        return cancelledSession;
    }

    private void disposePages() {
        if (this.m_dataSourceWizard != null) {
            this.m_dataSourceWizard.dispose();
            this.m_dataSourceWizard = null;
        }
        if (this.m_profileSelectionWizard != null) {
            this.m_profileSelectionWizard.dispose();
            this.m_profileSelectionWizard = null;
        }
        if (this.m_editorPage != null) {
            this.m_editorPage.dispose();
            this.m_editorPage = null;
        }
        if (this.m_profileEditorPage != null) {
            this.m_profileEditorPage.dispose();
            this.m_profileEditorPage = null;
        }
        this.m_wizardProfileRef = null;
        this.m_useProfileSelectionPage = false;
    }

    protected void setUseProfileSelectionPage(boolean use) {
        this.m_useProfileSelectionPage = use;
    }

    protected void setDesignNameValidator(IDesignNameValidatorBase validator) {
        if (this.m_inCreateMode) {
            ((ProfileSelectionWizardPage)this.getProfileSelectionWizard().getStartingPage()).setDesignNameValidator(validator);
        }
    }

    protected IWizard getNewWizard() throws OdaException {
        if (this.hasSelectedOdaDataSource()) {
            return this.getExtendedWizard();
        }
        return this.getProfileSelectionWizard();
    }

    protected IWizardPage getWizardStartingPage() throws OdaException {
        if (this.m_useProfileSelectionPage || !this.hasSelectedOdaDataSource()) {
            return this.getProfileSelectionWizard().getStartingPage();
        }
        return this.getExtendedWizard().getCustomStartingPage();
    }

    private ProfileSelectionWizard getProfileSelectionWizard() {
        if (this.m_profileSelectionWizard == null) {
            this.m_profileSelectionWizard = new ProfileSelectionWizard(this);
        }
        return this.m_profileSelectionWizard;
    }

    public IWizardPage getNewCustomOdaStartingPage(String odaDataSourceId, String newDataSourceName, ProfileReferenceBase profileRef) throws OdaException {
        DesignSessionRequest sessionRequest = this.m_designSession != null ? this.m_designSession.getRequest() : null;
        this.restartNewDesign(odaDataSourceId, newDataSourceName, profileRef, sessionRequest);
        return this.hasSelectedOdaDataSource() ? this.getExtendedWizard().getCustomStartingPage() : null;
    }

    protected NewDataSourceWizard getExtendedWizard() throws OdaException {
        if (this.m_dataSourceWizard == null) {
            if (!$assertionsDisabled && !this.hasSelectedOdaDataSource()) {
                throw new AssertionError();
            }
            this.m_dataSourceWizard = OdaProfileUIExplorer.getInstance().getNewDataSourceWizardByType(this.m_odaDataSourceId);
            if (this.m_dataSourceWizard == null) {
                this.m_dataSourceWizard = new NewDataSourceWizard(this.m_odaDataSourceId);
            }
        }
        return this.m_dataSourceWizard;
    }

    private void initWizard(NewDataSourceWizard wizard, String aDataSourceName, String aDataSourceDesc, Properties dataSourceProps, ProfileReferenceBase newProfileRef, DesignSessionRequest sessionRequest) throws OdaException {
        wizard.initOdaDesignSession(newProfileRef, sessionRequest);
        wizard.addPages();
        if (wizard.hasProfileNamePage()) {
            if (aDataSourceName == null || aDataSourceName.length() == 0) {
                throw new OdaException(Messages.designSession_invalidArgument);
            }
            wizard.setProfilePageProperties(aDataSourceName, aDataSourceDesc, null, Boolean.TRUE);
        }
        wizard.refreshPropertiesIfExist(dataSourceProps);
    }

    protected ProfileSelectionEditorPage getProfileSelectionEditorPage() throws OdaException {
        if (this.m_profileEditorPage == null) {
            if (this.m_designSession == null) {
                throw new OdaException(Messages.common_notInDesignSession);
            }
            this.m_profileEditorPage = new ProfileSelectionEditorPage();
        }
        return this.m_profileEditorPage;
    }

    protected PropertyPage getEditorPage() throws OdaException {
        return this.getAdaptableEditorPage();
    }

    protected IAdaptable getEditPropertyPageElement() throws OdaException {
        if (this.m_designSession == null) {
            throw new OdaException(Messages.common_notInDesignSession);
        }
        return DesignerUtil.getAdaptableDataSourceDesign(this.m_designSession);
    }

    protected DataSourceEditorPage getAdaptableEditorPage() throws OdaException {
        DataSourceEditorPage editorPage = this.getExtendedEditorPage();
        if (editorPage.getElement() == null) {
            editorPage.setElement(this.getEditPropertyPageElement());
        }
        return editorPage;
    }

    protected DataSourceEditorPage getExtendedEditorPage() throws OdaException {
        if (this.m_editorPage == null) {
            this.m_editorPage = OdaProfileUIExplorer.getInstance().getDataSourceEditorPage(this.m_odaDataSourceId);
            if (this.m_editorPage == null) {
                throw new OdaException(Messages.extension_missingPropertyPage);
            }
        }
        return this.m_editorPage;
    }

    private Properties getProfileProperties(ProfileReferenceBase profileRef) throws OdaException {
        Properties profileProps;
        try {
            IConnectionProfile profile = profileRef.getProfileInstance();
            profileProps = profile.getBaseProperties();
        }
        catch (Exception ex) {
            throw new OdaException((Throwable)ex);
        }
        return profileProps;
    }

    protected OdaDesignSession finishNewDataSource() throws OdaException {
        NewDataSourceWizard wizard = null;
        try {
            wizard = this.getExtendedWizard();
        }
        catch (OdaException ex) {
            ex.printStackTrace();
            DesignerLogger logger = DesignerLogger.getInstance();
            logger.warning(sm_className, "finishNewDataSource", "Caught exception while getting an extended wizard.", ex);
        }
        DataSourceDesign newDataSourceDesign = wizard != null ? wizard.getDataSourceDesign() : null;
        return DataSourceDesignSessionBase.setDesignSessionResponse(this.m_designSession, newDataSourceDesign, wizard);
    }

    protected OdaDesignSession finishNewDesignFromProfile(String newDataSourceName, ProfileReferenceBase profileRef) throws OdaException {
        DataSourceDesign newDataSourceDesign = this.finishDataSourceDesignFromProfile(newDataSourceName, profileRef);
        return DataSourceDesignSessionBase.setDesignSessionResponse(this.m_designSession, newDataSourceDesign, this.getExtendedWizard());
    }

    private DataSourceDesign finishDataSourceDesignFromProfile(String newDataSourceName, ProfileReferenceBase profileRef) throws OdaException {
        NewDataSourceWizard wizard = this.getExtendedWizard();
        DataSourceDesign newDataSourceDesign = wizard.finishDataSourceDesign();
        if (newDataSourceDesign != null) {
            if (!$assertionsDisabled && profileRef == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && profileRef.getProfileInstance() == null) {
                throw new AssertionError();
            }
            if (newDataSourceName == null || newDataSourceName.length() == 0) {
                newDataSourceName = profileRef.getName();
            }
            newDataSourceDesign.setName(newDataSourceName);
            newDataSourceDesign.setDisplayName(profileRef.getDescription());
        }
        return newDataSourceDesign;
    }

    protected static OdaDesignSession createResponseDesignSession(DataSourceDesign newDataSourceDesign, NewDataSourceWizard wizard) {
        boolean isSessionOk = newDataSourceDesign != null;
        OdaDesignSession responseSession = DesignFactory.eINSTANCE.createResponseDesignSession(isSessionOk, newDataSourceDesign);
        DataSourceDesignSessionBase.setResponseDesignerState(responseSession, wizard);
        return responseSession;
    }

    private static OdaDesignSession setDesignSessionResponse(OdaDesignSession designSession, DataSourceDesign responseDataSourceDesign, NewDataSourceWizard wizard) {
        if (designSession == null) {
            designSession = DataSourceDesignSessionBase.createDefaultRequestDesignSession();
        }
        boolean isSessionOk = responseDataSourceDesign != null;
        designSession.setNewResponse(isSessionOk, responseDataSourceDesign);
        DataSourceDesignSessionBase.setResponseDesignerState(designSession, wizard);
        return designSession;
    }

    private static OdaDesignSession createDefaultRequestDesignSession() {
        return DesignFactory.eINSTANCE.createRequestDesignSession(null);
    }

    private static void setResponseDesignerState(OdaDesignSession designSession, NewDataSourceWizard wizard) {
        DesignerState customState;
        if (!$assertionsDisabled && designSession == null) {
            throw new AssertionError();
        }
        if (wizard != null && (customState = wizard.getResponseDesignerState()) != null) {
            designSession.getResponse().setDesignerState(customState);
        }
    }

    protected OdaDesignSession finishEditDataSource() throws OdaException {
        ProfileSelectionEditorPage profilePage;
        if (!$assertionsDisabled && this.m_designSession == null) {
            throw new AssertionError();
        }
        DataSourceEditorPage editorPage = null;
        try {
            editorPage = this.getAdaptableEditorPage();
        }
        catch (OdaException ex) {
            DesignerLogger logger = DesignerLogger.getInstance();
            logger.severe(sm_className, "finishEditDataSource", "Caught exception while getting an extended editor page.", ex);
            throw ex;
        }
        if (!$assertionsDisabled && editorPage == null) {
            throw new AssertionError();
        }
        OdaDesignSession responseSession = null;
        if (editorPage.isInOdaDesignSession()) {
            responseSession = editorPage.getEditSessionResponse();
        }
        if (this.m_useProfileSelectionPage && (profilePage = this.getProfileSelectionEditorPage()).isInOdaDesignSession()) {
            responseSession = profilePage.getEditSessionResponse();
        }
        return responseSession;
    }

    private boolean hasSelectedOdaDataSource() {
        return this.m_odaDataSourceId != null && this.m_odaDataSourceId.length() > 0;
    }

    public static interface IDesignNameValidatorBase {
        public boolean isValid(String var1) throws OdaException;
    }

    public static class ProfileReferenceBase {
        private String m_instanceId;
        private String m_instanceName;
        private File m_storageFile;
        private boolean m_maintainLink;
        private OdaConnectionProfile m_profileInstance;

        public ProfileReferenceBase(String profileInstanceId, File storageFile, boolean maintainExternalLink) {
            this.m_instanceId = profileInstanceId;
            this.m_storageFile = storageFile;
            this.m_maintainLink = maintainExternalLink;
        }

        public ProfileReferenceBase(String profileInstanceName, String storageFilePath, boolean maintainExternalLink) {
            this.m_instanceName = profileInstanceName;
            this.m_storageFile = DesignUtil.convertPathToFile((String)storageFilePath);
            this.m_maintainLink = maintainExternalLink;
        }

        public String getInstanceId() {
            IConnectionProfile profile;
            if (this.m_instanceId == null && this.m_instanceName != null && (profile = this.getProfileInstance()) != null) {
                this.m_instanceId = profile.getInstanceID();
            }
            return this.m_instanceId;
        }

        public String getName() {
            IConnectionProfile profile;
            if (this.m_instanceName == null && this.m_instanceId != null && (profile = this.getProfileInstance()) != null) {
                this.m_instanceName = profile.getName();
            }
            return this.m_instanceName;
        }

        public String getDescription() {
            IConnectionProfile profileInstance = this.getProfileInstance();
            return profileInstance != null ? profileInstance.getDescription() : null;
        }

        public File getStorageFile() {
            return this.m_storageFile;
        }

        public String getStorageFilePath() {
            return DesignUtil.convertFileToPath((File)this.getStorageFile());
        }

        public boolean maintainExternalLink() {
            return this.m_maintainLink;
        }

        public IConnectionProfile getProfileInstance() {
            return this.getOdaProfileInstance();
        }

        private OdaConnectionProfile getOdaProfileInstance() {
            if (this.m_profileInstance != null) {
                return this.m_profileInstance;
            }
            if (this.m_instanceId != null) {
                this.m_profileInstance = this.getInstanceById();
            }
            if (this.m_profileInstance == null && this.m_instanceName != null) {
                this.m_profileInstance = this.getInstanceByName();
            }
            return this.m_profileInstance;
        }

        private OdaConnectionProfile getInstanceById() {
            OdaConnectionProfile profileInstance = null;
            try {
                profileInstance = (OdaConnectionProfile)OdaProfileExplorer.getInstance().getProfileById(this.m_instanceId, this.m_storageFile);
            }
            catch (OdaException ex) {
                ex.printStackTrace();
                DesignerLogger logger = DesignerLogger.getInstance();
                logger.warning(sm_className, "ProfileReferenceBase.getInstanceById", "Caught exception while getting an instance of connection profile by id (" + this.m_instanceId + ") from " + this.m_storageFile + " .", ex);
            }
            return profileInstance;
        }

        private OdaConnectionProfile getInstanceByName() {
            OdaConnectionProfile profileInstance = null;
            try {
                profileInstance = (OdaConnectionProfile)OdaProfileExplorer.getInstance().getProfileByName(this.m_instanceName, this.m_storageFile);
            }
            catch (OdaException ex) {
                ex.printStackTrace();
                DesignerLogger logger = DesignerLogger.getInstance();
                logger.warning(sm_className, "ProfileReferenceBase.getInstanceByName", "Caught exception while getting an instance of connection profile by name (" + this.m_instanceName + ") from " + this.m_storageFile + " .", ex);
            }
            return profileInstance;
        }

        public boolean equals(ProfileReferenceBase aProfileRef) {
            if (!this.equalsIgnoreMaintainLink(aProfileRef)) {
                return false;
            }
            return this.m_maintainLink == aProfileRef.m_maintainLink;
        }

        public boolean equalsIgnoreMaintainLink(ProfileReferenceBase aProfileRef) {
            if (aProfileRef == null) {
                return false;
            }
            if (this.m_storageFile != null && !this.m_storageFile.equals(aProfileRef.m_storageFile)) {
                return false;
            }
            if (this.m_storageFile == null && aProfileRef.m_storageFile != null) {
                return false;
            }
            if (this.m_instanceId != null && this.m_instanceId.equals(aProfileRef.m_instanceId)) {
                return true;
            }
            if (this.m_instanceId != null && !this.m_instanceId.equals(aProfileRef.m_instanceId)) {
                return false;
            }
            if (this.m_instanceId == null && aProfileRef.m_instanceId != null) {
                return false;
            }
            if (this.m_instanceName != null && !this.m_instanceName.equals(aProfileRef.m_instanceName)) {
                return false;
            }
            return this.m_instanceName != null || aProfileRef.m_instanceName == null;
        }
    }
}

