/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;

public class ServiceUse {
    final ServiceFactory factory;
    final BundleContextImpl context;
    final ServiceRegistrationImpl registration;
    private Object cachedService;
    private int useCount = 0;

    ServiceUse(BundleContextImpl context, ServiceRegistrationImpl registration) {
        Object service = registration.getService();
        if (service instanceof ServiceFactory) {
            this.factory = (ServiceFactory)service;
            this.cachedService = null;
        } else {
            this.factory = null;
            this.cachedService = service;
        }
        this.context = context;
        this.registration = registration;
    }

    Object getService() {
        Object service;
        if (this.useCount > 0 || this.factory == null) {
            ++this.useCount;
            return this.cachedService;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        try {
            service = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ServiceUse.this.factory.getService(ServiceUse.this.context.getBundleImpl(), ServiceUse.this.registration);
                }
            });
        }
        catch (Throwable t) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(this.factory + ".getService() exception: " + t.getMessage());
                Debug.printStackTrace(t);
            }
            this.context.getFramework().getAdaptor().handleRuntimeError(t);
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "getService"), 3, t);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), se);
            return null;
        }
        if (service == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(this.factory + ".getService() returned null.");
            }
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_OBJECT_NULL_EXCEPTION, this.factory.getClass().getName()), 2);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), se);
            return null;
        }
        String[] clazzes = this.registration.getClasses();
        String invalidService = ServiceRegistry.checkServiceClass(clazzes, service);
        if (invalidService != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + invalidService);
            }
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_NOT_INSTANCEOF_CLASS_EXCEPTION, this.factory.getClass().getName(), invalidService), 2);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), se);
            return null;
        }
        this.cachedService = service;
        ++this.useCount;
        return service;
    }

    boolean ungetService() {
        if (this.useCount == 0) {
            return true;
        }
        --this.useCount;
        if (this.useCount > 0) {
            return false;
        }
        if (this.factory == null) {
            return true;
        }
        final Object service = this.cachedService;
        this.cachedService = null;
        if (Debug.DEBUG_SERVICES) {
            Debug.println("ungetService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceUse.this.factory.ungetService(ServiceUse.this.context.getBundleImpl(), ServiceUse.this.registration, service);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println(this.factory + ".ungetService() exception");
                Debug.printStackTrace(t);
            }
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), 3, t);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), se);
        }
        return true;
    }

    void releaseService() {
        if (this.useCount == 0 || this.factory == null) {
            return;
        }
        final Object service = this.cachedService;
        this.cachedService = null;
        this.useCount = 0;
        if (Debug.DEBUG_SERVICES) {
            Debug.println("releaseService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceUse.this.factory.ungetService(ServiceUse.this.context.getBundleImpl(), ServiceUse.this.registration, service);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(this.factory + ".ungetService() exception");
                Debug.printStackTrace(t);
            }
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), 3, t);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), se);
        }
    }
}

