/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.impl.ResultMetaData2;
import org.eclipse.birt.report.data.adapter.impl.ResultSetColumnDefinition;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;

public class MetaDataPopulator {
    private static final char RENAME_SEPARATOR = '_';
    private static final String UNNAME_PREFIX = "UNNAMED";

    public static IResultMetaData retrieveResultMetaData(DataSetHandle dataSetHandle) throws BirtException {
        PropertyHandle handle;
        ArrayList resultSetList = null;
        if (dataSetHandle instanceof OdaDataSetHandle) {
            handle = dataSetHandle.getPropertyHandle("resultSet");
            resultSetList = handle.getListValue();
        } else if (dataSetHandle instanceof ScriptDataSetHandle) {
            handle = dataSetHandle.getPropertyHandle("resultSetHints");
            resultSetList = handle.getListValue();
        } else {
            return null;
        }
        List computedList = (List)dataSetHandle.getProperty("computedColumns");
        ArrayList<ResultSetColumnDefinition> columnMeta = new ArrayList<ResultSetColumnDefinition>();
        int count = 0;
        if (resultSetList != null && !resultSetList.isEmpty()) {
            ResultSetColumnDefinition columnDef;
            HashSet<String> orgColumnNameSet = new HashSet<String>();
            HashSet<String> uniqueColumnNameSet = new HashSet<String>();
            int n = 0;
            while (n < resultSetList.size()) {
                orgColumnNameSet.add(((ResultSetColumn)resultSetList.get(n)).getColumnName());
                ++n;
            }
            int i = 0;
            while (i < resultSetList.size()) {
                ResultSetColumn resultSetColumn = (ResultSetColumn)resultSetList.get(i);
                uniqueColumnNameSet.add(resultSetColumn.getColumnName());
                columnDef = new ResultSetColumnDefinition(resultSetColumn.getColumnName());
                columnDef.setDataTypeName(resultSetColumn.getDataType());
                columnDef.setDataType(DataAdapterUtil.adaptModelDataType(resultSetColumn.getDataType()));
                if (resultSetColumn.getPosition() != null) {
                    columnDef.setColumnPosition(resultSetColumn.getPosition());
                }
                if (resultSetColumn.getNativeDataType() != null) {
                    columnDef.setNativeDataType(resultSetColumn.getNativeDataType());
                }
                if (MetaDataPopulator.findColumnHint(dataSetHandle, resultSetColumn.getColumnName()) != null) {
                    ColumnHintHandle columnHint = MetaDataPopulator.findColumnHint(dataSetHandle, resultSetColumn.getColumnName());
                    columnDef.setAlias(columnHint.getAlias());
                    columnDef.setLableName(columnHint.getDisplayName());
                }
                columnDef.setComputedColumn(false);
                columnMeta.add(columnDef);
                ++i;
            }
            count += resultSetList.size();
            if (computedList != null) {
                n = 0;
                while (n < computedList.size()) {
                    orgColumnNameSet.add(((ComputedColumn)computedList.get(n)).getName());
                    ++n;
                }
                int i2 = 0;
                while (i2 < computedList.size()) {
                    ComputedColumn computedColumn = (ComputedColumn)computedList.get(i2);
                    String columnName = computedColumn.getName();
                    String uniqueColumnName = MetaDataPopulator.getUniqueName(orgColumnNameSet, uniqueColumnNameSet, columnName, i2 + count);
                    uniqueColumnNameSet.add(uniqueColumnName);
                    if (!uniqueColumnName.equals(columnName)) {
                        MetaDataPopulator.updateComputedColumn(dataSetHandle, uniqueColumnName, columnName);
                    }
                    columnDef = new ResultSetColumnDefinition(uniqueColumnName);
                    columnDef.setDataTypeName(computedColumn.getDataType());
                    columnDef.setDataType(DataAdapterUtil.adaptModelDataType(computedColumn.getDataType()));
                    if (MetaDataPopulator.findColumnHint(dataSetHandle, uniqueColumnName) != null) {
                        ColumnHintHandle columnHint = MetaDataPopulator.findColumnHint(dataSetHandle, uniqueColumnName);
                        columnDef.setAlias(columnHint.getAlias());
                        columnDef.setLableName(columnHint.getDisplayName());
                    }
                    columnDef.setComputedColumn(true);
                    columnMeta.add(columnDef);
                    ++i2;
                }
            }
            return new ResultMetaData2(columnMeta);
        }
        return null;
    }

    private static ColumnHintHandle findColumnHint(DataSetHandle dataSetHandle, String columnName) {
        Iterator columnHintIter = dataSetHandle.columnHintsIterator();
        if (columnHintIter != null) {
            while (columnHintIter.hasNext()) {
                ColumnHintHandle modelColumnHint = (ColumnHintHandle)columnHintIter.next();
                if (!modelColumnHint.getColumnName().equals(columnName)) continue;
                return modelColumnHint;
            }
        }
        return null;
    }

    public static boolean needsUseResultHint(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        boolean hasResultSetHint = false;
        boolean hasColumnHint = false;
        PropertyHandle handle = dataSetHandle.getPropertyHandle("columnHints");
        if (handle != null) {
            hasColumnHint = handle.iterator().hasNext();
        }
        if (!(hasResultSetHint = MetaDataPopulator.populateResultsetHint(dataSetHandle, metaData))) {
            hasResultSetHint = MetaDataPopulator.checkHandleType(dataSetHandle);
        }
        return hasResultSetHint || hasColumnHint;
    }

    private static boolean populateResultsetHint(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        boolean hasResultSetHint = false;
        int columnCount = 0;
        HashSet<String> orgColumnNameSet = new HashSet<String>();
        HashSet<String> uniqueColumnNameSet = new HashSet<String>();
        if (metaData != null) {
            columnCount = metaData.getColumnCount();
            int n = 0;
            while (n < columnCount) {
                orgColumnNameSet.add(metaData.getColumnName(n + 1));
                ++n;
            }
        }
        int i = 0;
        while (i < columnCount) {
            String columnName = metaData.getColumnName(i + 1);
            String uniqueColumnName = MetaDataPopulator.getUniqueName(orgColumnNameSet, uniqueColumnNameSet, columnName, i);
            uniqueColumnNameSet.add(uniqueColumnName);
            if (!uniqueColumnName.equals(columnName)) {
                MetaDataPopulator.updateModelColumn(dataSetHandle, uniqueColumnName, i + 1);
                if (!hasResultSetHint) {
                    hasResultSetHint = true;
                }
            }
            ++i;
        }
        return hasResultSetHint;
    }

    public static String getUniqueName(HashSet orgColumnNameSet, HashSet newColumnNameSet, String columnName, int index) {
        String newColumnName;
        if (columnName == null || columnName.trim().length() == 0 || newColumnNameSet.contains(columnName)) {
            newColumnName = columnName == null || columnName.trim().length() == 0 ? "UNNAMED_" + String.valueOf(index + 1) : String.valueOf(columnName) + '_' + String.valueOf(index + 1);
            int i = 1;
            while (orgColumnNameSet.contains(newColumnName) || newColumnNameSet.contains(newColumnName)) {
                newColumnName = String.valueOf(newColumnName) + String.valueOf('_') + i;
                ++i;
            }
        } else {
            newColumnName = columnName;
        }
        return newColumnName;
    }

    private static boolean checkHandleType(DataSetHandle dataSetHandle) {
        if (dataSetHandle instanceof ScriptDataSetHandle) {
            return true;
        }
        if (dataSetHandle instanceof JointDataSetHandle) {
            Iterator iter = ((JointDataSetHandle)dataSetHandle).dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle dsHandle = (DataSetHandle)iter.next();
                if (dsHandle != null && dsHandle instanceof ScriptDataSetHandle) {
                    return true;
                }
                if (!(dsHandle instanceof JointDataSetHandle) || !MetaDataPopulator.checkHandleType(dsHandle)) continue;
                return true;
            }
        }
        return false;
    }

    private static void updateModelColumn(DataSetHandle ds, String uniqueColumnName, int index) throws BirtException {
        PropertyHandle resultSetColumns = ds.getPropertyHandle("resultSet");
        if (resultSetColumns == null) {
            return;
        }
        for (ResultSetColumnHandle rsColumnHandle : resultSetColumns) {
            assert (rsColumnHandle.getPosition() != null);
            if (rsColumnHandle.getPosition() != index) continue;
            if (rsColumnHandle.getColumnName() == null || rsColumnHandle.getColumnName().equals(uniqueColumnName)) break;
            rsColumnHandle.setColumnName(uniqueColumnName);
            break;
        }
    }

    private static void updateComputedColumn(DataSetHandle ds, String uniqueColumnName, String originalName) throws BirtException {
        PropertyHandle computedColumn = ds.getPropertyHandle("computedColumns");
        if (computedColumn == null) {
            return;
        }
        for (ComputedColumnHandle compColumnHandle : computedColumn) {
            if (compColumnHandle.getName() == null || !compColumnHandle.getName().equals(originalName)) continue;
            compColumnHandle.setName(uniqueColumnName);
        }
    }
}

