/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.mozilla.javascript.Scriptable;

class QueryExecutionHelper {
    private DataEngine dataEngine;
    private IModelAdapter modelAdaptor;
    private DataSessionContext sessionContext;
    private boolean useResultHints;
    private DataSetHandle major;

    QueryExecutionHelper(DataEngine dataEngine, IModelAdapter modelAdaptor, DataSessionContext sessionContext) {
        this(dataEngine, modelAdaptor, sessionContext, true);
    }

    QueryExecutionHelper(DataEngine dataEngine, IModelAdapter modelAdaptor, DataSessionContext sessionContext, boolean useResultHints) {
        this.dataEngine = dataEngine;
        this.modelAdaptor = modelAdaptor;
        this.sessionContext = sessionContext;
        this.useResultHints = useResultHints;
    }

    IQueryResults executeQuery(IQueryDefinition queryDefn) throws BirtException {
        return this.executeQuery(queryDefn, null, null, null, null);
    }

    IQueryResults executeQuery(IQueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt, Scriptable scope) throws BirtException {
        return this.executeQuery(queryDefn, paramBindingIt, filterIt, bindingIt, true, false, scope);
    }

    IQueryResults executeQuery(IQueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt, boolean keepDataSetFilter, boolean disAllowAggregation, Scriptable scope) throws BirtException {
        this.defineDataSourceDataSet(queryDefn, keepDataSetFilter, disAllowAggregation);
        this.populateQueryDefn(queryDefn, paramBindingIt, filterIt, bindingIt, disAllowAggregation);
        return this.dataEngine.prepare(queryDefn, this.sessionContext.getAppContext()).execute(scope);
    }

    private void defineDataSourceDataSet(IQueryDefinition queryDefn, boolean keepDataSetFilter, boolean allowAggregation) throws AdapterException, BirtException {
        String dataSetName = queryDefn.getDataSetName();
        ModuleHandle module = this.sessionContext.getModuleHandle();
        if (module != null) {
            List l = module.getAllDataSets();
            DataSetHandle handle = null;
            int i = 0;
            while (i < l.size()) {
                if (((DataSetHandle)l.get(i)).getQualifiedName() != null && ((DataSetHandle)l.get(i)).getQualifiedName().equals(dataSetName)) {
                    handle = (DataSetHandle)l.get(i);
                    break;
                }
                ++i;
            }
            this.major = handle;
            this.defineDataSet(handle, keepDataSetFilter, allowAggregation);
        }
    }

    private void populateQueryDefn(IQueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt, boolean disAllowAggregation) throws AdapterException {
        try {
            List filters;
            while (bindingIt != null && bindingIt.hasNext()) {
                IBinding binding = this.modelAdaptor.adaptBinding((ComputedColumnHandle)bindingIt.next());
                if (disAllowAggregation && binding.getAggrFunction() != null) continue;
                queryDefn.addBinding(binding);
            }
            List parameterBindings = this.convertParamterBindings(paramBindingIt);
            if (parameterBindings != null) {
                queryDefn.getInputParamBindings().addAll(parameterBindings);
            }
            if ((filters = this.convertFilters(filterIt)) != null) {
                queryDefn.getFilters().addAll(filters);
            }
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private List convertFilters(Iterator filterIt) {
        if (filterIt == null) {
            return null;
        }
        filters = new ArrayList<FilterDefinition>();
        ** GOTO lbl10
        {
            filter = this.modelAdaptor.adaptFilter((FilterConditionHandle)filterIt.next());
            filters.add(filter);
            do {
                if (filterIt.hasNext()) continue block0;
lbl10:
                // 2 sources

            } while (filterIt.hasNext());
        }
        return filters;
    }

    private List convertParamterBindings(Iterator paramBindingIt) {
        if (paramBindingIt == null) {
            return null;
        }
        ArrayList<InputParameterBinding> parameterBindings = new ArrayList<InputParameterBinding>();
        while (paramBindingIt.hasNext()) {
            InputParameterBinding inputParamBinding;
            ScriptExpression paramValueExpr;
            ParamBindingHandle paramBinding;
            Object paramObj = paramBindingIt.next();
            if (paramObj instanceof ParamBindingHandle) {
                paramBinding = (ParamBindingHandle)paramObj;
                if (paramBinding.getExpression() == null) continue;
                paramValueExpr = new ScriptExpression(paramBinding.getExpression());
                inputParamBinding = new InputParameterBinding(paramBinding.getParamName(), (IBaseExpression)paramValueExpr);
                parameterBindings.add(inputParamBinding);
                continue;
            }
            if (!(paramObj instanceof OdaDataSetParameterHandle) || (paramBinding = (OdaDataSetParameterHandle)paramObj).getDefaultValue() == null) continue;
            paramValueExpr = new ScriptExpression(paramBinding.getDefaultValue());
            inputParamBinding = new InputParameterBinding(paramBinding.getName(), (IBaseExpression)paramValueExpr);
            parameterBindings.add(inputParamBinding);
        }
        return parameterBindings;
    }

    private void defineDataSet(DataSetHandle handle, boolean keepDataSetFilter, boolean disAllowAggregation) throws AdapterException, BirtException {
        List computedColumns;
        if (handle == null) {
            throw new AdapterException("datasethandle.null.error");
        }
        DataSourceHandle dataSourceHandle = handle.getDataSource();
        if (dataSourceHandle != null) {
            BaseDataSourceDesign dsourceDesign = this.modelAdaptor.adaptDataSource(dataSourceHandle);
            this.dataEngine.defineDataSource((IBaseDataSourceDesign)dsourceDesign);
        }
        if (handle instanceof JointDataSetHandle) {
            this.defineSourceDataSets((JointDataSetHandle)handle);
        }
        BaseDataSetDesign baseDS = this.modelAdaptor.adaptDataSet(handle);
        if (!this.useResultHints && handle.equals(this.major)) {
            baseDS.getResultSetHints().clear();
        }
        if (!keepDataSetFilter && baseDS.getFilters() != null) {
            baseDS.getFilters().clear();
        }
        if (disAllowAggregation && (computedColumns = baseDS.getComputedColumns()) != null && computedColumns.size() != 0) {
            int i = 0;
            while (i < computedColumns.size()) {
                IComputedColumn computedColumn = (IComputedColumn)computedColumns.get(i);
                if (computedColumn.getAggregateFunction() != null) {
                    computedColumns.set(i, new ComputedColumn(computedColumn.getName(), "null"));
                }
                ++i;
            }
        }
        this.dataEngine.defineDataSet((IBaseDataSetDesign)baseDS);
    }

    private void defineSourceDataSets(JointDataSetHandle jointDataSetHandle) throws BirtException {
        Iterator iter = jointDataSetHandle.dataSetsIterator();
        while (iter.hasNext()) {
            DataSetHandle dsHandle = (DataSetHandle)iter.next();
            if (dsHandle == null) continue;
            this.defineDataSet(dsHandle, true, false);
        }
    }
}

