/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import com.ibm.icu.text.Collator;
import java.math.BigDecimal;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

public class BirtComp
implements IScriptFunctionExecutor {
    private static final long serialVersionUID = 29055295217417372L;
    private static final String WRONG_ARGUMENT = "Wrong number of arguments for BirtComp function: {0}";
    private static final String ANY_OF = "anyOf";
    private static final String BETWEEN = "between";
    private static final String NOT_BETWEEN = "notBetween";
    private static final String EQUAL_TO = "equalTo";
    private static final String GREATER_THAN = "greaterThan";
    private static final String LESS_THAN = "lessThan";
    private static final String GREATER_OR_EQUAL = "greaterOrEqual";
    private static final String LESS_OR_EQUAL = "lessOrEqual";
    private static final String NOT_EQUAL = "notEqual";
    private static final String LIKE = "like";
    private static final String NOT_LIKE = "notLike";
    private static final String MATCH = "match";
    private static final String COMPARE_STRING = "compareString";
    private static final String PLUGIN_ID = "org.eclipse.birt.core";
    private IScriptFunctionExecutor executor;
    private static Collator myCollator = Collator.getInstance();
    private static Pattern s_JSReExprPattern;

    BirtComp(String functionName) throws BirtException {
        if (ANY_OF.equals(functionName)) {
            this.executor = new Function_AnyOf();
        } else if (BETWEEN.equals(functionName)) {
            this.executor = new Function_Between(true);
        } else if (NOT_BETWEEN.equals(functionName)) {
            this.executor = new Function_Between(false);
        } else if (EQUAL_TO.equals(functionName)) {
            this.executor = new Function_Compare(0);
        } else if (GREATER_THAN.equals(functionName)) {
            this.executor = new Function_Compare(2);
        } else if (LESS_THAN.equals(functionName)) {
            this.executor = new Function_Compare(3);
        } else if (GREATER_OR_EQUAL.equals(functionName)) {
            this.executor = new Function_Compare(4);
        } else if (LESS_OR_EQUAL.equals(functionName)) {
            this.executor = new Function_Compare(5);
        } else if (NOT_EQUAL.equals(functionName)) {
            this.executor = new Function_Compare(1);
        } else if (LIKE.equals(functionName)) {
            this.executor = new Function_Compare(6);
        } else if (NOT_LIKE.equals(functionName)) {
            this.executor = new Function_Compare(8);
        } else if (MATCH.equals(functionName)) {
            this.executor = new Function_Compare(7);
        } else if (COMPARE_STRING.equals(functionName)) {
            this.executor = new Function_Compare(9);
        } else {
            throw new BirtException("org.eclipse.birt.core.script.function.bre", null, (Object)(String.valueOf(Messages.getString("invalid.function.name")) + "BirtComp." + functionName));
        }
    }

    private static int compare(Object obj1, Object obj2) throws BirtException {
        if (obj1 == null || obj2 == null) {
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            return 0;
        }
        if (BirtComp.isSameType(obj1, obj2)) {
            if (obj1 instanceof Boolean) {
                if (obj1.equals(obj2)) {
                    return 0;
                }
                Boolean bool = (Boolean)obj1;
                if (bool.equals(Boolean.TRUE)) {
                    return 1;
                }
                return -1;
            }
            if (obj1 instanceof Comparable) {
                if (obj1 instanceof String) {
                    return myCollator.compare(obj1, obj2);
                }
                return ((Comparable)obj1).compareTo(obj2);
            }
            return myCollator.compare(obj1.toString(), obj2.toString());
        }
        if (obj1 instanceof BigDecimal || obj2 instanceof BigDecimal) {
            BigDecimal a = DataTypeUtil.toBigDecimal((Object)obj1);
            BigDecimal b = DataTypeUtil.toBigDecimal((Object)obj2);
            return a.compareTo(b);
        }
        if (BirtComp.isNumericOrString(obj1) && BirtComp.isNumericOrString(obj2)) {
            return DataTypeUtil.toDouble((Object)obj1).compareTo(DataTypeUtil.toDouble((Object)obj2));
        }
        if (BirtComp.isTimeOrString(obj1) && BirtComp.isTimeOrString(obj2)) {
            return DataTypeUtil.toSqlTime((Object)obj1).compareTo(DataTypeUtil.toSqlTime((Object)obj2));
        }
        if (BirtComp.isSQLDateOrString(obj1) && BirtComp.isSQLDateOrString(obj2)) {
            return DataTypeUtil.toSqlDate((Object)obj1).compareTo(DataTypeUtil.toSqlDate((Object)obj2));
        }
        if (BirtComp.isDateOrString(obj1) && BirtComp.isDateOrString(obj2)) {
            return DataTypeUtil.toDate((Object)obj1).compareTo(DataTypeUtil.toDate((Object)obj2));
        }
        throw new IllegalArgumentException();
    }

    private static int compareString(Object obj1, Object obj2, boolean ignoreCase, boolean trimed) throws BirtException {
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        if (!(obj1 instanceof String) || !(obj2 instanceof String)) {
            throw new IllegalArgumentException();
        }
        String str1 = DataTypeUtil.toString((Object)obj1);
        String str2 = DataTypeUtil.toString((Object)obj2);
        if (ignoreCase) {
            if (trimed) {
                return str1.trim().compareToIgnoreCase(str2.trim());
            }
            return str1.compareToIgnoreCase(str2);
        }
        if (trimed) {
            return str1.trim().compareTo(str2.trim());
        }
        return str1.compareTo(str2);
    }

    private static boolean isTimeOrString(Object result) {
        return result instanceof Time || result instanceof String;
    }

    private static Matcher getJSReExprPatternMatcher(String patternStr) {
        if (s_JSReExprPattern == null) {
            s_JSReExprPattern = Pattern.compile("^/(.*)/([a-zA-Z]*)$");
        }
        return s_JSReExprPattern.matcher(patternStr);
    }

    private static boolean match(Object obj1, Object obj2) throws BirtException {
        if (obj2 == null) {
            throw new IllegalArgumentException("pattern value can not be null!");
        }
        if (obj1 == null) {
            return false;
        }
        String sourceStr = obj1.toString();
        String pattern = obj2.toString();
        Matcher jsReExprMatcher = BirtComp.getJSReExprPatternMatcher(pattern);
        int flags = 0;
        if (jsReExprMatcher.matches()) {
            String flagStr = pattern.substring(jsReExprMatcher.start(2), jsReExprMatcher.end(2));
            int i = 0;
            while (i < flagStr.length()) {
                switch (flagStr.charAt(i)) {
                    case 'm': {
                        flags |= 8;
                        break;
                    }
                    case 'i': {
                        flags |= 2;
                        break;
                    }
                    case 'g': {
                        break;
                    }
                    default: {
                        throw new BirtException(PLUGIN_ID, "birt.core.BirtComp.invalidRegularExpression", (Object)pattern);
                    }
                }
                ++i;
            }
            pattern = pattern.substring(jsReExprMatcher.start(1), jsReExprMatcher.end(1));
        }
        try {
            Matcher m = Pattern.compile(pattern, flags).matcher(sourceStr);
            return m.find();
        }
        catch (PatternSyntaxException e) {
            throw new BirtException(PLUGIN_ID, "birt.core.BirtComp.invalidRegularExpression", (Object)e);
        }
    }

    private static boolean like(Object obj1, Object obj2) {
        if (obj2 == null) {
            throw new IllegalArgumentException("pattern value can not be null!");
        }
        if (obj1 == null) {
            return false;
        }
        String str = obj1.toString();
        String pattern = BirtComp.toPatternString(obj2.toString());
        return str.matches(pattern);
    }

    private static String toPatternString(String regex) {
        String pattern = "";
        int i = 0;
        while (i < regex.length()) {
            char c = regex.charAt(i);
            if (c == '\\') {
                if (++i < regex.length()) {
                    pattern = String.valueOf(pattern) + regex.charAt(i);
                }
            } else {
                pattern = c == '%' ? String.valueOf(pattern) + ".*" : (c == '_' ? String.valueOf(pattern) + "." : String.valueOf(pattern) + c);
            }
            ++i;
        }
        return pattern;
    }

    private static boolean isSameType(Object resultExpr, Object resultOp1) {
        return resultExpr.getClass().equals(resultOp1.getClass());
    }

    private static boolean isNumericOrString(Object result) {
        return result instanceof Number || result instanceof String;
    }

    private static boolean isDateOrString(Object result) {
        return result instanceof Date || result instanceof String;
    }

    private static boolean isSQLDateOrString(Object result) {
        return result instanceof java.sql.Date || result instanceof String;
    }

    public Object execute(Object[] arguments) throws BirtException {
        return this.executor.execute(arguments);
    }

    private class Function_AnyOf
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_AnyOf() {
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length < 2) {
                throw new IllegalArgumentException(MessageFormat.format(BirtComp.WRONG_ARGUMENT, BirtComp.ANY_OF));
            }
            int i = 1;
            while (i < args.length) {
                try {
                    if (BirtComp.compare(args[0], args[i]) == 0) {
                        return Boolean.TRUE;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            if (args.length == 2 && args[1] instanceof Object[]) {
                Object[] objs = (Object[])args[1];
                int i2 = 0;
                while (i2 < objs.length) {
                    try {
                        if (BirtComp.compare(args[0], objs[i2]) == 0) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (Exception exception) {}
                    ++i2;
                }
            }
            return Boolean.FALSE;
        }
    }

    private class Function_Between
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;
        private boolean mode;

        Function_Between(boolean mode) {
            this.mode = mode;
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length != 3) {
                throw new IllegalArgumentException(MessageFormat.format(BirtComp.WRONG_ARGUMENT, BirtComp.BETWEEN));
            }
            try {
                Object max;
                Object min;
                if (BirtComp.compare(args[1], args[2]) <= 0) {
                    min = args[1];
                    max = args[2];
                } else {
                    min = args[2];
                    max = args[1];
                }
                return this.mode ? new Boolean(BirtComp.compare(args[0], min) >= 0 && BirtComp.compare(args[0], max) <= 0) : new Boolean(BirtComp.compare(args[0], min) < 0 || BirtComp.compare(args[0], max) > 0);
            }
            catch (BirtException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
    }

    private class Function_Compare
    implements IScriptFunctionExecutor {
        public static final int MODE_EQUAL = 0;
        public static final int MODE_NOT_EQUAL = 1;
        public static final int MODE_GREATERTHAN = 2;
        public static final int MODE_LESSTHAN = 3;
        public static final int MODE_GREATEROREQUAL = 4;
        public static final int MODE_LESSOREQUAL = 5;
        public static final int MODE_LIKE = 6;
        public static final int MODE_MATCH = 7;
        public static final int MODE_NOT_LIKE = 8;
        public static final int MODE_COMPARE_STRING = 9;
        private static final long serialVersionUID = 1L;
        private int mode;

        Function_Compare(int mode) {
            this.mode = mode;
        }

        private void throwException() {
            String func = null;
            switch (this.mode) {
                case 0: {
                    func = BirtComp.EQUAL_TO;
                    break;
                }
                case 1: {
                    func = BirtComp.NOT_EQUAL;
                    break;
                }
                case 2: {
                    func = BirtComp.GREATER_THAN;
                    break;
                }
                case 3: {
                    func = BirtComp.LESS_THAN;
                    break;
                }
                case 4: {
                    func = BirtComp.GREATER_OR_EQUAL;
                    break;
                }
                case 5: {
                    func = BirtComp.LESS_OR_EQUAL;
                    break;
                }
                case 6: {
                    func = BirtComp.LIKE;
                    break;
                }
                case 7: {
                    func = BirtComp.MATCH;
                    break;
                }
                case 8: {
                    func = BirtComp.NOT_LIKE;
                    break;
                }
                case 9: {
                    func = BirtComp.COMPARE_STRING;
                }
                default: {
                    func = "Unknown";
                }
            }
            throw new IllegalArgumentException(MessageFormat.format(BirtComp.WRONG_ARGUMENT, func));
        }

        public Object execute(Object[] args) throws BirtException {
            try {
                if (this.mode == 9) {
                    if (args.length == 3) {
                        if (!(args[2] instanceof Boolean)) {
                            this.throwException();
                        }
                        if (BirtComp.compareString(args[0], args[1], (Boolean)args[2], false) == 0) {
                            return true;
                        }
                        return false;
                    }
                    if (args.length == 4) {
                        if (!(args[2] instanceof Boolean) || !(args[3] instanceof Boolean)) {
                            this.throwException();
                        }
                        if (BirtComp.compareString(args[0], args[1], (Boolean)args[2], (Boolean)args[3]) == 0) {
                            return true;
                        }
                        return false;
                    }
                    if (BirtComp.compareString(args[0], args[1], false, false) == 0) {
                        return true;
                    }
                    return false;
                }
                if (args == null || args.length != 2) {
                    this.throwException();
                }
                switch (this.mode) {
                    case 0: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) == 0);
                    }
                    case 1: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) != 0);
                    }
                    case 2: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) > 0);
                    }
                    case 3: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) < 0);
                    }
                    case 4: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) >= 0);
                    }
                    case 5: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) <= 0);
                    }
                    case 6: {
                        return new Boolean(BirtComp.like(args[0], args[1]));
                    }
                    case 7: {
                        return new Boolean(BirtComp.match(args[0], args[1]));
                    }
                    case 8: {
                        return new Boolean(!BirtComp.like(args[0], args[1]));
                    }
                }
                return null;
            }
            catch (BirtException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
    }
}

