/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import java.util.regex.Pattern;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

class BirtStr
implements IScriptFunctionExecutor {
    private static final long serialVersionUID = 1L;
    private IScriptFunctionExecutor executor;

    BirtStr(String functionName) throws BirtException {
        if ("left".equals(functionName)) {
            this.executor = new Function_Left();
        } else if ("right".equals(functionName)) {
            this.executor = new Function_Right();
        } else if ("concat".equals(functionName)) {
            this.executor = new Function_Concat();
        } else if ("toUpper".equals(functionName)) {
            this.executor = new Function_ToUpper();
        } else if ("toLower".equals(functionName)) {
            this.executor = new Function_ToLower();
        } else if ("trim".equals(functionName)) {
            this.executor = new Function_Trim();
        } else if ("trimLeft".equals(functionName)) {
            this.executor = new Function_TrimLeft();
        } else if ("trimRight".equals(functionName)) {
            this.executor = new Function_TrimRight();
        } else if ("indexOf".equals(functionName)) {
            this.executor = new Function_IndexOf();
        } else if ("search".equals(functionName)) {
            this.executor = new Function_Search();
        } else if ("charLength".equals(functionName)) {
            this.executor = new Function_CharLength();
        } else {
            throw new BirtException("org.eclipse.birt.core.script.function.bre", null, (Object)(String.valueOf(Messages.getString("invalid.function.name")) + "BirtStr." + functionName));
        }
    }

    public Object execute(Object[] arguments) throws BirtException {
        return this.executor.execute(arguments);
    }

    private class Function_CharLength
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_CharLength() {
        }

        private int charLength(String str) {
            if (str == null) {
                return 0;
            }
            return str.length();
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return new Integer(this.charLength(args[0] == null ? null : (String)args[0]));
        }
    }

    private class Function_Concat
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_Concat() {
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            String result = "";
            int i = 0;
            while (i < args.length) {
                result = String.valueOf(result) + args[i];
                ++i;
            }
            return result;
        }
    }

    private class Function_IndexOf
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_IndexOf() {
        }

        private int indexOf(String find_text, String str, int start) {
            if (start < 0) {
                throw new IllegalArgumentException();
            }
            if (find_text == null || str == null || str.indexOf(find_text) < 0) {
                return -1;
            }
            return str.indexOf(find_text, start);
        }

        private int indexOf(String find_text, String str) {
            return this.indexOf(find_text, str, 0);
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length > 3 || args.length < 2) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            if (args.length == 3) {
                return new Integer(this.indexOf(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1], ((Number)args[2]).intValue()));
            }
            return new Integer(this.indexOf(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1]));
        }
    }

    private class Function_Left
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_Left() {
        }

        private String left(String str, int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (str == null) {
                return null;
            }
            if (n == 0) {
                return "";
            }
            if (n >= str.length()) {
                return str;
            }
            return str.substring(0, n);
        }

        private String left(String str) {
            return this.left(str, 1);
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length > 2) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            if (args.length == 1) {
                return this.left(args[0] == null ? null : (String)args[0]);
            }
            return this.left(args[0] == null ? null : (String)args[0], ((Number)args[1]).intValue());
        }
    }

    private class Function_Right
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_Right() {
        }

        public String right(String str, int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (str == null) {
                return null;
            }
            if (n == 0) {
                return "";
            }
            if (n >= str.length()) {
                return str;
            }
            return str.substring(str.length() - n, str.length());
        }

        public String right(String str) {
            return this.right(str, 1);
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length > 2) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            if (args.length == 1) {
                return this.right(args[0] == null ? null : (String)args[0]);
            }
            return this.right(args[0] == null ? null : (String)args[0], ((Number)args[1]).intValue());
        }
    }

    private class Function_Search
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_Search() {
        }

        private int search(String pattern, String str, int start) {
            if (start < 0) {
                throw new IllegalArgumentException();
            }
            if (pattern == null || str == null) {
                return -1;
            }
            String subStr = str.substring(start);
            String newStr = pattern.replaceAll("\\Q?\\E", ".");
            String finalStr = newStr.replaceAll("\\Q*\\E", ".*");
            Pattern p = Pattern.compile(finalStr);
            String[] split = p.split(subStr);
            if (split[0].length() != subStr.length()) {
                return split[0].length() + start;
            }
            return -1;
        }

        private int search(String pattern, String str) {
            return this.search(pattern, str, 0);
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length > 3 || args.length < 2) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            if (args.length == 3) {
                return new Integer(this.search(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1], ((Number)args[2]).intValue()));
            }
            return new Integer(this.search(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1]));
        }
    }

    private class Function_ToLower
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_ToLower() {
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return args[0] == null ? null : ((String)args[0]).toLowerCase();
        }
    }

    private class Function_ToUpper
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_ToUpper() {
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return args[0] == null ? null : ((String)args[0]).toUpperCase();
        }
    }

    private class Function_Trim
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_Trim() {
        }

        private String trim(String str) {
            if (str == null) {
                return null;
            }
            String trimStr = str.trim();
            return trimStr.replaceAll("\\s+", " ");
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return this.trim(args[0] == null ? null : (String)args[0]);
        }
    }

    private class Function_TrimLeft
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_TrimLeft() {
        }

        private String trimLeft(String str) {
            if (str == null) {
                return null;
            }
            byte[] value = str.getBytes();
            int st = 0;
            while (st < str.length() && value[st] <= 32) {
                ++st;
            }
            return st > 0 ? str.substring(st, str.length()) : str;
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return this.trimLeft(args[0] == null ? null : (String)args[0]);
        }
    }

    private class Function_TrimRight
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_TrimRight() {
        }

        private String trimRight(String str) {
            if (str == null) {
                return null;
            }
            byte[] value = str.getBytes();
            int end = str.length();
            while (end > 0 && value[end - 1] <= 32) {
                --end;
            }
            return end < str.length() ? str.substring(0, end) : str;
        }

        public Object execute(Object[] args) throws BirtException {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return this.trimRight(args[0] == null ? null : (String)args[0]);
        }
    }
}

